/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program.rules.insertion;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.rules.ProgramNodeInsertionRule;
import gui.program.ProgramRootNode;
import gui.program.SpecialSequenceNode;
import gui.program.WithBeforeAndAfter;
import gui.tools.LanguagePack;
import javax.swing.tree.TreeNode;

public class BeforeStartNodeCannotMoveRule
implements ProgramNodeInsertionRule {
    public boolean canInsert(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        if (!SpecialSequenceNode.SpecialSequenceType.BEFORE_START.matches(toInsert)) {
            return true;
        }
        if (this.isProgramRootNode(parent)) {
            ProgramRootNode programRootNode = (ProgramRootNode)parent;
            if (programRootNode.hasBeforeStart()) {
                return false;
            }
            if (programRootNode.hasInitVariables()) {
                return index == 1;
            }
            return index == 0;
        }
        if (this.isWithBeforeAndAfter(parent)) {
            WithBeforeAndAfter withAfterNodeSupport = (WithBeforeAndAfter)parent;
            if (toInsert.getParent() != null) {
                return false;
            }
            if (withAfterNodeSupport.getBeforeStartSequence() != null) {
                return false;
            }
            if (withAfterNodeSupport.getAfterEndSequence() != null) {
                return index == ((AbstractProgramNode)withAfterNodeSupport).getIndex((TreeNode)((Object)withAfterNodeSupport.getAfterEndSequence()));
            }
            if (parent.getChildCount() == index) {
                return true;
            }
        }
        return false;
    }

    public String getErrorMessage(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        return LanguagePack.getTextResource().nodeIsNotAllowedHere(toInsert.toString());
    }

    private boolean isWithBeforeAndAfter(Object object) {
        return object instanceof WithBeforeAndAfter;
    }

    private boolean isProgramRootNode(Object object) {
        return object instanceof ProgramRootNode;
    }
}

