/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program.rules.insertion;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.rules.ProgramNodeInsertionRule;
import gui.polyscope.program.IfNodePredicate;
import gui.polyscope.program.ProgramNodeAdapter;
import gui.program.IfNode;
import gui.tools.LanguagePack;
import java.util.List;
import javax.swing.tree.TreeNode;

public class ElseAndElseIfNodesMustBeAddedToProperIfNode
implements ProgramNodeInsertionRule {
    private static final TextResource TEXT_RESOURCE = LanguagePack.getTextResource();
    private static final CommandNamesResource COMMAND_NAMES_RESOURCE = LanguagePack.getCommandNamesResource();

    public boolean canInsert(AbstractProgramNode toInsert, AbstractProgramNode newParent, int index) {
        ProgramNodeAdapter insert = new ProgramNodeAdapter(toInsert);
        ProgramNodeAdapter parent = new ProgramNodeAdapter(newParent);
        if (!(insert.getProgramNode() instanceof IfNode)) {
            return true;
        }
        IfNode.Type insertType = ((IfNode)insert.getProgramNode()).getType();
        if (insertType == IfNode.Type.IF) {
            return true;
        }
        IfNode prevIfNode = this.getPreviousIfNode(parent.getProgramNode(), index);
        if (prevIfNode == null) {
            return false;
        }
        List<ProgramNodeAdapter> elseNodes = parent.searchChildren(new IfNodePredicate(IfNode.Type.ELSE, prevIfNode, insert));
        if (insertType == IfNode.Type.ELSE && !elseNodes.isEmpty()) {
            return false;
        }
        if (insertType == IfNode.Type.ELSE_IF) {
            for (ProgramNodeAdapter elseNode : elseNodes) {
                if (elseNode.getIndex() >= index) continue;
                return false;
            }
        }
        List<ProgramNodeAdapter> elseIfNodes = parent.searchChildren(new IfNodePredicate(IfNode.Type.ELSE_IF, prevIfNode));
        for (ProgramNodeAdapter elseIf : elseIfNodes) {
            AbstractProgramNode pn;
            ProgramNodeAdapter prev = elseIf.getPrevious();
            if (prev == null || !((pn = prev.getProgramNode()) instanceof IfNode) || ((IfNode)pn).getType() != IfNode.Type.ELSE) continue;
            return false;
        }
        return true;
    }

    private IfNode getPreviousIfNode(AbstractProgramNode parent, int index) {
        --index;
        while (index >= 0) {
            IfNode ifNode;
            TreeNode tn = parent.getChildAt(index);
            if (tn instanceof IfNode && (ifNode = (IfNode)((Object)tn)).getType() == IfNode.Type.IF) {
                return (IfNode)((Object)tn);
            }
            --index;
        }
        return null;
    }

    public String getErrorMessage(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        IfNode ifNodeToAdd = (IfNode)toInsert;
        String thisNodeName = ifNodeToAdd.getType() == IfNode.Type.ELSE_IF ? COMMAND_NAMES_RESOURCE.ElseIf() : COMMAND_NAMES_RESOURCE.Else();
        String missingNodeName = COMMAND_NAMES_RESOURCE.If();
        return TEXT_RESOURCE.missingRequiredNode(thisNodeName, missingNodeName);
    }
}

