/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program.rules.insertion;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.rules.ProgramNodeInsertionRule;
import gui.program.IfNode;

public class IfNodeContextInsertRule
implements ProgramNodeInsertionRule {
    public boolean canInsert(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        return this.canInsertAfterPreviousChild(toInsert, parent, index) && this.canInsertBeforeNextChild(toInsert, parent, index);
    }

    public String getErrorMessage(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        return "Node not allowed at this position";
    }

    private boolean canInsertAfterPreviousChild(AbstractProgramNode childNode, AbstractProgramNode parentNode, int index) {
        if (index > 0) {
            AbstractProgramNode before = (AbstractProgramNode)parentNode.getChildAt(index - 1);
            if (before.getIndexAfter(childNode) != index) {
                return false;
            }
            return !this.ispreviousNodeSimpelAndChildIfNode(childNode, before) || ((IfNode)childNode).getType() == IfNode.Type.IF;
        }
        return true;
    }

    private boolean ispreviousNodeSimpelAndChildIfNode(AbstractProgramNode childNode, AbstractProgramNode previous) {
        return childNode instanceof IfNode && !(previous instanceof IfNode);
    }

    private boolean canInsertBeforeNextChild(AbstractProgramNode childNode, AbstractProgramNode parentNode, int index) {
        AbstractProgramNode after;
        return index >= parentNode.getChildCount() - 1 || (after = (AbstractProgramNode)parentNode.getChildAt(index)).getIndexBefore(childNode) == index;
    }
}

