/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program.rules.insertion;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.rules.ProgramNodeInsertionRule;
import gui.program.InitVariablesNode;
import gui.program.ProgramRootNode;
import gui.tools.LanguagePack;

public class InitVariablesNodeOnlyInsertedBeforeProgramRootNodeRule
implements ProgramNodeInsertionRule {
    public boolean canInsert(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        if (this.isTypeNotInitVariablesNode(toInsert)) {
            return true;
        }
        if (this.isTypeNotProgramRootNode(parent)) {
            return false;
        }
        ProgramRootNode root = (ProgramRootNode)parent;
        if (root.hasInitVariables()) {
            return false;
        }
        return index == 0;
    }

    private boolean isTypeNotInitVariablesNode(AbstractProgramNode toInsert) {
        return !(toInsert instanceof InitVariablesNode);
    }

    private boolean isTypeNotProgramRootNode(AbstractProgramNode parent) {
        return !(parent instanceof ProgramRootNode);
    }

    public String getErrorMessage(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        return LanguagePack.getTextResource().nodeIsNotAllowedHere(toInsert.toString());
    }
}

