/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program.rules.insertion;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.rules.ProgramNodeInsertionRule;
import gui.program.MotionDefiningNode;
import gui.program.MoveChildNode;
import gui.tools.LanguagePack;
import javax.swing.tree.TreeNode;

public class PositionNodeMustBeChildOfMoveNode
implements ProgramNodeInsertionRule {
    public boolean canInsert(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        if (!this.isMotionDefiningNodeNeeded((TreeNode)toInsert)) {
            return true;
        }
        return parent.getNodeOfType(MotionDefiningNode.class) != null;
    }

    private boolean isMotionDefiningNodeNeeded(TreeNode node) {
        return this.findNodeThatNeedsMotionDefiningNode(node) != null;
    }

    private TreeNode findNodeThatNeedsMotionDefiningNode(TreeNode node) {
        if (node instanceof MoveChildNode) {
            return node;
        }
        if (!(node instanceof MotionDefiningNode)) {
            int i = 0;
            while (i < node.getChildCount()) {
                TreeNode tn = this.findNodeThatNeedsMotionDefiningNode(node.getChildAt(i));
                if (tn != null) {
                    return tn;
                }
                ++i;
            }
        }
        return null;
    }

    public String getErrorMessage(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        TreeNode tn = this.findNodeThatNeedsMotionDefiningNode((TreeNode)toInsert);
        if (tn != null) {
            return LanguagePack.getTextResource().mustBeAChildNodeOfMoveCommand(tn.toString(), LanguagePack.getCommandNamesResource().Move());
        }
        return null;
    }
}

