/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program.rules.insertion;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramNodeAncestorIterator;
import com.ur.polyscope.program.nodes.rules.ProgramNodeInsertionRule;
import gui.program.CallSubProgramNode;
import gui.program.SubProgramNode;
import gui.tools.LanguagePack;
import java.util.Enumeration;

public class SubProgramNodesCannotCallSubProgramNodes
implements ProgramNodeInsertionRule {
    public boolean canInsert(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        return !this.childNodesIsCallToSubProgram(toInsert) || !this.ancestorIsSubProgramNode(parent);
    }

    private boolean childNodesIsCallToSubProgram(AbstractProgramNode node) {
        if (node instanceof CallSubProgramNode) {
            return true;
        }
        Enumeration children = node.children();
        boolean isSubProgram = false;
        while (!isSubProgram && children.hasMoreElements()) {
            isSubProgram = this.childNodesIsCallToSubProgram((AbstractProgramNode)children.nextElement());
        }
        return isSubProgram;
    }

    private boolean ancestorIsSubProgramNode(AbstractProgramNode parent) {
        ProgramNodeAncestorIterator iterator = new ProgramNodeAncestorIterator(new AbstractProgramNode[]{parent});
        while (iterator.hasNext()) {
            AbstractProgramNode ancestor = iterator.next();
            if (!(ancestor instanceof SubProgramNode)) continue;
            return true;
        }
        return false;
    }

    public String getErrorMessage(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        return LanguagePack.getTextResource().subprogramsMayNotCallOtherSubprograms();
    }
}

