/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program.rules.insertion;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.rules.ProgramNodeInsertionRule;
import gui.program.until.UntilNode;
import gui.tools.LanguagePack;
import javax.swing.tree.MutableTreeNode;

public class UntilNodeCountRestrictionRule
implements ProgramNodeInsertionRule {
    private ProgramNodeInsertionRule untilInsertionRule;

    public UntilNodeCountRestrictionRule(ProgramNodeInsertionRule untilInsertionRule) {
        this.untilInsertionRule = untilInsertionRule;
    }

    public boolean canInsert(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        if (toInsert instanceof UntilNode && this.untilInsertionRule.canInsert(toInsert, parent, index)) {
            return UntilNode.canBeOfType(((UntilNode)toInsert).getSelectedTypeNode(), (MutableTreeNode)parent);
        }
        return true;
    }

    public String getErrorMessage(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        String title;
        switch (((UntilNode)toInsert).getSelectedTypeNode().getType()) {
            case EXPRESSION: {
                title = LanguagePack.getCommandNamesResource().Expression();
                break;
            }
            case DISTANCE: {
                title = LanguagePack.getTextResource().Distance();
                break;
            }
            case REACHED_WAYPOINT: {
                title = LanguagePack.getCommandNamesResource().ReachedWaypoint();
                break;
            }
            case IO: {
                title = LanguagePack.getTextResource().untilIO();
                break;
            }
            case TOOL_CONTACT_DETECTION: {
                title = LanguagePack.getTextResource().toolContact();
                break;
            }
            default: {
                title = "";
            }
        }
        return LanguagePack.getTextResource().CannotAddUntilNode(title);
    }
}

