/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program.rules.insertion;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.rules.ProgramNodeInsertionRule;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import gui.program.direction.MoveDirectionNode;
import gui.program.position.WaypointNode;
import gui.program.until.UntilNode;
import gui.tools.LanguagePack;

public class UntilNodeInsertionRule
implements ProgramNodeInsertionRule {
    public boolean canInsert(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        if (toInsert instanceof UntilNode) {
            if (((UntilNode)toInsert).getSelectedTypeNode().getType() == UntilTypeNode.Type.DISTANCE) {
                return parent instanceof MoveDirectionNode;
            }
            if (((UntilNode)toInsert).getSelectedTypeNode().getType() == UntilTypeNode.Type.REACHED_WAYPOINT) {
                return parent instanceof WaypointNode;
            }
            return parent instanceof WaypointNode || parent instanceof MoveDirectionNode;
        }
        return true;
    }

    public String getErrorMessage(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        String errorMessage;
        switch (((UntilNode)toInsert).getSelectedTypeNode().getType()) {
            case EXPRESSION: {
                errorMessage = LanguagePack.getTextResource().AddUntilExpressionWarning();
                break;
            }
            case DISTANCE: {
                errorMessage = LanguagePack.getTextResource().AddUntilDistanceWarning();
                break;
            }
            case REACHED_WAYPOINT: {
                errorMessage = LanguagePack.getTextResource().AddUntilReachedWarning();
                break;
            }
            case IO: {
                errorMessage = LanguagePack.getTextResource().AddUntilIOWarning();
                break;
            }
            default: {
                errorMessage = LanguagePack.getTextResource().AddUntilWarning();
            }
        }
        return errorMessage;
    }
}

