/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program.rules.removal;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.rules.ProgramNodeRemovalRule;
import gui.program.IfNode;

public class IfNodeContextRemoveRule
implements ProgramNodeRemovalRule {
    public boolean canRemove(AbstractProgramNode nodeToRemove) {
        if (nodeToRemove instanceof IfNode) {
            return this.mayRemoveIfNode((IfNode)nodeToRemove);
        }
        return true;
    }

    public String getErrorMessage(AbstractProgramNode nodeToRemove) {
        return "Attempted node removal not allowed";
    }

    private boolean mayRemoveIfNode(IfNode ifNode) {
        AbstractProgramNode next;
        AbstractProgramNode parent;
        int ifNodeIndex;
        if (ifNode.getType() == IfNode.Type.IF && (ifNodeIndex = this.getNodeIndex(parent = (AbstractProgramNode)ifNode.getParent(), ifNode)) != -1 && ifNodeIndex < parent.getChildCount() - 1 && (next = (AbstractProgramNode)parent.getChildAt(ifNodeIndex + 1)) instanceof IfNode) {
            IfNode nextIfNode = (IfNode)next;
            return nextIfNode.getType() != IfNode.Type.ELSE_IF && nextIfNode.getType() != IfNode.Type.ELSE;
        }
        return true;
    }

    private int getNodeIndex(AbstractProgramNode parent, AbstractProgramNode child) {
        int i = 0;
        while (i < parent.getChildCount()) {
            if (parent.getChildAt(i) == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

