/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup;

import com.ur.disk.Directories;
import com.ur.i18n.TextResource;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.filemanager.FileTypePersistence;
import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationListener;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.MetaData;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.polyscope.viewfacade.lang.ErrorablePanel;
import com.ur.polyscope.viewfacade.safety.RobotInstallationPersistenceService;
import com.ur.polyscope.viewfacade.safety.SafetySettingsComparator;
import com.ur.resources.ViewImageResource;
import com.ur.swing.SwingUtil;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import com.ur.view.installation.InstallationLoadingCardPanel;
import com.ur.view.installation.filemanager.RobotInstallationFileManagerConfiguration;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.setup.NewInstallationCreator;
import gui.polyscope.setup.UseInstallationInCurrentProgramDialogCreator;
import gui.tools.ConfirmationMessageProvider;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import gui.tools.URFileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class LoadSaveInstallationTab
extends InstallationLoadingCardPanel
implements UseInstallationInCurrentProgramDialogCreator {
    public static final String NEW_INSTALLATION = "NewInstallation";
    public static final String LOAD_INSTALLATION_BUTTON = "loadbutton.LoadSaveInstallationTab";
    private static final boolean CREATE_INSTALLATION = false;
    private static final boolean LOAD_INSTALLATION = true;
    private static final int ERROR_MESSAGE_HEIGHT = 35;
    private final FileTypePersistence filePersistence;
    private final RobotInstallationLookupService installationLookupService;
    private NewInstallationCreator newInstallationCreator;
    private FileContainer saveInstallationFileContainer;
    private Errorable installationErrorable;
    private boolean installationLoaded;
    private boolean ignoreCancelVetoWhenExiting;
    private JLabel errorMessageForSave;
    private JLabel explanationLabel;
    private JTextField installationNameTextField;
    private JButton newButton;
    private JPanel northPanel;
    private JButton saveAsButton;
    private JButton saveButton;
    private JLabel titleLabel;
    private final ViewContext viewContext;
    private final RobotInstallationPersistenceService persistenceService;

    @Inject
    LoadSaveInstallationTab(FileTypePersistence filePersistence, RobotInstallationSite installationSite, RobotInstallationLookupService installationLookupService, ViewContext viewContext, NewInstallationCreator newInstallationCreator, SafetySettingsComparator safetySettingsComparator, InstallationLoadingContext installationLoadingContext, RobotInstallationPersistenceService persistenceService, ErrorablePanel errorablePanel, EventManager eventManager) {
        super((FilePersistence)filePersistence, installationSite, installationLookupService, safetySettingsComparator, installationLoadingContext, (TextResource)viewContext.getTextResource(TextResource.class), errorablePanel, eventManager);
        this.viewContext = viewContext;
        this.filePersistence = filePersistence;
        this.installationLookupService = installationLookupService;
        this.newInstallationCreator = newInstallationCreator;
        this.persistenceService = persistenceService;
        this.initComponents();
        this.assignHelpIds();
        EventNotificationService.register((Object)this, InstallationListener.class, event -> {
            if (event.getType() == InstallationListener.EventType.CHANGED) {
                this.disableSaveButton();
            }
        });
        this.configureTitle(viewContext.getFontFactory().getRelativeFont(URFontFactory.Size.MEDIUM), this.northPanel);
        this.finalizeComponents();
        this.setButton(this.saveButton, false);
        EventNotificationService.register((Object)this, InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationModified() {
                Log.trace((String)("Modified installation " + LoadSaveInstallationTab.this.lookupService.getInstallation()));
                LoadSaveInstallationTab.this.enableSaveButton();
            }

            public void installationSaved() {
                Log.trace((String)("Saving installation " + LoadSaveInstallationTab.this.lookupService.getInstallation()));
                LoadSaveInstallationTab.this.setButton(LoadSaveInstallationTab.this.saveButton, false);
            }

            public void installationLoaded(Installation installation) {
                Log.trace((String)("Loaded installation " + LoadSaveInstallationTab.this.lookupService.getInstallation()));
                LoadSaveInstallationTab.this.setButton(LoadSaveInstallationTab.this.saveButton, false);
                LoadSaveInstallationTab.this.ignoreCancelVetoWhenExiting = true;
                LoadSaveInstallationTab.this.installationLoaded = true;
                LoadSaveInstallationTab.this.updateInstallationFilename();
            }
        });
    }

    private void setButton(JButton button, boolean enabled) {
        SwingUtil.invokeLater(() -> button.setEnabled(enabled));
    }

    private void enableSaveButton() {
        this.setButton(this.saveButton, true);
        if (this.isShowing()) {
            this.updateInstallationFilename();
        }
    }

    private void disableSaveButton() {
        this.setButton(this.saveButton, false);
    }

    public void setInstallationErrorable(Errorable installationErrorable) {
        this.installationErrorable = installationErrorable;
    }

    private void finalizeComponents() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.saveAsButton.setText(String.valueOf(textResource.saveAs()) + "...");
        this.titleLabel.setText(textResource.installationLoadSaveTitle());
        this.explanationLabel.setText(textResource.installationLoadSaveExplanation());
        this.newButton.setText(textResource.createNew());
    }

    private void assignHelpIds() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:installation_loadsave");
    }

    public void enter(Object o) {
        this.update();
        this.checkIfInstallationIsInvalid();
        EventNotificationService.notify(VetoListener.class, listener -> listener.veto(LoadSaveInstallationTab.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
        this.ignoreCancelVetoWhenExiting = false;
    }

    public Object exit() {
        if (!this.installationLoaded && !this.ignoreCancelVetoWhenExiting) {
            EventNotificationService.notify(VetoListener.class, listener -> {
                this.informVetoCancelled();
                listener.cancelVeto(LoadSaveInstallationTab.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES);
            });
        }
        return super.exit();
    }

    public void informVetoCancelled() {
        this.installationLoaded = false;
    }

    public ErrorMessage fatalUnknownException(String title) {
        TextResource textBundle = (TextResource)this.viewContext.getTextResource(TextResource.class);
        return new ErrorMessage(title, textBundle.anUnexpectedErrorOccurredExplanation(), textBundle.anUnexpectedErrorOccurredSuggestion());
    }

    public void saveInstallation() {
        try {
            this.persistenceService.save(this.installationLookupService.getInstallation());
        }
        catch (Exception exception) {
            LegacyURDialogCreator.showErrorDialog(this.fatalUnknownException(((TextResource)this.viewContext.getTextResource(TextResource.class)).failedToSaveInstallation()));
        }
    }

    private void checkIfInstallationIsInvalid() {
        this.saveAsButton.setEnabled(true);
        if (this.installationErrorable.getStatus() == Errorable.Status.ERROR) {
            this.saveButton.setEnabled(false);
            this.saveAsButton.setEnabled(false);
            this.errorMessageForSave.setText(HTML.html((String)((TextResource)this.viewContext.getTextResource(TextResource.class)).errorsInSafetySetup()));
            this.errorMessageForSave.setIcon(ViewImageResource.formError());
        } else {
            this.errorMessageForSave.setText("");
            this.errorMessageForSave.setIcon(null);
        }
    }

    public void update() {
        try {
            if (this.saveInstallationFileContainer != null && this.saveInstallationFileContainer.getFile() != null) {
                File installationFile = this.saveInstallationFileContainer.getFile();
                if (!URFileUtils.isFilenameValid(installationFile)) {
                    Log.error((String)("Could not save installation installationFile: \"" + installationFile.getPath()));
                    LegacyURDialogCreator.showErrorDialog(LanguagePack.getErrorMessages().unableToSaveInstallationFile(installationFile.getPath()));
                    this.saveInstallationFileContainer = null;
                    return;
                }
                Installation installation = this.installationLookupService.getInstallation();
                installation.setMetaData((MetaData)new PersistanceMetaData(installationFile));
                this.saveRobotInstallation();
                this.saveInstallationFileContainer = null;
            }
            this.updateInstallationFilename();
        }
        catch (Exception e) {
            Log.error((String)"update in LoadSaveInstallationTab", (Throwable)e);
        }
    }

    private void updateInstallationFilename() {
        Installation installation = this.installationLookupService.getInstallation();
        URI programsDirectoryAsURI = Directories.programs().toURI();
        URI installationFileAsURI = ((PersistanceMetaData)installation.getMetaData(PersistanceMetaData.class)).fileWithoutExtension().toURI();
        URI relativizedFilePathAsURI = programsDirectoryAsURI.relativize(installationFileAsURI);
        try {
            this.installationNameTextField.setText(URLDecoder.decode(relativizedFilePathAsURI.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void saveRobotInstallation() {
        this.saveInstallation();
        this.askToUseInstallationInCurrentProgram();
    }

    private boolean isOkToLoadOrCreateRobotInstallation(boolean isLoad) {
        ConfirmationMessage message;
        ConfirmationMessageProvider confirmationMessage = LanguagePack.getConfirmationMessages();
        ConfirmationMessage confirmationMessage2 = message = isLoad ? confirmationMessage.confirmUnsavedInstallationChangesOnLoad() : confirmationMessage.confirmUnsavedInstallationChangesOnCreate();
        return !this.saveButton.isEnabled() || LegacyURDialogCreator.confirmMessageDialog(message) == DialogReturnValue.OK;
    }

    public String toString() {
        return LoadSaveInstallationTab.class.getName();
    }

    private void initComponents() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.northPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.explanationLabel = new JLabel();
        JPanel centerPanel = new JPanel();
        JPanel jPanel1 = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.installationNameTextField = new JTextField();
        this.saveButton = new JButton();
        this.saveAsButton = new JButton();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel3 = new JLabel();
        JButton loadButton = new JButton();
        loadButton.setName(LOAD_INSTALLATION_BUTTON);
        this.newButton = new JButton();
        this.newButton.setName(NEW_INSTALLATION);
        this.errorMessageForSave = new JLabel();
        JPanel jPanel2 = new JPanel();
        this.setLayout(new BorderLayout());
        this.northPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.northPanel.setLayout(new BorderLayout());
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText(textResource.installationLoadSaveTitle());
        this.northPanel.add((Component)this.titleLabel, "North");
        this.explanationLabel.setHorizontalAlignment(0);
        this.explanationLabel.setText("<EXPLANATION>");
        this.northPanel.add((Component)this.explanationLabel, "South");
        this.add(this.northPanel, "North");
        centerPanel.setLayout(new GridLayout(3, 1));
        jPanel1.setPreferredSize(new Dimension(483, 250));
        jLabel2.setText(textResource.saveTheCurrentInstallation());
        this.installationNameTextField.setEditable(false);
        this.installationNameTextField.setMinimumSize(new Dimension(120, 27));
        this.installationNameTextField.setPreferredSize(new Dimension(180, 28));
        this.installationNameTextField.setBackground(this.getBackground());
        this.saveButton.setText(textResource.Save());
        this.saveButton.addActionListener(evt -> this.saveButtonActionPerformed());
        this.saveAsButton.setText("Save As...");
        this.saveAsButton.addActionListener(evt -> this.saveAsButtonActionPerformed());
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveAsButton)).addComponent(this.installationNameTextField, -2, 291, -2)).addContainerGap(182, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(25, 25, 25).addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.installationNameTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveButton).addComponent(this.saveAsButton)).addContainerGap(75, Short.MAX_VALUE)));
        centerPanel.add(jPanel1);
        jPanel3.setPreferredSize(new Dimension(483, 76));
        jLabel3.setText(textResource.loadADifferentInstallationFile());
        jLabel3.setPreferredSize(new Dimension(300, 17));
        loadButton.setText(textResource.Load());
        loadButton.addActionListener(evt -> this.loadButtonActionPerformed());
        this.newButton.setText("<New>");
        this.newButton.addActionListener(evt -> this.newButtonActionPerformed());
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel3, -2, -1, -2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(loadButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newButton))).addGap(0, 159, Short.MAX_VALUE)).addComponent(this.errorMessageForSave, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(jLabel3, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(loadButton).addComponent(this.newButton)).addGap(18, 18, 18).addComponent(this.errorMessageForSave, -2, 35, -2).addContainerGap(73, Short.MAX_VALUE)));
        centerPanel.add(jPanel3);
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 483, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 192, Short.MAX_VALUE));
        centerPanel.add(jPanel2);
        this.add(centerPanel, "Center");
    }

    private void loadButtonActionPerformed() {
        if (this.isOkToLoadOrCreateRobotInstallation(true)) {
            this.ignoreCancelVetoWhenExiting = true;
            this.performLoadRobotInstallation();
        }
    }

    private void saveButtonActionPerformed() {
        this.saveRobotInstallation();
    }

    private void saveAsButtonActionPerformed() {
        this.saveInstallationFileContainer = new FileContainer();
        this.ignoreCancelVetoWhenExiting = true;
        this.saveInstallationFileContainer.setFile(this.installationLookupService == null || this.installationLookupService.getInstallation() == null ? null : ((PersistanceMetaData)this.installationLookupService.getInstallation().getMetaData(PersistanceMetaData.class)).file());
        this.filePersistence.saveFile(this.saveInstallationFileContainer, (FileManagerConfiguration)new RobotInstallationFileManagerConfiguration(((TextResource)this.viewContext.getTextResource(TextResource.class)).loadInstallation()), ".installation");
    }

    private void newButtonActionPerformed() {
        if (this.isOkToLoadOrCreateRobotInstallation(false)) {
            this.newInstallationCreator.showKeepSafetyDialog(this);
        }
    }
}

