/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup;

import com.ur.i18n.TextResource;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.security.GoToEnterPassword;
import com.ur.polyscope.security.PasswordLoginListener;
import com.ur.polyscope.security.PasswordManager;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.util.concurrent.SequentialTask;
import com.ur.util.concurrent.Task;
import com.ur.util.logging.Log;
import gui.polyscope.setup.NewInstallationCreator;
import gui.polyscope.setup.UseInstallationInCurrentProgramDialogCreator;
import gui.tools.dialogs.DialogInputStrategy;
import javax.inject.Inject;
import javax.swing.SwingWorker;

public class RequestCreationTypeFromUser {
    private final PasswordManager passwordManager;
    private final GoToEnterPassword enterPassword;
    private final ConfirmationDialogCreator confirmationDialogCreator;
    private final TextResource textResource;
    private final TaskMonitor taskMonitor;
    private final InstallationLoadingContext installationLoadingContext;

    @Inject
    public RequestCreationTypeFromUser(PasswordManager passwordManager, GoToEnterPassword enterPassword, ConfirmationDialogCreator dialogCreator, TextResource textResource, TaskMonitor taskMonitor, InstallationLoadingContext installationLoadingContext) {
        this.passwordManager = passwordManager;
        this.enterPassword = enterPassword;
        this.confirmationDialogCreator = dialogCreator;
        this.textResource = textResource;
        this.taskMonitor = taskMonitor;
        this.installationLoadingContext = installationLoadingContext;
    }

    public void showKeepSafetyDialog(final UseInstallationInCurrentProgramDialogCreator dialogCreator, final NewInstallationCreator newInstallationCreator) {
        ConfirmationDialogListener listener = new ConfirmationDialogListener(){

            public void onOkClicked() {
                newInstallationCreator.createNewInstallationWithCurrentSafety();
                dialogCreator.askToUseInstallationInCurrentProgram();
            }

            public void onCancelClicked() {
                RequestCreationTypeFromUser.this.requestLogin(dialogCreator, newInstallationCreator);
            }
        };
        this.confirmationDialogCreator.showConfirmationDialog(this.confirmInstallationSafety(), listener);
    }

    private void requestLogin(final UseInstallationInCurrentProgramDialogCreator dialogCreator, final NewInstallationCreator newInstallationCreator) {
        if (this.passwordManager.isPasswordDefined(PasswordManager.Lock.SAFETY)) {
            Log.info((String)"Requesting SAFETY password");
            this.enterPassword.requestPassword(PasswordManager.Lock.SAFETY, new PasswordLoginListener(){

                public void onLoginSuccess() {
                    RequestCreationTypeFromUser.this.createNewInstallationAndShowDialog(dialogCreator, newInstallationCreator);
                }

                public void onLoginFailure() {
                }
            });
        } else {
            Log.info((String)"Creating installation without SAFETY password");
            this.createNewInstallationAndShowDialog(dialogCreator, newInstallationCreator);
        }
    }

    private ConfirmationMessage confirmInstallationSafety() {
        ConfirmationMessage message = new ConfirmationMessage(DialogWithName.NEW_INSTALLATION_SAFETY_CONFIGURATION.getName(), this.textResource.newInstallationDialogTitle(), this.textResource.newInstallationDialogDescription(), this.textResource.newInstallationDialogOptionKeep(), this.textResource.newInstallationDialogOptionReset());
        message.setSuppressKey("suppressDialogConfirmNewInstallation");
        return message;
    }

    private void createNewInstallationAndShowDialog(final UseInstallationInCurrentProgramDialogCreator dialogCreator, final NewInstallationCreator newInstallationCreator) {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                new DialogInputStrategy().runWithProgress(RequestCreationTypeFromUser.this.taskMonitor, (Task)new SequentialTask(RequestCreationTypeFromUser.this.textResource.confirmUnsavedInstallationChangesCreateAction(), false){

                    public void run() {
                        RequestCreationTypeFromUser.this.installationLoadingContext.setLoading(true);
                        newInstallationCreator.createNewInstallation();
                        RequestCreationTypeFromUser.this.installationLoadingContext.setLoading(false);
                        dialogCreator.askToUseInstallationInCurrentProgram();
                    }
                });
                return null;
            }
        };
        worker.execute();
    }
}

