/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup;

import com.ur.i18n.TextResource;
import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.lang.react.RecipeHelper;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvasbehavior.URCanvas3DFingerDragViewShifter;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.resources.ViewImageResource;
import com.ur.swing.CardPanel;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.view.hmc.ControllerSocketSender;
import gui.polyscope.setup.StopRobotIfBrakeReleased;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.math3.util.Precision;

public class RobotMountingTab
extends CardPanel {
    public static final String BASE_ANGLE_LABEL_NAME = "baseAngleLabel_" + RobotMountingTab.class.getName();
    public static final String SHOW_MOUNTING_ACTION = "showMountingAction." + RobotMountingTab.class.getSimpleName();
    private static final String ROBOT_SETUP_PANEL = "robotSetupPanel";
    private static RobotMountingTab instance;
    private final DecimalFormat decimalFormat = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.0;-0.0");
    private final InstallationComponentLookup installationLookupService;
    private final RobotCanvas3DFactory robotCanvas3DFactory;
    private final StopRobotIfBrakeReleased stopRobotIfBrakeReleased;
    private RobotCanvas3D robotCanvas3D;
    private double baseAngle;
    private double tiltAngle;
    private double baseAngleVel;
    private double tiltAngleVel;
    private boolean changesWereMade = false;
    private JLabel baseAngleLabel;
    private JPanel bottomSidePanel;
    private JLabel mountingTitleLabel;
    private JPanel northPanel;
    private JPanel rightSidePanel;
    private JLabel tiltAngleLabel;
    private final ViewContext viewContext;
    private final RecipeHelper recipeHelper = new RecipeHelper();

    @Inject
    RobotMountingTab(InstallationComponentLookup installationLookupService, ViewContext viewContext, RobotCanvas3DFactory robotCanvas3DFactory, StopRobotIfBrakeReleased stopRobotIfBrakeReleased, @Source(value=Arm.class) Recipe<Arm> armRecipe) {
        this.installationLookupService = installationLookupService;
        this.viewContext = viewContext;
        this.robotCanvas3DFactory = robotCanvas3DFactory;
        this.stopRobotIfBrakeReleased = stopRobotIfBrakeReleased;
        this.recipeHelper.add(Arm.class, armRecipe, (Consumer)new ArmConsumer());
        instance = this;
        this.initComponents();
        new URCanvas3DFingerDragViewShifter(this.robotCanvas3D);
        this.setName(ROBOT_SETUP_PANEL);
        this.initHelpIds();
        this.configureTitle(viewContext.getFontFactory().getRelativeFont(URFontFactory.Size.MEDIUM), this.northPanel);
    }

    public static RobotMountingTab instance() {
        return instance;
    }

    private void initHelpIds() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)this.mountingTitleLabel, "gui:installation_mounting_tab");
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)this.rightSidePanel, "gui:installation_mounting_tab_tilt_angle");
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)this.bottomSidePanel, "gui:installation_mounting_tab_mounting_angle");
    }

    public void enter(Object o) {
        super.enter(o);
        this.changesWereMade = false;
        SetupFeatureContainerNode featureContainer = (SetupFeatureContainerNode)this.installationLookupService.getComponent(SetupFeatureContainerNode.class);
        this.baseAngle = featureContainer.getWorldTransform().getMountingBaseAngle();
        this.setBaseAngleText();
        this.tiltAngle = featureContainer.getWorldTransform().getMountingTiltAngle();
        this.setTiltAngleText();
        this.robotCanvas3D.setVisible(true);
        this.robotCanvas3D.enter();
        this.recipeHelper.subscribe(Arm.class);
        EventNotificationService.register((Object)((Object)this), InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationLoaded(Installation installation) {
                SetupFeatureContainerNode n = (SetupFeatureContainerNode)RobotMountingTab.this.installationLookupService.getComponent(SetupFeatureContainerNode.class);
                RobotMountingTab.this.changesWereMade = false;
                RobotMountingTab.this.robotCanvas3D.setVisible(false);
                RobotMountingTab.this.baseAngle = n.getWorldTransform().getMountingBaseAngle();
                RobotMountingTab.this.setBaseAngleText();
                RobotMountingTab.this.tiltAngle = n.getWorldTransform().getMountingTiltAngle();
                RobotMountingTab.this.setTiltAngleText();
                RobotMountingTab.this.robotCanvas3D.setVisible(true);
            }
        });
    }

    public Object exit() {
        this.recipeHelper.unsubscribe(Arm.class);
        EventNotificationService.unregister((Object)((Object)this), InstallationStateListener.class);
        this.robotCanvas3D.setVisible(false);
        this.robotCanvas3D.exit();
        this.changesWereMade = false;
        return super.exit();
    }

    private void changeTiltAngle(double angle) {
        SetupFeatureContainerNode setupFeatureContainerNode = (SetupFeatureContainerNode)this.installationLookupService.getComponent(SetupFeatureContainerNode.class);
        if (!Precision.equals((double)setupFeatureContainerNode.getWorldTransform().getMountingTiltAngle(), (double)angle, (double)0.001)) {
            this.changesWereMade = true;
            this.stopRobotIfBrakeReleased();
            this.tiltAngle = angle;
            this.setTiltAngleText();
            setupFeatureContainerNode.getWorldTransform().setMountingTiltAngle(this.tiltAngle);
            ControllerSocketSender.sendSetGravity(setupFeatureContainerNode.getGravity());
        }
    }

    private void changeBaseAngle(double angle) {
        SetupFeatureContainerNode setupFeatureContainerNode = (SetupFeatureContainerNode)this.installationLookupService.getComponent(SetupFeatureContainerNode.class);
        if (!Precision.equals((double)setupFeatureContainerNode.getWorldTransform().getMountingBaseAngle(), (double)angle, (double)0.001)) {
            this.changesWereMade = true;
            this.stopRobotIfBrakeReleased();
            this.baseAngle = angle;
            this.setBaseAngleText();
            setupFeatureContainerNode.getWorldTransform().setMountingBaseAngle(this.baseAngle);
            ControllerSocketSender.sendSetGravity(setupFeatureContainerNode.getGravity());
        }
    }

    private void stopRobotIfBrakeReleased() {
        this.stopRobotIfBrakeReleased.requestStopWithVeto(RobotMountingTab.class);
    }

    public void setTiltAngleText() {
        this.tiltAngleLabel.setText(String.valueOf(this.decimalFormat.format(this.tiltAngle / Math.PI * 180.0)) + "\u00b0");
    }

    public void setBaseAngleText() {
        this.baseAngleLabel.setText(String.valueOf(this.decimalFormat.format(this.baseAngle / Math.PI * 180.0)) + "\u00b0");
    }

    private void initComponents() {
        this.northPanel = new JPanel();
        this.mountingTitleLabel = new JLabel();
        JPanel centerPanel = new JPanel();
        JPanel robotPanel = new JPanel();
        this.rightSidePanel = new JPanel();
        JButton jButton2 = new JButton();
        JButton jButton3 = new JButton();
        JButton jButton4 = new JButton();
        JLabel jLabel6 = new JLabel();
        JButton jButton9 = new JButton();
        JButton jButton12 = new JButton();
        this.tiltAngleLabel = new JLabel();
        JButton jButton10 = new JButton();
        JButton jButton13 = new JButton();
        this.bottomSidePanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        JButton jButton8 = new JButton();
        JButton jButton5 = new JButton();
        this.baseAngleLabel = new JLabel();
        JButton jButton6 = new JButton();
        JButton jButton1 = new JButton();
        this.setLayout(new BorderLayout());
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.mountingTitleLabel.setText(textResource.installationRobotMounting());
        this.northPanel.add(this.mountingTitleLabel);
        this.add(this.northPanel, "North");
        centerPanel.setLayout(new BorderLayout());
        robotPanel.setMinimumSize(new Dimension(600, 400));
        robotPanel.setPreferredSize(new Dimension(600, 400));
        robotPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)robotPanel, "Center");
        this.robotCanvas3D = this.robotCanvas3DFactory.buildMetalRobot();
        this.robotCanvas3D.setDebugName("Robot Mounting 3D Canvas");
        this.robotCanvas3D.showStaticElements(Arrays.asList(VisualizerElementType.PAYLOAD_COG, VisualizerElementType.TCP));
        robotPanel.add(this.robotCanvas3D.getComponent(), "Center");
        this.rightSidePanel.setLayout(new BoxLayout(this.rightSidePanel, 1));
        jButton2.setIcon(ViewImageResource.roboticonCieling());
        jButton2.setMaximumSize(new Dimension(60, 45));
        jButton2.setMinimumSize(new Dimension(60, 45));
        jButton2.setPreferredSize(new Dimension(60, 45));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotMountingTab.this.jButton2ActionPerformed();
            }
        });
        this.rightSidePanel.add(jButton2);
        this.rightSidePanel.add(Box.createVerticalStrut(2));
        jButton3.setIcon(ViewImageResource.roboticonWall());
        jButton3.setMaximumSize(new Dimension(60, 45));
        jButton3.setMinimumSize(new Dimension(60, 45));
        jButton3.setPreferredSize(new Dimension(60, 45));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotMountingTab.this.jButton3ActionPerformed();
            }
        });
        this.rightSidePanel.add(jButton3);
        this.rightSidePanel.add(Box.createVerticalStrut(2));
        jButton4.setIcon(ViewImageResource.roboticonGround());
        jButton4.setMaximumSize(new Dimension(60, 45));
        jButton4.setMinimumSize(new Dimension(60, 45));
        jButton4.setPreferredSize(new Dimension(60, 45));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotMountingTab.this.jButton4ActionPerformed();
            }
        });
        this.rightSidePanel.add(jButton4);
        this.rightSidePanel.add(Box.createVerticalStrut(2));
        jLabel6.setHorizontalAlignment(0);
        jLabel6.setText(textResource.installationRobotMountingTilt());
        this.rightSidePanel.add(jLabel6);
        jButton9.setIcon(ViewImageResource.gtkGoUp());
        jButton9.setText(textResource.fourtyfiveDegrees());
        jButton9.setMargin(new Insets(2, 2, 2, 2));
        jButton9.setVerticalTextPosition(3);
        jButton9.setHorizontalTextPosition(0);
        jButton9.setMaximumSize(new Dimension(60, 58));
        jButton9.setMinimumSize(new Dimension(60, 58));
        jButton9.setPreferredSize(new Dimension(60, 58));
        jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotMountingTab.this.jButton9ActionPerformed();
            }
        });
        this.rightSidePanel.add(jButton9);
        this.rightSidePanel.add(Box.createVerticalStrut(2));
        jButton12.setIcon(ViewImageResource.gtkGoUp());
        jButton12.setMaximumSize(new Dimension(60, 45));
        jButton12.setMinimumSize(new Dimension(60, 45));
        jButton12.setPreferredSize(new Dimension(60, 45));
        jButton12.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RobotMountingTab.this.jButton12MousePressed();
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                RobotMountingTab.this.jButton12MouseReleased();
            }
        });
        this.rightSidePanel.add(jButton12);
        this.rightSidePanel.add(Box.createVerticalStrut(2));
        this.tiltAngleLabel.setHorizontalAlignment(4);
        this.tiltAngleLabel.setText("0\u00b0");
        this.tiltAngleLabel.setHorizontalTextPosition(0);
        this.tiltAngleLabel.setMaximumSize(new Dimension(57, 25));
        this.tiltAngleLabel.setPreferredSize(new Dimension(57, 25));
        this.rightSidePanel.add(this.tiltAngleLabel);
        jButton10.setIcon(ViewImageResource.gtkGoDown());
        jButton10.setMaximumSize(new Dimension(60, 45));
        jButton10.setMinimumSize(new Dimension(60, 45));
        jButton10.setPreferredSize(new Dimension(60, 45));
        jButton10.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RobotMountingTab.this.jButton10MousePressed();
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                RobotMountingTab.this.jButton10MouseReleased();
            }
        });
        this.rightSidePanel.add(jButton10);
        this.rightSidePanel.add(Box.createVerticalStrut(2));
        jButton13.setIcon(ViewImageResource.gtkGoDown());
        jButton13.setText(textResource.fourtyfiveDegrees());
        jButton13.setMargin(new Insets(2, 2, 2, 2));
        jButton13.setVerticalTextPosition(1);
        jButton13.setHorizontalTextPosition(0);
        jButton13.setMaximumSize(new Dimension(60, 58));
        jButton13.setMinimumSize(new Dimension(60, 58));
        jButton13.setPreferredSize(new Dimension(60, 58));
        jButton13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotMountingTab.this.jButton13ActionPerformed();
            }
        });
        this.rightSidePanel.add(jButton13);
        centerPanel.add((Component)this.rightSidePanel, "East");
        jLabel1.setText(textResource.rotateRobotBaseMounting());
        this.bottomSidePanel.add(jLabel1);
        jButton8.setIcon(ViewImageResource.gtkGoBackLtr());
        jButton8.setText(textResource.fourtyfiveDegrees());
        jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotMountingTab.this.jButton8ActionPerformed();
            }
        });
        this.bottomSidePanel.add(jButton8);
        jButton5.setIcon(ViewImageResource.gtkGoBackLtr());
        jButton5.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RobotMountingTab.this.jButton5MousePressed();
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                RobotMountingTab.this.jButton5MouseReleased();
            }
        });
        this.bottomSidePanel.add(jButton5);
        this.baseAngleLabel.setName(BASE_ANGLE_LABEL_NAME);
        this.baseAngleLabel.setHorizontalAlignment(4);
        this.baseAngleLabel.setText("359\u00b0");
        this.baseAngleLabel.setHorizontalTextPosition(0);
        this.baseAngleLabel.setIconTextGap(0);
        this.baseAngleLabel.setMaximumSize(new Dimension(50, 15));
        this.baseAngleLabel.setMinimumSize(new Dimension(50, 15));
        this.baseAngleLabel.setPreferredSize(new Dimension(58, 15));
        this.bottomSidePanel.add(this.baseAngleLabel);
        jButton6.setIcon(ViewImageResource.gtkGoBackRtl());
        jButton6.setHorizontalTextPosition(10);
        jButton6.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RobotMountingTab.this.jButton6MousePressed();
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                RobotMountingTab.this.jButton6MouseReleased();
            }
        });
        this.bottomSidePanel.add(jButton6);
        jButton1.setIcon(ViewImageResource.gtkGoBackRtl());
        jButton1.setText(textResource.fourtyfiveDegrees());
        jButton1.setHorizontalTextPosition(10);
        jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotMountingTab.this.jButton1ActionPerformed();
            }
        });
        this.bottomSidePanel.add(jButton1);
        centerPanel.add((Component)this.bottomSidePanel, "South");
        this.add(centerPanel, "Center");
    }

    private void jButton10MouseReleased() {
        this.tiltAngleVel = 0.0;
    }

    private void jButton10MousePressed() {
        this.tiltAngleVel = -0.01;
        new RotateViewThread().start();
    }

    private void jButton12MouseReleased() {
        this.tiltAngleVel = 0.0;
    }

    private void jButton12MousePressed() {
        this.tiltAngleVel = 0.01;
        new RotateViewThread().start();
    }

    private void jButton13ActionPerformed() {
        double angle = Math.floor((((SetupFeatureContainerNode)this.installationLookupService.getComponent(SetupFeatureContainerNode.class)).getWorldTransform().getMountingTiltAngle() - 0.1) / 0.7853981633974483) * Math.PI / 4.0;
        if (angle < 0.0) {
            angle = 0.0;
        }
        this.changeTiltAngle(angle);
    }

    private void jButton9ActionPerformed() {
        double angle = Math.ceil((((SetupFeatureContainerNode)this.installationLookupService.getComponent(SetupFeatureContainerNode.class)).getWorldTransform().getMountingTiltAngle() + 0.1) / 0.7853981633974483) * Math.PI / 4.0;
        if (angle > Math.PI) {
            angle = Math.PI;
        }
        this.changeTiltAngle(angle);
    }

    private void jButton1ActionPerformed() {
        double angle = Math.floor((((SetupFeatureContainerNode)this.installationLookupService.getComponent(SetupFeatureContainerNode.class)).getWorldTransform().getMountingBaseAngle() - 0.1) / 0.7853981633974483) * Math.PI / 4.0;
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        this.changeBaseAngle(angle);
    }

    private void jButton8ActionPerformed() {
        double angle = Math.ceil((((SetupFeatureContainerNode)this.installationLookupService.getComponent(SetupFeatureContainerNode.class)).getWorldTransform().getMountingBaseAngle() + 0.1) / 0.7853981633974483) * Math.PI / 4.0;
        if (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        this.changeBaseAngle(angle);
    }

    private void jButton5MousePressed() {
        this.baseAngleVel = 0.01;
        new RotateViewThread().start();
    }

    private void jButton5MouseReleased() {
        this.baseAngleVel = 0.0;
    }

    private void jButton6MousePressed() {
        this.baseAngleVel = -0.01;
        new RotateViewThread().start();
    }

    private void jButton6MouseReleased() {
        this.baseAngleVel = 0.0;
    }

    private void jButton4ActionPerformed() {
        this.changeTiltAngle(0.0);
    }

    private void jButton3ActionPerformed() {
        this.changeTiltAngle(1.5707963267948966);
    }

    private void jButton2ActionPerformed() {
        this.changeTiltAngle(Math.PI);
    }

    private class ArmConsumer
    implements Consumer<Arm> {
        private ArmConsumer() {
        }

        public void accept(Arm arm) {
            RobotMountingTab.this.robotCanvas3D.addQueue((Runnable)new UpdateGraphicsRunnable(arm.getActualJointsPosition()));
        }
    }

    private class RotateViewThread
    extends Thread {
        public RotateViewThread() {
            super("RotateViewThread");
        }

        @Override
        public void run() {
            while (RobotMountingTab.this.baseAngleVel != 0.0) {
                RobotMountingTab robotMountingTab = RobotMountingTab.this;
                robotMountingTab.baseAngle = robotMountingTab.baseAngle + RobotMountingTab.this.baseAngleVel;
                if (RobotMountingTab.this.baseAngle > Math.PI * 2) {
                    RobotMountingTab robotMountingTab2 = RobotMountingTab.this;
                    robotMountingTab2.baseAngle = robotMountingTab2.baseAngle - Math.PI * 2;
                }
                if (RobotMountingTab.this.baseAngle < 0.0) {
                    RobotMountingTab robotMountingTab3 = RobotMountingTab.this;
                    robotMountingTab3.baseAngle = robotMountingTab3.baseAngle + Math.PI * 2;
                }
                try {
                    RotateViewThread.sleep(50L);
                }
                catch (Exception e) {
                    Log.error((String)"Speed thread (in RobotPositioningPanel) exception: ", (Throwable)e);
                }
            }
            while (RobotMountingTab.this.tiltAngleVel != 0.0) {
                RobotMountingTab robotMountingTab = RobotMountingTab.this;
                robotMountingTab.tiltAngle = robotMountingTab.tiltAngle + RobotMountingTab.this.tiltAngleVel;
                if (RobotMountingTab.this.tiltAngle > Math.PI) {
                    RobotMountingTab.this.tiltAngle = Math.PI;
                }
                if (RobotMountingTab.this.tiltAngle < 0.0) {
                    RobotMountingTab.this.tiltAngle = 0.0;
                }
                try {
                    RotateViewThread.sleep(50L);
                }
                catch (Exception e) {
                    Log.error((String)"Speed thread (in RobotPositioningPanel) exception: ", (Throwable)e);
                }
            }
        }
    }

    private class UpdateGraphicsRunnable
    implements Runnable {
        private final JointPositionVector jointPosition;

        public UpdateGraphicsRunnable(JointPositionVector jointPosition) {
            this.jointPosition = jointPosition;
        }

        @Override
        public void run() {
            RobotMountingTab.this.robotCanvas3D.setJointAngleVector(this.jointPosition);
            RobotMountingTab.this.changeBaseAngle(RobotMountingTab.this.baseAngle);
            RobotMountingTab.this.changeTiltAngle(RobotMountingTab.this.tiltAngle);
        }
    }
}

