/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup;

import com.ur.i18n.TextResource;
import com.ur.lang.StringUtils;
import com.ur.log.logentry.LanguagePack;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.controllerinterface.errorcode.ErrorCode;
import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvasbehavior.UpdateZoomInCanvas;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorWrapper;
import com.ur.polyscope.visualizer.canvasbehavior.ZoomRenderer;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.polyscope.visualizer.panel.ElementsVisualizer;
import com.ur.polyscope.visualizer.panel.ElementsVisualizerAggregator;
import com.ur.polyscope.visualizer.panel.RobotView3DPanel;
import com.ur.swing.CardPanel;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.view.DialogWithName;
import com.ur.view.hmc.ControllerSocketSender;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

@Singleton
public class RobotPositionVerificationPanel
extends CardPanel {
    private final ElementsVisualizer elementVisualizers;
    private final URFontFactory fontFactory;
    private final ViewContext viewContext;
    private final RobotCanvas3DFactory robotCanvas3DFactory;
    private RobotView3DPanel robotView3DPanel;
    private JLabel explanationLabel;
    private JCheckBox jointPositionsVerifiedCheckBox;
    private JButton acknowledgeExitButton;
    private ErrorCode errorCode;
    private ControllerInterface controllerInterface;
    private FeaturesLookup featuresLookup;

    @Inject
    public RobotPositionVerificationPanel(ElementsVisualizerAggregator elementVisualizers, ViewContext viewContext, RobotCanvas3DFactory robotCanvas3DFactory, ControllerInterface controllerInterface, FeaturesLookup featuresLookup) {
        this.elementVisualizers = elementVisualizers;
        this.viewContext = viewContext;
        this.fontFactory = viewContext.getFontFactory();
        this.robotCanvas3DFactory = robotCanvas3DFactory;
        this.controllerInterface = controllerInterface;
        this.featuresLookup = featuresLookup;
        this.initGuiComponents();
        this.resetPanel();
    }

    private ErrorMessage errorMessageFromController(int errorCode, int errorArgument) {
        String title = LanguagePack.getMessageCode((int)errorCode, (int)errorArgument);
        String message = LanguagePack.getMessageCodeArgument((int)errorCode, (int)errorArgument);
        String explanation = LanguagePack.getFriendlyMessageCodeExplanation((int)errorCode, (int)errorArgument);
        String suggestion = LanguagePack.getFriendlyMessageCodeSuggestion((int)errorCode, (int)errorArgument);
        if (StringUtils.startsAndEndsWith((String)"!", (String)explanation)) {
            return new ErrorMessage(DialogWithName.RUNTIME_EXCEPTION.getName(), title, message, "");
        }
        if (StringUtils.startsAndEndsWith((String)"!", (String)suggestion)) {
            return new ErrorMessage(DialogWithName.RUNTIME_EXCEPTION.getName(), title, explanation, "");
        }
        return new ErrorMessage(DialogWithName.RUNTIME_EXCEPTION.getName(), title, explanation, suggestion);
    }

    public void setProtectiveStopText(RobotMessage message) {
        ErrorMessage errorMessage = this.errorMessageFromController(message.errorCode.getId(), message.errorArgument);
        this.explanationLabel.setText("<html><p>" + errorMessage.getTitle() + "</p>" + "<br>" + errorMessage.getMessage() + "</html>");
        this.errorCode = message.errorCode;
    }

    public void enter(Object o) {
        this.robotView3DPanel.setActive(true);
        this.elementVisualizers.initialize();
        EventNotificationService.notify(VetoListener.class, listener -> listener.veto(RobotPositionVerificationPanel.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
    }

    public Object exit() {
        this.robotView3DPanel.setActive(false);
        this.resetPanel();
        EventNotificationService.notify(VetoListener.class, listener -> listener.cancelVeto(RobotPositionVerificationPanel.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
        return null;
    }

    private void resetPanel() {
        this.acknowledgeExitButton.setEnabled(false);
        this.jointPositionsVerifiedCheckBox.setSelected(false);
    }

    private void initGuiComponents() {
        this.setLayout(new BoxLayout((Container)((Object)this), 3));
        this.add(this.createTitleLabel());
        this.add(this.createExplanantionLabel());
        this.add(Box.createVerticalGlue());
        this.add(this.createRobot3DView());
        JPanel approvalButtons = new JPanel();
        approvalButtons.setLayout(new BoxLayout(approvalButtons, 2));
        approvalButtons.add(this.createJointPositionVerificationPanel());
        approvalButtons.add(Box.createVerticalGlue());
        approvalButtons.add(this.createAcknowledgeAndPowerOffExitPanel());
        this.add(approvalButtons);
    }

    private JPanel createRobot3DView() {
        this.robotView3DPanel = new RobotView3DPanel(this.robotCanvas3DFactory, this.controllerInterface, this.viewContext, "Position Verification 3D Canvas");
        this.robotView3DPanel.setElementVisualizers(this.elementVisualizers);
        ViewBehaviorWrapper wrapper = new ViewBehaviorWrapper(this.featuresLookup);
        this.robotView3DPanel.getRobotCanvas3D().addJ3DComponent((J3DComponent)new ZoomRenderer(this.robotView3DPanel.getRobotCanvas3D().getComponent(), (ViewBehaviorHolder)wrapper));
        this.robotView3DPanel.getRobotCanvas3D().addNodeToScene(this.elementVisualizers.getElementNode());
        this.robotView3DPanel.getRobotCanvas3D().alwaysRun((Runnable)new UpdateZoomInCanvas((ViewBehaviorHolder)wrapper));
        Dimension robot3DViewPanelDimension = new Dimension(550, 350);
        this.robotView3DPanel.setPreferredSize(robot3DViewPanelDimension);
        this.robotView3DPanel.setMaximumSize(robot3DViewPanelDimension);
        return this.robotView3DPanel;
    }

    private JPanel createJointPositionVerificationPanel() {
        JPanel jointPositionVerificationPanel = new JPanel(new FlowLayout(0));
        jointPositionVerificationPanel.setBorder(new EmptyBorder(0, 25, 0, 0));
        jointPositionVerificationPanel.add(this.createJointPositionsConfirmedCheckBox());
        return jointPositionVerificationPanel;
    }

    private JCheckBox createJointPositionsConfirmedCheckBox() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.jointPositionsVerifiedCheckBox = new JCheckBox(textResource.jointPositionsVerifedFromGraphics());
        this.jointPositionsVerifiedCheckBox.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.DEFAULT));
        this.jointPositionsVerifiedCheckBox.addActionListener(e -> this.acknowledgeExitButton.setEnabled(this.jointPositionsVerifiedCheckBox.isSelected()));
        return this.jointPositionsVerifiedCheckBox;
    }

    private JLabel createTitleLabel() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        JLabel titleLabel = new JLabel(textResource.robotPositionVerificationTitle());
        titleLabel.setBorder(new EmptyBorder(10, 0, 0, 0));
        titleLabel.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.MAIN_HEADING_SIZE));
        titleLabel.setAlignmentX(0.5f);
        return titleLabel;
    }

    private JLabel createExplanantionLabel() {
        this.explanationLabel = new JLabel();
        this.explanationLabel.setBorder(new EmptyBorder(5, 20, 5, 20));
        this.explanationLabel.setFont(this.fontFactory.getDefaultFont());
        this.explanationLabel.setAlignmentX(0.5f);
        return this.explanationLabel;
    }

    private JButton createPowerOffExitButton() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        JButton powerOffExitButton = new JButton(textResource.robotPositionVerifiedCancel());
        powerOffExitButton.addActionListener(e -> {
            Log.error((String)"Powering off", (Throwable)new Exception());
            this.controllerInterface.runScript("power off");
            if (this.errorCode == ErrorCode.ROBOT_RESTARTED_AFTER_JOINT_POSITION_DISAGREEMENT) {
                ControllerSocketSender.sendUnlockProtectiveStop();
            }
            this.navigateBack();
        });
        return powerOffExitButton;
    }

    private JButton createAcknowledgeExitButton() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.acknowledgeExitButton = new JButton(textResource.robotPositionVerifiedAction());
        this.acknowledgeExitButton.addActionListener(e -> {
            ControllerSocketSender.sendUnlockProtectiveStop();
            this.navigateBack();
        });
        return this.acknowledgeExitButton;
    }

    private JPanel createAcknowledgeAndPowerOffExitPanel() {
        JPanel acknowledgeAndPowerOffExitPanel = new JPanel(new FlowLayout(2));
        acknowledgeAndPowerOffExitPanel.add(this.createPowerOffExitButton());
        acknowledgeAndPowerOffExitPanel.add(this.createAcknowledgeExitButton());
        acknowledgeAndPowerOffExitPanel.setBorder(new EmptyBorder(0, 0, 0, 25));
        return acknowledgeAndPowerOffExitPanel;
    }
}

