/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup;

import com.ur.log.logentry.robotmessage.RobotModes;
import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.dev.RobotMode;
import javax.inject.Inject;

public class StopRobotIfBrakeReleased {
    private ControllerInterface controllerInterface;

    @Inject
    public StopRobotIfBrakeReleased(ControllerInterface controllerInterface) {
        this.controllerInterface = controllerInterface;
    }

    public void requestStopWithVeto(Class<?> vetoProvider) {
        RobotState rs = RobotState.getLatestRobotState();
        if (rs.robotMode == RobotMode.IDLE && RobotModes.isInBreakRelease((int[])rs.jointMode) || rs.robotMode == RobotMode.RUNNING) {
            if (vetoProvider != null) {
                EventNotificationService.notify(VetoListener.class, listener -> listener.veto(vetoProvider, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
            }
            this.controllerInterface.runScript("power off");
        }
    }
}

