/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup.treenodes;

import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ISetupTreeContainer;
import com.ur.swing.SwingUtil;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.module.UIInstallationNode;
import com.ur.view.polyscope.module.installation.InstallationContributionsProvider;
import gui.installation.ContributionStateListener;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.setup.treenodes.SetupInstallationVariablesTreeNode;
import gui.polyscope.setup.treenodes.SetupLoadSaveInstallationTreeNode;
import gui.polyscope.setup.treenodes.SetupMountingTreeNode;
import gui.polyscope.setup.treenodes.geom.GeomLineNode;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

@Singleton
public class SetupTreeContainer
implements ISetupTreeContainer {
    private final DefaultMutableTreeNode setupTreeRoot;
    private final transient DefaultTreeModel setupTreeModel;
    private final FixedNodes fixedNodes;
    private DefaultMutableTreeNode UIInstallationNodesMarker;
    private List<UIInstallationNode> uiInstallationNodes = new ArrayList<UIInstallationNode>();
    private InstallationContributionsProvider installationContributionsProvider;
    private final RobotInstallationSite robotInstallationSite;
    private InstallationLoadingContext installationLoadingContext;
    private final InstallationStateListener installationStateListener = new InstallationStateListener.Template(){

        public void installationLoaded(Installation installation) {
            SetupTreeContainer.this.updateUIInstallationNodes();
        }

        public void installationModified() {
            if (!SetupTreeContainer.this.installationLoadingContext.isLoading()) {
                SetupTreeContainer.this.setupTreeModel.nodeChanged(SetupTreeContainer.this.setupTreeRoot);
            }
        }
    };
    private final ContributionStateListener contributionStateListener = new ContributionStateListener(){

        @Override
        public void preContributionModified() {
        }

        @Override
        public void contributionModified() {
            SetupTreeContainer.this.updateUIInstallationNodes();
        }

        @Override
        public void postContributionModified() {
        }
    };

    @Inject
    protected SetupTreeContainer(RobotInstallationLookupService robotInstallationLookupService, InstallationContributionsProvider installationContributionsProvider, RobotInstallationSite robotInstallationSite, InstallationLoadingContext installationLoadingContext) {
        this.installationContributionsProvider = installationContributionsProvider;
        this.robotInstallationSite = robotInstallationSite;
        this.installationLoadingContext = installationLoadingContext;
        this.setupTreeRoot = new DefaultMutableTreeNode();
        this.setupTreeModel = new DefaultTreeModel(this.setupTreeRoot);
        this.fixedNodes = new FixedNodes(robotInstallationLookupService);
        this.insertUIInstallationNodes();
    }

    private void updateUIInstallationNodes() {
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                SetupTreeContainer.this.removeUIInstallationNodes();
                SetupTreeContainer.this.insertUIInstallationNodes();
            }
        });
    }

    public void activateInstallationListener() {
        EventNotificationService.register((Object)this, InstallationStateListener.class, (Object)this.installationStateListener);
        EventNotificationService.register((Object)this, ContributionStateListener.class, (Object)this.contributionStateListener);
    }

    public DefaultTreeModel getSetupTreeModel() {
        return this.setupTreeModel;
    }

    public void replaceTopLevelSafetyNode(DefaultMutableTreeNode node) {
        this.replaceTopLevelNode(node, this.fixedNodes.getVariablesIndex());
    }

    public void replaceTopLevelFeatureNode(SetupFeatureContainerNode node) {
        node.setTreeModel(this.setupTreeModel);
        this.replaceTopLevelNode(node, this.fixedNodes.getModbusIndex() + 1);
    }

    public void replaceTopLevelIONode(DefaultMutableTreeNode node) {
        this.replaceTopLevelNode(node, this.fixedNodes.getMountingIndex() + 1);
    }

    public void replaceTopLevelDefaultProgramNode(DefaultMutableTreeNode node) {
        this.replaceTopLevelNode(node, this.fixedNodes.getLoadSaveIndex());
        this.UIInstallationNodesMarker = node;
    }

    private void replaceTopLevelNode(DefaultMutableTreeNode node, int index) {
        DefaultMutableTreeNode findNodeByType;
        if (this.containAny(node.getClass()) && (findNodeByType = this.findNodeByType(node.getClass())).getParent() != null) {
            this.setupTreeModel.removeNodeFromParent(findNodeByType);
        }
        int indexToInsert = PrimitiveUtils.between((int)index, (int)0, (int)this.setupTreeModel.getChildCount(this.setupTreeRoot));
        this.insertNodeAt(node, indexToInsert);
    }

    public void insertUIInstallationNodes() {
        List<UIInstallationNode> nodes = this.installationContributionsProvider.getUIInstallationNodes();
        int UIInstallationNodeIndex = this.setupTreeRoot.getIndex(this.UIInstallationNodesMarker);
        for (UIInstallationNode node : nodes) {
            this.insertNodeAt(node, UIInstallationNodeIndex);
            this.uiInstallationNodes.add(node);
            ++UIInstallationNodeIndex;
        }
    }

    private void insertNodeAt(DefaultMutableTreeNode node, int index) {
        this.setupTreeModel.insertNodeInto(node, this.setupTreeRoot, index);
        this.setupTreeModel.reload();
    }

    public void removeUIInstallationNodes() {
        for (UIInstallationNode each : this.uiInstallationNodes) {
            this.setupTreeModel.removeNodeFromParent(each);
        }
        this.uiInstallationNodes.clear();
        this.setupTreeModel.reload();
    }

    public boolean containAny(Class<?> type) {
        if (this.setupTreeRoot == null) {
            return false;
        }
        Enumeration<TreeNode> e = this.setupTreeRoot.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
            if (current.getClass() != type) continue;
            return true;
        }
        return false;
    }

    private DefaultMutableTreeNode findNodeByType(Class<? extends DefaultMutableTreeNode> type) {
        if (this.setupTreeRoot == null) {
            return null;
        }
        Enumeration<TreeNode> e = this.setupTreeRoot.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
            if (current.getClass() != type) continue;
            try {
                return current;
            }
            catch (Exception ex) {
                Log.error((String)"Code error, something that is not a SetupTreeNode was in the SetupTreeNodes");
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Deprecated
    public SetupFeatureContainerNode getFeatureContainerNode() {
        return (SetupFeatureContainerNode)this.robotInstallationSite.getInstallation().getComponent(SetupFeatureContainerNode.class);
    }

    public boolean insertGeomNode(GeomPoseNode newNode) {
        return this.getFeatureContainerNode().insertGeomNode(newNode);
    }

    public boolean insertGeomPlaneNodeWithPoints(GeomPlaneNode planeNode, GeomPoseNode point1, GeomPoseNode point2, GeomPoseNode point3) {
        return this.getFeatureContainerNode().insertGeomPlaneNodeWithPoints(planeNode, point1, point2, point3);
    }

    public boolean insertGeomLineNodeBetweenPoints(GeomLineNode lineNode, GeomPoseNode point1, GeomPoseNode point2) {
        return this.getFeatureContainerNode().insertGeomLineNodeBetweenPoints(lineNode, point1, point2);
    }

    public void removeGeomFeature(GeomFeature nodeToRemove) {
        this.getFeatureContainerNode().removeGeomFeature(nodeToRemove);
    }

    private class FixedNodes {
        private final SetupLoadSaveInstallationTreeNode setupLoadSaveInstallationTreeNode;
        private final SetupMountingTreeNode setupMountingTreeNode = new SetupMountingTreeNode();
        private final SetupInstallationVariablesTreeNode setupInstallationVariablesTreeNode;
        private final DefaultMutableTreeNode setupModbusTreeNode;

        public FixedNodes(RobotInstallationLookupService robotInstallationLookupService) {
            this.setupInstallationVariablesTreeNode = new SetupInstallationVariablesTreeNode(robotInstallationLookupService);
            this.setupModbusTreeNode = new DefaultMutableTreeNode();
            this.setupLoadSaveInstallationTreeNode = new SetupLoadSaveInstallationTreeNode();
            SetupTreeContainer.this.setupTreeModel.insertNodeInto(new DefaultMutableTreeNode(), SetupTreeContainer.this.setupTreeRoot, 0);
            SetupTreeContainer.this.setupTreeModel.insertNodeInto(this.setupMountingTreeNode, SetupTreeContainer.this.setupTreeRoot, 1);
            SetupTreeContainer.this.setupTreeModel.insertNodeInto(this.setupInstallationVariablesTreeNode, SetupTreeContainer.this.setupTreeRoot, 2);
            SetupTreeContainer.this.setupTreeModel.insertNodeInto(this.setupModbusTreeNode, SetupTreeContainer.this.setupTreeRoot, 3);
            SetupTreeContainer.this.setupTreeModel.insertNodeInto(new DefaultMutableTreeNode(), SetupTreeContainer.this.setupTreeRoot, 4);
            SetupTreeContainer.this.setupTreeModel.insertNodeInto(this.setupLoadSaveInstallationTreeNode, SetupTreeContainer.this.setupTreeRoot, 5);
            SetupTreeContainer.this.setupTreeModel.reload();
            SetupTreeContainer.this.UIInstallationNodesMarker = this.setupLoadSaveInstallationTreeNode;
        }

        public int getModbusIndex() {
            return SetupTreeContainer.this.setupTreeRoot.getIndex(this.setupModbusTreeNode);
        }

        public int getLoadSaveIndex() {
            return SetupTreeContainer.this.setupTreeRoot.getIndex(this.setupLoadSaveInstallationTreeNode);
        }

        public int getMountingIndex() {
            return SetupTreeContainer.this.setupTreeRoot.getIndex(this.setupMountingTreeNode);
        }

        public int getVariablesIndex() {
            return SetupTreeContainer.this.setupTreeRoot.getIndex(this.setupInstallationVariablesTreeNode);
        }
    }
}

