/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup.treenodes.geom;

import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.ISetupFeatureContainerNode;
import com.ur.swing.SwingUtil;
import com.ur.util.Predicate;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FeatureTreeModelAdapter {
    private DefaultTreeModel sharedDefaultTreeModel;
    private Map<DefaultMutableTreeNode, DefaultMutableTreeNode> userDataMap;
    private final Predicate isContributedFeature = new Predicate(){

        public boolean test(Object o) {
            return o instanceof GeomPoseNodeContributed;
        }
    };

    public FeatureTreeModelAdapter(FeaturesLookup featuresLookupService) {
        this.sharedDefaultTreeModel = new DefaultTreeModel(featuresLookupService.getFeatureContainer().getRoot());
    }

    public void attachTreesToSharedFeatureModel(final JTree features, final JTree contributedFeatures) {
        this.sharedDefaultTreeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(final TreeModelEvent selectionEvent) {
                SwingUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JTree tree = this.selectTree((DefaultMutableTreeNode)selectionEvent.getChildren()[0], features, contributedFeatures);
                        ((DefaultTreeModel)tree.getModel()).reload();
                        this.selectTreeNode(selectionEvent);
                    }
                });
            }

            private JTree selectTree(DefaultMutableTreeNode node, JTree features2, JTree contributedFeatures2) {
                if (FeatureTreeModelAdapter.this.isContributedFeature.test((Object)node)) {
                    return contributedFeatures2;
                }
                return features2;
            }

            @Override
            public void treeNodesInserted(final TreeModelEvent e) {
                SwingUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FeatureTreeModelAdapter.this.populateFeatureTrees(features, contributedFeatures);
                        this.selectTreeNode(e);
                    }
                });
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                Object removedChild = e.getChildren()[0];
                JTree tree = this.selectTree((DefaultMutableTreeNode)removedChild, features, contributedFeatures);
                DefaultMutableTreeNode wrappedNode = (DefaultMutableTreeNode)FeatureTreeModelAdapter.this.userDataMap.get(removedChild);
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
                int deletedindex = root.getIndex(wrappedNode);
                FeatureTreeModelAdapter.this.populateFeatureTrees(features, contributedFeatures);
                if (deletedindex == 0) {
                    if (tree.getModel().getChildCount(tree.getModel().getRoot()) > 0) {
                        deletedindex = 1;
                    } else {
                        features.setSelectionRow(0);
                        return;
                    }
                }
                Object selectChild = tree.getModel().getChild(tree.getModel().getRoot(), deletedindex - 1);
                Object[] nodePath = ((DefaultTreeModel)tree.getModel()).getPathToRoot((TreeNode)selectChild);
                TreePath treePath = new TreePath(nodePath);
                tree.setSelectionPath(treePath);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                FeatureTreeModelAdapter.this.populateFeatureTrees(features, contributedFeatures);
            }

            private void selectTreeNode(TreeModelEvent e) {
                Object[] path = e.getChildren();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path[0];
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)FeatureTreeModelAdapter.this.userDataMap.get(node);
                JTree tree = this.selectTree(node, features, contributedFeatures);
                Object[] nodePath = ((DefaultTreeModel)tree.getModel()).getPathToRoot(defaultMutableTreeNode);
                TreePath treePath = new TreePath(nodePath);
                tree.setSelectionPath(treePath);
            }
        });
    }

    public boolean hasSharedRootChanged(FeaturesLookup featuresLookupService) {
        ISetupFeatureContainerNode featureContainer = featuresLookupService.getFeatureContainer();
        return featureContainer != this.sharedDefaultTreeModel.getRoot();
    }

    public void setSharedRoot(FeaturesLookup featuresLookupService) {
        ISetupFeatureContainerNode featureContainer = featuresLookupService.getFeatureContainer();
        this.sharedDefaultTreeModel.setRoot((TreeNode)featureContainer);
        featureContainer.setTreeModel(this.sharedDefaultTreeModel);
    }

    public void populateFeatureTrees(JTree features, JTree contributedFeatures) {
        this.userDataMap = new HashMap<DefaultMutableTreeNode, DefaultMutableTreeNode>();
        DefaultMutableTreeNode featureModelRoot = new DefaultMutableTreeNode();
        DefaultTreeModel featureModel = new DefaultTreeModel(featureModelRoot);
        DefaultMutableTreeNode contFeatureModelRoot = new DefaultMutableTreeNode();
        DefaultTreeModel contFeatureModel = new DefaultTreeModel(contFeatureModelRoot);
        MutableTreeNode sharedRoot = (MutableTreeNode)this.sharedDefaultTreeModel.getRoot();
        int childCount = this.sharedDefaultTreeModel.getChildCount(sharedRoot);
        int featIndex = 0;
        int contFeatIndex = 0;
        int i = 0;
        while (i < childCount) {
            int selectedIndex;
            DefaultTreeModel model;
            DefaultMutableTreeNode root;
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.sharedDefaultTreeModel.getChild(sharedRoot, i);
            DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(child);
            if (this.isContributedFeature.test((Object)child)) {
                root = contFeatureModelRoot;
                model = contFeatureModel;
                selectedIndex = contFeatIndex++;
            } else {
                root = featureModelRoot;
                model = featureModel;
                selectedIndex = featIndex++;
            }
            model.insertNodeInto(newChild, root, selectedIndex);
            this.userDataMap.put(child, newChild);
            if (!child.isLeaf()) {
                this.copySubTree(child, newChild, model);
            }
            ++i;
        }
        contributedFeatures.setModel(contFeatureModel);
        features.setModel(featureModel);
    }

    private void copySubTree(MutableTreeNode fromRoot, DefaultMutableTreeNode toRoot, DefaultTreeModel toModel) {
        int childCount = this.sharedDefaultTreeModel.getChildCount(fromRoot);
        int i = 0;
        while (i < childCount) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.sharedDefaultTreeModel.getChild(fromRoot, i);
            if (!(child instanceof GeomPoseNodeContributed)) {
                DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(child);
                toModel.insertNodeInto(newChild, toRoot, i);
                this.userDataMap.put(child, newChild);
                if (!child.isLeaf()) {
                    this.copySubTree(child, newChild, toModel);
                }
            }
            ++i;
        }
    }
}

