/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup.treenodes.geom;

import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.resources.ViewImageResource;
import gui.geom.BaseView;
import gui.geom.ToolView;
import gui.polyscope.setup.treenodes.geom.GeomLineNode;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class FeaturesCellRenderer
extends DefaultTreeCellRenderer {
    private final Icon featureBase = ViewImageResource.programnodeGeomBase();
    private final Icon featureTool = ViewImageResource.programnodeGeomTool();
    private Icon definedGeomPointIcon = ViewImageResource.programnodeGeomPointOk();
    private Icon undefinedGeomPointIcon = ViewImageResource.programnodeGeomPointUndefined();
    private Icon definedGeomLineIcon = ViewImageResource.programnodeGeomLineOk();
    private Icon undefinedGeomLineIcon = ViewImageResource.programnodeGeomLineUndefined();
    private Icon definedGeomPlaneIcon = ViewImageResource.programnodeGeomPlaneOk();
    private Icon undefinedGeomPlaneIcon = ViewImageResource.programnodeGeomPlaneUndefined();
    private Icon definedUrcapGeomPointIcon = ViewImageResource.urcapProgramnodeGeomPointOk();
    private Icon undefinedUrcapGeomPointIcon = ViewImageResource.urcapProgramnodeGeomPointUndefined();

    FeaturesCellRenderer() {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object v, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object value = null;
        if (v instanceof DefaultMutableTreeNode) {
            value = ((DefaultMutableTreeNode)v).getUserObject();
        }
        if (!(value instanceof GeomFeature)) {
            return this;
        }
        GeomFeature treeNode = (GeomFeature)value;
        this.hasFocus = hasFocus;
        this.setText(tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus));
        if (treeNode instanceof GeomPoseNodeContributed) {
            GeomPoseNode gpn = (GeomPoseNode)treeNode;
            this.setIconFor((GeomFeature)gpn, this.undefinedUrcapGeomPointIcon, this.definedUrcapGeomPointIcon);
        } else if (treeNode instanceof GeomPoseNode) {
            GeomPoseNode gpn = (GeomPoseNode)treeNode;
            this.setIconFor((GeomFeature)gpn, this.undefinedGeomPointIcon, this.definedGeomPointIcon);
        } else if (treeNode instanceof GeomLineNode) {
            GeomLineNode gln = (GeomLineNode)treeNode;
            this.setIconFor((GeomFeature)gln, this.undefinedGeomLineIcon, this.definedGeomLineIcon);
        } else if (treeNode instanceof GeomPlaneNode) {
            GeomPlaneNode gpn = (GeomPlaneNode)treeNode;
            this.setIconFor((GeomFeature)gpn, this.undefinedGeomPlaneIcon, this.definedGeomPlaneIcon);
        } else if (treeNode instanceof ToolView) {
            this.setIcon(this.featureTool);
        } else if (treeNode instanceof BaseView) {
            this.setIcon(this.featureBase);
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        this.selected = sel;
        return this;
    }

    private void setIconFor(GeomFeature geomFeature, Icon undefinedIcon, Icon definedIcon) {
        if (geomFeature.isUndefined()) {
            this.setIcon(undefinedIcon);
        } else {
            this.setIcon(definedIcon);
        }
    }
}

