/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup.treenodes.geom;

import com.ur.i18n.TextResource;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.event.EventNotificationService;
import com.ur.view.geometric.feature.EditGeomFeatureCardPanelImpl;
import com.ur.view.geometric.feature.FeaturesCardPanel;
import com.ur.view.geometric.feature.FeaturesCardPanelImpl;
import com.ur.view.geometric.feature.ViewGeomFeatureCardPanel;
import gui.polyscope.setup.treenodes.geom.FeatureTreeModelAdapter;
import gui.polyscope.setup.treenodes.geom.FeaturesCellRenderer;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

@Singleton
public class FeaturesTab
extends CardPanel {
    public static final String FEATURES_TREE = "featuresTree.G5FeaturesTab";
    private static final String URCAP_FEATURES_TREE = "urcap.featuresTree.G5FeaturesTab";
    public static final String ADD_POINT_FEATURE = "addPointFeature.G5FeaturesTab";
    public static final String ADD_LINE_FEATURE = "addLineFeature.G5FeaturesTab";
    public static final String ADD_PLANE_FEATURE = "addPlaneFeature.G5FeaturesTab";
    private final FeatureTreeModelAdapter featureTreeModelAdapter;
    private final FlippablePanel editFeatureCardPanel;
    private final JTree features;
    private final JTree contributedFeatures;
    private FeaturesLookup featuresLookupService;
    private JScrollPane contributedFeatureScrollPane;
    private JScrollPane featureScrollPane;
    private JPanel treePanel;
    private TextResource textResource;

    @Inject
    public FeaturesTab(FeaturesLookup featuresLookupService, FeaturesCardPanelImpl featuresTab, ViewContext viewContext) {
        this.featuresLookupService = featuresLookupService;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.featureTreeModelAdapter = new FeatureTreeModelAdapter(featuresLookupService);
        this.features = widgetFactory.createTree();
        this.features.setBorder((Border)new CardBorder(this.textResource.Features()));
        this.features.setShowsRootHandles(false);
        this.features.setRootVisible(false);
        this.features.setCellRenderer(new FeaturesCellRenderer());
        this.features.setName(FEATURES_TREE);
        this.features.addTreeWillExpandListener(new TreeWillNotExpandIfChildrenAreHidden());
        this.contributedFeatures = widgetFactory.createTree();
        this.contributedFeatures.setBorder((Border)new CardBorder(this.textResource.urcapFeatures()));
        this.contributedFeatures.setShowsRootHandles(false);
        this.contributedFeatures.setRootVisible(false);
        this.contributedFeatures.setCellRenderer(new FeaturesCellRenderer());
        this.contributedFeatures.setName(URCAP_FEATURES_TREE);
        this.contributedFeatures.addTreeWillExpandListener(new TreeWillNotExpandIfChildrenAreHidden());
        this.featureTreeModelAdapter.attachTreesToSharedFeatureModel(this.features, this.contributedFeatures);
        this.featureScrollPane = new JScrollPane(this.features);
        this.featureScrollPane.setPreferredSize(new Dimension(280, 350));
        this.contributedFeatureScrollPane = new JScrollPane(this.contributedFeatures);
        this.contributedFeatureScrollPane.setPreferredSize(new Dimension(280, -1));
        this.editFeatureCardPanel = new FlippablePanel();
        this.treePanel = new JPanel();
        this.treePanel.setLayout(new BoxLayout(this.treePanel, 1));
        this.add(this.treePanel, "West");
        this.treePanel.add(this.featureScrollPane);
        this.treePanel.add(this.contributedFeatureScrollPane);
        this.add((Component)this.editFeatureCardPanel, "Center");
        this.editFeatureCardPanel.setCardParent((CardPanel)this);
        this.editFeatureCardPanel.addCardPanel(FeaturesCardPanel.class, (CardPanel)featuresTab);
        this.editFeatureCardPanel.switchTo(FeaturesCardPanel.class, null);
        featuresTab.exit();
        this.features.addTreeSelectionListener(new FeatureTreeSelectionListener());
        this.contributedFeatures.addTreeSelectionListener(new ContributedFeatureTreeSelectionListener());
    }

    public void enter(Object o) {
        super.enter(o);
        this.editFeatureCardPanel.enterActiveChild(o);
        this.initializeFeatureTrees();
        EventNotificationService.register((Object)((Object)this), InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationLoaded(Installation installation) {
                FeaturesTab.this.initializeFeatureTrees();
            }
        });
        this.repaint();
        this.revalidate();
    }

    private void initializeFeatureTrees() {
        if (this.featureTreeModelAdapter.hasSharedRootChanged(this.featuresLookupService)) {
            this.featureTreeModelAdapter.setSharedRoot(this.featuresLookupService);
            this.featureTreeModelAdapter.populateFeatureTrees(this.features, this.contributedFeatures);
            this.features.setSelectionRow(0);
        }
        if (this.contributedFeatures.getModel().getChildCount(this.contributedFeatures.getModel().getRoot()) > 0) {
            this.contributedFeatureScrollPane.setVisible(true);
        } else {
            this.contributedFeatureScrollPane.setVisible(false);
        }
    }

    public Object exit() {
        EventNotificationService.unregister((Object)((Object)this), InstallationStateListener.class);
        this.editFeatureCardPanel.exitActiveChild();
        return super.exit();
    }

    private void updateInfo(Object selection) {
        if (this.isOnFeatureScreen()) {
            this.editFeatureCardPanel.getCurrentCard().exit();
            this.editFeatureCardPanel.getCurrentCard().enter(selection);
        } else if (this.editFeatureCardPanel.getCurrentCard() instanceof FeaturesCardPanel) {
            ((FeaturesCardPanel)this.editFeatureCardPanel.getCurrentCard()).updateSelectedFeature(selection);
        }
    }

    private boolean isOnFeatureScreen() {
        return FeaturesTab.getCurrentPanel().equals(this.editFeatureCardPanel.getCurrentCard()) || FeaturesTab.getCurrentPanel().getClass().equals(EditGeomFeatureCardPanelImpl.class) || FeaturesTab.getCurrentPanel().getClass().equals(ViewGeomFeatureCardPanel.class);
    }

    private class ContributedFeatureTreeSelectionListener
    implements TreeSelectionListener {
        private ContributedFeatureTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.getNewLeadSelectionPath() != null) {
                FeaturesTab.this.features.clearSelection();
                Object selection = ((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getUserObject();
                FeaturesTab.this.updateInfo(selection);
            }
        }
    }

    private class FeatureTreeSelectionListener
    implements TreeSelectionListener {
        private FeatureTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath oldTreePath;
            if (e.getNewLeadSelectionPath() != null) {
                FeaturesTab.this.contributedFeatures.clearSelection();
                Object selection = ((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getUserObject();
                FeaturesTab.this.updateInfo(selection);
                if (!this.isTopLevelNode((GeomFeature)selection) && FeaturesTab.this.features.isExpanded(e.getPath().getParentPath())) {
                    return;
                }
                if (this.isTopLevelNode((GeomFeature)selection) && !FeaturesTab.this.features.isExpanded(e.getPath())) {
                    FeaturesTab.this.features.expandPath(e.getPath());
                }
            }
            if ((oldTreePath = e.getOldLeadSelectionPath()) != null) {
                DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)oldTreePath.getLastPathComponent();
                Object oldUserNode = oldNode.getUserObject();
                if (this.isTopLevelNode((GeomFeature)oldUserNode)) {
                    FeaturesTab.this.features.collapsePath(oldTreePath);
                } else if (!e.getPath().isDescendant(oldTreePath) && FeaturesTab.this.features.isExpanded(oldTreePath.getParentPath())) {
                    FeaturesTab.this.features.collapsePath(oldTreePath.getParentPath());
                }
            }
        }

        private boolean isTopLevelNode(GeomFeature featureNode) {
            if (featureNode.getParent() == null) {
                return true;
            }
            return featureNode.getParent() instanceof SetupFeatureContainerNode;
        }
    }

    private static class TreeWillNotExpandIfChildrenAreHidden
    implements TreeWillExpandListener {
        private TreeWillNotExpandIfChildrenAreHidden() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            GeomFeature node;
            DefaultMutableTreeNode o;
            Object userObject;
            TreePath path = event.getPath();
            if (path.getLastPathComponent() instanceof DefaultMutableTreeNode && (userObject = (o = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof GeomFeature && (node = (GeomFeature)userObject).hasHiddenSubFeatureChildren()) {
                throw new ExpandVetoException(event);
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }
    }
}

