/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup.treenodes.geom;

import com.ur.lang.naming.NamedEntity;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.geomfeature.LineSpatialFeature;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.visualizer.geomfeature.GeomBranchNode;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.tools.LanguagePack;
import javax.inject.Inject;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class GeomLineNode
extends GeomBranchNode
implements LineSpatialFeature {
    private final int desiredChildCount = 2;
    private double cameraOffset;
    private double cameraHeight;
    private double cameraDistance;
    private RobotInstallationSite robotInstallationSite;

    @Inject
    public GeomLineNode(RobotInstallationSite robotInstallationSite) {
        this.robotInstallationSite = robotInstallationSite;
        this.resetView();
    }

    public static String getFeatureClassName() {
        return LanguagePack.getCommandNamesResource().geomLine();
    }

    public GeomPoseNode getPointOne() {
        if (this.getChildCount() > 0) {
            return (GeomPoseNode)((Object)this.getChildAt(0));
        }
        return null;
    }

    public GeomPoseNode getPointTwo() {
        if (this.getChildCount() > 1) {
            return (GeomPoseNode)((Object)this.getChildAt(1));
        }
        return null;
    }

    public boolean sameAs(NamedEntity entityToCompareTo) {
        if (this == entityToCompareTo) {
            return true;
        }
        if (!this.getName().equals(entityToCompareTo.getName())) {
            return false;
        }
        if (entityToCompareTo instanceof GeomLineNode) {
            GeomLineNode gpn = (GeomLineNode)entityToCompareTo;
            if (gpn.getChildCount() != this.getChildCount()) {
                return false;
            }
            int i = 0;
            while (i < this.getChildCount()) {
                if (!gpn.getChildAt(i).equals(this.getChildAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.sameAs(entityToCompareTo);
    }

    private void updateVisualization() {
        if (this.programVisualization == null) {
            return;
        }
        if (this.isUndefined()) {
            return;
        }
        GeomPoseNode poseNode1 = null;
        GeomPoseNode poseNode2 = null;
        try {
            poseNode1 = (GeomPoseNode)((Object)this.getChildAt(0));
            poseNode2 = (GeomPoseNode)((Object)this.getChildAt(1));
        }
        catch (Exception e) {
            System.err.println("GeomLineNode.updateVisualization() Error: A child of AeomLineNode was not a pose node: " + e);
            e.printStackTrace();
            return;
        }
        if (poseNode1 == null || poseNode2 == null) {
            return;
        }
        Vector3d startPoint = new Vector3d(poseNode1.getTransformPosition());
        Vector3d endPoint = new Vector3d(poseNode2.getTransformPosition());
        Vector3d lineDirection = new Vector3d();
        lineDirection.sub((Tuple3d)startPoint, (Tuple3d)endPoint);
        lineDirection.normalize();
        lineDirection.scale(10.0);
        endPoint.add((Tuple3d)lineDirection);
        lineDirection.scale(-1.0);
        startPoint.add((Tuple3d)lineDirection);
        Point3d[] points = new Point3d[]{new Point3d((Tuple3d)startPoint), new Point3d((Tuple3d)endPoint)};
        LineArray lineArray = new LineArray(2, 1);
        lineArray.setCoordinates(0, points);
        Shape3D shape = new Shape3D((Geometry)lineArray, this.getGeomFeatureAppearance());
        BranchGroup bg = new BranchGroup();
        bg.addChild((Node)shape);
        this.programVisualization.getGeomBranchGroup().addChild((Node)bg);
        this.programVisualization.setGeomFeaturesVisibleState(true);
        Point3d[] pointsToDraw = new Point3d[]{new Point3d((Tuple3d)poseNode1.getTransformPosition()), new Point3d((Tuple3d)poseNode2.getTransformPosition())};
        this.programVisualization.drawPoints(pointsToDraw);
    }

    public void setProgramVisualization(ProgramVisualization programVisualizationIn) {
        this.programVisualization = programVisualizationIn;
        this.recalculateTransform();
        this.updateVisualization();
    }

    protected void recalculateTransformSubClass() {
        if (!this.isUndefined()) {
            Transform3D newT3d = new Transform3D(this.getPointOne().getTransform());
            Vector3d point0pos = this.getPointOne().getTransformPosition();
            Vector3d point1pos = this.getPointTwo().getTransformPosition();
            double angleToRotatez = -Math.atan2(point1pos.getX() - point0pos.getX(), point1pos.getY() - point0pos.getY());
            Matrix3d rotMatZ = new Matrix3d();
            rotMatZ.rotZ(angleToRotatez);
            newT3d.setRotation(rotMatZ);
            double angleToRotateX = Math.atan2(point1pos.getZ() - point0pos.getZ(), Math.sqrt(Math.pow(point1pos.getY() - point0pos.getY(), 2.0) + Math.pow(point1pos.getX() - point0pos.getX(), 2.0)));
            Matrix3d rotMatX = new Matrix3d();
            rotMatX.rotX(angleToRotateX);
            newT3d.mul(new Transform3D(rotMatX, new Vector3d(), 1.0));
            Vector3d point0InPlane = new Vector3d(point0pos);
            Matrix3d currentRotMat = new Matrix3d();
            newT3d.get(currentRotMat);
            Vector3d point1InPlane = new Vector3d();
            currentRotMat.getColumn(0, point1InPlane);
            point1InPlane.add((Tuple3d)point0InPlane);
            Vector3d point2InPlane = new Vector3d();
            currentRotMat.getColumn(2, point2InPlane);
            point2InPlane.add((Tuple3d)point0InPlane);
            Vector3d endOfZAxisAtPointOne = new Vector3d();
            Matrix3d pointOneRotMat = new Matrix3d();
            this.getPointOne().getTransform().get(pointOneRotMat);
            pointOneRotMat.getColumn(2, endOfZAxisAtPointOne);
            endOfZAxisAtPointOne.add((Tuple3d)this.getPointOne().getTransformPosition());
            Point3d projectionOfPointOneZAxisOntoXZPlane = this.getProjectionOfPointOntoPlane(new Point3d((Tuple3d)endOfZAxisAtPointOne), new Point3d((Tuple3d)point0InPlane), new Point3d((Tuple3d)point1InPlane), new Point3d((Tuple3d)point2InPlane));
            Vector3d desiredZAxis = new Vector3d();
            desiredZAxis.sub((Tuple3d)projectionOfPointOneZAxisOntoXZPlane, (Tuple3d)this.getPointOne().getTransformPosition());
            desiredZAxis.normalize();
            Vector3d currentZAxis = new Vector3d();
            currentRotMat.getColumn(2, currentZAxis);
            double angleToRotateY = -Math.acos(desiredZAxis.dot(currentZAxis));
            if (Double.isNaN(angleToRotateY)) {
                angleToRotateY = -Math.acos(Math.round(desiredZAxis.dot(currentZAxis)));
            }
            Matrix3d rotMatY = new Matrix3d();
            rotMatY.rotY(angleToRotateY);
            newT3d.mul(new Transform3D(rotMatY, new Vector3d(), 1.0));
            newT3d.setTranslation(new Vector3d(this.getPointOne().getTransformPosition()));
            Transform3D originalTransform = new Transform3D(this.getTransform());
            this.setNewTransform(newT3d);
            if (!originalTransform.epsilonEquals(newT3d, Double.MIN_VALUE)) {
                this.publishTransformChanges();
            }
            this.recalculateViewTransform();
        }
    }

    public void recalculateViewTransform() {
        Matrix4d cameraOrientationMatrix = new Matrix4d(0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Transform3D cameraOrientation = new Transform3D(cameraOrientationMatrix);
        Transform3D translationToCenter = new Transform3D();
        translationToCenter.setTranslation(new Vector3d(this.cameraDistance, this.cameraOffset, this.cameraHeight));
        Transform3D t3d = new Transform3D(this.getTransform());
        t3d.mul(translationToCenter);
        t3d.mul(cameraOrientation);
        this.setNewCameraTransform(t3d);
        this.publishViewChanges();
    }

    public void moveView(double deltaDistance, double deltaX, double deltaY) {
        double newCameraDistance = this.cameraDistance + deltaDistance;
        double newCameraOffset = this.cameraOffset + deltaX;
        double newCameraHeight = this.cameraHeight + deltaY;
        if (newCameraDistance > 5.0) {
            newCameraDistance = 5.0;
        }
        if (newCameraDistance < 0.3) {
            newCameraDistance = 0.3;
        }
        if (newCameraOffset < -1.0) {
            newCameraOffset = -1.0;
        }
        if (newCameraOffset > 1.0) {
            newCameraOffset = 1.0;
        }
        if (newCameraHeight > 0.7) {
            newCameraHeight = 0.7;
        }
        if (newCameraHeight < -0.7) {
            newCameraHeight = -0.7;
        }
        if (newCameraDistance != this.cameraDistance || newCameraHeight != this.cameraHeight || newCameraOffset != this.cameraOffset) {
            this.cameraDistance = newCameraDistance;
            this.cameraHeight = newCameraHeight;
            this.cameraOffset = newCameraOffset;
            this.recalculateViewTransform();
        }
    }

    public double[] getView() {
        return new double[]{this.cameraDistance, this.cameraOffset, this.cameraHeight};
    }

    public void resetView() {
        if (this.robotInstallationSite.getInstallation() == null) {
            return;
        }
        this.cameraOffset = 0.0;
        this.cameraHeight = 0.2;
        this.cameraDistance = 1.5;
        this.recalculateViewTransform();
        this.updateVisualization();
    }

    public boolean arePointsTooClose() {
        Point3d point1;
        Point3d point0;
        boolean returnVal = true;
        if (this.children.size() == 2 && (point0 = new Point3d((Tuple3d)this.getPointOne().getTransformPosition())).distance(point1 = new Point3d((Tuple3d)this.getPointTwo().getTransformPosition())) > 0.01) {
            returnVal = false;
        }
        return returnVal;
    }

    private Point3d getProjectionOfPointOntoPlane(Point3d pointToProject, Point3d point0Inplane, Point3d point1Inplane, Point3d point2Inplane) {
        Point3d projection = new Point3d();
        if (!this.isUndefined()) {
            Vector3d p0 = new Vector3d((Tuple3d)point0Inplane);
            Vector3d p1 = new Vector3d((Tuple3d)point1Inplane);
            Vector3d p2 = new Vector3d((Tuple3d)point2Inplane);
            Vector3d p0p1 = new Vector3d();
            p0p1.sub((Tuple3d)p1, (Tuple3d)p0);
            Vector3d p0p2 = new Vector3d();
            p0p2.sub((Tuple3d)p2, (Tuple3d)p0);
            Vector3d planeNormal = new Vector3d();
            planeNormal.cross(p0p1, p0p2);
            double a = planeNormal.x;
            double b = planeNormal.y;
            double c = planeNormal.z;
            double d = -a * p0.x - b * p0.y - c * p0.z;
            double t0 = -((a * pointToProject.x + b * pointToProject.y + c * pointToProject.z + d) / (a * a + b * b + c * c));
            projection.x = pointToProject.x + a * t0;
            projection.y = pointToProject.y + b * t0;
            projection.z = pointToProject.z + c * t0;
        }
        return projection;
    }

    protected int getDesiredChildCount() {
        return 2;
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return LanguagePack.getCommandNamesResource().geomLine();
    }

    public Pose6d getTcpOffset() {
        return this.isUndefined() ? null : this.getPointOne().getTcpOffset();
    }
}

