/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup.treenodes.geom;

import com.sun.j3d.utils.geometry.Cylinder;
import com.ur.lang.naming.NamedEntity;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.geomfeature.PlaneSpatialFeature;
import com.ur.polyscope.geomfeature.PoseSpatialFeature;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.visualizer.geomfeature.GeomBranchNode;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.tools.LanguagePack;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class GeomPlaneNode
extends GeomBranchNode
implements PlaneSpatialFeature {
    private final int desiredChildCount = 3;
    private double cameraOffset;
    private double cameraHeight;
    private double cameraDistance;
    private transient ProgramVisualization progVis = null;
    private boolean hasUserPoints = false;
    private boolean manualEdited = false;
    private List<GeomPoseNode> userPoints = new ArrayList<GeomPoseNode>();
    private RobotInstallationSite robotInstallationSite;

    @Inject
    public GeomPlaneNode(RobotInstallationSite robotInstallationSite) {
        this.robotInstallationSite = robotInstallationSite;
        this.resetView();
    }

    public GeomPoseNode getPoint(int pointNumber) {
        GeomPoseNode node = null;
        if (pointNumber >= 0 && pointNumber < 3 && this.getChildCount() > pointNumber) {
            try {
                node = (GeomPoseNode)((Object)this.children.get(pointNumber));
            }
            catch (Exception e) {
                System.err.println("GeomPlaneNode.getPoint() Error: This object had a child which was non-GeomPoseNode: " + e);
                e.printStackTrace();
                node = null;
            }
        }
        return node;
    }

    public boolean sameAs(NamedEntity entityToCompareTo) {
        if (this == entityToCompareTo) {
            return true;
        }
        if (!this.getName().equals(entityToCompareTo.getName())) {
            return false;
        }
        if (entityToCompareTo instanceof GeomPlaneNode) {
            GeomPlaneNode gpn = (GeomPlaneNode)entityToCompareTo;
            if (gpn.getChildCount() != this.getChildCount()) {
                return false;
            }
            int i = 0;
            while (i < this.getChildCount()) {
                if (!gpn.getChildAt(i).equals(this.getChildAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.sameAs(entityToCompareTo);
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return LanguagePack.getCommandNamesResource().geomPlane();
    }

    private void updateVisualization() {
        if (this.progVis == null) {
            return;
        }
        if (!this.isUndefined()) {
            double radius = 0.4;
            double height = 0.005;
            Cylinder cyl = new Cylinder((float)radius, (float)height, 3, 32, 1, this.getGeomFeatureAppearance());
            Matrix4d m = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            Transform3D cylTrans = new Transform3D(this.getTransform());
            cylTrans.mul(new Transform3D(m));
            TransformGroup tg = new TransformGroup(cylTrans);
            tg.addChild((Node)cyl);
            BranchGroup bg = new BranchGroup();
            bg.addChild((Node)tg);
            this.progVis.getGeomBranchGroup().addChild((Node)bg);
            this.progVis.setGeomFeaturesVisibleState(true);
            if (!this.hasHiddenSubFeatureChildren()) {
                Point3d[] points = new Point3d[]{new Point3d((Tuple3d)this.getPoint(0).getTransformPosition()), new Point3d((Tuple3d)this.getPoint(1).getTransformPosition()), new Point3d((Tuple3d)this.getPoint(2).getTransformPosition())};
                this.progVis.drawPoints(points);
            }
        }
    }

    public void setProgramVisualization(ProgramVisualization programVisualization) {
        this.progVis = programVisualization;
        this.recalculateTransform();
        this.updateVisualization();
        this.progVis.setGeomFeaturesVisibleState(true);
    }

    protected void recalculateTransformSubClass() {
        if (!this.isUndefined()) {
            Transform3D newT3d = new Transform3D();
            Vector3d positionPoint0 = this.getPoint(0).getTransformPosition();
            Vector3d positionPoint1 = this.getPoint(1).getTransformPosition();
            Vector3d positionPoint2 = this.getPoint(2).getTransformPosition();
            Vector3d a = new Vector3d(positionPoint1.x - positionPoint0.x, positionPoint1.y - positionPoint0.y, positionPoint1.z - positionPoint0.z);
            a.normalize();
            Vector3d b = new Vector3d(positionPoint2.x - positionPoint0.x, positionPoint2.y - positionPoint0.y, positionPoint2.z - positionPoint0.z);
            b.normalize();
            Vector3d planeNormal = new Vector3d();
            planeNormal.cross(b, a);
            planeNormal.normalize();
            Vector3d newXAxis = new Vector3d(a);
            newXAxis.cross(a, planeNormal);
            Matrix3d newRotMat = new Matrix3d(newXAxis.x, a.x, planeNormal.x, newXAxis.y, a.y, planeNormal.y, newXAxis.z, a.z, planeNormal.z);
            newT3d.set(newRotMat);
            Vector3d currentZaxis = new Vector3d();
            newRotMat.getColumn(2, currentZaxis);
            Matrix3d rotMatFirstPoint = this.getPoint(0).getTransformRotation();
            Vector3d firstPointZaxis = new Vector3d();
            rotMatFirstPoint.getColumn(2, firstPointZaxis);
            double angleBetweenZAxes = firstPointZaxis.angle(currentZaxis);
            if (Math.abs(angleBetweenZAxes) > 1.5707963267948966) {
                Matrix3d r = new Matrix3d();
                r.rotX(Math.PI);
                newT3d.mul(new Transform3D(r, new Vector3d(), 1.0));
                Matrix3d r1 = new Matrix3d();
                r1.rotZ(Math.PI);
                newT3d.mul(new Transform3D(r1, new Vector3d(), 1.0));
            }
            newT3d.setTranslation(this.getPoint(0).getTransformPosition());
            Transform3D originalTransform = new Transform3D(this.getTransform());
            this.setNewTransform(newT3d);
            if (!originalTransform.epsilonEquals(newT3d, Double.MIN_VALUE)) {
                this.publishTransformChanges();
            }
            this.recalculateViewTransform();
        }
    }

    public void recalculateViewTransform() {
        Transform3D newCameraT3d = new Transform3D(this.getTransform());
        Matrix4d cameraOrientationMatrix = new Matrix4d(0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Transform3D cameraOrientation = new Transform3D(cameraOrientationMatrix);
        Transform3D translationToCenter = new Transform3D();
        translationToCenter.setTranslation(new Vector3d(this.cameraDistance, this.cameraOffset, this.cameraHeight));
        newCameraT3d.mul(translationToCenter);
        newCameraT3d.mul(cameraOrientation);
        this.setNewCameraTransform(newCameraT3d);
        this.publishViewChanges();
    }

    public void moveView(double deltaDistance, double deltaX, double deltaY) {
        double newCameraDistance = this.cameraDistance + deltaDistance;
        double newCameraOffset = this.cameraOffset + 0.5 * deltaX;
        double newCameraHeight = this.cameraHeight + 0.5 * deltaY;
        if (newCameraDistance > 5.0) {
            newCameraDistance = 5.0;
        }
        if (newCameraDistance < 0.3) {
            newCameraDistance = 0.3;
        }
        if (newCameraHeight > 0.7) {
            newCameraHeight = 0.7;
        }
        if (newCameraHeight < -0.7) {
            newCameraHeight = -0.7;
        }
        if (newCameraOffset > 0.7) {
            newCameraOffset = 0.7;
        }
        if (newCameraOffset < -0.7) {
            newCameraOffset = -0.7;
        }
        if (newCameraDistance != this.cameraDistance || newCameraHeight != this.cameraHeight || newCameraOffset != this.cameraOffset) {
            this.cameraDistance = newCameraDistance;
            this.cameraHeight = newCameraHeight;
            this.cameraOffset = newCameraOffset;
            this.recalculateViewTransform();
        }
    }

    public double[] getView() {
        return new double[]{this.cameraDistance, this.cameraOffset, this.cameraHeight};
    }

    public void resetView() {
        if (this.robotInstallationSite.getInstallation() == null) {
            return;
        }
        this.cameraOffset = 0.0;
        this.cameraHeight = 0.2;
        this.cameraDistance = 1.5;
        this.recalculateViewTransform();
        this.updateVisualization();
    }

    public boolean arePointsTooClose() {
        if (this.isManualEdited()) {
            return false;
        }
        boolean returnVal = true;
        if (this.children.size() == 3) {
            Point3d point0 = new Point3d((Tuple3d)this.getPoint(0).getTransformPosition());
            Point3d point1 = new Point3d((Tuple3d)this.getPoint(1).getTransformPosition());
            Point3d point2 = new Point3d((Tuple3d)this.getPoint(2).getTransformPosition());
            if (point0.distance(point1) > 0.01 && point0.distance(point2) > 0.01 && point1.distance(point2) > 0.01) {
                returnVal = false;
            }
        }
        return returnVal;
    }

    public boolean arePointsOnALine() {
        if (this.isManualEdited()) {
            return false;
        }
        boolean returnVal = false;
        if (this.children.size() == 3) {
            Point3d point0 = new Point3d((Tuple3d)this.getPoint(0).getTransformPosition());
            Point3d point1 = new Point3d((Tuple3d)this.getPoint(1).getTransformPosition());
            Point3d point2 = new Point3d((Tuple3d)this.getPoint(2).getTransformPosition());
            Vector3d vector0 = new Vector3d(point1.x - point0.x, point1.y - point0.y, point1.z - point0.z);
            Vector3d vector1 = new Vector3d(point2.x - point0.x, point2.y - point0.y, point2.z - point0.z);
            Vector3d vector2 = new Vector3d(point2.x - point1.x, point2.y - point1.y, point2.z - point1.z);
            double degreeEPS = 5.0;
            double radianEps = degreeEPS / 180.0 * Math.PI;
            double piMinusRadianEps = Math.PI - radianEps;
            double angle0 = vector0.angle(vector1);
            double angle1 = vector0.angle(vector2);
            double angle2 = vector1.angle(vector2);
            if (angle0 < radianEps || angle0 > piMinusRadianEps || angle1 < radianEps || angle1 > piMinusRadianEps || angle2 < radianEps || angle2 > piMinusRadianEps) {
                returnVal = true;
            }
        }
        return returnVal;
    }

    protected int getDesiredChildCount() {
        return 3;
    }

    public static String getFeatureClassName() {
        return LanguagePack.getCommandNamesResource().geomPlane();
    }

    public Pose6d getTcpOffset() {
        return this.isUndefined() ? null : this.getPoint(0).getTcpOffset();
    }

    public PoseSpatialFeature getPointOne() {
        return this.getPoint(0);
    }

    public PoseSpatialFeature getPointTwo() {
        return this.getPoint(1);
    }

    public PoseSpatialFeature getPointThree() {
        return this.getPoint(2);
    }

    public void setHasUserPoints(boolean hasUserPoints) {
        this.hasUserPoints = hasUserPoints;
    }

    public boolean getHasUserPoints() {
        return this.hasUserPoints;
    }

    public void setUserPoints(List<GeomPoseNode> userPoints) {
        this.userPoints = userPoints;
    }

    public List<GeomPoseNode> getUserPoints() {
        return this.userPoints;
    }

    public boolean isManualEdited() {
        return this.manualEdited;
    }

    public void setManualEdited(boolean manualEdited) {
        this.manualEdited = manualEdited;
    }
}

