/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup.treenodes.geom;

import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamedEntity;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.geomfeature.PoseSpatialFeature;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.JoggableGeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.util.logging.Log;
import com.ur.view.hmc.HMC;
import gui.program.position.LegacyPosition;
import gui.tools.LanguagePack;
import javax.inject.Inject;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class GeomPoseNode
extends JoggableGeomFeature
implements PoseSpatialFeature {
    private LegacyPosition position;
    private Pose6d tcpOffset;
    private double cameraOffset;
    private double cameraHeight;
    private double cameraDistance;
    private RobotInstallationSite robotInstallationSite;

    @Inject
    public GeomPoseNode(RobotInstallationSite robotInstallationSite) {
        this.robotInstallationSite = robotInstallationSite;
        this.allowsChildren = false;
        this.position = new LegacyPosition();
        this.tcpOffset = null;
        this.resetView();
    }

    public boolean sameAs(NamedEntity entityToCompareTo) {
        if (this == entityToCompareTo) {
            return true;
        }
        if (!this.getName().equals(entityToCompareTo.getName())) {
            return false;
        }
        boolean returnValue = false;
        if (entityToCompareTo instanceof GeomPoseNode) {
            GeomPoseNode node = (GeomPoseNode)entityToCompareTo;
            if (!this.isUndefined() && !node.isUndefined() && node.getPositionReference() == this.getPositionReference()) {
                returnValue = true;
            }
        } else {
            returnValue = super.sameAs(entityToCompareTo);
        }
        return returnValue;
    }

    public void makeNewPositionReferences() {
        LegacyPosition positionTemp = new LegacyPosition();
        positionTemp.set(this.position.getJointPositionVector(), this.position.getToolPosition(), this.position.getToolAxisAngle());
        this.position = positionTemp;
        this.tcpOffset = this.tcpOffset == null ? null : new Pose6d(this.tcpOffset);
    }

    public void copyValuesFromEntity(GeomFeature entityToCopyValuesFrom) {
        if (entityToCopyValuesFrom instanceof GeomPoseNode) {
            GeomPoseNode tmp = (GeomPoseNode)entityToCopyValuesFrom;
            this.setPositionReference(tmp.getPositionReference());
            this.setTcpOffsetReference(tmp.getTcpOffset());
            this.setIsVariable(tmp.isVariable(), false);
            if (!EqualsUtil.equals((Object)this.getName(), (Object)tmp.getName())) {
                this.setName(tmp.getName());
            }
        } else {
            Log.error((String)"This object was told to copy a non-GeomPoseNode: ");
        }
    }

    public LegacyPosition getPositionReference() {
        return this.position;
    }

    private void setPositionReference(LegacyPosition positionIn) {
        if (this.position != positionIn) {
            this.position = positionIn;
        }
        this.resetView();
        this.recalculateTransform();
    }

    public void setPosition(JointPositionVector jointPositionVector, Point3d toolPosition, Point3d toolAxisAngle) {
        this.position.set(jointPositionVector, toolPosition, toolAxisAngle);
        this.resetView();
        this.recalculateTransform();
    }

    public void setPosition(JointPositionVector jointPositionVector, Pose6d tool) {
        this.position.set(jointPositionVector, new Point3d((Tuple3d)tool.getPos()), new Point3d((Tuple3d)tool.getRot()));
        this.resetView();
        this.recalculateTransform();
    }

    public void setPositionNoRecalculate(JointPositionVector jointPositionVector, Pose6d tool) {
        this.position.set(jointPositionVector, new Point3d((Tuple3d)tool.getPos()), new Point3d((Tuple3d)tool.getRot()));
    }

    public Pose6d getTcpOffset() {
        return this.tcpOffset == null ? null : new Pose6d(this.tcpOffset);
    }

    public void setTcpOffset(Pose6d tcpOffset) {
        if (this.tcpOffset == null) {
            this.tcpOffset = new Pose6d();
        }
        this.tcpOffset.set(tcpOffset);
    }

    public void setTcpOffsetReference(Pose6d tcpOffset) {
        this.tcpOffset = tcpOffset;
    }

    public Pose6d getPose() {
        return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)this.getTransform());
    }

    public boolean isUndefined() {
        return this.position.isUndefined();
    }

    public String toString() {
        return this.getName();
    }

    public void setProgramVisualization(ProgramVisualization programVisualization) {
    }

    public void moveView(double deltaDistance, double deltaX, double deltaY) {
        double newCameraDistance = this.cameraDistance + deltaDistance;
        double newCameraOffset = this.cameraOffset + 0.5 * deltaX;
        double newCameraAngle = this.cameraHeight + 0.5 * deltaY;
        if (newCameraDistance > 5.0) {
            newCameraDistance = 5.0;
        }
        if (newCameraDistance < 0.3) {
            newCameraDistance = 0.3;
        }
        if (newCameraOffset < -1.0) {
            newCameraOffset = -1.0;
        }
        if (newCameraOffset > 1.0) {
            newCameraOffset = 1.0;
        }
        if (newCameraDistance != this.cameraDistance || newCameraOffset != this.cameraOffset || newCameraAngle != this.cameraHeight) {
            this.cameraHeight = newCameraAngle;
            this.cameraDistance = newCameraDistance;
            this.cameraOffset = newCameraOffset;
            this.recalculateViewTransform();
        }
    }

    public double[] getView() {
        return new double[]{this.cameraDistance, this.cameraOffset, this.cameraHeight};
    }

    public void resetView() {
        this.cameraOffset = 0.0;
        this.cameraHeight = 0.2;
        this.cameraDistance = 1.5;
        if (this.robotInstallationSite.getInstallation() == null) {
            return;
        }
        this.recalculateViewTransform();
    }

    public void recalculateViewTransform() {
        Matrix4d cameraOrientationMatrix = new Matrix4d(0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Transform3D cameraOrientation = new Transform3D(cameraOrientationMatrix);
        Transform3D translationToCenter = new Transform3D();
        translationToCenter.setTranslation(new Vector3d(this.cameraDistance, this.cameraOffset, this.cameraHeight));
        Transform3D newCameraT3d = new Transform3D(this.getTransform());
        newCameraT3d.mul(translationToCenter);
        newCameraT3d.mul(cameraOrientation);
        this.setNewCameraTransform(newCameraT3d);
        this.publishViewChanges();
    }

    public void recalculateTransform() {
        if (this.position.isUndefined()) {
            return;
        }
        Transform3D t3d = new Transform3D();
        Vector3d axisAnglePoint = new Vector3d((Tuple3d)this.position.getToolAxisAngle());
        AxisAngle4d aaPoint = new AxisAngle4d(axisAnglePoint, axisAnglePoint.length());
        t3d.set(aaPoint);
        Vector3d posv = new Vector3d((Tuple3d)this.position.getToolPosition());
        t3d.setTranslation(posv);
        Transform3D originalTransform = new Transform3D(this.getTransform());
        this.setNewTransform(t3d);
        if (!originalTransform.epsilonEquals(t3d, Double.MIN_VALUE)) {
            this.publishTransformChanges();
        }
        this.recalculateViewTransform();
    }

    public JointPositionVector getJointPositionVector() {
        return this.position.getJointPositionVector();
    }

    public static String getFeatureClassName() {
        return LanguagePack.getCommandNamesResource().geomPoint();
    }

    public void setSpatialPose(ToolPosition pose) {
        Pose6d pose6d = new Pose6d(pose.asArray());
        Point3d toolPosition = new Point3d((Tuple3d)pose6d.getPos());
        Point3d toolAxisAngle = new Point3d((Tuple3d)pose6d.getRot());
        JointPositionVector robotJointPosition = RobotState.getLatestRobotState().jointPosition;
        JointPositionVector jointPosition = new HMC().getInverseKinematics(toolPosition, toolAxisAngle, robotJointPosition);
        this.position.set(jointPosition, toolPosition, toolAxisAngle);
        this.recalculateTransform();
    }
}

