/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup.treenodes.geom;

import com.ur.i18n.TextResource;
import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamedEntity;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.OnDispose;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.controller.ConfigurationState;
import com.ur.polyscope.scriptwriter.PreambleScript;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.GeomFeatureObserver;
import com.ur.polyscope.visualizer.geomfeature.ISetupFeatureContainerNode;
import com.ur.swing.CardPanel;
import com.ur.swing.card.GetCardClass;
import com.ur.util.CollectionUtils;
import com.ur.util.Predicate;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.view.hmc.ControllerSocketSender;
import gui.geom.BaseView;
import gui.geom.CameraView;
import gui.geom.ToolView;
import gui.geom.WorldTransform;
import gui.polyscope.setup.treenodes.geom.GeomLineNode;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import gui.program.services.geom.GeomFeatureReferenceBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.inject.Inject;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class SetupFeatureContainerNode
extends DefaultMutableTreeNode
implements OnDispose,
InstallationComponent,
GetCardClass,
ISetupFeatureContainerNode,
PreambleScript {
    private transient DefaultTreeModel setupTreeModel;
    private transient Vector<GeomFeature> viewWorldFeatures;
    private RobotConfigurationProvider robotConfigurationProvider;
    private ConfigurationState configurationState;
    private TextResource textResource;

    @Inject
    public SetupFeatureContainerNode(BaseView baseView, ToolView toolView, RobotConfigurationProvider robotConfigurationProvider, ConfigurationState configurationState, TextResource textResource) {
        this.robotConfigurationProvider = robotConfigurationProvider;
        this.configurationState = configurationState;
        this.textResource = textResource;
        this.add((MutableTreeNode)((Object)baseView));
        this.add((MutableTreeNode)((Object)toolView));
    }

    public Class<?> getType() {
        return SetupFeatureContainerNode.class;
    }

    public DefaultTreeModel getTreeModel() {
        return this.setupTreeModel;
    }

    public void setTreeModel(DefaultTreeModel setupTreeModel) {
        this.setupTreeModel = setupTreeModel;
    }

    public Class<? extends CardPanel> getCardClass() {
        return null;
    }

    public Collection<GeomFeature> getAllGeomNodes() {
        return this.removeUndefinedFeatures(this.getFeatures());
    }

    private List<GeomFeature> removeUndefinedFeatures(List<GeomFeature> features) {
        Iterator<GeomFeature> iterator = features.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isDefined()) continue;
            iterator.remove();
        }
        return features;
    }

    public List<GeomFeature> getFeatures() {
        ArrayList<GeomFeature> featuresOfClass = new ArrayList<GeomFeature>();
        Enumeration<TreeNode> allFeatures = this.breadthFirstEnumeration();
        allFeatures.nextElement();
        while (allFeatures.hasMoreElements()) {
            GeomFeature geomFeature;
            TreeNode feature = allFeatures.nextElement();
            if (!(feature instanceof GeomFeature) || (geomFeature = (GeomFeature)feature).isHiddenSubFeature()) continue;
            featuresOfClass.add(geomFeature);
        }
        return featuresOfClass;
    }

    public Collection<SpatialFeature> getAllSpatialFeatures() {
        ArrayList<SpatialFeature> featuresOfClass = new ArrayList<SpatialFeature>();
        Enumeration<TreeNode> allFeatures = this.breadthFirstEnumeration();
        allFeatures.nextElement();
        while (allFeatures.hasMoreElements()) {
            GeomFeature geomFeature;
            TreeNode feature = allFeatures.nextElement();
            if (!(feature instanceof GeomFeature) || (geomFeature = (GeomFeature)feature).isHiddenSubFeature()) continue;
            featuresOfClass.add((SpatialFeature)geomFeature);
        }
        return featuresOfClass;
    }

    public List<GeomFeature> getLinkableFeatures() {
        ArrayList<GeomFeature> linkableFeatures = new ArrayList<GeomFeature>();
        Enumeration<TreeNode> allFeatures = this.breadthFirstEnumeration();
        allFeatures.nextElement();
        while (allFeatures.hasMoreElements()) {
            TreeNode feature = allFeatures.nextElement();
            if (!(feature instanceof GeomFeature) || !this.isLinkable((GeomFeature)feature)) continue;
            linkableFeatures.add((GeomFeature)feature);
        }
        return linkableFeatures;
    }

    public boolean isLinkable(GeomFeature feature) {
        return feature instanceof GeomPoseNode && !(feature instanceof GeomPoseNodeContributed);
    }

    private List<GeomFeature> getTopLevelFeaturesOfGeomPoseNode() {
        return this.getTopLevelFeaturesOf(new Predicate<GeomFeature>(){

            public boolean test(GeomFeature geomFeature) {
                return geomFeature instanceof GeomPoseNode && !(geomFeature instanceof GeomPoseNodeContributed);
            }
        });
    }

    private List<GeomFeature> getTopLevelFeaturesOfGeomLineNode() {
        return this.getTopLevelFeaturesOf(new Predicate<GeomFeature>(){

            public boolean test(GeomFeature geomFeature) {
                return geomFeature instanceof GeomLineNode;
            }
        });
    }

    private List<GeomFeature> getTopLevelFeaturesOfGeomPlaneNode() {
        return this.getTopLevelFeaturesOf(new Predicate<GeomFeature>(){

            public boolean test(GeomFeature geomFeature) {
                return geomFeature instanceof GeomPlaneNode;
            }
        });
    }

    private List<GeomFeature> getTopLevelFeaturesOfGeomPoseNodeContributed() {
        return this.getTopLevelFeaturesOf(new Predicate<GeomFeature>(){

            public boolean test(GeomFeature geomFeature) {
                return geomFeature instanceof GeomPoseNodeContributed;
            }
        });
    }

    private List<GeomFeature> getTopLevelFeaturesOf(Predicate<GeomFeature> predicate) {
        ArrayList<GeomFeature> topLevelFeaturesOfClass = new ArrayList<GeomFeature>();
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            GeomFeature geomFeature;
            TreeNode feature = enumeration.nextElement();
            if (!(feature instanceof GeomFeature) || (geomFeature = (GeomFeature)feature).isHiddenSubFeature() || !predicate.test((Object)geomFeature)) continue;
            topLevelFeaturesOfClass.add(geomFeature);
        }
        return topLevelFeaturesOfClass;
    }

    public Collection<GeomFeature> getUniqueGeomNodes(boolean nodesMustBeDefined) {
        List<GeomFeature> geomNodes = this.getFeatures();
        ArrayList<GeomFeature> result = new ArrayList<GeomFeature>();
        for (GeomFeature node : geomNodes) {
            if (nodesMustBeDefined && node.isUndefined()) continue;
            boolean isFound = false;
            for (GeomFeature each : result) {
                if (!each.sameAs((NamedEntity)node)) continue;
                isFound = true;
                break;
            }
            if (isFound) continue;
            result.add(node);
        }
        return result;
    }

    public BaseView getBaseViewFeature() {
        return (BaseView)((Object)this.getChildAt(0));
    }

    public ToolView getToolViewFeature() {
        return (ToolView)((Object)this.getChildAt(1));
    }

    private void clearGeomFeaturesSubscriptions() {
        Collection<GeomFeature> geomNodes = this.getAllGeomNodes();
        for (GeomFeature feature : geomNodes) {
            feature.removeAllSubscribers();
        }
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        if (newChild instanceof GeomFeature) {
            EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

                public void notify(InstallationStateListener listener) {
                    listener.installationModified();
                }
            });
        }
        super.insert(newChild, childIndex);
    }

    @Override
    public void remove(int childIndex) {
        TreeNode node = this.getChildAt(childIndex);
        if (node instanceof GeomFeature) {
            EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

                public void notify(InstallationStateListener listener) {
                    listener.installationModified();
                }
            });
        }
        super.remove(childIndex);
    }

    public boolean insertGeomNode(GeomPoseNode newNode) {
        int indexToInsertAt = 2;
        indexToInsertAt += this.getTopLevelFeaturesOfGeomPoseNode().size();
        if (newNode instanceof GeomPoseNodeContributed) {
            indexToInsertAt += this.getTopLevelFeaturesOfGeomLineNode().size();
            indexToInsertAt += this.getTopLevelFeaturesOfGeomPlaneNode().size();
            indexToInsertAt += this.getTopLevelFeaturesOfGeomPoseNodeContributed().size();
        }
        this.setupTreeModel.insertNodeInto((MutableTreeNode)((Object)newNode), this, indexToInsertAt);
        this.setupTreeModel.nodeChanged((TreeNode)((Object)newNode));
        newNode.environmentChange();
        this.notifyFeatureAdded((GeomFeature)newNode);
        return true;
    }

    public boolean insertGeomLineNodeBetweenPoints(GeomLineNode lineNode, GeomPoseNode point1, GeomPoseNode point2) {
        int indexToInsertAt = 2;
        indexToInsertAt += this.getTopLevelFeaturesOfGeomPoseNode().size();
        lineNode.add((MutableTreeNode)((Object)point1));
        lineNode.add((MutableTreeNode)((Object)point2));
        this.setupTreeModel.insertNodeInto((MutableTreeNode)((Object)lineNode), this, indexToInsertAt += this.getTopLevelFeaturesOfGeomLineNode().size());
        this.setupTreeModel.nodeChanged((TreeNode)((Object)point2));
        point2.environmentChange();
        this.notifyFeatureAdded((GeomFeature)lineNode);
        return true;
    }

    public boolean insertGeomPlaneNodeWithPoints(GeomPlaneNode planeNode, GeomPoseNode point1, GeomPoseNode point2, GeomPoseNode point3) {
        int indexToInsertAt = 2;
        indexToInsertAt += this.getTopLevelFeaturesOfGeomPoseNode().size();
        indexToInsertAt += this.getTopLevelFeaturesOfGeomLineNode().size();
        planeNode.add((MutableTreeNode)((Object)point1));
        planeNode.add((MutableTreeNode)((Object)point2));
        planeNode.add((MutableTreeNode)((Object)point3));
        this.setupTreeModel.insertNodeInto((MutableTreeNode)((Object)planeNode), this, indexToInsertAt += this.getTopLevelFeaturesOfGeomPlaneNode().size());
        this.notifyFeatureAdded((GeomFeature)planeNode);
        return true;
    }

    public void removeGeomFeature(GeomFeature nodeToRemove) {
        nodeToRemove.removeAllSubscribers();
        this.setupTreeModel.removeNodeFromParent((MutableTreeNode)nodeToRemove);
        nodeToRemove.environmentChange();
        this.notifyFeatureRemoved(nodeToRemove);
    }

    private void notifyFeatureAdded(GeomFeature feature) {
        final ArrayList<GeomFeature> features = new ArrayList<GeomFeature>();
        Enumeration featureEnumeration = feature.preorderEnumeration();
        while (featureEnumeration.hasMoreElements()) {
            features.add((GeomFeature)featureEnumeration.nextElement());
        }
        EventNotificationService.notify(GeomFeatureObserver.class, (NotificationStrategy)new NotificationStrategy<GeomFeatureObserver>(){

            public void notify(GeomFeatureObserver listener) {
                listener.added((Iterable)features);
            }
        });
    }

    private void notifyFeatureRemoved(GeomFeature feature) {
        final ArrayList<GeomFeature> features = new ArrayList<GeomFeature>();
        Enumeration featureEnumeration = feature.preorderEnumeration();
        while (featureEnumeration.hasMoreElements()) {
            features.add((GeomFeature)featureEnumeration.nextElement());
        }
        EventNotificationService.notify(GeomFeatureObserver.class, (NotificationStrategy)new NotificationStrategy<GeomFeatureObserver>(){

            public void notify(GeomFeatureObserver listener) {
                listener.removed((Iterable)features);
            }
        });
    }

    public <T extends GeomFeature> T getFeatureByName(String name) {
        for (GeomFeature each : this.getFeatures()) {
            if (!EqualsUtil.equals((Object)each.getName(), (Object)name) && !EqualsUtil.equals((Object)name, (Object)GeomFeatureReferenceBase.getFeatureClassName(each.getName()))) continue;
            return (T)each;
        }
        return null;
    }

    public void setWorldFeatures(CameraView view, WorldTransform transform) {
        this.viewWorldFeatures = new Vector();
        this.viewWorldFeatures.add((GeomFeature)view);
        this.viewWorldFeatures.add(transform);
    }

    public Collection<GeomFeature> getWorldFeatures() {
        return this.viewWorldFeatures;
    }

    public GeomFeature[] getJoggableGeomNodes() {
        ArrayList<CameraView> result = new ArrayList<CameraView>();
        result.add(this.getCameraView());
        result.addAll(this.getAllGeomNodes());
        return CollectionUtils.filter(result, (Predicate)new OnlyJoggableFeatures()).toArray(new GeomFeature[0]);
    }

    public CameraView getCameraView() {
        if (this.viewWorldFeatures == null) {
            this.createWorldFeatures();
        }
        return (CameraView)this.viewWorldFeatures.elementAt(0);
    }

    private void createWorldFeatures() {
        WorldTransform transform = new WorldTransform();
        this.setWorldFeatures(new CameraView(transform, this.robotConfigurationProvider, this.configurationState), transform);
    }

    public boolean hasWorldTransform() {
        return this.viewWorldFeatures != null && this.getWorldTransform() != null;
    }

    public WorldTransform getWorldTransform() {
        if (this.viewWorldFeatures == null) {
            this.createWorldFeatures();
        }
        return (WorldTransform)this.viewWorldFeatures.elementAt(1);
    }

    @Override
    public String toString() {
        return this.textResource.Features();
    }

    public List<GeomFeature> getSelectableFeatures() {
        ArrayList<GeomFeature> newGeomFeatures = new ArrayList<GeomFeature>();
        for (GeomFeature each : this.getUniqueGeomNodes(true)) {
            if (!each.isFirstLevelFeature()) continue;
            newGeomFeatures.add(each);
        }
        return newGeomFeatures;
    }

    public List<GeomFeature> getAllGeomFeatures() {
        return this.getGeomFeatures(false);
    }

    public List<GeomFeature> getAllDefinedGeomFeatures() {
        return this.getGeomFeatures(true);
    }

    private List<GeomFeature> getGeomFeatures(boolean mustBeDefined) {
        ArrayList<GeomFeature> newGeomFeatures = new ArrayList<GeomFeature>();
        newGeomFeatures.add((GeomFeature)this.getCameraView());
        newGeomFeatures.add(this.getWorldTransform());
        newGeomFeatures.addAll(this.getUniqueGeomNodes(mustBeDefined));
        return newGeomFeatures;
    }

    public Vector3d getGravity() {
        Vector3d gravity = new Vector3d(0.0, 0.0, 9.82);
        Matrix3d rot = new Matrix3d();
        this.getWorldTransform().getTransform().get(rot);
        rot.transform((Tuple3d)gravity);
        return gravity;
    }

    public boolean canGenerateScriptCode() {
        return true;
    }

    public void generatePreambleScript(ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        writer.appendLine(ControllerSocketSender.set_gravity(this.getGravity()));
    }

    public void dispose() {
        this.clearGeomFeaturesSubscriptions();
        this.removeFromParent();
    }

    @Override
    public void add(MutableTreeNode newChild) {
        super.add(newChild);
    }

    private static final class OnlyJoggableFeatures
    implements Predicate<GeomFeature> {
        private OnlyJoggableFeatures() {
        }

        public boolean test(GeomFeature geomFeature) {
            return geomFeature.isJoggableEnabled();
        }
    }
}

