/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup.treenodes.geom.menu;

import com.ur.i18n.CommandNamesResource;
import com.ur.polyscope.installation.menu.InstallationMenuCategory;
import com.ur.polyscope.installation.menu.InstallationMenuContribution;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import gui.geom.GeomFeatureFactory;
import gui.polyscope.setup.treenodes.geom.GeomLineNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;

@Singleton
@Extension(value="InstallationMenu")
public class LineFeatureMenuExtension
extends AbstractActionDefinition
implements MenuExtension {
    private final GeomFeatureFactory factory;
    private final FeaturesLookup featureLookupService;

    @Inject
    public LineFeatureMenuExtension(CommandNamesResource textResource, GeomFeatureFactory factory, FeaturesLookup featureLookupService) {
        this.factory = factory;
        this.featureLookupService = featureLookupService;
        this.putValue("Name", textResource.geomLine());
        this.putValue("InternalName", "addLineFeature.G5FeaturesTab");
        this.putValue("SmallIcon", ViewImageResource.programnodeGeomLineOk());
        this.putValue("HelpId", "gui:installation_features_add_line");
    }

    public void actionPerformed(ActionEvent e) {
        GeomLineNode lineNode = this.factory.createLineNode();
        GeomPoseNode child1 = this.factory.createPoseNode(true, false);
        GeomPoseNode child2 = this.factory.createPoseNode(true, false);
        lineNode.setShowAxes(true);
        lineNode.setIsVariable(true, false);
        child1.setJoggableEnabled(false);
        child1.setShowAxes(true);
        child2.setJoggableEnabled(false);
        child2.setShowAxes(true);
        SetupFeatureContainerNode featureContainer = (SetupFeatureContainerNode)this.featureLookupService.getFeatureContainer();
        featureContainer.insertGeomLineNodeBetweenPoints(lineNode, child1, child2);
    }

    public MenuExtension.MenuContribution create() {
        return MenuExtension.MenuContribution.locateMiddle((MenuExtension.MenuContribution)new InstallationMenuContribution((Action)((Object)this), InstallationMenuCategory.FEATURES));
    }
}

