/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup.treenodes.geom.menu;

import com.ur.i18n.CommandNamesResource;
import com.ur.polyscope.installation.menu.InstallationMenuCategory;
import com.ur.polyscope.installation.menu.InstallationMenuContribution;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import gui.geom.GeomFeatureFactory;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;

@Singleton
@Extension(value="InstallationMenu")
public class PlaneFeatureMenuExtension
extends AbstractActionDefinition
implements MenuExtension {
    private final GeomFeatureFactory factory;
    private final FeaturesLookup featureLookupService;

    @Inject
    public PlaneFeatureMenuExtension(CommandNamesResource textResource, GeomFeatureFactory factory, FeaturesLookup featureLookupService) {
        this.factory = factory;
        this.featureLookupService = featureLookupService;
        this.putValue("Name", textResource.geomPlane());
        this.putValue("InternalName", "addPlaneFeature.G5FeaturesTab");
        this.putValue("SmallIcon", ViewImageResource.programnodeGeomPlaneOk());
        this.putValue("HelpId", "gui:installation_features_add_plane");
    }

    public void actionPerformed(ActionEvent e) {
        GeomPlaneNode planeNode = this.factory.createPlaneNode();
        GeomPoseNode child1 = this.factory.createPoseNode(true, true);
        GeomPoseNode child2 = this.factory.createPoseNode(true, true);
        GeomPoseNode child3 = this.factory.createPoseNode(true, true);
        planeNode.setShowAxes(true);
        planeNode.setIsVariable(true, false);
        SetupFeatureContainerNode featureContainer = (SetupFeatureContainerNode)this.featureLookupService.getFeatureContainer();
        featureContainer.insertGeomPlaneNodeWithPoints(planeNode, child1, child2, child3);
    }

    public MenuExtension.MenuContribution create() {
        return MenuExtension.MenuContribution.locateLast((MenuExtension.MenuContribution)new InstallationMenuContribution((Action)((Object)this), InstallationMenuCategory.FEATURES));
    }
}

