/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.setup.treenodes.geom.menu;

import com.ur.i18n.CommandNamesResource;
import com.ur.polyscope.installation.menu.InstallationMenuCategory;
import com.ur.polyscope.installation.menu.InstallationMenuContribution;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import gui.geom.GeomFeatureFactory;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;

@Singleton
@Extension(value="InstallationMenu")
public class PointFeatureMenuExtension
extends AbstractActionDefinition
implements MenuExtension {
    private final GeomFeatureFactory factory;
    private final FeaturesLookup featureLookupService;

    @Inject
    public PointFeatureMenuExtension(CommandNamesResource textResource, GeomFeatureFactory factory, FeaturesLookup featureLookupService) {
        this.factory = factory;
        this.featureLookupService = featureLookupService;
        this.putValue("Name", textResource.geomPoint());
        this.putValue("InternalName", "addPointFeature.G5FeaturesTab");
        this.putValue("SmallIcon", ViewImageResource.programnodeGeomPointOk());
        this.putValue("HelpId", "gui:installation_features_add_point");
    }

    public void actionPerformed(ActionEvent e) {
        GeomPoseNode newGeomPoseNode = this.factory.createPoseNode(false, false);
        newGeomPoseNode.setShowAxes(true);
        newGeomPoseNode.setIsVariable(true, false);
        SetupFeatureContainerNode featureContainer = (SetupFeatureContainerNode)this.featureLookupService.getFeatureContainer();
        featureContainer.insertGeomNode(newGeomPoseNode);
    }

    public MenuExtension.MenuContribution create() {
        return new InstallationMenuContribution((Action)((Object)this), InstallationMenuCategory.FEATURES);
    }
}

