/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.polyscope.program.PlaceholderOperationService;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.program.nodes.ProgramNodeTypeImpl;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.reversible.Reversible;
import com.ur.view.domain.program.services.SilentEditProgramService;
import gui.program.AllowChildrenServiceImpl$AjcClosure1;
import gui.program.EntityFactory;
import gui.program.PlaceholderNode;
import gui.program.ProgramUndoRedoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AllowChildrenServiceImpl
implements PlaceholderOperationService {
    private final EntityFactory entityFactory;
    private final SilentEditProgramService editProgramService;
    private final ProgramUndoRedoService undoRedoService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    public AllowChildrenServiceImpl(EntityFactory entityFactory, SilentEditProgramService editProgramService, ProgramUndoRedoService undoRedoService) {
        this.entityFactory = entityFactory;
        this.editProgramService = editProgramService;
        this.undoRedoService = undoRedoService;
    }

    public boolean insertPlaceholderNodeToGivenNode(AbstractProgramNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Program node can not be null !");
        }
        boolean added = this.addPlaceHolder(node);
        if (added) {
            this.undoRedoService.consume(new ReversibleAllowChildren(node));
        }
        return added;
    }

    public boolean removePlaceholderNodeFromGivenNode(AbstractProgramNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Program node can not be null !");
        }
        RemovalResult removedChildren = this.removeChildren(node);
        if (removedChildren.success) {
            this.undoRedoService.consume(new ReversibleRemoveChildren(node, removedChildren.children));
        }
        return removedChildren.success;
    }

    private boolean addPlaceHolder(AbstractProgramNode node) {
        ProgramNodeType originalType = node.getProgramNodeType();
        this.setProgramNodeType(node, (ProgramNodeType)new ProgramNodeTypeImpl(true, true));
        PlaceholderNode placeholderNode = this.entityFactory.createPlaceholderNode();
        if (!this.editProgramService.addNode(placeholderNode, node)) {
            this.setProgramNodeType(node, originalType);
            return false;
        }
        return true;
    }

    private RemovalResult removeChildren(AbstractProgramNode parent) {
        Enumeration children;
        this.setProgramNodeType(parent, (ProgramNodeType)new ProgramNodeTypeImpl(true, false));
        ArrayList<AbstractProgramNode> removedChildren = new ArrayList<AbstractProgramNode>();
        while ((children = parent.children()).hasMoreElements()) {
            boolean result;
            AbstractProgramNode child = (AbstractProgramNode)children.nextElement();
            Collection<AbstractProgramNode> removed = this.editProgramService.deleteNode(child);
            boolean bl = result = removed == null || !removed.contains(child);
            if (result) {
                this.setProgramNodeType(parent, (ProgramNodeType)new ProgramNodeTypeImpl(true, true));
                return new RemovalResult(false, removedChildren);
            }
            removedChildren.addAll(removed);
        }
        this.setProgramNodeType(parent, (ProgramNodeType)new ProgramNodeTypeImpl(false, false));
        return new RemovalResult(true, removedChildren);
    }

    @IgnoreProgramChanges
    private void setProgramNodeType(AbstractProgramNode node, ProgramNodeType type) {
        AbstractProgramNode abstractProgramNode = node;
        ProgramNodeType programNodeType = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)abstractProgramNode, (Object)programNodeType);
        Object[] objectArray = new Object[]{this, abstractProgramNode, programNodeType, joinPoint};
        AllowChildrenServiceImpl$AjcClosure1 allowChildrenServiceImpl$AjcClosure1 = new AllowChildrenServiceImpl$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(allowChildrenServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static {
        AllowChildrenServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ void setProgramNodeType_aroundBody0(AllowChildrenServiceImpl ajc$this, AbstractProgramNode node, ProgramNodeType type, JoinPoint joinPoint) {
        node.setProgramNodeType(type);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AllowChildrenServiceImpl.java", AllowChildrenServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setProgramNodeType", "gui.program.AllowChildrenServiceImpl", "com.ur.polyscope.program.nodes.AbstractProgramNode:com.ur.polyscope.program.nodes.ProgramNodeType", "node:type", "", "void"), 170);
    }

    private static class RemovalResult {
        public final boolean success;
        public final List<AbstractProgramNode> children;

        RemovalResult(boolean success, List<AbstractProgramNode> children) {
            this.success = success;
            this.children = children;
        }
    }

    private class ReversibleAllowChildren
    implements Reversible<AbstractProgramNode> {
        private final AbstractProgramNode node;
        private boolean isUndo;

        ReversibleAllowChildren(AbstractProgramNode node) {
            this(node, true);
        }

        ReversibleAllowChildren(AbstractProgramNode node, boolean isUndo) {
            this.node = node;
            this.isUndo = isUndo;
        }

        public AbstractProgramNode getTarget() {
            return this.node;
        }

        public void undo() {
            boolean success;
            boolean bl = success = this.isUndo ? ((AllowChildrenServiceImpl)AllowChildrenServiceImpl.this).removeChildren((AbstractProgramNode)this.node).success : AllowChildrenServiceImpl.this.addPlaceHolder(this.node);
            if (success) {
                AllowChildrenServiceImpl.this.undoRedoService.consume(new ReversibleAllowChildren(this.node, !this.isUndo));
            }
        }
    }

    private class ReversibleRemoveChildren
    implements Reversible<AbstractProgramNode> {
        private final AbstractProgramNode node;
        private final List<AbstractProgramNode> children;
        private final boolean isUndo;

        ReversibleRemoveChildren(AbstractProgramNode node, List<AbstractProgramNode> children) {
            this(node, children, true);
        }

        ReversibleRemoveChildren(AbstractProgramNode node, List<AbstractProgramNode> children, boolean isUndo) {
            this.node = node;
            this.children = new ArrayList<AbstractProgramNode>(children);
            this.isUndo = isUndo;
        }

        public AbstractProgramNode getTarget() {
            return this.node;
        }

        public void undo() {
            boolean success;
            boolean bl = success = this.isUndo ? this.addChildren() : ((AllowChildrenServiceImpl)AllowChildrenServiceImpl.this).removeChildren((AbstractProgramNode)this.node).success;
            if (success) {
                AllowChildrenServiceImpl.this.undoRedoService.consume(new ReversibleRemoveChildren(this.node, this.children, !this.isUndo));
            }
        }

        private boolean addChildren() {
            AllowChildrenServiceImpl.this.setProgramNodeType(this.node, (ProgramNodeType)new ProgramNodeTypeImpl(true, true));
            for (AbstractProgramNode child : this.children) {
                boolean result = AllowChildrenServiceImpl.this.editProgramService.addNode(child, this.node);
                if (result) continue;
                AllowChildrenServiceImpl.this.setProgramNodeType(this.node, (ProgramNodeType)new ProgramNodeTypeImpl(false, false));
                return false;
            }
            return true;
        }
    }
}

