/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.optimove.OptiMoveConfigurationProvider;
import com.ur.polyscope.robot.configuration.tool.ToolConfigurationSettings;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.version.urversion.URVersion;
import com.ur.util.logging.Log;
import com.ur.view.program.CommandPanel;
import com.ur.view.variables.core.Variable;
import gui.commandpanels.wizards.PatternSequenceCard;
import gui.program.AnchoredSequenceNode$AjcClosure1;
import gui.program.AnchoredSequenceNode$AjcClosure3;
import gui.program.MotionDefiningNode;
import gui.program.PatternNode;
import gui.program.ProgramMetaDataComponent;
import gui.program.ProgramRootNode;
import gui.program.StackNode;
import gui.program.WizardNode;
import gui.program.position.WaypointNode;
import gui.program.services.ProgramReferenceService;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.swing.tree.TreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AnchoredSequenceNode
extends MotionDefiningNode
implements WizardNode {
    private static final URVersion OLD_ANCHOR_DEFINED_VERSION;
    private String name = "";
    private WaypointNode anchoredWaypointNode = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        AnchoredSequenceNode.ajc$preClinit();
        OLD_ANCHOR_DEFINED_VERSION = URVersion.POLYSCOPE_VERSION_3_1;
    }

    @Inject
    public AnchoredSequenceNode(ProgramReferenceService programReferenceService, JointConfigurationSettings settings, ToolConfigurationSettings toolConfigurationSettings, OptiMoveConfigurationProvider optiMoveConfigurationProvider) {
        super(programReferenceService, settings, toolConfigurationSettings, optiMoveConfigurationProvider, MotionDefiningNode.MotionType.LINEAR_MOVE);
    }

    public String getName() {
        return this.name;
    }

    public boolean isSuppressible() {
        return false;
    }

    @ProgramNodeChange
    public void setName(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AnchoredSequenceNode$AjcClosure1 anchoredSequenceNode$AjcClosure1 = new AnchoredSequenceNode$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(anchoredSequenceNode$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public WaypointNode getAnchorWaypointNode() {
        return this.anchoredWaypointNode;
    }

    @ProgramNodeChange
    public void setAnchorWaypointNode(WaypointNode anchorWaypointNode) {
        WaypointNode waypointNode = anchorWaypointNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)waypointNode);
        Object[] objectArray = new Object[]{this, waypointNode, joinPoint};
        AnchoredSequenceNode$AjcClosure3 anchoredSequenceNode$AjcClosure3 = new AnchoredSequenceNode$AjcClosure3(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(anchoredSequenceNode$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public Variable getAnchorPoseVariable() {
        try {
            AbstractProgramNode above = (AbstractProgramNode)this.getParent();
            AbstractProgramNode before = (AbstractProgramNode)above.getChildBefore((TreeNode)((Object)this));
            if (before instanceof PatternNode) {
                return ((PatternNode)before).getPatternPoseVariable();
            }
            if (above instanceof StackNode) {
                return ((StackNode)above).getFoundPoseVariable();
            }
        }
        catch (Exception e) {
            Log.error((String)("AnchoredSequenceNode.getAnchorPoseVariable(): ERROR: " + e));
        }
        return null;
    }

    @Override
    public double getCartesianSpeed() {
        try {
            AbstractProgramNode pn = (AbstractProgramNode)this.getParent();
            if (pn instanceof StackNode) {
                return ((StackNode)pn).getCartesianSpeed();
            }
            if ((pn = (AbstractProgramNode)pn.getChildAt(0)) instanceof PatternNode) {
                return ((PatternNode)pn).getCartesianSpeed();
            }
        }
        catch (Exception e) {
            Log.error((String)("AnchoredSequenceNode failed to find PatternNode af first child in parent: " + e.toString()));
        }
        return this.toolConfigurationSettings.getVToolDefault();
    }

    @Override
    public double getCartesianAcceleration() {
        try {
            AbstractProgramNode pn = (AbstractProgramNode)this.getParent();
            if (pn instanceof StackNode) {
                return ((StackNode)pn).getCartesianAcceleration();
            }
            if ((pn = (AbstractProgramNode)pn.getChildAt(0)) instanceof PatternNode) {
                return ((PatternNode)pn).getCartesianAcceleration();
            }
        }
        catch (Exception e) {
            Log.error((String)("AnchoredSequenceNode failed to find PatternNode af first child in parent: " + e.toString()));
        }
        return this.toolConfigurationSettings.getAToolDefault();
    }

    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        String poseVarName = "";
        Variable anchorPoseVariable = this.getAnchorPoseVariable();
        poseVarName = anchorPoseVariable == null ? "ur_anchor_pose_" + this.getId() : anchorPoseVariable.getScriptName();
        int i = 0;
        while (i < this.getChildCount()) {
            AbstractProgramNode pn = (AbstractProgramNode)this.getChildAt(i);
            if (pn instanceof WaypointNode) {
                WaypointNode wn = (WaypointNode)pn;
                if (wn.getPositionNodeType() == PositionNodeType.FIXED) {
                    wn.generateFixedWaypointCode(writer, poseVarName, this);
                } else {
                    writer.writeNode((ControllerInterfaceProgramNode)pn);
                }
            } else {
                writer.writeNode((ControllerInterfaceProgramNode)pn);
            }
            ++i;
        }
        return writer;
    }

    @Override
    public boolean isUndefined() {
        if (super.isUndefined()) {
            return true;
        }
        return this.isAnchorNodeUndefined();
    }

    private boolean isAnchorNodeUndefined() {
        if (this.anchoredWaypointNode == null) {
            return true;
        }
        if (this.supportOldAnchorNodeBehavior()) {
            return false;
        }
        Enumeration e = this.preorderEnumeration();
        while (e.hasMoreElements()) {
            AbstractProgramNode pn = (AbstractProgramNode)e.nextElement();
            if (!this.anchoredWaypointNode.equals(pn)) continue;
            return false;
        }
        return true;
    }

    private boolean supportOldAnchorNodeBehavior() {
        ProgramRootNode root = ProgramRootNode.get(this);
        if (root == null) {
            return false;
        }
        return URVersion.isLessThan((URVersion)root.getComponent(ProgramMetaDataComponent.class).getCreatedInVersion(), (URVersion)OLD_ANCHOR_DEFINED_VERSION);
    }

    @Override
    public AnchoredSequenceNode clone() {
        AnchoredSequenceNode result = (AnchoredSequenceNode)super.clone();
        int selectedIndex = this.getSelectedIndexOfAnchorWaypoint();
        result.anchoredWaypointNode = selectedIndex == -1 ? null : (WaypointNode)((Object)result.getChildAt(selectedIndex));
        return result;
    }

    private int getSelectedIndexOfAnchorWaypoint() {
        return this.anchoredWaypointNode == null ? -1 : this.getIndex((TreeNode)((Object)this.anchoredWaypointNode));
    }

    public String toString() {
        return this.name;
    }

    public Class<? extends CommandPanel<AnchoredSequenceNode>> getCardClass() {
        return PatternSequenceCard.class;
    }

    public boolean canPauseOnNode() {
        return false;
    }

    static final /* synthetic */ void setName_aroundBody0(AnchoredSequenceNode ajc$this, String name, JoinPoint joinPoint) {
        ajc$this.name = name;
    }

    static final /* synthetic */ void setAnchorWaypointNode_aroundBody2(AnchoredSequenceNode ajc$this, WaypointNode anchorWaypointNode, JoinPoint joinPoint) {
        if (!EqualsUtil.equals((Object)ajc$this.anchoredWaypointNode, (Object)anchorWaypointNode)) {
            ajc$this.anchoredWaypointNode = anchorWaypointNode;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AnchoredSequenceNode.java", AnchoredSequenceNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setName", "gui.program.AnchoredSequenceNode", "java.lang.String", "name", "", "void"), 46);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAnchorWaypointNode", "gui.program.AnchoredSequenceNode", "gui.program.position.WaypointNode", "anchorWaypointNode", "", "void"), 55);
    }
}

