/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.lang.Defense;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.visualizer.programvisualization.VisualizerBlend;
import com.ur.util.logging.Log;
import com.ur.view.hmc.ControllerInterfaceBlend;
import com.ur.view.hmc.HMC;
import gui.program.Motion;
import gui.program.position.PositionNode;
import gui.program.services.MotionData;
import java.io.Serializable;
import javax.vecmath.Point3d;

public class Blend
implements Serializable,
VisualizerBlend,
ControllerInterfaceBlend {
    private static final long serialVersionUID = 57L;
    private final Motion fromMotion;
    private final Motion toMotion;
    private Point3d[] pathData = null;

    public Blend(Motion fromMotion, Motion toMotion) {
        Defense.notNull((Object)fromMotion, (String)"fromPositionNode cannot be null");
        Defense.notNull((Object)toMotion, (String)"fromPositionNode cannot be null");
        this.fromMotion = fromMotion;
        this.toMotion = toMotion;
    }

    public void updateBlendPathData(MotionData motionData) {
        if (this.fromMotion == null || this.toMotion == null) {
            Log.error((String)"This should not happen!");
            return;
        }
        if (this.fromMotion.getToPositionNode() != this.toMotion.getFromPositionNode()) {
            Log.error((String)"This should not happen either!");
            return;
        }
        if (this.fromMotion.getToPositionNode().isUndefined() || this.fromMotion.getFromPositionNode().isUndefined() || this.toMotion.getToPositionNode().isUndefined()) {
            this.clearPathData();
            return;
        }
        if (this.fromMotion.getToPositionNode().getPositionNodeType() != PositionNodeType.FIXED || this.fromMotion.getFromPositionNode().getPositionNodeType() != PositionNodeType.FIXED || this.toMotion.getToPositionNode().getPositionNodeType() != PositionNodeType.FIXED) {
            if (this.pathData != null) {
                this.clearPathData();
            }
            return;
        }
        if (motionData.getPreviousMotions(this.fromMotion.getToPositionNode()).size() > Motion.MAX_MOTION_BRANCHES_SHOWING || motionData.getNextMotions(this.toMotion.getFromPositionNode()).size() > Motion.MAX_MOTION_BRANCHES_SHOWING) {
            this.clearPathData();
            return;
        }
        if (this.fromMotion.getToPositionNode().isCircleDefiningNode() || this.toMotion.getFromPositionNode().isCircleDefiningNode()) {
            return;
        }
        if (this.nodeUsesFeature(this.fromMotion.getFromPositionNode()) || this.nodeUsesFeature(this.fromMotion.getToPositionNode()) || this.nodeUsesFeature(this.toMotion.getFromPositionNode()) || this.nodeUsesFeature(this.toMotion.getToPositionNode())) {
            return;
        }
        if (this.pathData != null) {
            return;
        }
        if (this.toMotion.getFromPositionNode().isStopPoint() || !(this.toMotion.getFromPositionNode().getBlendRadius() > 0.0)) {
            this.pathData = new Point3d[0];
        } else if (this.fromMotion.getFromPositionNode().getBlendRadius() + this.fromMotion.getToPositionNode().getBlendRadius() > this.fromMotion.length() || this.toMotion.getFromPositionNode().getBlendRadius() + this.toMotion.getToPositionNode().getBlendRadius() > this.toMotion.length()) {
            this.pathData = new Point3d[0];
        } else {
            HMC hmc = new HMC();
            double pointSpacing = 0.001;
            this.pathData = hmc.getBlendPath(this, pointSpacing);
        }
    }

    private boolean nodeUsesFeature(PositionNode positionNode) {
        return positionNode.getMotionDefiningNode().selectedFeatureIsVariable();
    }

    private void clearPathData() {
        this.pathData = null;
    }

    public Point3d[] getPathData() {
        return this.pathData;
    }

    public final int hashCode() {
        return this.fromMotion.hashCode() + this.toMotion.hashCode() * 17 + (this.toMotion.hashCode() + this.fromMotion.hashCode() * 17);
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Blend) {
            Blend b = (Blend)o;
            return b.fromMotion.equals(this.fromMotion) && b.toMotion.equals(this.toMotion) || b.fromMotion.equals(this.toMotion) && b.toMotion.equals(this.fromMotion);
        }
        return false;
    }

    @Override
    public Motion fromMotion() {
        return this.fromMotion;
    }

    @Override
    public Motion toMotion() {
        return this.toMotion;
    }
}

