/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChangeAspect;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.optimove.OptiMoveConfigurationProvider;
import com.ur.polyscope.robot.configuration.tool.ToolConfigurationSettings;
import com.ur.swing.expression.Expression;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.util.logging.Log;
import com.ur.view.program.CommandPanel;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import gui.commandpanels.wizards.DirectionCard;
import gui.program.DirectionNode$AjcClosure1;
import gui.program.DirectionNode$AjcClosure11;
import gui.program.DirectionNode$AjcClosure13;
import gui.program.DirectionNode$AjcClosure15;
import gui.program.DirectionNode$AjcClosure17;
import gui.program.DirectionNode$AjcClosure19;
import gui.program.DirectionNode$AjcClosure3;
import gui.program.DirectionNode$AjcClosure5;
import gui.program.DirectionNode$AjcClosure7;
import gui.program.DirectionNode$AjcClosure9;
import gui.program.MotionDefiningNode;
import gui.program.ProgramRootNode;
import gui.program.WizardNode;
import gui.program.position.WaypointNode;
import gui.program.services.ProgramReferenceService;
import gui.tools.LanguagePack;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.inject.Inject;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class DirectionNode
extends MotionDefiningNode
implements WizardNode,
ExpressionNodeProperty {
    private static final long serialVersionUID = 2328215L;
    private static final double DEFAULT_CARTESIAN_SPEED = 0.01;
    private ProgramVariable variable;
    private Expression expr = new Expression();
    private double maxDistance = -0.5;
    private boolean stopAtDistance = false;
    private boolean stopAtExpression = false;
    private NamingService namingService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    @Inject
    public DirectionNode(ProgramReferenceService programReferenceService, JointConfigurationSettings settings, NamingService namingService, ToolConfigurationSettings toolConfigurationSettings, OptiMoveConfigurationProvider optiMoveConfigurationProvider) {
        super(programReferenceService, settings, optiMoveConfigurationProvider, MotionDefiningNode.MotionType.LINEAR_MOVE, toolConfigurationSettings, 0.01);
        this.namingService = namingService;
        this.setNodeTypeName(LanguagePack.getCommandNamesResource().Direction());
    }

    public ProgramVariable getVariable() {
        return this.variable;
    }

    @ProgramNodeChange
    @ProgramEntitiesChange
    public void setVariable(ProgramVariable variable) {
        ProgramVariable programVariable = variable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)programVariable);
        Object[] objectArray = new Object[]{this, programVariable, joinPoint};
        DirectionNode$AjcClosure3 directionNode$AjcClosure3 = new DirectionNode$AjcClosure3(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(directionNode$AjcClosure3.linkStackClosureAndJoinPoint(69648));
            directionNode$AjcClosure3.unlink();
        }
        catch (Throwable throwable) {
            directionNode$AjcClosure3.unlink();
            throw throwable;
        }
    }

    @CompoundProgramChange
    public void setMaxDistanceAndStopAtDistance(double distance) {
        double d = distance;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        Object[] objectArray = new Object[]{this, Conversions.doubleObject((double)d), joinPoint};
        DirectionNode$AjcClosure5 directionNode$AjcClosure5 = new DirectionNode$AjcClosure5(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(directionNode$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    public void setExpressionAndStopAtExpression(ExpressionBranchNode expression) {
        ExpressionBranchNode expressionBranchNode = expression;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)expressionBranchNode);
        Object[] objectArray = new Object[]{this, expressionBranchNode, joinPoint};
        DirectionNode$AjcClosure7 directionNode$AjcClosure7 = new DirectionNode$AjcClosure7(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(directionNode$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @Override
    @CompoundProgramChange
    public void resetToDefaults() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        DirectionNode$AjcClosure9 directionNode$AjcClosure9 = new DirectionNode$AjcClosure9(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(directionNode$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    public boolean isStopAtDistance() {
        return this.stopAtDistance;
    }

    @ProgramNodeChange
    public void setStopAtDistance(boolean stopAtDistance) {
        boolean bl = stopAtDistance;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        DirectionNode$AjcClosure11 directionNode$AjcClosure11 = new DirectionNode$AjcClosure11(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(directionNode$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    public boolean isStopAtExpression() {
        return this.stopAtExpression;
    }

    @ProgramNodeChange
    public void setStopAtExpression(boolean stopAtExpression) {
        boolean bl = stopAtExpression;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        DirectionNode$AjcClosure13 directionNode$AjcClosure13 = new DirectionNode$AjcClosure13(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(directionNode$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    public double getMaxDistance() {
        if (this.maxDistance < 0.0) {
            double dist = this.getDistanceBetweenPoints();
            if (dist == 0.0) {
                return 0.5;
            }
            return dist;
        }
        return this.maxDistance;
    }

    @ProgramNodeChange
    public void setMaxDistance(double maxDistance) {
        double d = maxDistance;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        Object[] objectArray = new Object[]{this, Conversions.doubleObject((double)d), joinPoint};
        DirectionNode$AjcClosure15 directionNode$AjcClosure15 = new DirectionNode$AjcClosure15(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(directionNode$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    public ExpressionBranchNode getExpression() {
        return this.expr.getExpression();
    }

    public String getExpressionScriptCode() {
        return this.expr.getScriptCodeText();
    }

    @ProgramEntitiesChange
    @ProgramNodeChange
    public void setExpression(ExpressionBranchNode e) {
        ExpressionBranchNode expressionBranchNode = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)expressionBranchNode);
        Object[] objectArray = new Object[]{this, expressionBranchNode, joinPoint};
        DirectionNode$AjcClosure19 directionNode$AjcClosure19 = new DirectionNode$AjcClosure19(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(directionNode$AjcClosure19.linkStackClosureAndJoinPoint(69648));
            directionNode$AjcClosure19.unlink();
        }
        catch (Throwable throwable) {
            directionNode$AjcClosure19.unlink();
            throw throwable;
        }
    }

    public double getDistanceBetweenPoints() {
        Point3d pfrom = this.getFromPosition();
        Point3d pto = this.getToPosition();
        if (pfrom == null || pto == null) {
            return 0.0;
        }
        return pfrom.distance(pto);
    }

    @Override
    public DirectionNode clone() {
        DirectionNode newNode = (DirectionNode)super.clone();
        newNode.expr = this.expr.clone();
        newNode.variable = this.variable.clone();
        newNode.variable.initialSetName(this.createUniqueVariableName());
        return newNode;
    }

    private String createUniqueVariableName() {
        return this.namingService.makeUniqueName(Variable.class, LanguagePack.getCommandNamesResource().varInterpolate());
    }

    @Override
    public boolean isUndefined() {
        if (this.variable == null) {
            if (ProgramRootNode.get(this) != null) {
                Log.error((String)"Should not be possible to have a null variable");
            }
            return true;
        }
        if (!this.stopAtDistance && !this.stopAtExpression) {
            return true;
        }
        if (this.stopAtExpression && this.expr.toString().length() < 1) {
            return true;
        }
        if (this.getChildCount() < 2) {
            return true;
        }
        if (this.children != null) {
            for (Object o : this.children) {
                AbstractProgramNode child;
                if (!(o instanceof AbstractProgramNode) || !(child = (AbstractProgramNode)o).isUndefined()) continue;
                return true;
            }
        }
        return false;
    }

    public Point3d getFromPosition() {
        try {
            WaypointNode wn = (WaypointNode)((Object)this.getFirstChild());
            return wn.isDefined() ? wn.getToolPosition() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Point3d getToPosition() {
        try {
            WaypointNode wn = (WaypointNode)((Object)this.getChildAt(1));
            return wn.isDefined() ? wn.getToolPosition() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Point3d getDirectionVector() {
        Point3d from = this.getFromPosition();
        Point3d to = new Point3d(this.getToPosition());
        if (from != null && to != null) {
            to.sub((Tuple3d)from);
            return to;
        }
        return null;
    }

    public LinkedHashSet<AbstractProgramNode> computeNextExecutionNodes() {
        LinkedHashSet<AbstractProgramNode> ret = new LinkedHashSet<AbstractProgramNode>();
        ret.add((AbstractProgramNode)this.children.get(0));
        ret.add((AbstractProgramNode)this.children.get(1));
        return ret;
    }

    public LinkedHashSet<AbstractProgramNode> computeNodeToExecuteAfterCompletingThisChild(AbstractProgramNode child) {
        return ((AbstractProgramNode)this.getParent()).computeNodeToExecuteAfterCompletingThisChild((AbstractProgramNode)this);
    }

    public Class<? extends CommandPanel<DirectionNode>> getCardClass() {
        return DirectionCard.class;
    }

    public String toString() {
        return LanguagePack.getCommandNamesResource().Direction();
    }

    @Override
    protected void getInternalProgramEntities(Collection<Object> collection) {
        if (this.expr != null) {
            this.expr.getExpression().getProgramEntities(collection);
        }
        collection.add(this.variable);
        super.getInternalProgramEntities(collection);
    }

    @Override
    protected boolean doSubstituteReference(Object original, Object substitute) {
        boolean result = false;
        if (this.variable == original && substitute instanceof ProgramVariable) {
            this.variable = (ProgramVariable)substitute;
            result = true;
        }
        result |= this.expr == null ? false : this.expr.getExpression().substituteReference(original, substitute);
        return result |= super.doSubstituteReference(original, substitute);
    }

    public boolean canPauseOnNode() {
        return false;
    }

    protected boolean canChildrenPauseOnNode() {
        return false;
    }

    static {
        DirectionNode.ajc$preClinit();
    }

    static final /* synthetic */ void setVariable_aroundBody0(DirectionNode ajc$this, ProgramVariable variable, JoinPoint joinPoint) {
        ajc$this.variable = variable;
    }

    static final /* synthetic */ void setVariable_aroundBody2(DirectionNode directionNode, ProgramVariable programVariable, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{directionNode, programVariable, joinPoint};
        DirectionNode$AjcClosure1 directionNode$AjcClosure1 = new DirectionNode$AjcClosure1(objectArray);
        try {
            ProgramEntitiesChangeAspect.aspectOf().aroundAnnotatedMethod(directionNode$AjcClosure1.linkStackClosureAndJoinPoint(69648));
            directionNode$AjcClosure1.unlink();
        }
        catch (Throwable throwable) {
            directionNode$AjcClosure1.unlink();
            throw throwable;
        }
    }

    static final /* synthetic */ void setMaxDistanceAndStopAtDistance_aroundBody4(DirectionNode ajc$this, double distance, JoinPoint joinPoint) {
        ajc$this.setMaxDistance(distance);
        ajc$this.setStopAtDistance(true);
    }

    static final /* synthetic */ void setExpressionAndStopAtExpression_aroundBody6(DirectionNode ajc$this, ExpressionBranchNode expression, JoinPoint joinPoint) {
        ajc$this.setExpression(expression);
        ajc$this.setStopAtExpression(true);
    }

    static final /* synthetic */ void resetToDefaults_aroundBody8(DirectionNode ajc$this, JoinPoint joinPoint) {
        ajc$this.setCartesianSpeed(0.01);
        ajc$this.setCartesianAcceleration(ajc$this.toolConfigurationSettings.getAToolDefault());
    }

    static final /* synthetic */ void setStopAtDistance_aroundBody10(DirectionNode ajc$this, boolean stopAtDistance, JoinPoint joinPoint) {
        if (ajc$this.stopAtDistance != stopAtDistance) {
            ajc$this.stopAtDistance = stopAtDistance;
            ajc$this.textHasChanged();
        }
    }

    static final /* synthetic */ void setStopAtExpression_aroundBody12(DirectionNode ajc$this, boolean stopAtExpression, JoinPoint joinPoint) {
        if (ajc$this.stopAtExpression != stopAtExpression) {
            ajc$this.stopAtExpression = stopAtExpression;
            ajc$this.textHasChanged();
        }
    }

    static final /* synthetic */ void setMaxDistance_aroundBody14(DirectionNode ajc$this, double maxDistance, JoinPoint joinPoint) {
        if (ajc$this.maxDistance != maxDistance) {
            ajc$this.maxDistance = maxDistance;
        }
    }

    static final /* synthetic */ void setExpression_aroundBody16(DirectionNode ajc$this, ExpressionBranchNode e, JoinPoint joinPoint) {
        if (!EqualsUtil.equals((Object)ajc$this.expr.getExpression(), (Object)e)) {
            ajc$this.expr.setExpression(e);
        }
    }

    static final /* synthetic */ void setExpression_aroundBody18(DirectionNode directionNode, ExpressionBranchNode expressionBranchNode, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{directionNode, expressionBranchNode, joinPoint};
        DirectionNode$AjcClosure17 directionNode$AjcClosure17 = new DirectionNode$AjcClosure17(objectArray);
        try {
            ProgramEntitiesChangeAspect.aspectOf().aroundAnnotatedMethod(directionNode$AjcClosure17.linkStackClosureAndJoinPoint(69648));
            directionNode$AjcClosure17.unlink();
        }
        catch (Throwable throwable) {
            directionNode$AjcClosure17.unlink();
            throw throwable;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DirectionNode.java", DirectionNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setVariable", "gui.program.DirectionNode", "com.ur.view.variables.core.ProgramVariable", "variable", "", "void"), 55);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMaxDistanceAndStopAtDistance", "gui.program.DirectionNode", "double", "distance", "", "void"), 60);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setExpressionAndStopAtExpression", "gui.program.DirectionNode", "com.ur.swing.expression.ExpressionBranchNode", "expression", "", "void"), 66);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resetToDefaults", "gui.program.DirectionNode", "", "", "", "void"), 73);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setStopAtDistance", "gui.program.DirectionNode", "boolean", "stopAtDistance", "", "void"), 83);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setStopAtExpression", "gui.program.DirectionNode", "boolean", "stopAtExpression", "", "void"), 95);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMaxDistance", "gui.program.DirectionNode", "double", "maxDistance", "", "void"), 116);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setExpression", "gui.program.DirectionNode", "com.ur.swing.expression.ExpressionBranchNode", "e", "", "void"), 134);
    }
}

