/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.disk.Directories;
import com.ur.i18n.TextResource;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.program.ProgramComponent;
import com.ur.polyscope.scriptwriter.PreambleScript;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.util.logging.Log;
import gui.installation.RobotInstallationLookupService;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.SaveProgramService;
import gui.program.ProgramInstallationHandler;
import gui.program.ProgramRootNode;
import gui.tools.URFileUtils;
import java.io.File;
import javax.inject.Inject;

public class FileManagementProgramComponent
implements ProgramComponent,
PreambleScript {
    private final String INSTALLATION_EXTENSION = ".installation";
    private final ProgramInstallationHandler programInstallationHandler;
    private final RobotInstallationLookupService lookupService;
    private final SaveProgramService saveProgramService;
    private final ProgramLookupService programLookupService;
    private File programFile;
    private String programDirectory = "";
    private String robotEnvironmentFileName = "";
    private String robotEnvironmentDirectory = "";
    private String robotEnvironmentRelativePath = "";
    private boolean isLegacyProgram = false;
    private TextResource textResource;
    private LoadInstallation loadInstallation = new AttemptLoadInstallation();

    @Inject
    public FileManagementProgramComponent(RobotInstallationLookupService lookupService, ProgramInstallationHandler programInstallationHandler, SaveProgramService saveProgramService, ProgramLookupService programLookupService, TextResource textResource) {
        this.lookupService = lookupService;
        this.programInstallationHandler = programInstallationHandler;
        this.saveProgramService = saveProgramService;
        this.programLookupService = programLookupService;
        Installation robotInstallation = lookupService.getInstallation();
        this.textResource = textResource;
        if (robotInstallation != null) {
            PersistanceMetaData persistanceMetaData = (PersistanceMetaData)robotInstallation.getMetaData(PersistanceMetaData.class);
            this.robotEnvironmentFileName = persistanceMetaData.fileName();
            this.robotEnvironmentDirectory = persistanceMetaData.directory();
            this.programDirectory = Directories.programs().getPath();
        } else {
            Log.warning((String)"Could not find robotInstallation");
        }
    }

    public Class<? extends ProgramComponent> getType() {
        return FileManagementProgramComponent.class;
    }

    public void setAsLegacyProgram(boolean isLegacyProgram) {
        this.isLegacyProgram = isLegacyProgram;
    }

    public String getInstallationRelativePath() {
        String programDir = this.getProgramDirectory();
        try {
            File programsDir = new File(programDir, "temp");
            File installationFile = new File(this.robotEnvironmentDirectory, String.valueOf(this.robotEnvironmentFileName) + ".installation");
            String programDirectory = programsDir.getCanonicalPath();
            return URFileUtils.relativizeInstallationPath(programDirectory, installationFile.getCanonicalPath());
        }
        catch (Exception e) {
            Log.error((String)"Cannot relativize path", (Throwable)e);
            return programDir;
        }
    }

    public void setInstallationRelativePath(String relativePath) {
        this.robotEnvironmentRelativePath = relativePath;
        File installationFile = new File(URFileUtils.unrelativizePathWithProgramsDir(String.valueOf(this.programDirectory) + File.separator + relativePath + ".installation"));
        if (installationFile.exists()) {
            try {
                this.setInstallationDirectory(installationFile.getParentFile().getCanonicalPath());
            }
            catch (Exception exception) {
                Log.error((String)"Cannot find canonical path of installation");
                this.setInstallationDirectory(installationFile.getParent());
            }
            String INSTALLATION_EXTENSION_REGEX = "([.]installation)$";
            this.setInstallationFileName(installationFile.getName().replaceAll(INSTALLATION_EXTENSION_REGEX, ""));
        }
    }

    public String getInstallationFileName() {
        return this.robotEnvironmentFileName;
    }

    public void setInstallationFileName(String installationFileName) {
        FileManagementProgramComponent currentProgramComponent;
        this.robotEnvironmentFileName = installationFileName;
        FileManagementProgramComponent fileManagementProgramComponent = currentProgramComponent = this.programLookupService.getProgramRootNode() == null ? null : this.programLookupService.getProgramRootNode().getComponent(FileManagementProgramComponent.class);
        if (currentProgramComponent == this) {
            this.saveProgramService.programChanged();
        }
    }

    public void setInstallationDirectory(String installationPath) {
        this.robotEnvironmentDirectory = installationPath;
    }

    public String getInstallationDirectory() {
        return this.robotEnvironmentDirectory;
    }

    public File getProgramFile() {
        return this.programFile;
    }

    public void setProgramFile(File file) {
        this.programFile = file;
        if (!URFileUtils.areFilesCanonicallyEqual(new File(this.programDirectory), new File(this.programFile.getParent()))) {
            this.setProgramDirectory(this.programFile.getParent());
            this.setInstallationRelativePath(this.robotEnvironmentRelativePath);
        }
    }

    public String getProgramDirectory() {
        return this.programDirectory;
    }

    public void setProgramDirectory(String directory) {
        this.programDirectory = directory;
    }

    public InstallationLoadedResult loadRobotInstallationForProgram(String directory, String name) {
        return this.loadInstallation.load(directory, name);
    }

    public File getFile(ProgramRootNode programRootNode) {
        return new File(String.valueOf(this.getProgramDirectory()) + File.separator + programRootNode.getName() + ".urp");
    }

    public void setAcceptToRunProgramWithDifferentInstallationLoaded() {
        this.loadInstallation = new IgnoreLoadInstallation();
    }

    public boolean isSetToRunProgramWithDifferentInstallationLoaded() {
        return this.loadInstallation instanceof IgnoreLoadInstallation;
    }

    public String setDirectoryAndExtractName(File file) {
        String result = this.textResource.placeholderUnnamed();
        if (file == null) {
            return result;
        }
        this.setProgramDirectory(file.getParentFile().getPath());
        result = file.getName();
        if (result.endsWith(".urp")) {
            result = result.substring(0, result.length() - 4);
        }
        return result;
    }

    public void generatePreambleScript(ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        this.lookupService.generatePreambleScript(writer, scriptGeneratorLookup);
    }

    public boolean canGenerateScriptCode() {
        InstallationLoadedResult loadResult = this.loadRobotInstallationForProgram();
        return loadResult == InstallationLoadedResult.WAS_ALREADY_LOADED || loadResult == InstallationLoadedResult.INSTALLATION_WAS_ALREADY_LOADED_AND_NOW_CHANGED_FOR_PROGRAM;
    }

    private InstallationLoadedResult loadRobotInstallationForProgram() {
        if (this.isLegacyProgram) {
            return this.loadRobotInstallationForProgram(this.programDirectory, this.robotEnvironmentFileName);
        }
        return this.loadRobotInstallationForProgram(this.robotEnvironmentDirectory, this.robotEnvironmentFileName);
    }

    private class AttemptLoadInstallation
    implements LoadInstallation {
        private AttemptLoadInstallation() {
        }

        @Override
        public InstallationLoadedResult load(String directory, String name) {
            if (this.activeInstallationMatchProgramsInstallation(directory, name)) {
                return InstallationLoadedResult.WAS_ALREADY_LOADED;
            }
            return FileManagementProgramComponent.this.programInstallationHandler.loadRobotInstallationForProgram(directory, name);
        }

        private boolean activeInstallationMatchProgramsInstallation(String directory, String name) {
            Installation currentInstallation = FileManagementProgramComponent.this.lookupService.getInstallation();
            File currentInstallationFile = ((PersistanceMetaData)currentInstallation.getMetaData(PersistanceMetaData.class)).file();
            File newInstallationFile = new File(directory, String.valueOf(name) + ".installation");
            try {
                return currentInstallationFile.getCanonicalPath().equals(newInstallationFile.getCanonicalPath());
            }
            catch (Exception exception) {
                return currentInstallationFile.getAbsolutePath().equals(newInstallationFile.getAbsolutePath());
            }
        }
    }

    private class IgnoreLoadInstallation
    implements LoadInstallation {
        private IgnoreLoadInstallation() {
        }

        @Override
        public InstallationLoadedResult load(String directory, String name) {
            return InstallationLoadedResult.WAS_ALREADY_LOADED;
        }
    }

    public static enum InstallationLoadedResult {
        WAS_ALREADY_LOADED,
        INSTALLATION_LOADED,
        INSTALLATION_LOAD_FAILED,
        INSTALLATION_WAS_ALREADY_LOADED_AND_NOW_CHANGED_FOR_PROGRAM;

    }

    private static interface LoadInstallation {
        public InstallationLoadedResult load(String var1, String var2);
    }
}

