/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.i18n.CommandNamesResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.program.nodes.ProgramNodeTypeImpl;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChangeAspect;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.program.ForceType;
import com.ur.view.program.CommandPanel;
import com.ur.view.program.CommandPanelProvider;
import gui.commandpanels.ForceCard;
import gui.installation.services.LookupServiceFacade;
import gui.polyscope.setup.treenodes.geom.GeomLineNode;
import gui.program.ForceNode$AjcClosure1;
import gui.program.ForceNode$AjcClosure11;
import gui.program.ForceNode$AjcClosure13;
import gui.program.ForceNode$AjcClosure15;
import gui.program.ForceNode$AjcClosure17;
import gui.program.ForceNode$AjcClosure19;
import gui.program.ForceNode$AjcClosure21;
import gui.program.ForceNode$AjcClosure23;
import gui.program.ForceNode$AjcClosure3;
import gui.program.ForceNode$AjcClosure5;
import gui.program.ForceNode$AjcClosure7;
import gui.program.ForceNode$AjcClosure9;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.GeomFeatureReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ForceNode
extends AbstractProgramNode
implements CommandPanelProvider {
    private static final double DEFAULT_MAX_FORCE_CONTROL_TRANSLATION_SPEED = 0.15;
    private static final double DEFAULT_MAX_FORCE_CONTROL_ROTATION_SPEED = 1.0471975511965976;
    private static final double DEFAULT_MAX_MOTION_CONTROL_TRANSLATION_ERROR = 0.1;
    private static final double DEFAULT_MAX_MOTION_CONTROL_ORIENTATION_ERROR = 0.3490658503988659;
    private static final int[] DEFAULT_SELECTION_VECTOR;
    private static final double[] DEFAULT_WRENCH;
    private static final double[] DEFAULT_LIMITS_MOTION;
    private static final double[] DEFAULT_LIMITS_FORCE;
    private static final Map<ForceType, Integer> FORCE_TYPE_VALUES;
    private final Extension extension;
    private ForceType forceType;
    private GeomFeatureReference featureReference;
    private int[] selectionVector = new int[6];
    private double[] forceModeWrench = new double[6];
    private double[] limitsMotion = new double[6];
    private double[] limitsForce = new double[6];
    private final CommandNamesResource commandNamesResource;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    static {
        ForceNode.ajc$preClinit();
        DEFAULT_SELECTION_VECTOR = new int[6];
        DEFAULT_WRENCH = new double[6];
        DEFAULT_LIMITS_MOTION = new double[6];
        DEFAULT_LIMITS_FORCE = new double[6];
        Arrays.fill(DEFAULT_SELECTION_VECTOR, 0);
        Arrays.fill(DEFAULT_WRENCH, 0.0);
        int i = 0;
        while (i < 3) {
            ForceNode.DEFAULT_LIMITS_MOTION[i] = 0.1;
            ForceNode.DEFAULT_LIMITS_MOTION[i + 3] = 0.3490658503988659;
            ForceNode.DEFAULT_LIMITS_FORCE[i] = 0.15;
            ForceNode.DEFAULT_LIMITS_FORCE[i + 3] = 1.0471975511965976;
            ++i;
        }
        FORCE_TYPE_VALUES = new HashMap<ForceType, Integer>(){
            {
                this.put(ForceType.POINT, 1);
                this.put(ForceType.SIMPLE, 2);
                this.put(ForceType.FRAME, 2);
                this.put(ForceType.MOTION, 3);
            }
        };
    }

    @Inject
    public ForceNode(ProgramReferenceService programReferenceService, Extension extension, CommandNamesResource commandNamesResource) {
        super((ProgramNodeType)new ProgramNodeTypeImpl(true, true));
        this.featureReference = programReferenceService.getGeomFeatureReference("Joint_0_name");
        this.extension = extension;
        this.forceType = ForceType.SIMPLE;
        this.commandNamesResource = commandNamesResource;
        this.setNodeTypeName(this.commandNamesResource.Force());
        this.copyArray(DEFAULT_SELECTION_VECTOR, this.selectionVector);
        this.selectionVector[this.getDefaultCompliantAxis()] = 1;
        this.copyArray(DEFAULT_WRENCH, this.forceModeWrench);
        this.copyArray(DEFAULT_LIMITS_MOTION, this.limitsMotion);
        this.copyArray(DEFAULT_LIMITS_FORCE, this.limitsForce);
    }

    @CompoundProgramChange
    public void setForceTypeAndAdjustValues(ForceType forceType) {
        ForceType forceType2 = forceType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)((Object)forceType2));
        Object[] objectArray = new Object[]{this, forceType2, joinPoint};
        ForceNode$AjcClosure1 forceNode$AjcClosure1 = new ForceNode$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(forceNode$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public boolean isAdvanced() {
        return this.forceType != ForceType.SIMPLE;
    }

    public ForceType getForceType() {
        return this.forceType;
    }

    @ProgramNodeChange
    public void setForceType(ForceType forceType) {
        ForceType forceType2 = forceType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)forceType2));
        Object[] objectArray = new Object[]{this, forceType2, joinPoint};
        ForceNode$AjcClosure3 forceNode$AjcClosure3 = new ForceNode$AjcClosure3(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(forceNode$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public int getSelection(int index) {
        return this.indexOK(index, this.selectionVector) ? this.selectionVector[index] : this.indexOutOfRange(index);
    }

    public int[] getSelectionVector() {
        return this.copyArray(this.selectionVector, new int[6]);
    }

    @ProgramNodeChange
    public void setSelection(int index, int value) {
        int n = index;
        int n2 = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        ForceNode$AjcClosure5 forceNode$AjcClosure5 = new ForceNode$AjcClosure5(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(forceNode$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @ProgramNodeChange
    public void setSelectionVector(int[] selectionVector) {
        int[] nArray = selectionVector;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)nArray);
        Object[] objectArray = new Object[]{this, nArray, joinPoint};
        ForceNode$AjcClosure7 forceNode$AjcClosure7 = new ForceNode$AjcClosure7(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(forceNode$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    public double getWrench(int index) {
        return this.indexOK(index, this.forceModeWrench) ? this.forceModeWrench[index] : (double)this.indexOutOfRange(index);
    }

    public double[] getWrenchVector() {
        return this.copyArray(this.forceModeWrench, new double[6]);
    }

    @ProgramNodeChange
    public void setWrench(int index, double wrench) {
        int n = index;
        double d = wrench;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.doubleObject((double)d));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), Conversions.doubleObject((double)d), joinPoint};
        ForceNode$AjcClosure9 forceNode$AjcClosure9 = new ForceNode$AjcClosure9(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(forceNode$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @ProgramNodeChange
    public void setWrenchVector(double[] wrenchVector) {
        double[] dArray = wrenchVector;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)dArray);
        Object[] objectArray = new Object[]{this, dArray, joinPoint};
        ForceNode$AjcClosure11 forceNode$AjcClosure11 = new ForceNode$AjcClosure11(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(forceNode$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    public double getMotionControlErrorLimit(int index) {
        return this.indexOK(index, this.limitsMotion) ? this.limitsMotion[index] : (double)this.indexOutOfRange(index);
    }

    public double[] getMotionControlErrorLimits() {
        return this.copyArray(this.limitsMotion, new double[6]);
    }

    @ProgramNodeChange
    public void setMotionControlErrorLimit(int index, double limit) {
        int n = index;
        double d = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.doubleObject((double)d));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), Conversions.doubleObject((double)d), joinPoint};
        ForceNode$AjcClosure13 forceNode$AjcClosure13 = new ForceNode$AjcClosure13(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(forceNode$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    @ProgramNodeChange
    public void setMotionControlErrorLimits(double[] limits) {
        double[] dArray = limits;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)dArray);
        Object[] objectArray = new Object[]{this, dArray, joinPoint};
        ForceNode$AjcClosure15 forceNode$AjcClosure15 = new ForceNode$AjcClosure15(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(forceNode$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    public double getForceControlSpeedLimit(int index) {
        return this.indexOK(index, this.limitsForce) ? this.limitsForce[index] : (double)this.indexOutOfRange(index);
    }

    public double[] getForceControlSpeedLimits() {
        return this.copyArray(this.limitsForce, new double[6]);
    }

    @ProgramNodeChange
    public void setForceControlSpeedLimit(int index, double limit) {
        int n = index;
        double d = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.doubleObject((double)d));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), Conversions.doubleObject((double)d), joinPoint};
        ForceNode$AjcClosure17 forceNode$AjcClosure17 = new ForceNode$AjcClosure17(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(forceNode$AjcClosure17.linkClosureAndJoinPoint(69648));
    }

    @ProgramNodeChange
    public void setForceControlSpeedLimits(double[] limits) {
        double[] dArray = limits;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)dArray);
        Object[] objectArray = new Object[]{this, dArray, joinPoint};
        ForceNode$AjcClosure19 forceNode$AjcClosure19 = new ForceNode$AjcClosure19(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(forceNode$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    public GeomFeatureReference getFeatureReference() {
        return this.featureReference;
    }

    @ProgramNodeChange
    @ProgramEntitiesChange
    public void setFeatureReference(GeomFeatureReference newFeatureReference) {
        GeomFeatureReference geomFeatureReference = newFeatureReference;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)((Object)geomFeatureReference));
        Object[] objectArray = new Object[]{this, geomFeatureReference, joinPoint};
        ForceNode$AjcClosure23 forceNode$AjcClosure23 = new ForceNode$AjcClosure23(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(forceNode$AjcClosure23.linkStackClosureAndJoinPoint(69648));
            forceNode$AjcClosure23.unlink();
        }
        catch (Throwable throwable) {
            forceNode$AjcClosure23.unlink();
            throw throwable;
        }
    }

    public boolean hasAdvancedSettings() {
        return !this.areLimitsDefault() || !this.isSelectionVectorDefault() || !this.isWrenchDefault();
    }

    private boolean isWrenchDefault() {
        int defaultCompliantAxis = this.getDefaultCompliantAxis();
        int i = 0;
        while (i < 6) {
            if (i != defaultCompliantAxis && Double.compare(this.forceModeWrench[i], 0.0) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isSelectionVectorDefault() {
        int defaultCompliantAxis = this.getDefaultCompliantAxis();
        int i = 0;
        while (i < 6) {
            int defaultSelection = 0;
            if (i == defaultCompliantAxis) {
                defaultSelection = 1;
            }
            if (this.selectionVector[i] != defaultSelection) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean areLimitsDefault() {
        int i = 0;
        while (i < 3) {
            if (Double.compare(this.limitsMotion[i], 0.1) != 0 || Double.compare(this.limitsMotion[i + 3], 0.3490658503988659) != 0 || Double.compare(this.limitsForce[i], 0.15) != 0 || Double.compare(this.limitsForce[i + 3], 1.0471975511965976) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Class<? extends CommandPanel<ForceNode>> getCardClass() {
        return ForceCard.class;
    }

    protected void getInternalProgramEntities(Collection<Object> collection) {
        if (this.featureReference != null) {
            collection.add((Object)this.featureReference);
        }
        super.getInternalProgramEntities(collection);
    }

    protected boolean doSubstituteReference(Object original, Object substitute) {
        boolean result = false;
        if (original == this.featureReference && substitute instanceof GeomFeatureReference) {
            this.featureReference = (GeomFeatureReference)((Object)substitute);
            result = true;
        }
        return result;
    }

    public String toString() {
        return this.commandNamesResource.Force();
    }

    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        this.scriptBegin(writer);
        writer.writeProgramLabel((ControllerInterfaceProgramNode)this);
        writer.sleep(0.02);
        this.startForceMode(writer, false);
        writer.writeChildren((Iterable)this.children);
        writer.endForceMode();
        this.scriptEnd(writer);
        return writer;
    }

    private void startForceMode(ScriptWriter writer, boolean testScript) {
        this.extension.appendPreForceModeScript(writer);
        writer.forceMode(this.getForceModeScriptCode(testScript), this.adjustSelectionVectorForMotion(this.selectionVector), this.adjustForceModeWrenchForMotion(this.forceModeWrench), this.getScriptIntValueForForceType(), this.adjustLimitsForMotion(this.getLimits()));
    }

    private int[] adjustSelectionVectorForMotion(int[] selectionVector) {
        int[] newSelectionVector = (int[])selectionVector.clone();
        if (this.forceType == ForceType.MOTION) {
            newSelectionVector[0] = 0;
        }
        return newSelectionVector;
    }

    private double[] adjustForceModeWrenchForMotion(double[] forceModeWrench) {
        double[] newForceModeWrench = (double[])forceModeWrench.clone();
        if (this.forceType == ForceType.MOTION) {
            newForceModeWrench[0] = DEFAULT_WRENCH[0];
        }
        return newForceModeWrench;
    }

    private double[] adjustLimitsForMotion(double[] limits) {
        double[] newLimits = (double[])limits.clone();
        if (this.forceType == ForceType.MOTION) {
            newLimits[0] = DEFAULT_LIMITS_MOTION[0];
        }
        return newLimits;
    }

    private int getScriptIntValueForForceType() {
        Integer value = FORCE_TYPE_VALUES.get((Object)this.forceType);
        if (value == null) {
            Log.error((String)("Invalid force node forceType = " + (Object)((Object)this.forceType)));
            return -1;
        }
        return value;
    }

    private String getForceModeScriptCode(boolean testScript) {
        GeomFeature geomFeature = this.featureReference.dereference();
        if (geomFeature.isVariable() && !testScript) {
            return LookupServiceFacade.get(ProgramReferenceService.class).getGeomFeatureVariable(geomFeature).getScriptName();
        }
        return geomFeature.getForceModeScriptCode();
    }

    private double[] getLimits() {
        double[] result = new double[6];
        int i = 0;
        while (i < 6) {
            result[i] = this.selectionVector[i] == 1 ? this.limitsForce[i] : this.limitsMotion[i];
            ++i;
        }
        return result;
    }

    public boolean isUndefined() {
        return super.isUndefined() || this.featureReference.dereference() == null;
    }

    public ForceNode clone() {
        ForceNode clone = (ForceNode)super.clone();
        clone.selectionVector = new int[6];
        System.arraycopy(this.selectionVector, 0, clone.selectionVector, 0, 6);
        clone.forceModeWrench = new double[6];
        System.arraycopy(this.forceModeWrench, 0, clone.forceModeWrench, 0, 6);
        clone.limitsMotion = new double[6];
        System.arraycopy(this.limitsMotion, 0, clone.limitsMotion, 0, 6);
        clone.limitsForce = new double[6];
        System.arraycopy(this.limitsForce, 0, clone.limitsForce, 0, 6);
        return clone;
    }

    public int getDefaultCompliantAxis() {
        if (this.featureReference != null) {
            return this.featureReference.dereference() instanceof GeomLineNode ? 1 : 2;
        }
        return 1;
    }

    public String getForceTestScriptCode() {
        if (this.featureReference.dereference() == null) {
            return "";
        }
        ScriptWriter script = new ScriptWriter();
        script.defineFunction("forceTestProgram");
        this.startForceMode(script, true);
        script.whileTrue();
        script.sync();
        script.end();
        script.end();
        return script.generateScript();
    }

    private int[] copyArray(int[] source, int[] destination) {
        System.arraycopy(source, 0, destination, 0, destination.length);
        return destination;
    }

    private double[] copyArray(double[] source, double[] destination) {
        System.arraycopy(source, 0, destination, 0, destination.length);
        return destination;
    }

    private boolean indexOK(int index, double[] array) {
        return index >= 0 && index < array.length;
    }

    private boolean indexOK(int index, int[] array) {
        return index >= 0 && index < array.length;
    }

    private int indexOutOfRange(int index) {
        Log.error((String)("Supplied index " + index + " is out of range."), (Throwable)new IndexOutOfBoundsException());
        return 0;
    }

    protected boolean canChildrenStartFromSelection() {
        return false;
    }

    protected boolean canChildrenPauseOnNode() {
        return false;
    }

    static final /* synthetic */ void setForceTypeAndAdjustValues_aroundBody0(ForceNode ajc$this, ForceType forceType, JoinPoint joinPoint) {
        if (ajc$this.forceType != forceType) {
            if (forceType == ForceType.SIMPLE) {
                int defaultCompliantAxis = ajc$this.getDefaultCompliantAxis();
                ajc$this.setSelectionVector(DEFAULT_SELECTION_VECTOR);
                ajc$this.setSelection(defaultCompliantAxis, 1);
                double simpleForce = ajc$this.forceModeWrench[ajc$this.getDefaultCompliantAxis()];
                ajc$this.setWrenchVector(DEFAULT_WRENCH);
                ajc$this.setWrench(defaultCompliantAxis, simpleForce);
                ajc$this.setMotionControlErrorLimits(DEFAULT_LIMITS_MOTION);
                ajc$this.setForceControlSpeedLimits(DEFAULT_LIMITS_FORCE);
            }
            ajc$this.setForceType(forceType);
        }
    }

    static final /* synthetic */ void setForceType_aroundBody2(ForceNode ajc$this, ForceType forceType, JoinPoint joinPoint) {
        if (ajc$this.forceType != forceType) {
            ajc$this.forceType = forceType;
            ajc$this.textHasChanged();
        }
    }

    static final /* synthetic */ void setSelection_aroundBody4(ForceNode ajc$this, int index, int value, JoinPoint joinPoint) {
        if (ajc$this.indexOK(index, ajc$this.selectionVector)) {
            if (ajc$this.selectionVector[index] != value) {
                ajc$this.selectionVector[index] = value;
                ajc$this.textHasChanged();
            }
        } else {
            ajc$this.indexOutOfRange(index);
        }
    }

    static final /* synthetic */ void setSelectionVector_aroundBody6(ForceNode ajc$this, int[] selectionVector, JoinPoint joinPoint) {
        ajc$this.copyArray(selectionVector, ajc$this.selectionVector);
    }

    static final /* synthetic */ void setWrench_aroundBody8(ForceNode ajc$this, int index, double wrench, JoinPoint joinPoint) {
        if (ajc$this.indexOK(index, ajc$this.forceModeWrench)) {
            ajc$this.forceModeWrench[index] = wrench;
        } else {
            ajc$this.indexOutOfRange(index);
        }
    }

    static final /* synthetic */ void setWrenchVector_aroundBody10(ForceNode ajc$this, double[] wrenchVector, JoinPoint joinPoint) {
        ajc$this.copyArray(wrenchVector, ajc$this.forceModeWrench);
    }

    static final /* synthetic */ void setMotionControlErrorLimit_aroundBody12(ForceNode ajc$this, int index, double limit, JoinPoint joinPoint) {
        if (limit < 0.0) {
            return;
        }
        if (ajc$this.indexOK(index, ajc$this.limitsMotion)) {
            ajc$this.limitsMotion[index] = limit;
        } else {
            ajc$this.indexOutOfRange(index);
        }
    }

    static final /* synthetic */ void setMotionControlErrorLimits_aroundBody14(ForceNode ajc$this, double[] limits, JoinPoint joinPoint) {
        double[] dArray = limits;
        int n = limits.length;
        int n2 = 0;
        while (n2 < n) {
            double limit = dArray[n2];
            if (limit < 0.0) {
                return;
            }
            ++n2;
        }
        ajc$this.copyArray(limits, ajc$this.limitsMotion);
    }

    static final /* synthetic */ void setForceControlSpeedLimit_aroundBody16(ForceNode ajc$this, int index, double limit, JoinPoint joinPoint) {
        if (limit < 0.0) {
            return;
        }
        if (ajc$this.indexOK(index, ajc$this.limitsForce)) {
            ajc$this.limitsForce[index] = limit;
        } else {
            ajc$this.indexOutOfRange(index);
        }
    }

    static final /* synthetic */ void setForceControlSpeedLimits_aroundBody18(ForceNode ajc$this, double[] limits, JoinPoint joinPoint) {
        double[] dArray = limits;
        int n = limits.length;
        int n2 = 0;
        while (n2 < n) {
            double limit = dArray[n2];
            if (limit < 0.0) {
                return;
            }
            ++n2;
        }
        ajc$this.copyArray(limits, ajc$this.limitsForce);
    }

    static final /* synthetic */ void setFeatureReference_aroundBody20(ForceNode ajc$this, GeomFeatureReference newFeatureReference, JoinPoint joinPoint) {
        GeomFeature newFeature = newFeatureReference.dereference();
        if (newFeature != null && !ajc$this.isAdvanced()) {
            if (newFeature instanceof GeomLineNode && !(ajc$this.featureReference.dereference() instanceof GeomLineNode)) {
                ajc$this.selectionVector[1] = 1;
                ajc$this.selectionVector[2] = 0;
                ajc$this.forceModeWrench[1] = ajc$this.forceModeWrench[2];
                ajc$this.forceModeWrench[2] = 0.0;
            } else if (!(newFeature instanceof GeomLineNode) && ajc$this.featureReference.dereference() instanceof GeomLineNode) {
                ajc$this.selectionVector[1] = 0;
                ajc$this.selectionVector[2] = 1;
                ajc$this.forceModeWrench[1] = 0.0;
                ajc$this.forceModeWrench[2] = ajc$this.forceModeWrench[1];
            }
        }
        ajc$this.featureReference = newFeatureReference;
        ajc$this.textHasChanged();
    }

    static final /* synthetic */ void setFeatureReference_aroundBody22(ForceNode forceNode, GeomFeatureReference geomFeatureReference, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{forceNode, geomFeatureReference, joinPoint};
        ForceNode$AjcClosure21 forceNode$AjcClosure21 = new ForceNode$AjcClosure21(objectArray);
        try {
            ProgramEntitiesChangeAspect.aspectOf().aroundAnnotatedMethod(forceNode$AjcClosure21.linkStackClosureAndJoinPoint(69648));
            forceNode$AjcClosure21.unlink();
        }
        catch (Throwable throwable) {
            forceNode$AjcClosure21.unlink();
            throw throwable;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ForceNode.java", ForceNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setForceTypeAndAdjustValues", "gui.program.ForceNode", "com.ur.view.polyscope.program.ForceType", "forceType", "", "void"), 116);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setForceType", "gui.program.ForceNode", "com.ur.view.polyscope.program.ForceType", "forceType", "", "void"), 143);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFeatureReference", "gui.program.ForceNode", "gui.program.services.geom.GeomFeatureReference", "newFeatureReference", "", "void"), 263);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSelection", "gui.program.ForceNode", "int:int", "index:value", "", "void"), 159);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSelectionVector", "gui.program.ForceNode", "[I", "selectionVector", "", "void"), 171);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setWrench", "gui.program.ForceNode", "int:double", "index:wrench", "", "void"), 184);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setWrenchVector", "gui.program.ForceNode", "[D", "wrenchVector", "", "void"), 193);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMotionControlErrorLimit", "gui.program.ForceNode", "int:double", "index:limit", "", "void"), 206);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMotionControlErrorLimits", "gui.program.ForceNode", "[D", "limits", "", "void"), 218);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setForceControlSpeedLimit", "gui.program.ForceNode", "int:double", "index:limit", "", "void"), 236);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setForceControlSpeedLimits", "gui.program.ForceNode", "[D", "limits", "", "void"), 248);
    }

    public static interface Extension {
        public static final Extension NULL = writer -> {};

        public void appendPreForceModeScript(ScriptWriter var1);
    }
}

