/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import gui.tools.PersistStrategy;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstallationNameStrategy
implements PersistStrategy<Data> {
    private static final int READ_BUFFER_LENGTH = 8192;

    @Override
    public void marshal(Data toMarshal, Writer writer) throws IOException {
    }

    public String searchForEnclosedText(String left, String right, String str) {
        Pattern P = Pattern.compile(String.valueOf(left) + "(.*?)" + right);
        Matcher matcher = P.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String readAll(Reader reader) {
        try {
            int numCharsRead;
            char[] arr = new char[8192];
            StringBuilder buffer = new StringBuilder();
            while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
                buffer.append(arr, 0, numCharsRead);
            }
            reader.close();
            String targetString = buffer.toString();
            return targetString;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String readInstallationName(String content) {
        String result = this.searchForEnclosedText("installation=\"", "\"", content);
        if (result != null) {
            return result;
        }
        result = this.searchForEnclosedText("<robotEnvironmentFileName>", "</robotEnvironmentFileName>", content);
        return result;
    }

    private String readInstallationDirectory(String content) {
        String result = this.searchForEnclosedText("directory=\"", "\"", content);
        if (result != null) {
            return result;
        }
        result = this.searchForEnclosedText("<directory>", "</directory>", content);
        return result;
    }

    private String readInstallationRelativePath(String content) {
        String result = this.searchForEnclosedText("installationRelativePath=\"", "\"", content);
        if (result != null) {
            return result;
        }
        result = this.searchForEnclosedText("<robotEnvironmentRelativePath>", "</robotEnvironmentRelativePath>", content);
        return result;
    }

    @Override
    public Data unmarshal(Reader reader) throws IOException {
        String content = this.readAll(reader);
        return new Data(this.readInstallationDirectory(content), this.readInstallationName(content), this.readInstallationRelativePath(content));
    }

    public static class Data {
        private final String directory;
        private final String name;
        private final String relativePath;

        public Data(String directory, String name, String relativePath) {
            this.directory = directory;
            this.name = name;
            this.relativePath = relativePath;
        }

        public String getDirectory() {
            return this.directory;
        }

        public String getName() {
            return this.name;
        }

        public String getRelativePath() {
            return this.relativePath;
        }
    }
}

