/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.lang.Defense;
import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.program.nodes.ProgramNodeTypeImpl;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChangeAspect;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.swing.expression.Expression;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.view.domain.program.services.impl.UpdateInternalVariables;
import com.ur.view.program.CommandPanel;
import com.ur.view.program.CommandPanelProvider;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import gui.commandpanels.LoopCard;
import gui.program.EntityFactory;
import gui.program.LoopNode$AjcClosure1;
import gui.program.LoopNode$AjcClosure11;
import gui.program.LoopNode$AjcClosure13;
import gui.program.LoopNode$AjcClosure15;
import gui.program.LoopNode$AjcClosure17;
import gui.program.LoopNode$AjcClosure19;
import gui.program.LoopNode$AjcClosure3;
import gui.program.LoopNode$AjcClosure5;
import gui.program.LoopNode$AjcClosure7;
import gui.program.LoopNode$AjcClosure9;
import gui.tools.LanguagePack;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.inject.Inject;
import javax.swing.tree.TreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class LoopNode
extends AbstractProgramNode
implements ExpressionNodeProperty,
CommandPanelProvider,
UpdateInternalVariables {
    private static final long serialVersionUID = 52L;
    private Type loopType = Type.FOREVER;
    private int count = 0;
    private ProgramVariable variable = null;
    private Expression expr = new Expression();
    private boolean checkConditionInSeperateThread = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    @Inject
    public LoopNode() {
        super((ProgramNodeType)new ProgramNodeTypeImpl(true, true));
        this.setNodeTypeName(LanguagePack.getCommandNamesResource().Loop());
    }

    @CompoundProgramChange
    public void setTypeAndCheckCondition(Type loopType) {
        Type type = loopType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)((Object)type));
        Object[] objectArray = new Object[]{this, type, joinPoint};
        LoopNode$AjcClosure1 loopNode$AjcClosure1 = new LoopNode$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(loopNode$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    public void setCountAndType(int count) {
        int n = count;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
        LoopNode$AjcClosure3 loopNode$AjcClosure3 = new LoopNode$AjcClosure3(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(loopNode$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    public void setExpressionAndType(ExpressionBranchNode expression) {
        ExpressionBranchNode expressionBranchNode = expression;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)expressionBranchNode);
        Object[] objectArray = new Object[]{this, expressionBranchNode, joinPoint};
        LoopNode$AjcClosure5 loopNode$AjcClosure5 = new LoopNode$AjcClosure5(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(loopNode$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public Type getType() {
        return this.loopType;
    }

    @ProgramNodeChange
    public void setType(Type loopType) {
        Type type = loopType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)((Object)type));
        Object[] objectArray = new Object[]{this, type, joinPoint};
        LoopNode$AjcClosure7 loopNode$AjcClosure7 = new LoopNode$AjcClosure7(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(loopNode$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    public int getCount() {
        return this.count;
    }

    @ProgramNodeChange
    public void setCount(int count) {
        int n = count;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
        LoopNode$AjcClosure9 loopNode$AjcClosure9 = new LoopNode$AjcClosure9(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(loopNode$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    public ProgramVariable getVariable() {
        return this.variable;
    }

    @ProgramNodeChange
    @ProgramEntitiesChange
    public void setVariable(Variable variable) {
        Variable variable2 = variable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)variable2);
        Object[] objectArray = new Object[]{this, variable2, joinPoint};
        LoopNode$AjcClosure13 loopNode$AjcClosure13 = new LoopNode$AjcClosure13(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(loopNode$AjcClosure13.linkStackClosureAndJoinPoint(69648));
            loopNode$AjcClosure13.unlink();
        }
        catch (Throwable throwable) {
            loopNode$AjcClosure13.unlink();
            throw throwable;
        }
    }

    public void setVariableWithoutChangeNotification(Variable variable) {
        this.variable = (ProgramVariable)variable;
    }

    public ExpressionBranchNode getExpression() {
        return this.expr.getExpression();
    }

    @ProgramEntitiesChange
    @ProgramNodeChange
    public void setExpression(ExpressionBranchNode expression) {
        ExpressionBranchNode expressionBranchNode = expression;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)expressionBranchNode);
        Object[] objectArray = new Object[]{this, expressionBranchNode, joinPoint};
        LoopNode$AjcClosure17 loopNode$AjcClosure17 = new LoopNode$AjcClosure17(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(loopNode$AjcClosure17.linkStackClosureAndJoinPoint(69648));
            loopNode$AjcClosure17.unlink();
        }
        catch (Throwable throwable) {
            loopNode$AjcClosure17.unlink();
            throw throwable;
        }
    }

    public boolean isCheckConditionInSeperateThread() {
        return this.checkConditionInSeperateThread;
    }

    @ProgramNodeChange
    public void setCheckConditionInSeperateThread(boolean checkConditionInSeperateThread) {
        boolean bl = checkConditionInSeperateThread;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        LoopNode$AjcClosure19 loopNode$AjcClosure19 = new LoopNode$AjcClosure19(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(loopNode$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    public LoopNode clone() {
        LoopNode clone = (LoopNode)super.clone();
        clone.expr = this.expr.clone();
        clone.loopType = this.loopType;
        clone.checkConditionInSeperateThread = this.checkConditionInSeperateThread;
        clone.variable = this.variable != null ? this.variable.clone() : null;
        clone.count = this.count;
        return clone;
    }

    public String toString() {
        switch (this.loopType) {
            case FOREVER: {
                return LanguagePack.getCommandNamesResource().Loop();
            }
            case COUNTING: {
                return LanguagePack.getCommandNamesResource().loopExactlyXTimes(this.count);
            }
            case WHILE: {
                if (this.expr == null) {
                    return LanguagePack.getCommandNamesResource().loopMissingExpression();
                }
                return LanguagePack.getCommandNamesResource().loopWhileExpressionIsTrue(this.expr.toString());
            }
        }
        return "UnknownWhileNode";
    }

    public Class<? extends CommandPanel<LoopNode>> getCardClass() {
        return LoopCard.class;
    }

    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        this.scriptBegin(writer);
        writer.writeProgramLabel((ControllerInterfaceProgramNode)this);
        if (!this.checkConditionInSeperateThread) {
            switch (this.loopType) {
                case FOREVER: {
                    writer.whileTrue();
                    break;
                }
                case COUNTING: {
                    writer.assign(this.getVariable().getScriptName(), "0");
                    writer.whileCondition(String.valueOf(this.getVariable().getScriptName()) + " < " + this.count);
                    break;
                }
                case WHILE: {
                    writer.whileCondition(this.expr.getScriptCodeText());
                }
            }
            writer.writeChildren((Iterable)this.children);
            if (this.loopType == Type.COUNTING) {
                writer.incrementVariable(this.getVariable().getScriptName());
            }
            writer.end();
        } else {
            int id = this.getId();
            writer.defineThread("Thread_while_" + id);
            writer.whileTrue();
            writer.writeChildren((Iterable)this.children);
            writer.end();
            writer.end();
            writer.ifCondition(this.expr.getScriptCodeText());
            writer.globalVariable("thread_handler_" + id, "run Thread_while_" + id + "()");
            writer.whileCondition(this.expr.getScriptCodeText());
            writer.sync();
            writer.end();
            writer.killThread("thread_handler_" + id);
            writer.end();
        }
        this.scriptEnd(writer);
        return writer;
    }

    public LinkedHashSet<AbstractProgramNode> computeNodeToExecuteAfterCompletingThisChild(AbstractProgramNode child) {
        int nextIndex = this.getIndex((TreeNode)child) + 1;
        if (nextIndex < this.getChildCount()) {
            return super.computeNodeToExecuteAfterCompletingThisChild(child);
        }
        LinkedHashSet<AbstractProgramNode> ret = new LinkedHashSet<AbstractProgramNode>();
        ret.add(this);
        return ret;
    }

    public LinkedHashSet<AbstractProgramNode> computeNextExecutionNodes() {
        AbstractProgramNode myparent;
        LinkedHashSet<AbstractProgramNode> ret = new LinkedHashSet<AbstractProgramNode>();
        AbstractProgramNode child = (AbstractProgramNode)this.getFirstChild();
        if (child != null) {
            ret.add(child);
        }
        if ((myparent = (AbstractProgramNode)this.getParent()) != null) {
            ret.addAll(myparent.computeNodeToExecuteAfterCompletingThisChild((AbstractProgramNode)this));
        }
        return ret;
    }

    public boolean isUndefined() {
        if (this.getType() == Type.WHILE && this.getExpression().isUndefined()) {
            return true;
        }
        return super.isUndefined();
    }

    protected void getInternalProgramEntities(Collection<Object> collection) {
        if (this.expr != null) {
            this.expr.getExpression().getProgramEntities(collection);
        }
        collection.add(this.variable);
        super.getInternalProgramEntities(collection);
    }

    protected boolean doSubstituteReference(Object original, Object substitute) {
        boolean result = false;
        result |= this.expr == null ? false : this.expr.getExpression().substituteReference(original, substitute);
        if (this.variable == original && substitute instanceof ProgramVariable) {
            this.variable = (ProgramVariable)substitute;
            result = true;
        }
        return result;
    }

    @Override
    public void updateProgramCounters(EntityFactory entityFactory, NamingService namingService) {
        ProgramVariable newVariable = entityFactory.createLoopVariable();
        namingService.registerNamedEntity((NamedEntity)newVariable);
        if (this.getExpression() != null) {
            this.getExpression().substituteReference((Object)this.getVariable(), (Object)newVariable);
        }
        this.setVariableWithoutChangeNotification(newVariable);
    }

    protected boolean canChildrenStartFromSelection() {
        return super.canChildrenStartFromSelection() && !this.checkConditionInSeperateThread;
    }

    static {
        LoopNode.ajc$preClinit();
    }

    static final /* synthetic */ void setTypeAndCheckCondition_aroundBody0(LoopNode ajc$this, Type loopType, JoinPoint joinPoint) {
        ajc$this.setType(loopType);
        if (loopType != Type.WHILE) {
            ajc$this.setCheckConditionInSeperateThread(false);
        }
    }

    static final /* synthetic */ void setCountAndType_aroundBody2(LoopNode ajc$this, int count, JoinPoint joinPoint) {
        ajc$this.setCount(count);
        ajc$this.setTypeAndCheckCondition(Type.COUNTING);
    }

    static final /* synthetic */ void setExpressionAndType_aroundBody4(LoopNode ajc$this, ExpressionBranchNode expression, JoinPoint joinPoint) {
        ajc$this.setExpression(expression);
        ajc$this.setTypeAndCheckCondition(Type.WHILE);
    }

    static final /* synthetic */ void setType_aroundBody6(LoopNode ajc$this, Type loopType, JoinPoint joinPoint) {
        if (ajc$this.loopType != loopType) {
            ajc$this.loopType = loopType;
            ajc$this.textHasChanged();
        }
    }

    static final /* synthetic */ void setCount_aroundBody8(LoopNode ajc$this, int count, JoinPoint joinPoint) {
        if (ajc$this.count != count) {
            ajc$this.count = count;
            ajc$this.textHasChanged();
        }
    }

    static final /* synthetic */ void setVariable_aroundBody10(LoopNode ajc$this, Variable variable, JoinPoint joinPoint) {
        Defense.isInstanceOf((Object)variable, ProgramVariable.class);
        if (!EqualsUtil.equals((Object)ajc$this.variable, (Object)variable)) {
            ajc$this.variable = (ProgramVariable)variable;
            ajc$this.textHasChanged();
        }
    }

    static final /* synthetic */ void setVariable_aroundBody12(LoopNode loopNode, Variable variable, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{loopNode, variable, joinPoint};
        LoopNode$AjcClosure11 loopNode$AjcClosure11 = new LoopNode$AjcClosure11(objectArray);
        try {
            ProgramEntitiesChangeAspect.aspectOf().aroundAnnotatedMethod(loopNode$AjcClosure11.linkStackClosureAndJoinPoint(69648));
            loopNode$AjcClosure11.unlink();
        }
        catch (Throwable throwable) {
            loopNode$AjcClosure11.unlink();
            throw throwable;
        }
    }

    static final /* synthetic */ void setExpression_aroundBody14(LoopNode ajc$this, ExpressionBranchNode expression, JoinPoint joinPoint) {
        if (!EqualsUtil.equals((Object)ajc$this.getExpression(), (Object)expression)) {
            ajc$this.expr.setExpression(expression);
            ajc$this.textHasChanged();
        }
    }

    static final /* synthetic */ void setExpression_aroundBody16(LoopNode loopNode, ExpressionBranchNode expressionBranchNode, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{loopNode, expressionBranchNode, joinPoint};
        LoopNode$AjcClosure15 loopNode$AjcClosure15 = new LoopNode$AjcClosure15(objectArray);
        try {
            ProgramEntitiesChangeAspect.aspectOf().aroundAnnotatedMethod(loopNode$AjcClosure15.linkStackClosureAndJoinPoint(69648));
            loopNode$AjcClosure15.unlink();
        }
        catch (Throwable throwable) {
            loopNode$AjcClosure15.unlink();
            throw throwable;
        }
    }

    static final /* synthetic */ void setCheckConditionInSeperateThread_aroundBody18(LoopNode ajc$this, boolean checkConditionInSeperateThread, JoinPoint joinPoint) {
        if (ajc$this.checkConditionInSeperateThread != checkConditionInSeperateThread) {
            ajc$this.checkConditionInSeperateThread = checkConditionInSeperateThread;
            ajc$this.textHasChanged();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LoopNode.java", LoopNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTypeAndCheckCondition", "gui.program.LoopNode", "gui.program.LoopNode$Type", "loopType", "", "void"), 45);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCountAndType", "gui.program.LoopNode", "int", "count", "", "void"), 53);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setExpressionAndType", "gui.program.LoopNode", "com.ur.swing.expression.ExpressionBranchNode", "expression", "", "void"), 59);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setType", "gui.program.LoopNode", "gui.program.LoopNode$Type", "loopType", "", "void"), 69);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCount", "gui.program.LoopNode", "int", "count", "", "void"), 81);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setVariable", "gui.program.LoopNode", "com.ur.view.variables.core.Variable", "variable", "", "void"), 94);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setExpression", "gui.program.LoopNode", "com.ur.swing.expression.ExpressionBranchNode", "expression", "", "void"), 114);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCheckConditionInSeperateThread", "gui.program.LoopNode", "boolean", "checkConditionInSeperateThread", "", "void"), 126);
    }

    public static enum Type {
        FOREVER,
        COUNTING,
        WHILE;

    }
}

