/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.lang.Defense;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.visualizer.programvisualization.VisualizerMotion;
import com.ur.util.logging.Log;
import com.ur.view.hmc.ControllerInterfaceMotion;
import com.ur.view.hmc.HMC;
import gui.program.MotionDefiningNode;
import gui.program.MoveNode;
import gui.program.position.PositionNode;
import gui.program.services.MotionData;
import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Motion
implements Serializable,
VisualizerMotion,
ControllerInterfaceMotion {
    public static int MAX_MOTION_BRANCHES_SHOWING = 5;
    private static final long serialVersionUID = 56L;
    private final PositionNode fromPositionNode;
    private final PositionNode toPositionNode;
    public MotionDefiningNode motionDefiningNode = null;
    public Point3d[] p3d = null;

    public Motion(PositionNode fromPositionNode, PositionNode toPositionNode) {
        Defense.notNull((Object)fromPositionNode, (String)"Cannot have a fromPositionNode that is null");
        Defense.notNull((Object)toPositionNode, (String)"Cannot have a toPositionNode that is null");
        this.fromPositionNode = fromPositionNode;
        this.toPositionNode = toPositionNode;
        this.calculateMotionDefiningNode();
    }

    private void calculateMotionDefiningNode() {
        MotionDefiningNode to_mdf = this.toPositionNode.getMotionDefiningNode();
        MotionDefiningNode from_mdf = this.fromPositionNode.getMotionDefiningNode();
        this.motionDefiningNode = from_mdf == to_mdf ? from_mdf : (to_mdf instanceof MoveNode ? to_mdf : from_mdf);
        if (this.motionDefiningNode == null) {
            Log.error((String)"MotionDefingNode is null", (Throwable)new Exception());
        }
    }

    public MotionDefiningNode getMotionDefiningNode() {
        assert (this.motionDefiningNode != null) : "MotionDefiningNode should never be null";
        return this.motionDefiningNode;
    }

    public boolean isUndefined() {
        return this.fromPositionNode.isUndefined() || this.toPositionNode.isUndefined();
    }

    public Point3d[] p3d() {
        return this.p3d;
    }

    public double length() {
        if (this.fromPositionNode.getPositionNodeType() == PositionNodeType.FIXED && this.toPositionNode.getPositionNodeType() == PositionNodeType.FIXED) {
            Vector3d v3d = new Vector3d();
            v3d.sub((Tuple3d)this.fromPositionNode.getToolPosition(), (Tuple3d)this.toPositionNode.getToolPosition());
            return v3d.length();
        }
        return 0.0;
    }

    @Override
    public PositionNode getFromPositionNode() {
        return this.fromPositionNode;
    }

    @Override
    public PositionNode getToPositionNode() {
        return this.toPositionNode;
    }

    public boolean kinematicCheck() {
        return !this.motionDefiningNode.isLinearMove() || !this.fromPositionNode.hasKinematicFlags() || !this.toPositionNode.hasKinematicFlags() || this.fromPositionNode.getKinematicFlags() == this.toPositionNode.getKinematicFlags();
    }

    public void updatePathData(MotionData motionData) {
        if (this.fromPositionNode.isUndefined() || this.toPositionNode.isUndefined()) {
            return;
        }
        if (this.toPositionNode.getMotionDefiningNode() == null || this.fromPositionNode.getMotionDefiningNode() == null) {
            return;
        }
        if (this.fromPositionNode.getPositionNodeType() != PositionNodeType.FIXED || this.toPositionNode.getPositionNodeType() != PositionNodeType.FIXED) {
            return;
        }
        if (this.fromPositionNode.isCircleDefiningNode() || this.toPositionNode.isCircleDefiningNode()) {
            return;
        }
        if (motionData.getNextMotions(this.fromPositionNode).size() > MAX_MOTION_BRANCHES_SHOWING || motionData.getPreviousMotions(this.toPositionNode).size() > MAX_MOTION_BRANCHES_SHOWING) {
            return;
        }
        if (this.p3d == null && !this.fromPositionNode.toString().equalsIgnoreCase(this.toPositionNode.toString())) {
            if (!this.toPositionNode.getMotionDefiningNode().isCartesianMotion()) {
                HMC hmc = new HMC();
                this.p3d = hmc.getJointPath(this.fromPositionNode, this.toPositionNode, 0.05);
            } else {
                double r_to;
                Point3d pFrom = this.fromPositionNode.getActualToolPosition();
                Point3d pTo = this.toPositionNode.getActualToolPosition();
                if (pFrom == null || pTo == null) {
                    this.p3d = new Point3d[0];
                    return;
                }
                Vector3d dist = new Vector3d();
                dist.sub((Tuple3d)pFrom, (Tuple3d)pTo);
                double r_from = this.fromPositionNode.isStopPoint() ? 0.0 : this.fromPositionNode.getBlendRadius();
                double d = r_to = this.toPositionNode.isStopPoint() ? 0.0 : this.toPositionNode.getBlendRadius();
                if (r_from + r_to <= dist.length()) {
                    Point3d pFromOffset = new Point3d();
                    Point3d pToOffset = new Point3d();
                    pFromOffset.interpolate((Tuple3d)pFrom, (Tuple3d)pTo, r_from / dist.length());
                    pToOffset.interpolate((Tuple3d)pTo, (Tuple3d)pFrom, r_to / dist.length());
                    this.p3d = new Point3d[2];
                    this.p3d[0] = pFromOffset;
                    this.p3d[1] = pToOffset;
                } else {
                    this.p3d = new Point3d[0];
                }
            }
        }
    }

    public int hashCode() {
        return this.getMotionDefiningNode().getMotionType().hashCode() + (this.fromPositionNode.hashCode() + this.toPositionNode.hashCode() % 29);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (Motion.class.equals(obj.getClass())) {
            Motion other = (Motion)obj;
            return this.getMotionDefiningNode().getMotionType() == other.getMotionDefiningNode().getMotionType() && (other.fromPositionNode.equivalentTo(this.fromPositionNode) && other.toPositionNode.equivalentTo(this.toPositionNode) || other.fromPositionNode.equivalentTo(this.toPositionNode) && other.toPositionNode.equivalentTo(this.fromPositionNode));
        }
        return false;
    }

    public String toString() {
        if (this.p3d == null) {
            return "Motion from " + this.getFromPositionNode() + " to " + this.getToPositionNode() + " null";
        }
        return "Motion from " + this.getFromPositionNode() + " to " + this.getToPositionNode() + " nP:" + this.p3d.length;
    }
}

