/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.polyscope.geomfeature.SpatialFeatureReference;
import com.ur.polyscope.internaltcp.domain.TCPReference;
import com.ur.polyscope.program.nodes.ProgramNode;
import com.ur.polyscope.program.nodes.move.MoveJNode;
import com.ur.polyscope.program.nodes.move.MoveLNode;
import com.ur.polyscope.program.nodes.move.MovePNode;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.optimove.OptiMoveConfigurationProvider;
import com.ur.polyscope.robot.configuration.tool.ToolConfigurationSettings;
import com.ur.polyscope.tcp.TCPRef;
import com.ur.polyscope.tcp.TCPType;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.aspects.NotNullArgumentAspect;
import com.ur.polyscope.valueobjects.validation.NotNull;
import com.ur.util.logging.Log;
import com.ur.view.program.CommandPanel;
import gui.commandpanels.MoveCard;
import gui.program.CircleMoveNode;
import gui.program.MotionDefiningNode;
import gui.program.MoveChildNode;
import gui.program.MoveNode$AjcClosure1;
import gui.program.direction.MoveDirectionNode;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.GeomFeatureReferenceBase;
import gui.tools.LanguagePack;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.swing.tree.TreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class MoveNode
extends MotionDefiningNode
implements MoveJNode,
MoveLNode,
MovePNode {
    private static final long serialVersionUID = 47L;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    public MoveNode(ProgramReferenceService programReferenceService, JointConfigurationSettings settings, ToolConfigurationSettings toolConfigurationSettings, OptiMoveConfigurationProvider optiMoveConfigurationProvider) {
        super(programReferenceService, settings, toolConfigurationSettings, optiMoveConfigurationProvider);
        this.setNodeTypeName(LanguagePack.getCommandNamesResource().Move());
    }

    public Class<? extends CommandPanel<MoveNode>> getCardClass() {
        return MoveCard.class;
    }

    public String toString() {
        switch (this.getMotionType()) {
            case JOINT_MOVE: 
            case LINEAR_MOVE: 
            case PROCESS_MOVE: {
                return LanguagePack.getCommandNamesResource().motionType(this.getMotionType());
            }
        }
        return LanguagePack.getCommandNamesResource().Move();
    }

    @Override
    public boolean isUndefined() {
        if (super.isUndefined()) {
            return true;
        }
        if (this.getMotionType() != MotionDefiningNode.MotionType.PROCESS_MOVE) {
            Enumeration enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!(o instanceof TreeNode)) {
                    Log.error((String)("MoveNode.isUndefined() Error 1: The enumeration returned by children() contained a non-TreeNode: " + o));
                    continue;
                }
                TreeNode node = (TreeNode)o;
                if (!(node instanceof CircleMoveNode)) continue;
                return true;
            }
        }
        return !this.containsAnyDefinedWaypoint();
    }

    private boolean containsAnyDefinedWaypoint() {
        Enumeration enumeration = this.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (!(o instanceof MoveChildNode)) continue;
            return true;
        }
        return false;
    }

    public void copyDataFrom(MoveNode moveNode) {
        this.setTcp(moveNode.getTcp());
        this.setMotionType(moveNode.getMotionType());
        this.setJointSpeed(moveNode.getJointSpeed());
        this.setJointAcceleration(moveNode.getJointAcceleration());
        this.setCartesianSpeed(moveNode.getCartesianSpeed());
        this.setCartesianAcceleration(moveNode.getCartesianAcceleration());
        this.setSharedProcessMoveBlendRadius(moveNode.getSharedProcessMoveBlendRadius());
        this.setFeatureReference((GeomFeatureReferenceBase)moveNode.getFeatureReference());
    }

    public double getToolSpeed() {
        return this.getSpeed().getIn(Speed.Unit.SI);
    }

    public void setToolSpeed(double value) {
        this.setSpeed(Speed.from((double)value, (Speed.Unit)Speed.Unit.SI));
    }

    public double getToolAcceleration() {
        return this.getAcceleration().getIn(Acceleration.Unit.SI);
    }

    public void setToolAcceleration(double value) {
        this.setAcceleration(Acceleration.from((double)value, (Acceleration.Unit)Acceleration.Unit.SI));
    }

    public void setFeatureReference(SpatialFeatureReference featureReference) {
        this.setFeatureReference((GeomFeatureReferenceBase)featureReference);
    }

    public TCPType getTCPType() {
        if (this.isUseActiveTCP()) {
            return TCPType.ACTIVE_TCP;
        }
        if (this.isIgnoreTCP()) {
            return TCPType.TOOL_FLANGE;
        }
        return TCPType.TCP;
    }

    public void setTCPType(TCPType tcpType) {
        switch (tcpType) {
            case ACTIVE_TCP: {
                this.setTCPSettings(null, true);
                break;
            }
            case TOOL_FLANGE: {
                this.setTCPSettings(null, false);
                break;
            }
            case TCP: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown TCPType " + tcpType);
            }
        }
    }

    public TCPRef getTCPRef() {
        return this.getTcpReference();
    }

    public void setTCPRef(@NotNull TCPRef tcpRef) {
        TCPRef tCPRef = tcpRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)tCPRef);
        Object[] objectArray = new Object[]{this, tCPRef, joinPoint};
        MoveNode$AjcClosure1 moveNode$AjcClosure1 = new MoveNode$AjcClosure1(objectArray);
        NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(moveNode$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public double getBlend() {
        return this.getSharedProcessMoveBlendRadius();
    }

    public void setBlend(double value) {
        this.setSharedProcessMoveBlendRadius(value);
    }

    public Class<? extends com.ur.polyscope.program.nodes.move.MoveNode> getType() {
        Class<MoveJNode> type;
        MotionDefiningNode.MotionType motionType = this.getMotionType();
        switch (motionType) {
            case JOINT_MOVE: {
                type = MoveJNode.class;
                break;
            }
            case LINEAR_MOVE: {
                type = MoveLNode.class;
                break;
            }
            case PROCESS_MOVE: {
                type = MovePNode.class;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported node type:" + (Object)((Object)motionType));
            }
        }
        return type;
    }

    public ProgramNode.GenericProgramNode asGeneric() {
        return new ProgramNode.GenericProgramNode((ProgramNode)this){

            public String getName() {
                return MoveNode.this.getType().getSimpleName();
            }
        };
    }

    public <T extends com.ur.polyscope.program.nodes.move.MoveNode> T convertTo(Class<T> clazz) {
        if (clazz != this.getType()) {
            if (clazz == MoveJNode.class) {
                this.throwIfMovePAndHasCircleMoveChild();
                this.throwIfMovePOrMoveLAndHasDirectionChild();
                this.setMotionType(MotionDefiningNode.MotionType.JOINT_MOVE);
            } else if (clazz == MoveLNode.class) {
                this.throwIfMovePAndHasCircleMoveChild();
                this.setMotionType(MotionDefiningNode.MotionType.LINEAR_MOVE);
            } else if (clazz == MovePNode.class) {
                this.setMotionType(MotionDefiningNode.MotionType.PROCESS_MOVE);
            } else {
                throw new IllegalArgumentException("Unsupported node type:" + clazz);
            }
        }
        return (T)((com.ur.polyscope.program.nodes.move.MoveNode)clazz.cast(this));
    }

    private void throwIfMovePAndHasCircleMoveChild() {
        if (this.isProcessMove() && this.hasCircleMoveChild()) {
            throw new IllegalArgumentException("This move node contains a circle move which is only allowed under MoveP");
        }
    }

    private void throwIfMovePOrMoveLAndHasDirectionChild() {
        if ((this.isProcessMove() || this.isLinearMove()) && this.hasDirectionMoveChild()) {
            throw new IllegalArgumentException("This move node contains direction nodes which are not allowed in MoveJ. To change to a MoveJ, please first delete the direction nodes.");
        }
    }

    private boolean hasCircleMoveChild() {
        Enumeration children = this.children();
        while (children.hasMoreElements()) {
            TreeNode child = (TreeNode)children.nextElement();
            if (!(child instanceof CircleMoveNode)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDirectionMoveChild() {
        Enumeration children = this.children();
        while (children.hasMoreElements()) {
            TreeNode child = (TreeNode)children.nextElement();
            if (!(child instanceof MoveDirectionNode)) continue;
            return true;
        }
        return false;
    }

    static {
        MoveNode.ajc$preClinit();
    }

    static final /* synthetic */ void setTCPRef_aroundBody0(MoveNode ajc$this, TCPRef tcpRef, JoinPoint joinPoint) {
        ajc$this.setTCPSettings((TCPReference)tcpRef, false);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MoveNode.java", MoveNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTCPRef", "gui.program.MoveNode", "com.ur.polyscope.tcp.TCPRef", "tcpRef", "", "void"), 169);
    }
}

