/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.program.nodes.ProgramNodeTypeImpl;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChangeAspect;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.optimove.OptiMoveConfigurationProvider;
import com.ur.polyscope.robot.configuration.tool.ToolConfigurationSettings;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.visualizer.programvisualization.VisualizedProgramNodePositions;
import com.ur.util.logging.Log;
import com.ur.view.program.CommandPanel;
import com.ur.view.variables.core.ProgramVariable;
import gui.commandpanels.wizards.NewPatternCard;
import gui.commandpanels.wizards.PatternCard;
import gui.program.MotionDefiningNode;
import gui.program.PatternNode$AjcClosure1;
import gui.program.PatternNode$AjcClosure11;
import gui.program.PatternNode$AjcClosure13;
import gui.program.PatternNode$AjcClosure15;
import gui.program.PatternNode$AjcClosure17;
import gui.program.PatternNode$AjcClosure3;
import gui.program.PatternNode$AjcClosure5;
import gui.program.PatternNode$AjcClosure7;
import gui.program.PatternNode$AjcClosure9;
import gui.program.ProgramRootNode;
import gui.program.SuppressedNode;
import gui.program.WizardNode;
import gui.program.position.WaypointNode;
import gui.program.services.ProgramReferenceService;
import gui.tools.LanguagePack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class PatternNode
extends MotionDefiningNode
implements WizardNode,
com.ur.polyscope.program.nodes.PatternNode,
VisualizedProgramNodePositions {
    private static final long serialVersionUID = 242345L;
    private ProgramVariable variable = null;
    private ProgramVariable patternPoseVariable = null;
    private int firstAxisCount = 5;
    private int secondAxisCount = 5;
    private int thirdAxisCount = 5;
    private Type dimensionality = Type.UNDEFINED;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    @Inject
    public PatternNode(ProgramReferenceService programReferenceService, JointConfigurationSettings settings, ToolConfigurationSettings toolConfigurationSettings, OptiMoveConfigurationProvider optiMoveConfigurationProvider) {
        super(programReferenceService, settings, toolConfigurationSettings, optiMoveConfigurationProvider, MotionDefiningNode.MotionType.LINEAR_MOVE);
    }

    public boolean isSuppressible() {
        return false;
    }

    public boolean canStartFromSelection() {
        return false;
    }

    public boolean canChildrenStartFromSelection() {
        return false;
    }

    public boolean canPauseOnNode() {
        return false;
    }

    protected boolean canChildrenPauseOnNode() {
        return false;
    }

    public ProgramVariable getCounterVariable() {
        return this.variable;
    }

    @ProgramEntitiesChange
    @ProgramNodeChange
    public void setCounterVariable(ProgramVariable variable) {
        ProgramVariable programVariable = variable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)programVariable);
        Object[] objectArray = new Object[]{this, programVariable, joinPoint};
        PatternNode$AjcClosure3 patternNode$AjcClosure3 = new PatternNode$AjcClosure3(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(patternNode$AjcClosure3.linkStackClosureAndJoinPoint(69648));
            patternNode$AjcClosure3.unlink();
        }
        catch (Throwable throwable) {
            patternNode$AjcClosure3.unlink();
            throw throwable;
        }
    }

    public void setCounterVariableWithoutChangeNotification(ProgramVariable variable) {
        this.copyOriginalVariableProperties(variable);
        this.variable = variable;
    }

    private void copyOriginalVariableProperties(ProgramVariable variable) {
        if (this.variable != null) {
            variable.setPrefersPersistentValue(this.variable.prefersPersistentValue());
            variable.getExpression().setExpression(this.variable.getExpression().getExpression());
            variable.getInitExpression().setExpression(this.variable.getInitExpression().getExpression());
        }
    }

    public ProgramVariable getPatternPoseVariable() {
        return this.patternPoseVariable;
    }

    @ProgramEntitiesChange
    @ProgramNodeChange
    public void setPatternPoseVariable(ProgramVariable patternPoseVariable) {
        ProgramVariable programVariable = patternPoseVariable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)programVariable);
        Object[] objectArray = new Object[]{this, programVariable, joinPoint};
        PatternNode$AjcClosure7 patternNode$AjcClosure7 = new PatternNode$AjcClosure7(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(patternNode$AjcClosure7.linkStackClosureAndJoinPoint(69648));
            patternNode$AjcClosure7.unlink();
        }
        catch (Throwable throwable) {
            patternNode$AjcClosure7.unlink();
            throw throwable;
        }
    }

    public void setPatternPoseVariableWithoutChangeNotification(ProgramVariable patternPoseVariable) {
        this.patternPoseVariable = patternPoseVariable;
    }

    public boolean getPrefersPersistentCounterVariableValue() {
        return this.variable != null && this.variable.prefersPersistentValue();
    }

    @ProgramNodeChange
    public void setPrefersPersistentCounterVariableValue(boolean prefersPersistentValue) {
        boolean bl = prefersPersistentValue;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        PatternNode$AjcClosure9 patternNode$AjcClosure9 = new PatternNode$AjcClosure9(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(patternNode$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    public int getFirstAxisCount() {
        return this.firstAxisCount;
    }

    @ProgramNodeChange
    public void setFirstAxisCount(int firstAxisCount) {
        int n = firstAxisCount;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
        PatternNode$AjcClosure11 patternNode$AjcClosure11 = new PatternNode$AjcClosure11(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(patternNode$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    public int getSecondAxisCount() {
        return this.secondAxisCount;
    }

    @ProgramNodeChange
    public void setSecondAxisCount(int secondAxisCount) {
        int n = secondAxisCount;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
        PatternNode$AjcClosure13 patternNode$AjcClosure13 = new PatternNode$AjcClosure13(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(patternNode$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    public int getThirdAxisCount() {
        return this.thirdAxisCount;
    }

    @ProgramNodeChange
    public void setThirdAxisCount(int thirdAxisCount) {
        int n = thirdAxisCount;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
        PatternNode$AjcClosure15 patternNode$AjcClosure15 = new PatternNode$AjcClosure15(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(patternNode$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    public Type getDimensionality() {
        return this.dimensionality;
    }

    @ProgramNodeChange
    public void setDimensionality(Type dimensionality) {
        Type type = dimensionality;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)((Object)type));
        Object[] objectArray = new Object[]{this, type, joinPoint};
        PatternNode$AjcClosure17 patternNode$AjcClosure17 = new PatternNode$AjcClosure17(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(patternNode$AjcClosure17.linkClosureAndJoinPoint(69648));
    }

    public int getMaxChildCount() {
        switch (this.dimensionality) {
            case UNDEFINED: {
                return 0;
            }
            case LIST: {
                return Integer.MAX_VALUE;
            }
            case LINE: {
                return 2;
            }
            case SQUARE_OBSOLETE: {
                return 3;
            }
            case BOX_OBSOLETE: {
                return 4;
            }
            case SQUARE: {
                return 4;
            }
            case BOX: {
                return 8;
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isUndefined() {
        if (this.variable == null) {
            if (ProgramRootNode.get(this) != null) {
                Log.error((String)"Should always have a variable set");
            }
            return true;
        }
        if (this.dimensionality == Type.UNDEFINED) {
            return true;
        }
        if (this.children != null && !this.children.isEmpty()) {
            boolean allChildrenNodesAreSuppressed = true;
            for (Object o : this.children) {
                AbstractProgramNode child;
                if (o instanceof SuppressedNode) continue;
                allChildrenNodesAreSuppressed = false;
                if (!(o instanceof AbstractProgramNode) || !(child = (AbstractProgramNode)o).isUndefined()) continue;
                return true;
            }
            if (this.dimensionality == Type.LIST && allChildrenNodesAreSuppressed) {
                return true;
            }
        }
        return false;
    }

    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        this.scriptBegin(writer);
        writer.writeProgramLabel((ControllerInterfaceProgramNode)this);
        this.generateCodeForCalculatingAnchorPose(writer, this.getId());
        writer.movel(this.appendPoseVarName(this.getId()), this.getAcceleration().getIn(Acceleration.Unit.SI), this.getSpeed().getIn(Speed.Unit.SI));
        this.scriptEnd(writer);
        return writer;
    }

    public void generateCodeForCalculatingAnchorPose(ScriptWriter writer, int aid) {
        this.scriptBegin(writer);
        switch (this.getDimensionality()) {
            case LIST: {
                List<WaypointNode> waypoints = this.getWaypoints();
                int i = 0;
                while (i < waypoints.size()) {
                    if (i == 0) {
                        writer.ifCondition(String.valueOf(this.variable.getScriptName()) + " == 0");
                    } else {
                        writer.elseIfCondition(String.valueOf(this.variable.getScriptName()) + " == " + i);
                    }
                    WaypointNode waypointNode = waypoints.get(i);
                    writer.assign(this.appendPoseVarName(aid), waypointNode.generatePoseScriptCode());
                    ++i;
                }
                if (waypoints.size() <= 0) break;
                writer.end();
                break;
            }
            case LINE: {
                WaypointNode wp1 = (WaypointNode)this.children.elementAt(0);
                WaypointNode wp2 = (WaypointNode)this.children.elementAt(1);
                writer.assign(this.appendPoseVarName(aid), "interpolate_pose(" + wp1.generatePoseScriptCode() + "," + wp2.generatePoseScriptCode() + ", " + this.variable.getScriptName() + "/" + (this.getFirstAxisCount() - 1) + ".0)");
                break;
            }
            case SQUARE_OBSOLETE: {
                WaypointNode wp1 = (WaypointNode)this.children.elementAt(0);
                WaypointNode wp2 = (WaypointNode)this.children.elementAt(1);
                WaypointNode wp3 = (WaypointNode)this.children.elementAt(2);
                writer.assign(String.valueOf(this.variable.getScriptName()) + "_1", String.valueOf(this.variable.getScriptName()) + "%" + this.getFirstAxisCount());
                writer.assign(String.valueOf(this.variable.getScriptName()) + "_2", "floor(" + this.variable.getScriptName() + "/" + this.getFirstAxisCount() + ")");
                writer.assign("vector_a", "pose_sub(interpolate_pose(" + wp1.generatePoseScriptCode() + ", " + wp2.generatePoseScriptCode() + ", " + this.variable.getScriptName() + "_1/" + (this.getFirstAxisCount() - 1) + ".0), " + wp1.generatePoseScriptCode() + ")");
                writer.assign("vector_b", "pose_sub(interpolate_pose(" + wp2.generatePoseScriptCode() + ", " + wp3.generatePoseScriptCode() + ", " + this.variable.getScriptName() + "_2/" + (this.getSecondAxisCount() - 1) + ".0), " + wp2.generatePoseScriptCode() + ")");
                writer.assign(this.appendPoseVarName(aid), "pose_add(pose_add(" + wp1.generatePoseScriptCode() + ",vector_a),vector_b)");
                break;
            }
            case BOX_OBSOLETE: {
                WaypointNode wp1 = (WaypointNode)this.children.elementAt(0);
                WaypointNode wp2 = (WaypointNode)this.children.elementAt(1);
                WaypointNode wp3 = (WaypointNode)this.children.elementAt(2);
                WaypointNode wp4 = (WaypointNode)this.children.elementAt(3);
                writer.assign(String.valueOf(this.variable.getScriptName()) + "_1", String.valueOf(this.variable.getScriptName()) + "%" + this.getFirstAxisCount());
                writer.assign(String.valueOf(this.variable.getScriptName()) + "_2", "floor(" + this.variable.getScriptName() + "/" + this.getFirstAxisCount() + ")%" + this.getSecondAxisCount());
                writer.assign(String.valueOf(this.variable.getScriptName()) + "_3", "floor(" + this.variable.getScriptName() + "/" + this.getFirstAxisCount() * this.getSecondAxisCount() + ")");
                writer.assign("vector_a", "pose_sub(interpolate_pose(" + wp1.generatePoseScriptCode() + ", " + wp2.generatePoseScriptCode() + ", " + this.variable.getScriptName() + "_1/" + (this.getFirstAxisCount() - 1) + ".0)," + wp1.generatePoseScriptCode() + ")");
                writer.assign("vector_b", "pose_sub(interpolate_pose(" + wp2.generatePoseScriptCode() + ", " + wp3.generatePoseScriptCode() + ", " + this.variable.getScriptName() + "_2/" + (this.getSecondAxisCount() - 1) + ".0)," + wp2.generatePoseScriptCode() + ")");
                writer.assign("vector_c", "pose_sub(interpolate_pose(" + wp3.generatePoseScriptCode() + ", " + wp4.generatePoseScriptCode() + ", " + this.variable.getScriptName() + "_3/" + (this.getThirdAxisCount() - 1) + ".0)," + wp3.generatePoseScriptCode() + ")");
                writer.assign(this.appendPoseVarName(aid), "pose_add(pose_add(" + wp1.generatePoseScriptCode() + ",vector_a),pose_add(vector_b,vector_c))");
                break;
            }
            case SQUARE: {
                WaypointNode wp1 = (WaypointNode)this.children.elementAt(0);
                WaypointNode wp2 = (WaypointNode)this.children.elementAt(1);
                WaypointNode wp3 = (WaypointNode)this.children.elementAt(2);
                WaypointNode wp4 = (WaypointNode)this.children.elementAt(3);
                writer.assign(String.valueOf(this.variable.getScriptName()) + "_x", String.valueOf(this.variable.getScriptName()) + " % " + this.getFirstAxisCount());
                writer.assign(String.valueOf(this.variable.getScriptName()) + "_y", "floor(" + this.variable.getScriptName() + " / " + this.getFirstAxisCount() + ")");
                writer.assign(this.appendPoseVarName(aid), "interpolate_pose(interpolate_pose(" + wp1.generatePoseScriptCode() + ", " + wp2.generatePoseScriptCode() + ", " + this.variable.getScriptName() + "_x/" + (this.getFirstAxisCount() - 1) + "), interpolate_pose(" + wp4.generatePoseScriptCode() + ", " + wp3.generatePoseScriptCode() + "," + this.variable.getScriptName() + "_x/" + (this.getFirstAxisCount() - 1) + "), " + this.variable.getScriptName() + "_y/" + (this.getSecondAxisCount() - 1) + ")");
                break;
            }
            case BOX: {
                WaypointNode wp1 = (WaypointNode)this.children.elementAt(0);
                WaypointNode wp2 = (WaypointNode)this.children.elementAt(1);
                WaypointNode wp3 = (WaypointNode)this.children.elementAt(2);
                WaypointNode wp4 = (WaypointNode)this.children.elementAt(3);
                WaypointNode wp5 = (WaypointNode)this.children.elementAt(4);
                WaypointNode wp6 = (WaypointNode)this.children.elementAt(5);
                WaypointNode wp7 = (WaypointNode)this.children.elementAt(6);
                WaypointNode wp8 = (WaypointNode)this.children.elementAt(7);
                writer.assign(String.valueOf(this.variable.getScriptName()) + "_x_ratio", "(" + this.variable.getScriptName() + "%" + this.getFirstAxisCount() + ")/" + (this.getFirstAxisCount() - 1));
                writer.assign(String.valueOf(this.variable.getScriptName()) + "_y_ratio", "(floor(" + this.variable.getScriptName() + "/" + this.getFirstAxisCount() + ")%" + this.getSecondAxisCount() + ")/" + (this.getSecondAxisCount() - 1));
                writer.assign(String.valueOf(this.variable.getScriptName()) + "_z_ratio", "(floor(" + this.variable.getScriptName() + "/" + this.getFirstAxisCount() * this.getSecondAxisCount() + "))/" + (this.getThirdAxisCount() - 1));
                writer.assign(this.appendPoseVarName(aid), "interpolate_pose(interpolate_pose(interpolate_pose(" + wp1.generatePoseScriptCode() + ", " + wp2.generatePoseScriptCode() + ", " + this.variable.getScriptName() + "_x_ratio), " + "interpolate_pose(" + wp4.generatePoseScriptCode() + ", " + wp3.generatePoseScriptCode() + ", " + this.variable.getScriptName() + "_x_ratio), " + this.variable.getScriptName() + "_y_ratio), " + "interpolate_pose(interpolate_pose(" + wp5.generatePoseScriptCode() + ", " + wp6.generatePoseScriptCode() + ", " + this.variable.getScriptName() + "_x_ratio), " + "interpolate_pose(" + wp8.generatePoseScriptCode() + ", " + wp7.generatePoseScriptCode() + ", " + this.variable.getScriptName() + "_x_ratio), " + this.variable.getScriptName() + "_y_ratio), " + this.variable.getScriptName() + "_z_ratio)");
                break;
            }
            default: {
                writer.assign(this.appendPoseVarName(aid), "p[0,0,0,0,0,0])");
            }
        }
        writer.ifCondition(String.valueOf(this.variable.getScriptName()) + " >= " + (this.getTotalPointsCount() - 1));
        writer.assign(this.variable.getScriptName(), "0");
        writer.elseCondition();
        writer.assign(this.variable.getScriptName(), String.valueOf(this.variable.getScriptName()) + " + 1");
        writer.end();
        this.scriptEnd(writer);
    }

    private List<WaypointNode> getWaypoints() {
        ArrayList<WaypointNode> waypoints = new ArrayList<WaypointNode>();
        for (Object child : this.children) {
            if (!(child instanceof WaypointNode)) continue;
            waypoints.add((WaypointNode)child);
        }
        return waypoints;
    }

    private int getTotalPointsCount() {
        switch (this.getDimensionality()) {
            case UNDEFINED: {
                return 0;
            }
            case LIST: {
                return this.getWaypoints().size();
            }
            case LINE: {
                return this.getFirstAxisCount();
            }
            case SQUARE_OBSOLETE: {
                return this.getFirstAxisCount() * this.getSecondAxisCount();
            }
            case BOX_OBSOLETE: {
                return this.getFirstAxisCount() * this.getSecondAxisCount() * this.getThirdAxisCount();
            }
            case SQUARE: {
                return this.getFirstAxisCount() * this.getSecondAxisCount();
            }
            case BOX: {
                return this.getFirstAxisCount() * this.getSecondAxisCount() * this.getThirdAxisCount();
            }
        }
        return 0;
    }

    private String appendPoseVarName(int aid) {
        if (this.patternPoseVariable == null) {
            return "ur_anchor_pose_" + aid;
        }
        return this.patternPoseVariable.getScriptName();
    }

    public LinkedHashSet<AbstractProgramNode> computeNextExecutionNodes() {
        LinkedHashSet<AbstractProgramNode> ret = new LinkedHashSet<AbstractProgramNode>();
        if (this.children != null) {
            for (Object child : this.children) {
                ret.add((AbstractProgramNode)child);
            }
        }
        return ret;
    }

    public LinkedHashSet<AbstractProgramNode> computeNodeToExecuteAfterCompletingThisChild(AbstractProgramNode child) {
        return ((AbstractProgramNode)this.getParent()).computeNodeToExecuteAfterCompletingThisChild((AbstractProgramNode)this);
    }

    @Override
    public PatternNode clone() {
        PatternNode newNode = (PatternNode)super.clone();
        if (this.variable != null) {
            newNode.variable = this.variable.clone();
        }
        if (this.patternPoseVariable != null) {
            newNode.patternPoseVariable = this.patternPoseVariable.clone();
        }
        return newNode;
    }

    public Class<? extends CommandPanel<PatternNode>> getCardClass() {
        switch (this.dimensionality) {
            case UNDEFINED: {
                return NewPatternCard.class;
            }
            case LIST: {
                return PatternCard.class;
            }
            case LINE: {
                return PatternCard.class;
            }
            case SQUARE_OBSOLETE: {
                return PatternCard.class;
            }
            case BOX_OBSOLETE: {
                return PatternCard.class;
            }
            case SQUARE: {
                return PatternCard.class;
            }
            case BOX: {
                return PatternCard.class;
            }
        }
        return NewPatternCard.class;
    }

    public String toString() {
        switch (this.dimensionality) {
            case UNDEFINED: {
                return LanguagePack.getCommandNamesResource().Pattern();
            }
            case LIST: {
                return LanguagePack.getCommandNamesResource().patternList();
            }
            case LINE: {
                return LanguagePack.getCommandNamesResource().patternLine();
            }
            case SQUARE_OBSOLETE: {
                return LanguagePack.getCommandNamesResource().patternSquare();
            }
            case BOX_OBSOLETE: {
                return LanguagePack.getCommandNamesResource().patternBox();
            }
            case SQUARE: {
                return LanguagePack.getCommandNamesResource().patternSquare();
            }
            case BOX: {
                return LanguagePack.getCommandNamesResource().patternBox();
            }
        }
        return "Pattern-error";
    }

    public Set<Vector3d> getPositionsToVisualize() {
        HashSet<Vector3d> ret = new HashSet<Vector3d>();
        switch (this.dimensionality) {
            case UNDEFINED: {
                break;
            }
            case LIST: {
                int i = 0;
                while (i < this.children.size()) {
                    if (this.children.elementAt(i) instanceof WaypointNode) {
                        Point3d p3d = ((WaypointNode)this.children.elementAt(i)).getPositionReference().getToolPosition();
                        ret.add(new Vector3d((Tuple3d)p3d));
                    }
                    ++i;
                }
                break;
            }
            case LINE: {
                WaypointNode wp1 = (WaypointNode)this.children.elementAt(0);
                WaypointNode wp2 = (WaypointNode)this.children.elementAt(1);
                Point3d p3d1 = wp1.getPositionReference().getToolPosition();
                Point3d p3d2 = wp2.getPositionReference().getToolPosition();
                int i = 0;
                while (i < this.getFirstAxisCount()) {
                    ret.add(new Vector3d(p3d1.x + (p3d2.x - p3d1.x) * (double)i / (double)(this.getFirstAxisCount() - 1), p3d1.y + (p3d2.y - p3d1.y) * (double)i / (double)(this.getFirstAxisCount() - 1), p3d1.z + (p3d2.z - p3d1.z) * (double)i / (double)(this.getFirstAxisCount() - 1)));
                    ++i;
                }
                break;
            }
            case SQUARE_OBSOLETE: {
                WaypointNode wp1 = (WaypointNode)this.children.elementAt(0);
                WaypointNode wp2 = (WaypointNode)this.children.elementAt(1);
                WaypointNode wp3 = (WaypointNode)this.children.elementAt(2);
                int j = 0;
                while (j < this.getSecondAxisCount()) {
                    int i = 0;
                    while (i < this.getFirstAxisCount()) {
                        Vector3d vector1 = new Vector3d((Tuple3d)wp1.getPositionReference().getToolPosition());
                        Vector3d vector2 = new Vector3d((Tuple3d)wp2.getPositionReference().getToolPosition());
                        Vector3d vector3 = new Vector3d((Tuple3d)wp3.getPositionReference().getToolPosition());
                        vector3.sub((Tuple3d)vector2);
                        vector2.sub((Tuple3d)vector1);
                        vector3.scale((double)j / (double)(this.getSecondAxisCount() - 1));
                        vector2.scale((double)i / (double)(this.getFirstAxisCount() - 1));
                        vector1.add((Tuple3d)vector2);
                        vector1.add((Tuple3d)vector3);
                        ret.add(vector1);
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case BOX_OBSOLETE: {
                WaypointNode wp1 = (WaypointNode)this.children.elementAt(0);
                WaypointNode wp2 = (WaypointNode)this.children.elementAt(1);
                WaypointNode wp3 = (WaypointNode)this.children.elementAt(2);
                WaypointNode wp4 = (WaypointNode)this.children.elementAt(3);
                int k = 0;
                while (k < this.getThirdAxisCount()) {
                    int j = 0;
                    while (j < this.getSecondAxisCount()) {
                        int i = 0;
                        while (i < this.getFirstAxisCount()) {
                            Vector3d vector1 = new Vector3d((Tuple3d)wp1.getPositionReference().getToolPosition());
                            Vector3d vector2 = new Vector3d((Tuple3d)wp2.getPositionReference().getToolPosition());
                            Vector3d vector3 = new Vector3d((Tuple3d)wp3.getPositionReference().getToolPosition());
                            Vector3d vector4 = new Vector3d((Tuple3d)wp4.getPositionReference().getToolPosition());
                            vector4.sub((Tuple3d)vector3);
                            vector3.sub((Tuple3d)vector2);
                            vector2.sub((Tuple3d)vector1);
                            vector4.scale((double)k / (double)(this.getThirdAxisCount() - 1));
                            vector3.scale((double)j / (double)(this.getSecondAxisCount() - 1));
                            vector2.scale((double)i / (double)(this.getFirstAxisCount() - 1));
                            vector1.add((Tuple3d)vector2);
                            vector1.add((Tuple3d)vector3);
                            vector1.add((Tuple3d)vector4);
                            ret.add(vector1);
                            ++i;
                        }
                        ++j;
                    }
                    ++k;
                }
                break;
            }
            case SQUARE: {
                WaypointNode wp1 = (WaypointNode)this.children.elementAt(0);
                WaypointNode wp2 = (WaypointNode)this.children.elementAt(1);
                WaypointNode wp3 = (WaypointNode)this.children.elementAt(2);
                WaypointNode wp4 = (WaypointNode)this.children.elementAt(3);
                int j = 0;
                while (j < this.getSecondAxisCount()) {
                    int i = 0;
                    while (i < this.getFirstAxisCount()) {
                        Vector3d v11 = new Vector3d((Tuple3d)wp1.getPositionReference().getToolPosition());
                        Vector3d v21 = new Vector3d((Tuple3d)wp2.getPositionReference().getToolPosition());
                        Vector3d v12 = new Vector3d((Tuple3d)wp4.getPositionReference().getToolPosition());
                        Vector3d v22 = new Vector3d((Tuple3d)wp3.getPositionReference().getToolPosition());
                        double xfraction = (double)i / (double)(this.getFirstAxisCount() - 1);
                        double yfraction = (double)j / (double)(this.getSecondAxisCount() - 1);
                        v21.sub((Tuple3d)v11);
                        v21.scale(xfraction);
                        v21.add((Tuple3d)v11);
                        v22.sub((Tuple3d)v12);
                        v22.scale(xfraction);
                        v22.add((Tuple3d)v12);
                        v22.sub((Tuple3d)v21);
                        v22.scale(yfraction);
                        v22.add((Tuple3d)v21);
                        ret.add(v22);
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case BOX: {
                WaypointNode wp1 = (WaypointNode)this.children.elementAt(0);
                WaypointNode wp2 = (WaypointNode)this.children.elementAt(1);
                WaypointNode wp3 = (WaypointNode)this.children.elementAt(2);
                WaypointNode wp4 = (WaypointNode)this.children.elementAt(3);
                WaypointNode wp5 = (WaypointNode)this.children.elementAt(4);
                WaypointNode wp6 = (WaypointNode)this.children.elementAt(5);
                WaypointNode wp7 = (WaypointNode)this.children.elementAt(6);
                WaypointNode wp8 = (WaypointNode)this.children.elementAt(7);
                int k = 0;
                while (k < this.getThirdAxisCount()) {
                    int j = 0;
                    while (j < this.getSecondAxisCount()) {
                        int i = 0;
                        while (i < this.getFirstAxisCount()) {
                            Vector3d v111 = new Vector3d((Tuple3d)wp1.getPositionReference().getToolPosition());
                            Vector3d v211 = new Vector3d((Tuple3d)wp2.getPositionReference().getToolPosition());
                            Vector3d v121 = new Vector3d((Tuple3d)wp4.getPositionReference().getToolPosition());
                            Vector3d v221 = new Vector3d((Tuple3d)wp3.getPositionReference().getToolPosition());
                            Vector3d v112 = new Vector3d((Tuple3d)wp5.getPositionReference().getToolPosition());
                            Vector3d v212 = new Vector3d((Tuple3d)wp6.getPositionReference().getToolPosition());
                            Vector3d v122 = new Vector3d((Tuple3d)wp8.getPositionReference().getToolPosition());
                            Vector3d v222 = new Vector3d((Tuple3d)wp7.getPositionReference().getToolPosition());
                            double xfraction = (double)i / (double)(this.getFirstAxisCount() - 1);
                            double yfraction = (double)j / (double)(this.getSecondAxisCount() - 1);
                            double zfraction = (double)k / (double)(this.getThirdAxisCount() - 1);
                            v211.sub((Tuple3d)v111);
                            v211.scale(xfraction);
                            v211.add((Tuple3d)v111);
                            v221.sub((Tuple3d)v121);
                            v221.scale(xfraction);
                            v221.add((Tuple3d)v121);
                            v212.sub((Tuple3d)v112);
                            v212.scale(xfraction);
                            v212.add((Tuple3d)v112);
                            v222.sub((Tuple3d)v122);
                            v222.scale(xfraction);
                            v222.add((Tuple3d)v122);
                            v221.sub((Tuple3d)v211);
                            v221.scale(yfraction);
                            v221.add((Tuple3d)v211);
                            v222.sub((Tuple3d)v212);
                            v222.scale(yfraction);
                            v222.add((Tuple3d)v212);
                            v222.sub((Tuple3d)v221);
                            v222.scale(zfraction);
                            v222.add((Tuple3d)v221);
                            ret.add(v222);
                            ++i;
                        }
                        ++j;
                    }
                    ++k;
                }
                break;
            }
        }
        return ret;
    }

    @Override
    protected void getInternalProgramEntities(Collection<Object> collection) {
        collection.add(this.variable);
        collection.add(this.patternPoseVariable);
        super.getInternalProgramEntities(collection);
    }

    @Override
    protected boolean doSubstituteReference(Object original, Object substitute) {
        boolean result = false;
        if (this.variable == original && substitute instanceof ProgramVariable) {
            this.variable = (ProgramVariable)substitute;
            result = true;
        }
        if (this.patternPoseVariable == original && substitute instanceof ProgramVariable) {
            this.patternPoseVariable = (ProgramVariable)substitute;
            result = true;
        }
        return result |= super.doSubstituteReference(original, substitute);
    }

    public ProgramNodeType getNodeType() {
        ProgramNodeType programNodeType = super.getNodeType();
        boolean isChildrenAllowed = programNodeType.isChildrenAllowed();
        boolean isList = this.getDimensionality() == Type.LIST;
        return new ProgramNodeTypeImpl(isChildrenAllowed, isList);
    }

    static {
        PatternNode.ajc$preClinit();
    }

    static final /* synthetic */ void setCounterVariable_aroundBody0(PatternNode ajc$this, ProgramVariable variable, JoinPoint joinPoint) {
        ajc$this.variable = variable;
    }

    static final /* synthetic */ void setCounterVariable_aroundBody2(PatternNode patternNode, ProgramVariable programVariable, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{patternNode, programVariable, joinPoint};
        PatternNode$AjcClosure1 patternNode$AjcClosure1 = new PatternNode$AjcClosure1(objectArray);
        try {
            ProgramEntitiesChangeAspect.aspectOf().aroundAnnotatedMethod(patternNode$AjcClosure1.linkStackClosureAndJoinPoint(69648));
            patternNode$AjcClosure1.unlink();
        }
        catch (Throwable throwable) {
            patternNode$AjcClosure1.unlink();
            throw throwable;
        }
    }

    static final /* synthetic */ void setPatternPoseVariable_aroundBody4(PatternNode ajc$this, ProgramVariable patternPoseVariable, JoinPoint joinPoint) {
        ajc$this.patternPoseVariable = patternPoseVariable;
    }

    static final /* synthetic */ void setPatternPoseVariable_aroundBody6(PatternNode patternNode, ProgramVariable programVariable, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{patternNode, programVariable, joinPoint};
        PatternNode$AjcClosure5 patternNode$AjcClosure5 = new PatternNode$AjcClosure5(objectArray);
        try {
            ProgramEntitiesChangeAspect.aspectOf().aroundAnnotatedMethod(patternNode$AjcClosure5.linkStackClosureAndJoinPoint(69648));
            patternNode$AjcClosure5.unlink();
        }
        catch (Throwable throwable) {
            patternNode$AjcClosure5.unlink();
            throw throwable;
        }
    }

    static final /* synthetic */ void setPrefersPersistentCounterVariableValue_aroundBody8(PatternNode ajc$this, boolean prefersPersistentValue, JoinPoint joinPoint) {
        if (ajc$this.variable != null && ajc$this.variable.prefersPersistentValue() != prefersPersistentValue) {
            ajc$this.variable.setPrefersPersistentValue(prefersPersistentValue);
        }
    }

    static final /* synthetic */ void setFirstAxisCount_aroundBody10(PatternNode ajc$this, int firstAxisCount, JoinPoint joinPoint) {
        if (ajc$this.firstAxisCount != firstAxisCount) {
            ajc$this.firstAxisCount = firstAxisCount;
        }
    }

    static final /* synthetic */ void setSecondAxisCount_aroundBody12(PatternNode ajc$this, int secondAxisCount, JoinPoint joinPoint) {
        if (ajc$this.secondAxisCount != secondAxisCount) {
            ajc$this.secondAxisCount = secondAxisCount;
        }
    }

    static final /* synthetic */ void setThirdAxisCount_aroundBody14(PatternNode ajc$this, int thirdAxisCount, JoinPoint joinPoint) {
        if (ajc$this.thirdAxisCount != thirdAxisCount) {
            ajc$this.thirdAxisCount = thirdAxisCount;
        }
    }

    static final /* synthetic */ void setDimensionality_aroundBody16(PatternNode ajc$this, Type dimensionality, JoinPoint joinPoint) {
        if (ajc$this.dimensionality != dimensionality) {
            ajc$this.dimensionality = dimensionality;
            ajc$this.textHasChanged();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PatternNode.java", PatternNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCounterVariable", "gui.program.PatternNode", "com.ur.view.variables.core.ProgramVariable", "variable", "", "void"), 82);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPatternPoseVariable", "gui.program.PatternNode", "com.ur.view.variables.core.ProgramVariable", "patternPoseVariable", "", "void"), 105);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPrefersPersistentCounterVariableValue", "gui.program.PatternNode", "boolean", "prefersPersistentValue", "", "void"), 118);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFirstAxisCount", "gui.program.PatternNode", "int", "firstAxisCount", "", "void"), 129);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSecondAxisCount", "gui.program.PatternNode", "int", "secondAxisCount", "", "void"), 140);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setThirdAxisCount", "gui.program.PatternNode", "int", "thirdAxisCount", "", "void"), 151);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDimensionality", "gui.program.PatternNode", "gui.program.PatternNode$Type", "dimensionality", "", "void"), 162);
    }

    public static enum Type {
        UNDEFINED,
        LIST,
        LINE,
        SQUARE_OBSOLETE,
        BOX_OBSOLETE,
        SQUARE,
        BOX;

    }
}

