/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.lang.Defense;
import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.view.program.CommandPanelProvider;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import com.ur.view.variables.domain.VariableLookupService;
import gui.commandpanels.PopupCard;
import gui.program.PopupNode$AjcClosure1;
import gui.program.PopupNode$AjcClosure3;
import gui.program.PopupNode$AjcClosure5;
import gui.program.PopupNode$AjcClosure7;
import gui.program.PopupNode$AjcClosure9;
import gui.program.UpdateExecutionFlowComponent;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class PopupNode
extends AbstractProgramNode
implements CommandPanelProvider {
    public static final int MAX_MESSAGE_LENGTH = 255;
    private final VariableLookupService lookupService;
    private MessageDialogType messageDialogType = MessageDialogType.MESSAGE;
    private String message = "";
    private boolean haltProgram = false;
    private InputType inputType = InputType.TEXT;
    private Variable variable;
    private EnumMap<MessageDialogType, String> messagePopupToGenerator;
    private TextResource textResource;
    private CommandNamesResource commandNamesResource;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    @Inject
    public PopupNode(VariableLookupService lookupService, ViewContext viewContext) {
        this.lookupService = lookupService;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.commandNamesResource = (CommandNamesResource)viewContext.getTextResource(CommandNamesResource.class);
        this.messagePopupToGenerator = new EnumMap<MessageDialogType, String>(MessageDialogType.class){
            {
                this.put(MessageDialogType.ERROR, "popup(%s, \"" + PopupNode.this.textResource.Error() + "\", False, True, blocking=%s)");
                this.put(MessageDialogType.WARNING, "popup(%s, \"" + PopupNode.this.textResource.Warning() + "\", True, False, blocking=%s)");
                this.put(MessageDialogType.MESSAGE, "popup(%s, \"" + PopupNode.this.textResource.Message() + "\", False, False, blocking=%s)");
            }
        };
        this.setNodeTypeName(((CommandNamesResource)viewContext.getTextResource(CommandNamesResource.class)).Popup());
    }

    public Variable getVariable() {
        return this.variable;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public MessageDialogType getType() {
        return this.messageDialogType;
    }

    @ProgramNodeChange
    public void setVariable(Variable variable) {
        Variable variable2 = variable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)variable2);
        Object[] objectArray = new Object[]{this, variable2, joinPoint};
        PopupNode$AjcClosure1 popupNode$AjcClosure1 = new PopupNode$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(popupNode$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ProgramNodeChange
    public void setInputType(InputType inputType) {
        InputType inputType2 = inputType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)inputType2));
        Object[] objectArray = new Object[]{this, inputType2, joinPoint};
        PopupNode$AjcClosure3 popupNode$AjcClosure3 = new PopupNode$AjcClosure3(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(popupNode$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ProgramNodeChange
    public void setType(MessageDialogType messageDialogType) {
        MessageDialogType messageDialogType2 = messageDialogType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)messageDialogType2);
        Object[] objectArray = new Object[]{this, messageDialogType2, joinPoint};
        PopupNode$AjcClosure5 popupNode$AjcClosure5 = new PopupNode$AjcClosure5(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(popupNode$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public String getMessage() {
        return this.message;
    }

    @ProgramNodeChange
    public void setMessage(String message) {
        String string = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        PopupNode$AjcClosure7 popupNode$AjcClosure7 = new PopupNode$AjcClosure7(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(popupNode$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    public boolean isHaltProgram() {
        return this.haltProgram;
    }

    @ProgramNodeChange
    public void setHaltProgram(boolean haltProgram) {
        boolean bl = haltProgram;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        PopupNode$AjcClosure9 popupNode$AjcClosure9 = new PopupNode$AjcClosure9(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(popupNode$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    public boolean isVariableUndefined(Variable variable) {
        if (variable == null || variable.isUndefined()) {
            return true;
        }
        if (variable instanceof ProgramVariable) {
            Collection<NamedEntity> variablesByNameAndType = this.lookupService.getVariablesByNameAndType(variable.getName(), ProgramVariable.class);
            return variablesByNameAndType.isEmpty();
        }
        return false;
    }

    public boolean isUndefined() {
        if (this.inputType == InputType.VARIABLE && this.isVariableUndefined(this.variable)) {
            return true;
        }
        if (this.inputType == InputType.TEXT && this.getMessage().length() == 0) {
            return true;
        }
        return super.isUndefined();
    }

    public Class<PopupCard> getCardClass() {
        return PopupCard.class;
    }

    public String toString() {
        String popupCaption = StringUtils.isNullOrEmpty((String)this.getMessage()) ? "" : ": " + this.getMessage();
        return String.valueOf(this.commandNamesResource.Popup()) + popupCaption;
    }

    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        this.scriptBegin(writer);
        this.generateLabeledChildren(writer);
        boolean isBlocking = !this.haltProgram;
        String msg = this.createMessage();
        writer.popup(this.messagePopupToGenerator, this.messageDialogType, msg, isBlocking);
        if (this.haltProgram) {
            writer.halt();
        }
        this.scriptEnd(writer);
        return writer;
    }

    public LinkedHashSet<AbstractProgramNode> computeNextExecutionNodes() {
        if (this.isHaltProgram()) {
            return new LinkedHashSet<AbstractProgramNode>();
        }
        return super.computeNextExecutionNodes();
    }

    public Map<MessageDialogType, String> getMessagePopupMap() {
        return this.messagePopupToGenerator;
    }

    private String createMessage() {
        if (this.inputType == InputType.TEXT) {
            return "\"" + this.message + "\"";
        }
        if (this.variable != null) {
            return "str_cat(\"\"," + this.variable.getScriptName() + ")";
        }
        return "";
    }

    static {
        PopupNode.ajc$preClinit();
    }

    static final /* synthetic */ void setVariable_aroundBody0(PopupNode ajc$this, Variable variable, JoinPoint joinPoint) {
        if (ajc$this.variable != variable) {
            ajc$this.variable = variable;
            ajc$this.textHasChanged();
        }
    }

    static final /* synthetic */ void setInputType_aroundBody2(PopupNode ajc$this, InputType inputType, JoinPoint joinPoint) {
        if (ajc$this.inputType != inputType) {
            ajc$this.inputType = inputType;
            ajc$this.textHasChanged();
        }
    }

    static final /* synthetic */ void setType_aroundBody4(PopupNode ajc$this, MessageDialogType messageDialogType, JoinPoint joinPoint) {
        Defense.notNull((Object)messageDialogType, (String)"Cannot allow <null> value for Message Type in Popup Node");
        ajc$this.messageDialogType = messageDialogType;
    }

    static final /* synthetic */ void setMessage_aroundBody6(PopupNode ajc$this, String message, JoinPoint joinPoint) {
        if (message == null) {
            message = "";
        }
        if (message.length() > 255) {
            message = message.substring(0, 255);
        }
        if (!EqualsUtil.equals((Object)ajc$this.message, (Object)(message = message.replaceAll("\"", "'")))) {
            ajc$this.message = message;
            ajc$this.textHasChanged();
        }
    }

    static final /* synthetic */ void setHaltProgram_aroundBody8(PopupNode ajc$this, boolean haltProgram, JoinPoint joinPoint) {
        if (ajc$this.haltProgram != haltProgram) {
            ajc$this.haltProgram = haltProgram;
            UpdateExecutionFlowComponent.updateExecutionFlow(ajc$this);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PopupNode.java", PopupNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setVariable", "gui.program.PopupNode", "com.ur.view.variables.core.Variable", "variable", "", "void"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setInputType", "gui.program.PopupNode", "gui.program.PopupNode$InputType", "inputType", "", "void"), 80);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setType", "gui.program.PopupNode", "com.ur.swing.dialog.MessageDialogType", "messageDialogType", "", "void"), 88);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMessage", "gui.program.PopupNode", "java.lang.String", "message", "", "void"), 98);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setHaltProgram", "gui.program.PopupNode", "boolean", "haltProgram", "", "void"), 119);
    }

    public static enum InputType {
        TEXT,
        VARIABLE;

    }
}

