/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.i18n.TextResource;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.polyscope.installation.Installation;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.util.logging.Log;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.DashBoard;
import gui.program.FileManagementProgramComponent;
import gui.tools.DialogCreator;
import gui.tools.LegacyURDialogCreator;
import java.io.File;
import javax.inject.Inject;

public abstract class ProgramInstallationHandler {
    private static FileManagementProgramComponent.InstallationLoadedResult failedResult = FileManagementProgramComponent.InstallationLoadedResult.INSTALLATION_LOAD_FAILED;
    private RobotInstallationLookupService installationLookupService;
    private DialogCreator dialogCreator;
    private TextResource textResource;

    @Inject
    public ProgramInstallationHandler(RobotInstallationLookupService installationLookupService, DialogCreator dialogCreator, TextResource textResource) {
        this.installationLookupService = installationLookupService;
        this.dialogCreator = dialogCreator;
        this.textResource = textResource;
    }

    public static void alwaysUseCurrentInstallationInsteadOfFailedForTesting() {
        failedResult = FileManagementProgramComponent.InstallationLoadedResult.INSTALLATION_WAS_ALREADY_LOADED_AND_NOW_CHANGED_FOR_PROGRAM;
    }

    public FileManagementProgramComponent.InstallationLoadedResult loadRobotInstallationForProgram(String directory, String robotEnvironmentFileName) {
        Installation loadedInstallation = this.installationLookupService.load(new File(directory), robotEnvironmentFileName);
        if (loadedInstallation == null) {
            return this.handleMissingInstallationScenario(directory, robotEnvironmentFileName);
        }
        return this.loadProgramInstallation(loadedInstallation);
    }

    private FileManagementProgramComponent.InstallationLoadedResult handleMissingInstallationScenario(String directory, String robotEnvironmentFileName) {
        if (this.isInManualOperationalMode()) {
            DialogReturnValue useActiveInstallation = this.askToUseCurrentInstallation();
            if (useActiveInstallation.equals((Object)DialogReturnValue.OK)) {
                return FileManagementProgramComponent.InstallationLoadedResult.INSTALLATION_WAS_ALREADY_LOADED_AND_NOW_CHANGED_FOR_PROGRAM;
            }
            return failedResult;
        }
        return this.failLoadInAutomaticMode(directory, robotEnvironmentFileName);
    }

    public abstract boolean isInManualOperationalMode();

    private DialogReturnValue askToUseCurrentInstallation() {
        ConfirmationMessage installationNotFoundLoadProgramMessage = new ConfirmationMessage(DialogWithName.INSTALLATION_NOT_FOUND.getName(), this.textResource.installationNotFoundPopupHeader(), this.textResource.installationNotFoundManualModePopupDescription(), this.textResource.Yes(), this.textResource.No());
        return LegacyURDialogCreator.confirmMessageDialog(installationNotFoundLoadProgramMessage);
    }

    private FileManagementProgramComponent.InstallationLoadedResult failLoadInAutomaticMode(String directory, String robotEnvironmentFileName) {
        ErrorMessage installationNotFound = new ErrorMessage(DialogWithName.INSTALLATION_NOT_FOUND.getName(), this.textResource.installationNotFoundPopupHeader(), this.textResource.installationNotFoundAutomaticModePopupDescription(), "");
        this.dialogCreator.showErrorDialog(installationNotFound, new OkDialogListener());
        Log.error((String)("Installation not found: " + directory + File.separator + robotEnvironmentFileName + ".installation"));
        return failedResult;
    }

    private FileManagementProgramComponent.InstallationLoadedResult loadProgramInstallation(Installation loadedInstallation) {
        this.installationLookupService.setInstallation(loadedInstallation);
        if (!DashBoard.autoLoadingNoPopups && this.installationLookupService.getInstallationContributionsProvider().hasUndefinedInstallationContribution()) {
            LegacyURDialogCreator.showUndefinedInstallationContributionDialog(this.installationLookupService.getInstallationContributionsProvider().getUndefinedInstallationContributions());
        }
        return FileManagementProgramComponent.InstallationLoadedResult.INSTALLATION_LOADED;
    }
}

