/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.i18n.TextResource;
import com.ur.lang.EqualsUtil;
import com.ur.lang.NamingUtils;
import com.ur.lang.StringUtils;
import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.logging.naming.ReservedNamesProvider;
import com.ur.polyscope.program.ProgramComponent;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramModel;
import com.ur.polyscope.program.nodes.ProgramNodeTraversal;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.program.nodes.ProgramNodeTypeImpl;
import com.ur.polyscope.program.nodes.ProgramSelectionModel;
import com.ur.polyscope.program.nodes.ScriptGeneratorProvider;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.PreambleScript;
import com.ur.polyscope.scriptwriter.ScriptGenerator;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.visualizer.programvisualization.VisualizerProgramRootNode;
import com.ur.reference.Reference;
import com.ur.reversible.SubstitutionChange;
import com.ur.util.Predicate;
import com.ur.util.logging.Log;
import com.ur.view.program.CommandPanel;
import com.ur.view.program.CommandPanelProvider;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import com.ur.view.variables.domain.VariableLookupService;
import gui.commandpanels.ProgramCard;
import gui.polyscope.program.ProgramTreeModel;
import gui.program.CallSubProgramNode;
import gui.program.EventNode;
import gui.program.InitVariablesNode;
import gui.program.MainProgram;
import gui.program.ProgramRootNode$AjcClosure1;
import gui.program.ProgramRootNode$AjcClosure3;
import gui.program.ScriptNode;
import gui.program.SpecialSequenceNode;
import gui.program.SubProgramNode;
import gui.program.SuppressedNode;
import gui.program.ThreadNode;
import gui.program.TimerVariablePredicate;
import gui.program.preamble.ProgramNodePreambleScriptGenerator;
import gui.tools.LanguagePack;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ProgramRootNode
extends AbstractProgramNode
implements VisualizerProgramRootNode,
CommandPanelProvider,
com.ur.polyscope.program.ProgramRootNode,
ScriptGeneratorProvider {
    public static final String SUBSTITUTE_REFERENCE = "substituteReference";
    public static final int PROGRAM_VERSION = 2;
    public static final String PROGRAM_VERIFICATION_VARIABLE_NAME = "_hidden_verificationVariable";
    private static boolean isSubTreeCloning;
    private final Map<Class<? extends ProgramComponent>, ProgramComponent> components;
    private final VariableLookupService variableLookupService;
    private final Set<ProgramNodePreambleScriptGenerator> preambleGenerators;
    private final InitVariablesNode initVariablesNode;
    private final ReservedNamesProvider reservedNamesProvider;
    private MainProgram mainProgram;
    private final transient ProgramTreeModel programTreeModel;
    private String name;
    private transient boolean hasBeenSavedBefore;
    private final ScriptGeneratorLookup scriptGeneratorLookup = new ScriptGeneratorLookup();
    private AbstractProgramNode startingNode;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Inject
    public ProgramRootNode(Set<ProgramComponent> components, VariableLookupService variableLookupService, MainProgram mainProgram, ProgramTreeModel programTreeModel, Set<ProgramNodePreambleScriptGenerator> preambleScriptGeneratorMap, ReservedNamesProvider reservedNamesProvider, TextResource textResource, InitVariablesNode initVariablesNode) {
        super((ProgramNodeType)new ProgramNodeTypeImpl(true, true));
        this.variableLookupService = variableLookupService;
        this.mainProgram = mainProgram;
        this.programTreeModel = programTreeModel;
        this.preambleGenerators = preambleScriptGeneratorMap;
        this.reservedNamesProvider = reservedNamesProvider;
        this.name = textResource.placeholderUnnamed();
        this.initVariablesNode = initVariablesNode;
        this.programTreeModel.setRoot((TreeNode)((Object)this));
        this.components = new HashMap<Class<? extends ProgramComponent>, ProgramComponent>();
        for (ProgramComponent each : components) {
            this.components.put(each.getType(), each);
        }
        this.initRootNode();
    }

    public static ProgramRootNode get(AbstractProgramNode programNode) {
        if (programNode == null) {
            return null;
        }
        if (programNode.getProgramRoot() == null) {
            try {
                ProgramRootNode rootNode = (ProgramRootNode)((Object)programNode.getRoot());
                programNode.setProgramRoot((AbstractProgramNode)rootNode);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return (ProgramRootNode)programNode.getProgramRoot();
    }

    public static void setProgramRoot(ProgramRootNode root, AbstractProgramNode node) {
        node.setProgramRoot((AbstractProgramNode)root);
        if (node instanceof SuppressedNode) {
            ProgramRootNode.setProgramRoot(root, ((SuppressedNode)node).getSuppressedNode());
        } else {
            int i = 0;
            while (i < node.getChildCount()) {
                TreeNode child = node.getChildAt(i);
                if (child instanceof AbstractProgramNode) {
                    ProgramRootNode.setProgramRoot(root, (AbstractProgramNode)child);
                }
                ++i;
            }
        }
    }

    public static boolean isSubTreeCloning() {
        return isSubTreeCloning;
    }

    public static void setSubTreeCloning(boolean isCloning) {
        isSubTreeCloning = isCloning;
    }

    private static boolean isSuppressedNodeIn(Enumeration<TreeNode> en, AbstractProgramNode programNode, boolean isUnderSuppressedNode) {
        while (en.hasMoreElements()) {
            AbstractProgramNode node;
            TreeNode pn = en.nextElement();
            if (!(pn instanceof SuppressedNode ? programNode.equals(node = ((SuppressedNode)((Object)pn)).getSuppressedNode()) || ProgramRootNode.isSuppressedNodeIn(node.preorderEnumeration(), programNode, true) : isUnderSuppressedNode && programNode.equals(pn))) continue;
            return true;
        }
        return false;
    }

    @IgnoreProgramChanges
    protected void initRootNode() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ProgramRootNode$AjcClosure1 programRootNode$AjcClosure1 = new ProgramRootNode$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(programRootNode$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public <T extends ProgramComponent> T getComponent(Class<T> type) {
        if (EqualsUtil.equals(type, ProgramModel.class)) {
            return (T)this.getProgramTreeModel();
        }
        return (T)this.components.get(type);
    }

    public void setComponent(ProgramComponent component) {
        this.components.put(component.getType(), component);
    }

    public ScriptGeneratorLookup getScriptGeneratorLookup() {
        return this.scriptGeneratorLookup;
    }

    public ProgramModel getProgramTreeModel() {
        return this.programTreeModel;
    }

    public boolean hasInitVariables() {
        return this.getFirstChild() instanceof InitVariablesNode;
    }

    public boolean hasBeforeStart() {
        return SpecialSequenceNode.SpecialSequenceType.BEFORE_START.matches(this.getChildAt(this.hasInitVariables() ? 1 : 0));
    }

    public SpecialSequenceNode getBeforeStart() {
        AbstractProgramNode pn = (AbstractProgramNode)this.getChildAt(this.hasInitVariables() ? 1 : 0);
        if (pn instanceof SpecialSequenceNode) {
            return (SpecialSequenceNode)pn;
        }
        return null;
    }

    public AbstractProgramNode getStartingNode() {
        return this.startingNode == null ? this.mainProgram : this.startingNode;
    }

    public void setStartingNode(AbstractProgramNode startingNode) {
        this.startingNode = startingNode;
    }

    @SubstitutionChange(method="substituteReference")
    public void substituteReferenceWithProgramChange(Reference<?, ?> original, Reference<?, ?> substitute) {
        Reference<?, ?> reference = original;
        Reference<?, ?> reference2 = substitute;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, reference, reference2);
        Object[] objectArray = new Object[]{this, reference, reference2, joinPoint};
        ProgramRootNode$AjcClosure3 programRootNode$AjcClosure3 = new ProgramRootNode$AjcClosure3(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(programRootNode$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public MainProgram getMainProgram() {
        return this.mainProgram;
    }

    public void setMainProgram(MainProgram mainProgram) {
        this.mainProgram = mainProgram;
    }

    public List<SubProgramNode> getSubProgramList(boolean includeSuppressedPrograms) {
        ArrayList<SubProgramNode> result = new ArrayList<SubProgramNode>();
        if (this.children != null) {
            for (Object o : this.children) {
                SuppressedNode suppressedNode;
                if (o instanceof SubProgramNode) {
                    result.add((SubProgramNode)o);
                    continue;
                }
                if (!includeSuppressedPrograms || !(o instanceof SuppressedNode) || !((suppressedNode = (SuppressedNode)o).getSuppressedNode() instanceof SubProgramNode)) continue;
                result.add((SubProgramNode)suppressedNode.getSuppressedNode());
            }
        }
        return result;
    }

    public SubProgramNode getSubProgramOfNode(AbstractProgramNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof SubProgramNode) {
            return (SubProgramNode)node;
        }
        return this.getSubProgramOfNode((AbstractProgramNode)node.getParent());
    }

    public boolean hasBeenSaved() {
        return this.hasBeenSavedBefore;
    }

    public synchronized void setHasBeenSaved(boolean hasBeenSaved) {
        this.hasBeenSavedBefore = hasBeenSaved;
    }

    public LinkedHashSet<AbstractProgramNode> computeNodeToExecuteAfterCompletingThisChild(AbstractProgramNode child) {
        LinkedHashSet<AbstractProgramNode> ret = new LinkedHashSet<AbstractProgramNode>();
        if (child instanceof MainProgram) {
            MainProgram mainProg = (MainProgram)child;
            if (!mainProg.isRunOnlyOnce()) {
                ret.add(child);
            }
        } else if (child instanceof ThreadNode) {
            ThreadNode threadNode = (ThreadNode)child;
            if (!threadNode.getRunOnlyOnce()) {
                ret.add(child);
            }
        } else {
            if (child instanceof SubProgramNode) {
                for (AbstractProgramNode p : child.getPrevExecutionProgramNodes()) {
                    if (p instanceof CallSubProgramNode) {
                        CallSubProgramNode csn = (CallSubProgramNode)p;
                        ret.addAll(((AbstractProgramNode)csn.getParent()).computeNodeToExecuteAfterCompletingThisChild((AbstractProgramNode)csn));
                        continue;
                    }
                    Log.error((String)"getPrevExecutionProgramNodes in a SubProgramNode gave a node that was not a CallSubProgramNode!");
                }
                return ret;
            }
            if (child instanceof EventNode) {
                ret.add(child);
            }
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isUndefined() {
        if (this.children == null) {
            return false;
        }
        try {
            AbstractProgramNode child;
            boolean undefined;
            Object o;
            Iterator iterator = this.children.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((o = iterator.next()) instanceof AbstractProgramNode) || !(undefined = (child = (AbstractProgramNode)o).isUndefined()));
            return true;
        }
        catch (RuntimeException e) {
            Log.error((String)"", (Throwable)e);
            return true;
        }
    }

    public ProgramRootNode clone() {
        ProgramRootNode newNode = (ProgramRootNode)super.clone();
        newNode.setName(this.getName());
        newNode.hasBeenSavedBefore = false;
        return newNode;
    }

    public Class<? extends CommandPanel<MainProgram>> getCardClass() {
        return ProgramCard.class;
    }

    public String toString() {
        return LanguagePack.getCommandNamesResource().Program();
    }

    public Enumeration<?> nodeEnumeration() {
        return this.preorderEnumeration();
    }

    public AbstractProgramNode getNode(int nodeId) {
        if (nodeId != -1) {
            ProgramRootNode nodeInConsideration = this;
            boolean done = false;
            while (!done) {
                if (nodeInConsideration.getId() == nodeId) {
                    return nodeInConsideration;
                }
                if (!nodeInConsideration.isTreeExpandable()) {
                    return nodeInConsideration;
                }
                if (nodeInConsideration.getChildCount() > 0) {
                    AbstractProgramNode node;
                    Enumeration e = nodeInConsideration.children();
                    AbstractProgramNode nodeAfter = node = (AbstractProgramNode)e.nextElement();
                    boolean done2 = false;
                    while (!done2) {
                        done2 = true;
                        if (!e.hasMoreElements()) continue;
                        if (nodeAfter.getId() == -1) {
                            nodeAfter = (AbstractProgramNode)e.nextElement();
                            done2 = false;
                            continue;
                        }
                        if (nodeAfter.getId() > nodeId) continue;
                        node = nodeAfter;
                        nodeAfter = (AbstractProgramNode)e.nextElement();
                        done2 = false;
                    }
                    if (nodeAfter.getId() == -1) {
                        nodeInConsideration = node;
                        continue;
                    }
                    if (nodeAfter.getId() <= nodeId) {
                        nodeInConsideration = nodeAfter;
                        continue;
                    }
                    nodeInConsideration = node;
                    continue;
                }
                done = true;
            }
        }
        Log.warning((String)("Node with id = " + nodeId + " not found"));
        return null;
    }

    public ProgramNodeTraversal getCurrentNode() {
        ProgramSelectionModel selectionModel = this.getComponent(ProgramSelectionModel.class);
        if (selectionModel != null) {
            return selectionModel.getCurrentNode();
        }
        return null;
    }

    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        if (this.isUndefined() || this.unableToGeneratePreamble()) {
            return writer;
        }
        this.generateScriptCode(writer, null);
        return writer;
    }

    private boolean unableToGeneratePreamble() {
        for (ProgramComponent each : this.components.values()) {
            if (!(each instanceof PreambleScript) || ((PreambleScript)each).canGenerateScriptCode()) continue;
            return true;
        }
        return false;
    }

    public ScriptWriter generateScriptCodeWithCurrentInstallation(ScriptWriter writer) {
        if (this.isUndefined()) {
            return writer;
        }
        this.generateScriptCode(writer, null);
        return writer;
    }

    public void generateScriptCode(ScriptWriter writer, JointPositionVector startPos) {
        this.scriptGeneratorLookup.clear();
        this.scriptBegin(writer);
        writer.defineFunction(this.getScriptName());
        writer.setMinimumIndentation(1);
        if (startPos != null && !startPos.isUndefined()) {
            writer.set_pos(startPos);
        }
        this.generatePreambleScriptCode(writer);
        this.getMainProgram().generateScriptCode(writer);
        writer.setMinimumIndentation(0);
        writer.forceIndentation(1);
        writer.end();
        this.scriptEnd(writer);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getScriptName() {
        if (this.hasBeenSavedBefore) {
            String candidate = NamingUtils.makeFirstCharLetter((String)this.name);
            candidate = NamingUtils.makeLegalCharacters((String)candidate);
            candidate = this.removeNonAZ09Underscore(candidate);
            candidate = this.ensureNonEmpty(candidate);
            candidate = NamingUtils.makeReservedNamePrefixed((String)candidate, (String[])this.reservedNamesProvider.getAllKeywords());
            return candidate;
        }
        return "unnamed";
    }

    private String removeNonAZ09Underscore(String candidate) {
        return candidate.replaceAll("[^a-zA-Z0-9_]", "");
    }

    private String ensureNonEmpty(String candidate) {
        if (StringUtils.isNullOrOnlyWhitespace((String)candidate)) {
            candidate = "P";
        }
        return candidate;
    }

    public void generatePreambleScriptCode(ScriptWriter writer) {
        writer.globalVariable(PROGRAM_VERIFICATION_VARIABLE_NAME, "0");
        for (ProgramComponent each : this.components.values()) {
            if (!(each instanceof PreambleScript)) continue;
            ((PreambleScript)each).generatePreambleScript(writer, this.scriptGeneratorLookup);
        }
        Predicate nonTimerVariables = v -> v.getClass().equals(ProgramVariable.class) && !((ProgramVariable)v).getProperties().containsKey("TimerVariable");
        this.variableLookupService.generatePreambleScript(writer, (ScriptGenerator)this, (Predicate<Variable>)nonTimerVariables, false, this.hasInitVariables());
        this.variableLookupService.generatePreambleScript(writer, (ScriptGenerator)this, new TimerVariablePredicate(), true, true);
        LinkedHashSet<ProgramNodePreambleScriptGenerator> preamblesGenerated = new LinkedHashSet<ProgramNodePreambleScriptGenerator>();
        Enumeration enumeration = this.depthFirstEnumeration();
        block1: while (enumeration.hasMoreElements()) {
            AbstractProgramNode abstractProgramNode = (AbstractProgramNode)enumeration.nextElement();
            for (ProgramNodePreambleScriptGenerator programNodePreambleScriptGenerator : this.preambleGenerators) {
                if (!programNodePreambleScriptGenerator.canGenerate(abstractProgramNode)) continue;
                if (!preamblesGenerated.contains(programNodePreambleScriptGenerator)) {
                    preamblesGenerated.add(programNodePreambleScriptGenerator);
                    programNodePreambleScriptGenerator.setup(writer);
                }
                programNodePreambleScriptGenerator.generatePreambleScript(writer, abstractProgramNode);
                continue block1;
            }
        }
        for (ProgramNodePreambleScriptGenerator programNodePreambleScriptGenerator : preamblesGenerated) {
            programNodePreambleScriptGenerator.cleanup(writer);
        }
        SubProgramNode subProgramNode = this.getSubProgramOfNode(this.getStartingNode());
        if (subProgramNode != null) {
            subProgramNode.setJumpToLabel(this.getStartingNode().getId());
        }
        ArrayList<EventNode> arrayList = new ArrayList<EventNode>();
        ArrayList<ThreadNode> threadNodes = new ArrayList<ThreadNode>();
        Enumeration topLevelNodes = this.children();
        while (topLevelNodes.hasMoreElements()) {
            Object o = topLevelNodes.nextElement();
            if (!(o instanceof AbstractProgramNode)) continue;
            AbstractProgramNode p = (AbstractProgramNode)o;
            if (p instanceof SubProgramNode) {
                p.generateScriptCode(writer);
                ((SubProgramNode)p).setJumpToLabel(-1);
                continue;
            }
            if (p instanceof ThreadNode) {
                threadNodes.add((ThreadNode)p);
                continue;
            }
            if (p instanceof EventNode) {
                arrayList.add((EventNode)p);
                continue;
            }
            if (!(p instanceof ScriptNode)) continue;
            p.generateScriptCode(writer);
        }
        writer.writeNode((ControllerInterfaceProgramNode)this.getBeforeStart());
        for (ThreadNode t : threadNodes) {
            t.generateScriptCode(writer);
        }
        if (!arrayList.isEmpty()) {
            writer.defineThread("EventThread");
            writer.whileTrue();
            int remaining = arrayList.size();
            for (EventNode en : arrayList) {
                String expressionCondition = en.generateExpressionScriptCode();
                if (remaining == arrayList.size()) {
                    writer.ifCondition(expressionCondition);
                } else {
                    writer.elseIfCondition(expressionCondition);
                }
                en.generateScriptCode(writer);
                if (--remaining != 0) continue;
                writer.end();
            }
            writer.sync();
            writer.end();
            writer.end();
            writer.assign("eventThread", "run EventThread()");
        }
        if (subProgramNode != null) {
            writer.appendLine(String.valueOf(subProgramNode.getScriptName()) + "()");
            writer.halt();
        } else if (this.startingNode != null && this.startingNode != this.getMainProgram()) {
            writer.appendLine("jump_to_label(" + this.startingNode.getId() + ")");
        }
        this.startingNode = null;
    }

    public boolean equals(ProgramRootNode prn) {
        boolean equals = false;
        if (prn != null && this.getScriptName().equals(prn.getScriptName()) && !this.getScriptName().equals("unnamed")) {
            equals = true;
        }
        return equals;
    }

    public Set<ThreadNode> getThreads() {
        HashSet<ThreadNode> threads = new HashSet<ThreadNode>();
        Enumeration topLevelNodes = this.children();
        while (topLevelNodes.hasMoreElements()) {
            AbstractProgramNode p;
            try {
                p = (AbstractProgramNode)topLevelNodes.nextElement();
            }
            catch (Exception e) {
                Log.error((String)"A child of ProgramRootNode was non-ProgramNode: ", (Throwable)e);
                p = null;
            }
            if (p == null || !(p instanceof ThreadNode)) continue;
            threads.add((ThreadNode)p);
        }
        return threads;
    }

    public boolean isSuppressed(AbstractProgramNode programNode) {
        Enumeration en = this.preorderEnumeration();
        return ProgramRootNode.isSuppressedNodeIn(en, programNode, false);
    }

    static {
        ProgramRootNode.ajc$preClinit();
    }

    static final /* synthetic */ void initRootNode_aroundBody0(ProgramRootNode ajc$this, JoinPoint joinPoint) {
        ajc$this.programTreeModel.insertNodeInto((MutableTreeNode)((Object)ajc$this.initVariablesNode), (MutableTreeNode)((Object)ajc$this), 0);
        ajc$this.programTreeModel.makeVisible(ajc$this.initVariablesNode);
        ajc$this.programTreeModel.insertNodeInto((MutableTreeNode)((Object)ajc$this.mainProgram), (MutableTreeNode)((Object)ajc$this), 1);
        ProgramRootNode.setProgramRoot(ajc$this, ajc$this);
    }

    static final /* synthetic */ void substituteReferenceWithProgramChange_aroundBody2(ProgramRootNode ajc$this, Reference original, Reference substitute, JoinPoint joinPoint) {
        ajc$this.substituteReference(original, substitute);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProgramRootNode.java", ProgramRootNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "initRootNode", "gui.program.ProgramRootNode", "", "", "", "void"), 149);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "substituteReferenceWithProgramChange", "gui.program.ProgramRootNode", "com.ur.reference.Reference:com.ur.reference.Reference", "original:substitute", "", "void"), 206);
    }
}

