/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.i18n.TextResource;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamedEntityCollection;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.program.ProgramLoadingContext;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.polyscope.viewfacade.program.ProgramEventType;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.util.Waiting;
import com.ur.util.concurrent.ParallelTask;
import com.ur.util.concurrent.Task;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import com.ur.view.domain.installation.impl.ResolveNameOnInstallationOrProgramLoad;
import com.ur.view.polyscope.persistence.program.LogTime;
import com.ur.view.variables.core.ProgramVariable;
import gui.installation.services.LookupServiceFacade;
import gui.polyscope.DashBoard;
import gui.polyscope.SaveProgramService;
import gui.polyscope.program.ProgramPanel;
import gui.program.EntityFactory;
import gui.program.ErrorMessageException;
import gui.program.FileManagementProgramComponent;
import gui.program.InstallationNameStrategy;
import gui.program.PreProgramLoad;
import gui.program.ProgramInstallationHandler;
import gui.program.ProgramLoadingContextImpl;
import gui.program.ProgramRootNode;
import gui.program.ScriptNode;
import gui.program.SubProgramNode;
import gui.program.UpdateExecutionFlowComponent;
import gui.program.calibration.KinematicConversion;
import gui.program.persistence.ProgramPersistenceStrategy;
import gui.program.persistence.UpgradeWaypointsComponent;
import gui.program.position.PositionNode;
import gui.tools.DialogCreator;
import gui.tools.InputStrategy;
import gui.tools.LanguagePack;
import gui.tools.URFileUtils;
import gui.tools.dialogs.DialogInputStrategy;
import gui.tree.TreePanel;
import java.io.File;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

@Singleton
public class ProgramRootNodeLoad {
    public static InputStrategy inputStrategy;
    public static ProgramRootNode programLoaded;
    private static TaskMonitor taskMonitor;
    private static SaveProgramService saveProgramService;
    private static DialogCreator dialogCreator;
    private static EntityFactory entityFactory;
    private static ProgramInstallationHandler programInstallationHandler;
    private static RobotInstallationSite robotInstallationSite;
    private static ControllerInterface controllerInterface;
    private static ProgramLoadingContext programLoadingContext;
    private static TextResource textResource;

    static {
        taskMonitor = null;
        programLoadingContext = new ProgramLoadingContextImpl();
        textResource = LanguagePack.getTextResource();
    }

    @Inject
    public ProgramRootNodeLoad(TaskMonitor taskMonitor, SaveProgramService saveProgramService, DialogCreator dialogCreator, ProgramInstallationHandler programInstallationHandler, EntityFactory entityFactory, RobotInstallationSite robotInstallationSite, ControllerInterface controllerInterface) {
        ProgramRootNodeLoad.taskMonitor = taskMonitor;
        ProgramRootNodeLoad.saveProgramService = saveProgramService;
        ProgramRootNodeLoad.dialogCreator = dialogCreator;
        ProgramRootNodeLoad.programInstallationHandler = programInstallationHandler;
        ProgramRootNodeLoad.entityFactory = entityFactory;
        ProgramRootNodeLoad.robotInstallationSite = robotInstallationSite;
        ProgramRootNodeLoad.controllerInterface = controllerInterface;
    }

    @Inject
    public static void setEntityFactory(EntityFactory entityFactory) {
        ProgramRootNodeLoad.entityFactory = entityFactory;
    }

    @Inject
    public static void setRobotInstallationSite(RobotInstallationSite robotInstallationSite) {
        ProgramRootNodeLoad.robotInstallationSite = robotInstallationSite;
    }

    @Inject
    public static void setProgramInstallationHandler(ProgramInstallationHandler programInstallationHandler) {
        ProgramRootNodeLoad.programInstallationHandler = programInstallationHandler;
    }

    @Inject
    public static void setControllerInterface(ControllerInterface controllerInterface) {
        ProgramRootNodeLoad.controllerInterface = controllerInterface;
    }

    @Inject
    public static void setProgramLoadingContext(ProgramLoadingContext programLoadingContext) {
        ProgramRootNodeLoad.programLoadingContext = programLoadingContext;
    }

    private static TaskMonitor getTaskMonitor() {
        if (taskMonitor == null) {
            taskMonitor = LookupServiceFacade.get(TaskMonitor.class);
        }
        return taskMonitor;
    }

    private static InputStrategy getInputStrategy() {
        if (inputStrategy == null) {
            inputStrategy = new DialogInputStrategy();
        }
        return inputStrategy;
    }

    private static ProgramPersistenceStrategy getProgramPersistenceStrategy() {
        return LookupServiceFacade.get(ProgramPersistenceStrategy.class);
    }

    public static ProgramRootNode deserializeProgram(File file) throws IOException {
        if (file == null || !file.isFile() || !file.exists()) {
            Log.warning((String)("Method called without a valid program file argument. Argument = " + file));
            return null;
        }
        return URFileUtils.readPossiblyCompressedFile(file, ProgramRootNodeLoad.getProgramPersistenceStrategy());
    }

    private static InstallationNameStrategy.Data readInstallationFileData(File file) {
        if (file == null || !file.isFile() || !file.exists()) {
            Log.warning((String)("Method called without a valid program file argument. Argument = " + file));
            return null;
        }
        try {
            return URFileUtils.readPossiblyCompressedFile(file, new InstallationNameStrategy());
        }
        catch (IOException e) {
            Log.error((String)"Cannot read installation file data", (Throwable)e);
            return null;
        }
    }

    private static void reconstructProgramAfterLoad(ProgramRootNode program) {
        Enumeration e = program.preorderEnumeration();
        while (e.hasMoreElements()) {
            List<PositionNode> pList;
            PositionNode pNode;
            AbstractProgramNode node = (AbstractProgramNode)e.nextElement();
            if (!(node instanceof PositionNode) || (pNode = (PositionNode)node).getPositionReference() == null) continue;
            if (pNode.getPositionReference().getSubscribers() == null) {
                pList = new ArrayList();
                pList.add(pNode);
                pNode.getPositionReference().setSubscribers(pList);
                continue;
            }
            pList = pNode.getPositionReference().getSubscribers();
            pList.add(pNode);
        }
    }

    @Deprecated
    private static TextResource getTextResource() {
        return textResource;
    }

    public static ProgramRootNode loadSubProgram(File file) throws IOException {
        programLoadingContext.setLoading(true);
        try {
            ProgramRootNode programRootNode = ProgramRootNodeLoad.deserializeProgram(file);
            return programRootNode;
        }
        finally {
            programLoadingContext.setLoading(false);
        }
    }

    private static ProgramRootNode loadProgram(File file) {
        programLoaded = null;
        try {
            LogTime.startLog("   Notify of program load");
            EventNotificationService.notify(ProgramEventListener.class, (NotificationStrategy)ProgramEventType.notificationStrategy((ProgramEventType)ProgramEventType.CLEANUP_CONTRIBUTION_VIEWS), (boolean)false);
            LogTime.stopLog("   Notify of program load", 250L);
            LogTime.startLog("   Deserialize program");
            programLoaded = ProgramRootNodeLoad.deserializeProgram(file);
            LogTime.stopLog("   Deserialize program", 250L);
            if (programLoaded == null) {
                Log.error((String)"Static field programLoaded is null after calling actualLoad()");
                throw new Exception(textResource.programLoadedError());
            }
            LogTime.startLog("   Finalize");
            programLoaded.getComponent(FileManagementProgramComponent.class).setProgramFile(file);
            String directory = file.getParent();
            programLoaded.getComponent(FileManagementProgramComponent.class).setProgramDirectory(directory);
            String path = file.getPath();
            String name = path.substring(directory.length() + 1, path.length());
            if (name.lastIndexOf(".") != -1) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            if (!programLoaded.hasInitVariables()) {
                programLoaded.getProgramTreeModel().insertNodeInto((MutableTreeNode)((Object)entityFactory.createInitVariablesNode()), (MutableTreeNode)((Object)programLoaded), 0);
            }
            programLoaded.setName(name);
            LogTime.stopLog("   Finalize", 250L);
        }
        catch (InvalidClassException invalidClassException) {
            dialogCreator.showErrorDialog(LanguagePack.getErrorMessages().invalidProgram(file.getName()), new OkDialogListener());
        }
        catch (ClassNotFoundException classNotFoundException) {
            dialogCreator.showErrorDialog(LanguagePack.getErrorMessages().notAProgram(file.getName()), new OkDialogListener());
        }
        catch (ErrorMessageException e) {
            programLoaded = null;
            dialogCreator.showErrorDialog(e.getErrorMessage(), new OkDialogListener());
        }
        catch (Exception e) {
            ProgramRootNodeLoad.dealWithGeneralException(file, e);
        }
        if (programLoaded != null) {
            LogTime.startLog("   Try again");
            ProgramRootNodeLoad.tryToLoadProgram(file);
        }
        LogTime.stopLog("   Try again", 250L);
        return programLoaded;
    }

    private static void dealWithGeneralException(File file, Exception e) {
        if (e.getClass().getName().contains("ConversionException")) {
            String loadErrorMessage = textResource.invalidProgramFileVersion(file.getAbsolutePath());
            Log.error((String)loadErrorMessage, (Throwable)e);
            dialogCreator.showErrorDialog(LanguagePack.getErrorMessages().cannotLoadProgram(file.getName()), new OkDialogListener());
        } else {
            programLoaded = null;
            if (e.getMessage() != null && e.getMessage().equals("Not in GZIP format")) {
                Log.error((String)("Program is not in a valid format: " + file.getAbsolutePath()), (Throwable)e);
            } else {
                Log.error((String)"Program failed to load unexpectedly", (Throwable)e);
            }
            dialogCreator.showErrorDialog(LanguagePack.getErrorMessages().cannotLoadProgram(file.getName()), new OkDialogListener());
        }
    }

    private static void tryToLoadProgram(File file) {
        try {
            if (controllerInterface.isConnected()) {
                ProgramRootNodeLoad.loadProgramWhileConnected();
            } else {
                ProgramRootNodeLoad.showProgramFailedToLoadMessage(file);
                Log.error((String)("Program failed to load:\n\t" + file));
                programLoaded = null;
            }
        }
        catch (Exception e) {
            Log.error((String)"Error after program load", (Throwable)e);
        }
    }

    private static void loadProgramWhileConnected() {
        ProgramRootNodeLoad.reconstructProgramAfterLoad(programLoaded);
        UpdateExecutionFlowComponent.updateExecutionFlow(programLoaded);
        programLoaded.getProgramTreeModel().nodeStructureChanged((TreeNode)((Object)programLoaded));
        if (programLoaded.getComponent(FileManagementProgramComponent.class).getInstallationFileName() == null) {
            Log.error((String)"programLoaded.getRobotEnvironmentFileName() is null", (Throwable)new Exception());
        }
        if (((PersistanceMetaData)robotInstallationSite.getInstallation().getMetaData(PersistanceMetaData.class)).fileName() == null) {
            Log.error((String)"Configuration.environment.getFileName() is null", (Throwable)new Exception());
        }
        if (programLoaded.getComponent(FileManagementProgramComponent.class).getInstallationFileName() == null || programLoaded.getComponent(FileManagementProgramComponent.class).getInstallationFileName().length() == 0) {
            programLoaded.getComponent(FileManagementProgramComponent.class).setInstallationFileName("default");
        }
        programLoaded.setHasBeenSaved(true);
        KinematicConversion.attachKinematics(programLoaded);
    }

    private static void showProgramFailedToLoadMessage(File file) {
        ErrorMessage errorMessage = LanguagePack.getErrorMessages().cannotLoadProgramControllerNotConnected(file.getName());
        dialogCreator.showErrorDialog(errorMessage, new OkDialogListener());
    }

    private static void loadSubProgramFiles() {
        Enumeration e = programLoaded.preorderEnumeration();
        while (e.hasMoreElements()) {
            ScriptNode sc;
            AbstractProgramNode node = (AbstractProgramNode)e.nextElement();
            if (node instanceof SubProgramNode) {
                SubProgramNode spn = (SubProgramNode)node;
                if (spn.getFile() == null || !spn.isKeepSynchronizedWithDisk()) continue;
                spn.loadFile();
                continue;
            }
            if (!(node instanceof ScriptNode) || (sc = (ScriptNode)node).getType() != ScriptNode.Type.FILE_TYPE) continue;
            sc.readFile();
        }
    }

    public static ProgramRootNode load(File file) {
        return ProgramRootNodeLoad.load(file, true, true, LookupServiceFacade.get(ProgramModeHolder.class).getMode() == ProgramModeHolder.ProgramMode.Editable);
    }

    public static ProgramRootNode autoloadWithOutKinematicCheck(File file) {
        return ProgramRootNodeLoad.load(file, false, true, false);
    }

    public static ProgramRootNode loadWithOutKinematicCheck(File file) {
        return ProgramRootNodeLoad.load(file, false, true, true);
    }

    public static ProgramRootNode loadWithOutKinematicCheckOrInstallation(File file) {
        return ProgramRootNodeLoad.load(file, false, false, true);
    }

    private static ProgramRootNode load(File file, boolean withKinematic, boolean withDefaultInstallation, boolean withUserVariableNameClashResolution) {
        try {
            ProgramPanel.setTreeExpansionDone(false);
            programLoadingContext.setLoading(true);
            ProgramRootNodeLoad.getInputStrategy().runWithProgress(ProgramRootNodeLoad.getTaskMonitor(), (Task)new LoadTask(file, withKinematic, withDefaultInstallation, withUserVariableNameClashResolution, entityFactory));
        }
        finally {
            programLoadingContext.setLoading(false);
            ProgramPanel.setTreeExpansionDone(true);
            if (programLoaded != null) {
                programLoaded.textHasChanged();
            }
        }
        return programLoaded;
    }

    private static void resetProgramLoaded() {
        programLoaded = null;
    }

    private static final class CountDownLatchOKDialogListener
    extends OkDialogListener {
        private final CountDownLatch latch;

        public CountDownLatchOKDialogListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onOkClicked() {
            this.latch.countDown();
        }
    }

    private static class LoadTask
    extends ParallelTask {
        private final File file;
        private final boolean withKinematic;
        private final boolean withDefaultInstallation;
        private final boolean withUserVariableNameClashResolution;
        private final NamingService namingService;
        private final EntityFactory entityFactory;

        public LoadTask(File file, boolean withKinematic, boolean withDefaultInstallation, boolean withUserVariableNameClashResolution, EntityFactory entityFactory) {
            super(textResource.inProgress());
            this.file = file;
            this.withKinematic = withKinematic;
            this.withDefaultInstallation = withDefaultInstallation;
            this.withUserVariableNameClashResolution = withUserVariableNameClashResolution;
            this.namingService = LookupServiceFacade.get(NamingService.class);
            this.entityFactory = entityFactory;
        }

        private void anotherRun() {
            try {
                if (this.file == null) {
                    throw new RuntimeException("Program file is null");
                }
                ProgramRootNodeLoad.loadProgram(this.file);
            }
            catch (Exception e) {
                Log.error((String)("Failed to load program: " + this.file.getName()), (Throwable)e);
            }
        }

        private FileManagementProgramComponent.InstallationLoadedResult tryLoadInstallation() {
            InstallationNameStrategy.Data installationFileData = null;
            try {
                installationFileData = ProgramRootNodeLoad.readInstallationFileData(this.file);
            }
            catch (Exception e) {
                Log.error((String)"Program failed to load unexpectedly", (Throwable)e);
                dialogCreator.showErrorDialog(LanguagePack.getErrorMessages().cannotLoadProgram(this.file.getName()), new OkDialogListener());
                return null;
            }
            LogTime.startLog("Load installation");
            FileManagementProgramComponent.InstallationLoadedResult result = null;
            if (this.withDefaultInstallation && installationFileData != null) {
                ProgramRootNode node = this.entityFactory.createProgramRootNode();
                String installationRelativePath = installationFileData.getRelativePath();
                FileManagementProgramComponent fileManagement = node.getComponent(FileManagementProgramComponent.class);
                if (StringUtils.isNullOrEmpty((String)installationRelativePath) || !new File(this.file.getParentFile().getPath(), String.valueOf(installationRelativePath) + ".installation").exists()) {
                    result = fileManagement.loadRobotInstallationForProgram(this.file.getParentFile().getPath(), installationFileData.getName());
                } else {
                    File installationFile = new File(URFileUtils.unrelativizePathWithProgramsDir(String.valueOf(this.file.getParentFile().getPath()) + File.separator + installationRelativePath));
                    result = fileManagement.loadRobotInstallationForProgram(installationFile.getParent(), installationFile.getName());
                }
            }
            LogTime.stopLog("Load installation", 1000L);
            return result;
        }

        private void loadProgramProcess() {
            try {
                EventNotificationService.notify(PreProgramLoad.class, preProgramLoad -> preProgramLoad.onPreProgramLoad(this.file), (boolean)false);
                this.anotherRun();
            }
            catch (ErrorMessageException e) {
                Log.error((String)("Failed to load program during pre-load processing: " + this.file.getName()), (Throwable)e);
                this.showErrorDialogAndThrottle(e);
            }
        }

        private void showErrorDialogAndThrottle(ErrorMessageException e) {
            CountDownLatch latch = new CountDownLatch(1);
            dialogCreator.showErrorDialog(e.getErrorMessage(), new CountDownLatchOKDialogListener(latch));
            try {
                latch.await(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                Log.error((String)ex.getMessage(), (Throwable)ex);
                Thread.currentThread().interrupt();
            }
            ProgramRootNodeLoad.resetProgramLoaded();
        }

        public void run() {
            try {
                if (this.file == null) {
                    Log.error((String)"Loading Task Runner : Program file is null");
                    return;
                }
                ProgramRootNodeLoad.resetProgramLoaded();
                this.deregisterOldProgram();
                Installation installationBeforeLoad = robotInstallationSite.getInstallation();
                FileManagementProgramComponent.InstallationLoadedResult result = this.tryLoadInstallation();
                if (result != FileManagementProgramComponent.InstallationLoadedResult.INSTALLATION_LOAD_FAILED) {
                    this.loadProgramProcess();
                }
                if (programLoaded == null) {
                    this.reRegisterOldProgram();
                    PersistanceMetaData persistanceMetaData = (PersistanceMetaData)installationBeforeLoad.getMetaData(PersistanceMetaData.class);
                    programInstallationHandler.loadRobotInstallationForProgram(persistanceMetaData.directory(), persistanceMetaData.fileName());
                    return;
                }
                if (result == FileManagementProgramComponent.InstallationLoadedResult.INSTALLATION_LOAD_FAILED) {
                    return;
                }
                LogTime.startLog("Load sub-programs");
                ProgramRootNodeLoad.loadSubProgramFiles();
                LogTime.stopLog("Load sub-programs", 2000L);
                DashBoard.setProgram(programLoaded);
                LogTime.startLog("Convert program - kinematics");
                if (this.withKinematic) {
                    KinematicConversion.convertProgram(programLoaded);
                }
                LogTime.stopLog("Convert program - kinematics", 250L);
                LogTime.startLog("Post load program");
                ResolveNameOnInstallationOrProgramLoad.postLoadProgram(programLoaded, this.withUserVariableNameClashResolution);
                Waiting.until(TreePanel::isTreeExpansionDone, (int)1, (TimeUnit)TimeUnit.MINUTES);
                LogTime.stopLog("Post load program", 250L);
                if (result == FileManagementProgramComponent.InstallationLoadedResult.INSTALLATION_WAS_ALREADY_LOADED_AND_NOW_CHANGED_FOR_PROGRAM) {
                    if (saveProgramService != null) {
                        saveProgramService.programChanged();
                    }
                } else if (programLoaded.getComponent(UpgradeWaypointsComponent.class) != null && saveProgramService != null) {
                    saveProgramService.programChanged();
                }
                EventNotificationService.notify(ProgramEventListener.class, (NotificationStrategy)ProgramEventType.notificationStrategy((ProgramEventType)ProgramEventType.POST_POST_NEW_PROGRAM, (com.ur.polyscope.program.ProgramRootNode)programLoaded), (boolean)false);
            }
            catch (ErrorMessageException e) {
                dialogCreator.showErrorDialog(e.getErrorMessage(), new OkDialogListener());
            }
        }

        private void reRegisterOldProgram() {
            LogTime.startLog("ReRegister program and variables");
            this.reRegisterCurrentProgramEntitiesAndVariables();
            this.reRegisterCurrentProgramReferences();
            LogTime.stopLog("ReRegister program and variables", 250L);
        }

        private void deregisterOldProgram() {
            LogTime.startLog("deregister program");
            this.deregisterCurrentProgramEntitiesAndVariables();
            this.deregisterCurrentProgramReferences();
            LogTime.stopLog("deregister program", 250L);
        }

        private void deregisterCurrentProgramEntitiesAndVariables() {
            ProgramRootNode node = DashBoard.getProgram();
            if (node != null) {
                this.namingService.deregisterNamedEntities((NamedEntityCollection)node.getProgramEntitiesInSubtree((Collection)new NamedEntityCollection()));
            }
            Collection filteredCollection = this.namingService.getAllEntities().getFilteredCollection();
            for (NamedEntity namedEntity : filteredCollection) {
                if (!(namedEntity instanceof ProgramVariable)) continue;
                this.namingService.deregisterNamedEntity(namedEntity);
            }
        }

        private void deregisterCurrentProgramReferences() {
            EventNotificationService.notify(ProgramEventListener.class, (NotificationStrategy)ProgramEventType.notificationStrategy((ProgramEventType)ProgramEventType.PRE_NEW_PROGRAM));
        }

        private void reRegisterCurrentProgramEntitiesAndVariables() {
            LogTime.startLog("Re-register current program entities and variables");
            NamedEntityCollection collection = new NamedEntityCollection();
            if (DashBoard.getProgram() != null) {
                DashBoard.getProgram().getProgramEntitiesInSubtree((Collection)collection);
            }
            this.namingService.registerNamedEntities(collection);
            for (NamedEntity namedEntity : collection.getFilteredCollection()) {
                if (!(namedEntity instanceof ProgramVariable)) continue;
                this.namingService.registerNamedEntity(namedEntity);
            }
            LogTime.stopLog("Re-register current program entities and variables", 250L);
        }

        private void reRegisterCurrentProgramReferences() {
            EventNotificationService.notify(ProgramEventListener.class, (NotificationStrategy)ProgramEventType.notificationStrategy((ProgramEventType)ProgramEventType.LOAD_PROGRAM_FAILED));
        }
    }
}

