/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.i18n.TextResource;
import com.ur.injection.Builder;
import com.ur.lang.EqualsUtil;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.polyscope.concept.operations.location.ConceptLocationFactory;
import com.ur.polyscope.concept.operations.location.Types;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.MetaData;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.polyscope.viewfacade.program.ProgramEventType;
import com.ur.polyscope.viewfacade.safety.RobotInstallationPersistenceService;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.AggregateDialogCreator;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.util.concurrent.ParallelTask;
import com.ur.util.concurrent.Task;
import com.ur.util.event.EventManager;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import com.ur.view.Settings;
import gui.installation.RobotInstallationLookupService;
import gui.installation.services.LookupServiceFacade;
import gui.polyscope.DashBoard;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramMetaDataComponent;
import gui.program.ProgramRootNode;
import gui.program.SubProgramNode;
import gui.program.calibration.KinematicDataComponent;
import gui.program.calibration.KinematicPersistenceStrategy;
import gui.program.persistence.ProgramPersistenceStrategy;
import gui.tools.LanguagePack;
import gui.tools.URFileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;

public class ProgramRootNodeSave {
    private final EventManager eventManager;
    private final TaskMonitor taskMonitor;
    private final Builder builder;
    private final RobotInstallationLookupService installationLookupService;
    private final KinematicPersistenceStrategy kinematicPersistenceStrategy;
    private final Provider<KinematicsCalibration> calibrationProvider;
    private final ConceptLocationFactory conceptLocationFactory;
    private final RobotInstallationPersistenceService persistenceService;
    private final TextResource textResource;
    private final AggregateDialogCreator dialogCreator;

    @Inject
    public ProgramRootNodeSave(TaskMonitor taskMonitor, EventManager eventManager, Builder builder, RobotInstallationLookupService installationLookupService, KinematicPersistenceStrategy kinematicPersistenceStrategy, @Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe, ConceptLocationFactory conceptLocationFactory, RobotInstallationPersistenceService persistenceService, ViewContext viewContext) {
        this.eventManager = eventManager;
        this.taskMonitor = taskMonitor;
        this.builder = builder;
        this.installationLookupService = installationLookupService;
        this.kinematicPersistenceStrategy = kinematicPersistenceStrategy;
        this.calibrationProvider = calibrationRecipe.lastProvider();
        this.conceptLocationFactory = conceptLocationFactory;
        this.persistenceService = persistenceService;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.dialogCreator = viewContext.getDialogCreator();
    }

    public void save(ProgramRootNode programRootNode, boolean saveInstallation, boolean sendEvent) {
        this.save(programRootNode, saveInstallation, sendEvent, false);
    }

    public void save(final ProgramRootNode programRootNode, boolean saveInstallation, boolean sendEvent, boolean copyInstallation) {
        programRootNode.getComponent(ProgramMetaDataComponent.class).setRobotIdentification((RobotIdentification)this.builder.get(RobotIdentification.class));
        if (this.kinematicPersistenceStrategy.updateKinematicsInfo()) {
            programRootNode.getComponent(KinematicDataComponent.class).setKinematics((KinematicsCalibration)this.calibrationProvider.get());
        }
        if (copyInstallation) {
            this.copyInstallation(programRootNode);
        } else if (saveInstallation) {
            this.actualSaveInstallation();
        }
        ParallelTask saveTask = new ParallelTask(this.textResource.inProgress()){

            public void run() {
                if (!programRootNode.isUndefined()) {
                    ProgramRootNodeSave.this.saveScriptFile(programRootNode);
                }
                ProgramRootNodeSave.this.actualSave(programRootNode);
            }
        };
        this.taskMonitor.runAndWait((Task)saveTask);
        if (sendEvent) {
            this.eventManager.fireEvent(ProgramEventListener.class, ProgramEventType.notificationStrategy((ProgramEventType)ProgramEventType.POST_PROGRAM_SAVE));
        }
    }

    public boolean isSavingExternally(ProgramRootNode programRootNode, File urpFile) {
        ConceptLocation currentProgram = this.conceptLocationFactory.get(programRootNode.getName(), programRootNode.getComponent(FileManagementProgramComponent.class).getProgramDirectory(), Types.getProgram());
        ConceptLocation newProgram = this.conceptLocationFactory.get(urpFile.getName(), urpFile.getParentFile().getPath(), Types.getProgram());
        return newProgram.isExternalTo(currentProgram);
    }

    public void saveToFile(ProgramRootNode programRootNode, File destinationFile) {
        boolean shouldCopyInstallation = this.isSavingExternally(programRootNode, destinationFile);
        programRootNode.setName(programRootNode.getComponent(FileManagementProgramComponent.class).setDirectoryAndExtractName(destinationFile));
        this.save(programRootNode, true, true, shouldCopyInstallation);
    }

    private void copyInstallation(ProgramRootNode programRootNode) {
        FileManagementProgramComponent fileManagementProgramComponent = programRootNode.getComponent(FileManagementProgramComponent.class);
        String directory = fileManagementProgramComponent.getProgramDirectory();
        Installation installation = this.installationLookupService.getInstallation();
        PersistanceMetaData persistanceMetaData = new PersistanceMetaData(directory, ((PersistanceMetaData)installation.getMetaData(PersistanceMetaData.class)).fileName());
        fileManagementProgramComponent.setInstallationDirectory(directory);
        installation.setMetaData((MetaData)persistanceMetaData);
        this.persistenceService.save(installation);
    }

    private void actualSaveInstallation() {
        this.persistenceService.save(this.installationLookupService.getInstallation());
    }

    public boolean isInstallationBeingCopied(String directory) {
        return !EqualsUtil.equals((Object)directory, (Object)((PersistanceMetaData)this.installationLookupService.getInstallation().getMetaData(PersistanceMetaData.class)).directory());
    }

    public void saveOnlyTheProgram(ProgramRootNode programRootNode) {
        this.save(programRootNode, false, false);
    }

    public static void saveURPToStream(ProgramRootNode programRootNode, OutputStream os) throws IOException {
        URFileUtils.writeCompressedStream(os, programRootNode, ProgramRootNodeSave.getProgramPersistenceStrategy());
    }

    protected void saveScriptFile(ProgramRootNode programRootNode) {
        block5: {
            ScriptWriter writer = new ScriptWriter();
            PersistanceMetaData persistanceMetaData = (PersistanceMetaData)this.installationLookupService.getInstallation().getMetaData(PersistanceMetaData.class);
            FileManagementProgramComponent fileManagementProgramComponent = programRootNode.getComponent(FileManagementProgramComponent.class);
            fileManagementProgramComponent.setInstallationFileName(persistanceMetaData.fileName());
            fileManagementProgramComponent.setInstallationDirectory(persistanceMetaData.directory());
            programRootNode.generateScriptCodeWithCurrentInstallation(writer);
            FileOutputStream stream = null;
            OutputStreamWriter oututf8 = null;
            try {
                try {
                    File file = new File(String.valueOf(fileManagementProgramComponent.getProgramDirectory()) + File.separator + programRootNode.getName() + ".script");
                    stream = new FileOutputStream(file);
                    oututf8 = new OutputStreamWriter((OutputStream)stream, "UTF8");
                    oututf8.write(writer.generateScript());
                    Log.info((String)("Saving file \"" + file.getPath() + "\""));
                }
                catch (IOException ex) {
                    Log.error((String)"Cannot write file ", (Throwable)ex);
                    this.closeSilent(oututf8);
                    this.closeSilent(stream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeSilent(oututf8);
                this.closeSilent(stream);
                throw throwable;
            }
            this.closeSilent(oututf8);
            this.closeSilent(stream);
        }
    }

    private void closeSilent(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            Log.error((String)"Cannot close stream: ", (Throwable)e);
        }
    }

    private File getDefaultURPFile(ProgramRootNode programRootNode) {
        return new File(String.valueOf(programRootNode.getComponent(FileManagementProgramComponent.class).getProgramDirectory()) + File.separator + programRootNode.getName() + ".urp");
    }

    public boolean isInstallationModified() {
        return ((RobotInstallationSite)this.builder.get(RobotInstallationSite.class)).hasModifications();
    }

    public void save(ProgramRootNode programRootNode) {
        this.save(programRootNode, this.isInstallationModified(), true);
    }

    private File getDefaultTextFile(File urpFile) {
        String urpPath = urpFile.getPath();
        String txtPath = urpPath.replaceFirst(String.valueOf(Pattern.quote(".urp")) + "$", Matcher.quoteReplacement(".txt"));
        return new File(txtPath);
    }

    public boolean actualSave(ProgramRootNode programRootNode) {
        return this.actualSave(programRootNode, null);
    }

    public boolean actualSave(ProgramRootNode programRootNode, File urpFile) {
        try {
            if (urpFile == null) {
                urpFile = this.getDefaultURPFile(programRootNode);
            }
            programRootNode.getComponent(FileManagementProgramComponent.class).setProgramDirectory(urpFile.getParent());
            this.eventManager.fireEvent(ProgramEventListener.class, ProgramEventType.notificationStrategy((ProgramEventType)ProgramEventType.PRE_PROGRAM_SAVE));
            this.performBackup(programRootNode, urpFile);
            this.actualSaveOnlyProgram(programRootNode, urpFile);
            this.generateDOCFile(programRootNode, urpFile);
            programRootNode.setHasBeenSaved(true);
            if (DashBoard.getProgram().equals(programRootNode)) {
                this.eventManager.fireEvent(ProgramEventListener.class, ProgramEventType.notificationStrategy((ProgramEventType)ProgramEventType.POST_PROGRAM_SAVE));
            }
            return true;
        }
        catch (Exception e) {
            String path = String.valueOf(programRootNode.getComponent(FileManagementProgramComponent.class).getProgramDirectory()) + File.separator + programRootNode.getName() + ".urp";
            Log.error((String)("Could not save program file: \"" + path + "\""), (Throwable)e);
            this.dialogCreator.showErrorDialog(LanguagePack.getErrorMessages().unableToSaveProgram(path), null);
            return false;
        }
    }

    public void actualSaveOnlyProgram(ProgramRootNode programRootNode, File urpFile) throws IOException {
        URFileUtils.writePossiblyCompressedFile(urpFile, programRootNode, ProgramRootNodeSave.getProgramPersistenceStrategy());
    }

    private void generateDOCFile(ProgramRootNode programRootNode, File urpFile) throws IOException {
        programRootNode.getComponent(FileManagementProgramComponent.class).setProgramFile(urpFile);
        Log.info((String)("Saved .urp file: \"" + urpFile.getAbsolutePath() + "\""));
        StringBuilder docString = new StringBuilder();
        Enumeration e = programRootNode.preorderEnumeration();
        while (e.hasMoreElements()) {
            SubProgramNode spn;
            AbstractProgramNode node = (AbstractProgramNode)e.nextElement();
            docString.append(String.valueOf(AbstractProgramNode.indent((int)node.getLevel())) + " " + node.toString() + "\r\n");
            if (!(node instanceof SubProgramNode) || (spn = (SubProgramNode)node).getFile() == null || !spn.isKeepSynchronizedWithDisk()) continue;
            spn.saveFile();
        }
        OutputStreamWriter writer = null;
        FileOutputStream os = null;
        try {
            File txtFile = this.getDefaultTextFile(urpFile);
            os = new FileOutputStream(txtFile);
            writer = new OutputStreamWriter((OutputStream)os, "UTF8");
            writer.write(docString.toString());
        }
        catch (Throwable throwable) {
            this.closeSilent(writer);
            this.closeSilent(os);
            throw throwable;
        }
        this.closeSilent(writer);
        this.closeSilent(os);
    }

    private static ProgramPersistenceStrategy getProgramPersistenceStrategy() {
        return LookupServiceFacade.get(ProgramPersistenceStrategy.class);
    }

    private void performBackup(ProgramRootNode programRootNode, File urpFile) throws IOException {
        this.backupFileNameRecursive(programRootNode, urpFile, 0);
    }

    private boolean backupFileNameRecursive(ProgramRootNode programRootNode, File file, int recursiondepth) throws IOException {
        boolean success;
        if (file.exists() && !Settings.isSuppressBackup()) {
            if (recursiondepth >= 10) {
                success = Files.deleteIfExists(file.toPath());
            } else {
                File newName = new File(String.valueOf(programRootNode.getComponent(FileManagementProgramComponent.class).getProgramDirectory()) + File.separator + programRootNode.getName() + ".old" + recursiondepth);
                success = this.backupFileNameRecursive(programRootNode, newName, recursiondepth + 1);
                if (success) {
                    if (recursiondepth == 0) {
                        FileUtils.copy((File)file, (File)newName);
                        success = true;
                    } else {
                        success = file.renameTo(newName);
                    }
                }
            }
        } else {
            success = true;
        }
        return success;
    }
}

