/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.polyscope.program.ProgramComponent;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.util.logging.Log;
import gui.polyscope.program.ProgramPanel;
import gui.program.ProgramRootNode;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ProgramSelectionModel
implements ProgramComponent,
com.ur.polyscope.program.nodes.ProgramSelectionModel {
    private final Provider<ProgramPanel> programPanelProvider;

    @Inject
    public ProgramSelectionModel(Provider<ProgramPanel> programPanelProvider) {
        this.programPanelProvider = programPanelProvider;
    }

    public Class<? extends ProgramComponent> getType() {
        return com.ur.polyscope.program.nodes.ProgramSelectionModel.class;
    }

    public AbstractProgramNode getCurrentNode() {
        TreePath tp;
        JTree tree = ((ProgramPanel)this.programPanelProvider.get()).getProgramTree();
        if (tree != null && (tp = tree.getSelectionPath()) != null && tp.getLastPathComponent() != null) {
            return (AbstractProgramNode)tp.getLastPathComponent();
        }
        return null;
    }

    public void setSelected(AbstractProgramNode node) {
        if (node != null && this.getCurrentNode() != node) {
            TreePath tp = new TreePath(node.getPath());
            JTree tree = ((ProgramPanel)this.programPanelProvider.get()).getProgramTree();
            if (tree == null) {
                Log.error((String)"getTree() returned null", (Throwable)new Exception());
                return;
            }
            tree.setSelectionPath(tp);
            tree.scrollPathToVisible(tp);
        }
    }

    public void selectPreviousNode() {
        AbstractProgramNode previousNode = (AbstractProgramNode)this.getCurrentNode().getPreviousNode();
        if (previousNode instanceof ProgramRootNode) {
            previousNode = (AbstractProgramNode)previousNode.getPreviousNode();
        }
        if (previousNode == null) {
            previousNode = (AbstractProgramNode)ProgramRootNode.get(this.getCurrentNode()).getLastLeaf();
        }
        this.setSelected(previousNode);
    }

    public void selectNextNode() {
        AbstractProgramNode nextNode = (AbstractProgramNode)this.getCurrentNode().getNextNode();
        if (nextNode instanceof ProgramRootNode) {
            nextNode = (AbstractProgramNode)nextNode.getNextNode();
        }
        if (nextNode == null) {
            nextNode = ProgramRootNode.get(this.getCurrentNode()).getMainProgram();
        }
        this.setSelected(nextNode);
    }
}

