/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChangeAspect;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.swing.expression.Expression;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.util.logging.Log;
import com.ur.view.program.CommandPanel;
import com.ur.view.program.CommandPanelProvider;
import gui.commandpanels.ScriptCard;
import gui.program.ScriptNode$AjcClosure1;
import gui.program.ScriptNode$AjcClosure11;
import gui.program.ScriptNode$AjcClosure3;
import gui.program.ScriptNode$AjcClosure5;
import gui.program.ScriptNode$AjcClosure7;
import gui.program.ScriptNode$AjcClosure9;
import gui.tools.LanguagePack;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ScriptNode
extends AbstractProgramNode
implements Cloneable,
ExpressionNodeProperty,
CommandPanelProvider {
    private static final long serialVersionUID = 154L;
    private Type scriptType = Type.LINE_TYPE;
    private ExpressionBranchNode expressionBranchNode = null;
    private Expression expr = null;
    private String scriptCodeString = null;
    private File scriptFile = null;
    private StringBuffer loadedFileContents = null;
    private boolean loadedFileContentHasChanged = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    @Inject
    ScriptNode() {
        this.setNodeTypeName(LanguagePack.getCommandNamesResource().Script());
    }

    @CompoundProgramChange
    public void setAndReadFile(File file) {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)file2);
        Object[] objectArray = new Object[]{this, file2, joinPoint};
        ScriptNode$AjcClosure1 scriptNode$AjcClosure1 = new ScriptNode$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(scriptNode$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void readFile() {
        this.setLoadedFileContentHasChanged(false);
        if (this.scriptFile == null) {
            this.setLoadedFileContents("");
            this.setLoadedFileContentHasChanged(false);
            return;
        }
        StringBuffer fileData = new StringBuffer();
        try (BufferedReader input = new BufferedReader(new FileReader(this.scriptFile));){
            String line = null;
            while ((line = input.readLine()) != null) {
                fileData.append(line);
                fileData.append("\n");
            }
            this.setLoadedFileContents(fileData.toString());
            this.setLoadedFileContentHasChanged(false);
        }
        catch (IOException iOException) {
            this.setLoadedFileContentHasChanged(true);
        }
    }

    public Type getType() {
        return this.scriptType;
    }

    @ProgramNodeChange
    public void setType(Type scriptType) {
        Type type = scriptType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)type));
        Object[] objectArray = new Object[]{this, type, joinPoint};
        ScriptNode$AjcClosure3 scriptNode$AjcClosure3 = new ScriptNode$AjcClosure3(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(scriptNode$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public ExpressionBranchNode getExpression() {
        this.handleObsolete();
        return this.expressionBranchNode;
    }

    @ProgramEntitiesChange
    @ProgramNodeChange
    public void setExpression(ExpressionBranchNode expressionBranchNode) {
        ExpressionBranchNode expressionBranchNode2 = expressionBranchNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)expressionBranchNode2);
        Object[] objectArray = new Object[]{this, expressionBranchNode2, joinPoint};
        ScriptNode$AjcClosure7 scriptNode$AjcClosure7 = new ScriptNode$AjcClosure7(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(scriptNode$AjcClosure7.linkStackClosureAndJoinPoint(69648));
            scriptNode$AjcClosure7.unlink();
        }
        catch (Throwable throwable) {
            scriptNode$AjcClosure7.unlink();
            throw throwable;
        }
    }

    public File getFile() {
        return this.scriptFile;
    }

    @ProgramNodeChange
    public void setFile(File file) {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)file2);
        Object[] objectArray = new Object[]{this, file2, joinPoint};
        ScriptNode$AjcClosure9 scriptNode$AjcClosure9 = new ScriptNode$AjcClosure9(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(scriptNode$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    public String getLoadedFileContents() {
        if (this.loadedFileContents == null) {
            return "";
        }
        return this.loadedFileContents.toString();
    }

    @ProgramNodeChange
    public void setLoadedFileContents(String scriptContents) {
        String string = scriptContents;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        ScriptNode$AjcClosure11 scriptNode$AjcClosure11 = new ScriptNode$AjcClosure11(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(scriptNode$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    public boolean isLoadedFileContentChanged() {
        return this.loadedFileContentHasChanged;
    }

    public void setLoadedFileContentHasChanged(boolean hasChanged) {
        this.loadedFileContentHasChanged = hasChanged;
    }

    public boolean saveChangesToFile() {
        if (this.scriptFile == null) {
            return false;
        }
        try {
            this.doSaveChangesToFile();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void doSaveChangesToFile() throws IOException {
        try (BufferedWriter output = null;){
            try {
                output = new BufferedWriter(new FileWriter(this.scriptFile));
                output.write(this.getLoadedFileContents());
                this.setLoadedFileContentHasChanged(false);
            }
            catch (IOException ex) {
                this.setLoadedFileContentHasChanged(true);
                Log.error((String)("Failed to save the script file: " + this.scriptFile.getPath()));
                throw ex;
            }
        }
    }

    public ScriptNode clone() {
        this.handleObsolete();
        ScriptNode clone = (ScriptNode)super.clone();
        clone.expressionBranchNode = this.expressionBranchNode.clone();
        clone.scriptFile = this.scriptFile;
        clone.loadedFileContents = this.loadedFileContents == null ? null : new StringBuffer(this.loadedFileContents);
        return clone;
    }

    private void handleObsolete() {
        if (this.expressionBranchNode == null) {
            this.expressionBranchNode = this.expr != null ? this.expr.getExpression() : (this.scriptCodeString != null ? new ExpressionBranchNode(this.scriptCodeString) : new ExpressionBranchNode());
            this.expr = null;
            this.scriptCodeString = null;
        }
    }

    public boolean isUndefined() {
        if (this.scriptType == Type.LINE_TYPE) {
            this.handleObsolete();
            return this.expressionBranchNode.getLength() == 0;
        }
        if (this.loadedFileContents == null) {
            return true;
        }
        return this.loadedFileContents.length() < 3;
    }

    public String toString() {
        if (this.scriptType == Type.LINE_TYPE) {
            this.handleObsolete();
            StringBuffer s = new StringBuffer();
            this.expressionBranchNode.generateText(s);
            String str = s.toString();
            if (!"".equals(str)) {
                return str;
            }
        } else if (this.scriptType == Type.FILE_TYPE && this.scriptFile != null) {
            return String.valueOf(LanguagePack.getCommandNamesResource().Script()) + ": " + this.scriptFile.getName();
        }
        return LanguagePack.getCommandNamesResource().Script();
    }

    public Class<? extends CommandPanel<ScriptNode>> getCardClass() {
        return ScriptCard.class;
    }

    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        this.scriptBegin(writer);
        if (this.scriptType == Type.LINE_TYPE) {
            this.handleObsolete();
            writer.writeProgramLabel((ControllerInterfaceProgramNode)this);
            writer.appendLine(this.expressionBranchNode.generateScriptCode());
        } else if (this.scriptType == Type.FILE_TYPE) {
            try {
                BufferedReader input;
                if (this.loadedFileContentHasChanged) {
                    this.saveChangesToFile();
                }
                if (this.scriptFile == null) {
                    writer.appendLine("ScriptFile is null");
                }
                try {
                    input = new BufferedReader(new FileReader(this.scriptFile));
                }
                catch (IOException iOException) {
                    System.err.println("File does not exist, using cache..");
                    input = new BufferedReader(new StringReader(this.loadedFileContents.toString()));
                }
                try {
                    boolean labelWritten = false;
                    String line = null;
                    while ((line = input.readLine()) != null) {
                        if (!labelWritten) {
                            writer.writeProgramLabel((ControllerInterfaceProgramNode)this);
                            labelWritten = true;
                        }
                        writer.appendLine(line);
                    }
                }
                finally {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.scriptEnd(writer);
        return writer;
    }

    protected void getInternalProgramEntities(Collection<Object> collection) {
        this.handleObsolete();
        this.expressionBranchNode.getProgramEntities(collection);
    }

    protected boolean doSubstituteReference(Object original, Object substitute) {
        this.handleObsolete();
        return this.expressionBranchNode.substituteReference(original, substitute);
    }

    static {
        ScriptNode.ajc$preClinit();
    }

    static final /* synthetic */ void setAndReadFile_aroundBody0(ScriptNode ajc$this, File file, JoinPoint joinPoint) {
        ajc$this.setFile(file);
        ajc$this.readFile();
    }

    static final /* synthetic */ void setType_aroundBody2(ScriptNode ajc$this, Type scriptType, JoinPoint joinPoint) {
        ajc$this.scriptType = scriptType;
        ajc$this.textHasChanged();
    }

    static final /* synthetic */ void setExpression_aroundBody4(ScriptNode ajc$this, ExpressionBranchNode expressionBranchNode, JoinPoint joinPoint) {
        if (!EqualsUtil.equals((Object)ajc$this.expressionBranchNode, (Object)expressionBranchNode)) {
            ajc$this.expressionBranchNode = expressionBranchNode;
            ajc$this.textHasChanged();
        }
    }

    static final /* synthetic */ void setExpression_aroundBody6(ScriptNode scriptNode, ExpressionBranchNode expressionBranchNode, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{scriptNode, expressionBranchNode, joinPoint};
        ScriptNode$AjcClosure5 scriptNode$AjcClosure5 = new ScriptNode$AjcClosure5(objectArray);
        try {
            ProgramEntitiesChangeAspect.aspectOf().aroundAnnotatedMethod(scriptNode$AjcClosure5.linkStackClosureAndJoinPoint(69648));
            scriptNode$AjcClosure5.unlink();
        }
        catch (Throwable throwable) {
            scriptNode$AjcClosure5.unlink();
            throw throwable;
        }
    }

    static final /* synthetic */ void setFile_aroundBody8(ScriptNode ajc$this, File file, JoinPoint joinPoint) {
        ajc$this.scriptFile = file;
        ajc$this.textHasChanged();
    }

    static final /* synthetic */ void setLoadedFileContents_aroundBody10(ScriptNode ajc$this, String scriptContents, JoinPoint joinPoint) {
        if (ajc$this.loadedFileContents == null) {
            ajc$this.loadedFileContents = new StringBuffer();
        }
        ajc$this.loadedFileContents.replace(0, ajc$this.loadedFileContents.length(), scriptContents);
        ajc$this.textHasChanged();
        if (ajc$this.scriptFile == null && scriptContents.isEmpty()) {
            ajc$this.setLoadedFileContentHasChanged(false);
        } else {
            ajc$this.setLoadedFileContentHasChanged(true);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ScriptNode.java", ScriptNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAndReadFile", "gui.program.ScriptNode", "java.io.File", "file", "", "void"), 47);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setType", "gui.program.ScriptNode", "gui.program.ScriptNode$Type", "scriptType", "", "void"), 88);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setExpression", "gui.program.ScriptNode", "com.ur.swing.expression.ExpressionBranchNode", "expressionBranchNode", "", "void"), 102);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFile", "gui.program.ScriptNode", "java.io.File", "file", "", "void"), 114);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLoadedFileContents", "gui.program.ScriptNode", "java.lang.String", "scriptContents", "", "void"), 131);
    }

    public static enum Type {
        LINE_TYPE,
        FILE_TYPE;

    }
}

