/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.program.nodes.ProgramNodeTypeImpl;
import com.ur.view.program.CommandPanel;
import com.ur.view.program.CommandPanelProvider;
import gui.commandpanels.wizards.SpecialSequenceCard;
import gui.program.ProgramRootNode;
import gui.tools.LanguagePack;
import javax.inject.Inject;

public class SpecialSequenceNode
extends AbstractProgramNode
implements CommandPanelProvider {
    private SpecialSequenceType specialSequenceType;

    @Inject
    SpecialSequenceNode() {
        super((ProgramNodeType)new ProgramNodeTypeImpl(true, true));
        this.setNodeTypeName(LanguagePack.getCommandNamesResource().SpecialSequence());
    }

    public boolean isSuppressible() {
        return false;
    }

    public boolean isOfSort(AbstractProgramNode.ProgramNodeSort sort) {
        switch (sort) {
            case PRE_PROGRAM: {
                return this.getType() == SpecialSequenceType.BEFORE_START;
            }
            case TOP_LEVEL: {
                return this.getType() == SpecialSequenceType.BEFORE_START;
            }
        }
        return false;
    }

    public SpecialSequenceNode clone() {
        return (SpecialSequenceNode)super.clone();
    }

    public SpecialSequenceType getType() {
        return this.specialSequenceType;
    }

    public void setType(SpecialSequenceType specialSequenceType) {
        this.specialSequenceType = specialSequenceType;
    }

    public String toString() {
        switch (this.specialSequenceType) {
            case BEFORE_START: {
                return LanguagePack.getCommandNamesResource().BeforeStart();
            }
            case BEFORE_POINT: {
                return LanguagePack.getCommandNamesResource().BeforeStart();
            }
            case AFTER_END: {
                return LanguagePack.getCommandNamesResource().AfterEnd();
            }
        }
        throw new IllegalStateException("Unknown SpecialSequenceNode " + (Object)((Object)this.specialSequenceType));
    }

    public Class<? extends CommandPanel<SpecialSequenceNode>> getCardClass() {
        return SpecialSequenceCard.class;
    }

    public boolean isUndefined() {
        return super.isUndefined();
    }

    public boolean canStartFromSelection() {
        return super.canStartFromSelection() && !this.isTopLevelBeforeStartNode();
    }

    protected boolean canChildrenStartFromSelection() {
        return super.canChildrenStartFromSelection() && !this.isTopLevelBeforeStartNode();
    }

    public boolean canPauseOnNode() {
        return super.canPauseOnNode() && this.getType() != SpecialSequenceType.BEFORE_POINT;
    }

    protected boolean canChildrenPauseOnNode() {
        return super.canChildrenPauseOnNode() && this.getType() != SpecialSequenceType.BEFORE_POINT;
    }

    private boolean isTopLevelBeforeStartNode() {
        return this.getType() == SpecialSequenceType.BEFORE_START && this.getParent() instanceof ProgramRootNode;
    }

    public static enum SpecialSequenceType {
        BEFORE_START,
        BEFORE_POINT,
        AFTER_END;


        public boolean matches(Object object) {
            if (object instanceof SpecialSequenceNode) {
                SpecialSequenceNode sequenceNode = (SpecialSequenceNode)object;
                return sequenceNode.getType() == this;
            }
            return false;
        }
    }
}

