/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.EditProgramService;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChangeAspect;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.optimove.OptiMoveConfigurationProvider;
import com.ur.polyscope.robot.configuration.tool.ToolConfigurationSettings;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.swing.expression.Expression;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.view.program.CommandPanel;
import com.ur.view.variables.core.ProgramVariable;
import gui.commandpanels.wizards.NewSeekCard;
import gui.commandpanels.wizards.SeekCard;
import gui.program.AnchoredSequenceNode;
import gui.program.DirectionNode;
import gui.program.EntityFactory;
import gui.program.MotionDefiningNode;
import gui.program.SpecialSequenceNode;
import gui.program.StackNode$AjcClosure1;
import gui.program.StackNode$AjcClosure11;
import gui.program.StackNode$AjcClosure13;
import gui.program.StackNode$AjcClosure15;
import gui.program.StackNode$AjcClosure17;
import gui.program.StackNode$AjcClosure19;
import gui.program.StackNode$AjcClosure21;
import gui.program.StackNode$AjcClosure3;
import gui.program.StackNode$AjcClosure5;
import gui.program.StackNode$AjcClosure7;
import gui.program.StackNode$AjcClosure9;
import gui.program.WithBeforeAndAfter;
import gui.program.WizardNode;
import gui.program.position.WaypointNode;
import gui.program.services.ProgramReferenceService;
import gui.tools.LanguagePack;
import java.util.Collection;
import java.util.Vector;
import javax.inject.Inject;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.vecmath.Point3d;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class StackNode
extends MotionDefiningNode
implements WithBeforeAndAfter,
WizardNode,
ExpressionNodeProperty {
    private final EditProgramService editProgramService;
    private final EntityFactory entityFactory;
    private Expression expr = new Expression();
    private ProgramVariable foundPoseVariable = null;
    private Type stackType = Type.UNDEFINED;
    private AnchoredSequenceNode actionSequence = null;
    private SpecialSequenceNode beforeStartSequence = null;
    private SpecialSequenceNode afterEndSequence = null;
    private double itemThickness = 0.0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    @Inject
    public StackNode(EditProgramService editProgramService, ProgramReferenceService programReferenceService, EntityFactory entityFactory, JointConfigurationSettings settings, ToolConfigurationSettings toolConfigurationSettings, OptiMoveConfigurationProvider optiMoveConfigurationProvider) {
        super(programReferenceService, settings, toolConfigurationSettings, optiMoveConfigurationProvider, MotionDefiningNode.MotionType.LINEAR_MOVE);
        this.editProgramService = editProgramService;
        this.entityFactory = entityFactory;
    }

    public Type getType() {
        return this.stackType;
    }

    @ProgramNodeChange
    public void setType(Type stackType) {
        Type type = stackType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)((Object)type));
        Object[] objectArray = new Object[]{this, type, joinPoint};
        StackNode$AjcClosure1 stackNode$AjcClosure1 = new StackNode$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(stackNode$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public ProgramVariable getFoundPoseVariable() {
        return this.foundPoseVariable;
    }

    @ProgramNodeChange
    @ProgramEntitiesChange
    public void setFoundPoseVariable(ProgramVariable foundPoseVariable) {
        ProgramVariable programVariable = foundPoseVariable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)programVariable);
        Object[] objectArray = new Object[]{this, programVariable, joinPoint};
        StackNode$AjcClosure5 stackNode$AjcClosure5 = new StackNode$AjcClosure5(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(stackNode$AjcClosure5.linkStackClosureAndJoinPoint(69648));
            stackNode$AjcClosure5.unlink();
        }
        catch (Throwable throwable) {
            stackNode$AjcClosure5.unlink();
            throw throwable;
        }
    }

    public AnchoredSequenceNode getActionSequence() {
        return this.actionSequence;
    }

    @ProgramNodeChange
    public void setActionSequence(AnchoredSequenceNode actionSequence) {
        AnchoredSequenceNode anchoredSequenceNode = actionSequence;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)anchoredSequenceNode);
        Object[] objectArray = new Object[]{this, anchoredSequenceNode, joinPoint};
        StackNode$AjcClosure7 stackNode$AjcClosure7 = new StackNode$AjcClosure7(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(stackNode$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    public double getItemThickness() {
        return this.itemThickness;
    }

    @ProgramNodeChange
    public void setItemThickness(double itemThickness) {
        double d = itemThickness;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        Object[] objectArray = new Object[]{this, Conversions.doubleObject((double)d), joinPoint};
        StackNode$AjcClosure9 stackNode$AjcClosure9 = new StackNode$AjcClosure9(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(stackNode$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    public ExpressionBranchNode getExpression() {
        return this.expr.getExpression();
    }

    @ProgramEntitiesChange
    @ProgramNodeChange
    public void setExpression(ExpressionBranchNode expression) {
        ExpressionBranchNode expressionBranchNode = expression;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)expressionBranchNode);
        Object[] objectArray = new Object[]{this, expressionBranchNode, joinPoint};
        StackNode$AjcClosure13 stackNode$AjcClosure13 = new StackNode$AjcClosure13(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(stackNode$AjcClosure13.linkStackClosureAndJoinPoint(69648));
            stackNode$AjcClosure13.unlink();
        }
        catch (Throwable throwable) {
            stackNode$AjcClosure13.unlink();
            throw throwable;
        }
    }

    public String getExpressionText() {
        return this.expr.getText();
    }

    @Override
    public SpecialSequenceNode getBeforeStartSequence() {
        return this.beforeStartSequence;
    }

    @Override
    @ProgramNodeChange
    public void setBeforeStartSequence(SpecialSequenceNode beforeStartSequence) {
        SpecialSequenceNode specialSequenceNode = beforeStartSequence;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)specialSequenceNode);
        Object[] objectArray = new Object[]{this, specialSequenceNode, joinPoint};
        StackNode$AjcClosure15 stackNode$AjcClosure15 = new StackNode$AjcClosure15(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(stackNode$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    @Override
    public boolean getHasBeforeStartSequence() {
        return this.beforeStartSequence != null;
    }

    @Override
    @CompoundProgramChange
    public void setHasBeforeStartSequence(boolean shouldHaveBeforeStartSequence) {
        boolean bl = shouldHaveBeforeStartSequence;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        StackNode$AjcClosure17 stackNode$AjcClosure17 = new StackNode$AjcClosure17(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(stackNode$AjcClosure17.linkClosureAndJoinPoint(69648));
    }

    private void insertBeforeStartNode() {
        SpecialSequenceNode beforeStartSequence = this.entityFactory.createBeforePointNode();
        AbstractProgramNode lastNode = (AbstractProgramNode)this.getProgramTreeModel().getChild((Object)this, this.getChildCount() - 1);
        boolean isInserted = this.getHasAfterEndSequence() ? this.editProgramService.insertNodeBefore((AbstractProgramNode)beforeStartSequence, lastNode) : this.editProgramService.insertNodeAfter((AbstractProgramNode)beforeStartSequence, lastNode);
        if (isInserted) {
            this.setBeforeStartSequence(beforeStartSequence);
            this.editProgramService.setSelected((AbstractProgramNode)this);
        }
    }

    private void deleteBeforeStartNode() {
        if (this.editProgramService.deleteNode((AbstractProgramNode)this.beforeStartSequence) != null) {
            this.setBeforeStartSequence(null);
            this.editProgramService.setSelected((AbstractProgramNode)this);
        }
    }

    @Override
    public SpecialSequenceNode getAfterEndSequence() {
        return this.afterEndSequence;
    }

    @Override
    @ProgramNodeChange
    public void setAfterEndSequence(SpecialSequenceNode afterEndSequence) {
        SpecialSequenceNode specialSequenceNode = afterEndSequence;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)specialSequenceNode);
        Object[] objectArray = new Object[]{this, specialSequenceNode, joinPoint};
        StackNode$AjcClosure19 stackNode$AjcClosure19 = new StackNode$AjcClosure19(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(stackNode$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    @Override
    public boolean getHasAfterEndSequence() {
        return this.afterEndSequence != null;
    }

    @Override
    @CompoundProgramChange
    public void setHasAfterEndSequence(boolean shouldHaveAfterEndSequence) {
        boolean bl = shouldHaveAfterEndSequence;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        StackNode$AjcClosure21 stackNode$AjcClosure21 = new StackNode$AjcClosure21(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(stackNode$AjcClosure21.linkClosureAndJoinPoint(69648));
    }

    private void insertAfterEndNode() {
        AbstractProgramNode lastNode;
        SpecialSequenceNode afterEndSequence = this.entityFactory.createAfterEndNode();
        if (this.editProgramService.insertNodeAfter((AbstractProgramNode)afterEndSequence, lastNode = (AbstractProgramNode)this.getProgramTreeModel().getChild((Object)this, this.getChildCount() - 1))) {
            this.setAfterEndSequence(afterEndSequence);
            this.editProgramService.setSelected((AbstractProgramNode)this);
        }
    }

    private void deleteAfterEndNode() {
        if (this.editProgramService.deleteNode((AbstractProgramNode)this.afterEndSequence) != null) {
            this.setAfterEndSequence(null);
            this.editProgramService.setSelected((AbstractProgramNode)this);
        }
    }

    public DirectionNode getDirectionNode() {
        if (this.getChildCount() < 2) {
            return null;
        }
        if (this.getChildAt(1) instanceof DirectionNode) {
            return (DirectionNode)((Object)this.getChildAt(1));
        }
        return null;
    }

    public WaypointNode getStartPosition() {
        if (this.getChildCount() < 1) {
            return null;
        }
        if (this.getChildAt(0) instanceof WaypointNode) {
            return (WaypointNode)((Object)this.getChildAt(0));
        }
        return null;
    }

    @Override
    public StackNode clone() {
        DirectionNode directionNode;
        StackNode stackNode = (StackNode)super.clone();
        stackNode.foundPoseVariable = this.foundPoseVariable == null ? null : this.foundPoseVariable.clone();
        stackNode.expr = this.expr.clone();
        stackNode.children = new Vector();
        WaypointNode startPosition = this.getStartPosition();
        if (startPosition != null) {
            try {
                stackNode.add((MutableTreeNode)((Object)startPosition.clone()));
            }
            catch (Exception exception) {}
        }
        if ((directionNode = this.getDirectionNode()) != null) {
            stackNode.add((MutableTreeNode)((Object)directionNode.clone()));
        }
        if (this.actionSequence != null) {
            stackNode.actionSequence = this.actionSequence.clone();
            stackNode.add((MutableTreeNode)((Object)stackNode.actionSequence));
        }
        if (this.getHasBeforeStartSequence()) {
            stackNode.beforeStartSequence = this.beforeStartSequence.clone();
            stackNode.add((MutableTreeNode)((Object)stackNode.beforeStartSequence));
        }
        if (this.getHasAfterEndSequence()) {
            stackNode.afterEndSequence = this.afterEndSequence.clone();
            stackNode.add((MutableTreeNode)((Object)stackNode.afterEndSequence));
        }
        return stackNode;
    }

    public String appendPoseVarName(int aid) {
        if (this.foundPoseVariable == null) {
            return "ur_anchor_pose_" + aid;
        }
        return this.foundPoseVariable.getScriptName();
    }

    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        this.scriptBegin(writer);
        WaypointNode startPoint = this.getStartPosition();
        DirectionNode direction = this.getDirectionNode();
        Point3d directionVector = direction.getDirectionVector();
        double directionLength = direction.getDistanceBetweenPoints();
        directionVector.scale(1.0 / directionLength);
        int id = this.getId();
        writer.writeProgramLabel((ControllerInterfaceProgramNode)this);
        writer.ifCondition(String.valueOf(direction.getVariable().getScriptName()) + " == 0.0");
        writer.writeNode((ControllerInterfaceProgramNode)this.beforeStartSequence);
        writer.writeNode((ControllerInterfaceProgramNode)startPoint);
        writer.globalVariable("ur_start_point_" + id, "get_forward_kin()");
        writer.elseCondition();
        writer.appendLine("movel(p[ur_start_point_" + id + "[0]+" + direction.getVariable().getScriptName() + "*" + directionVector.x + ", " + "ur_start_point_" + id + "[1]+" + direction.getVariable().getScriptName() + "*" + directionVector.y + ", " + "ur_start_point_" + id + "[2]+" + direction.getVariable().getScriptName() + "*" + directionVector.z + ", " + "ur_start_point_" + id + "[3]," + "ur_start_point_" + id + "[4]," + "ur_start_point_" + id + "[5]]" + startPoint.generateMotionParametersCode() + ")");
        writer.end();
        writer.defineThread("ur_Thread_direction_" + id);
        if (this.stackType == Type.DESTACK) {
            writer.appendLine("speedl([" + directionVector.x * direction.getCartesianSpeed() + "," + directionVector.y * direction.getCartesianSpeed() + "," + directionVector.z * direction.getCartesianSpeed() + ",0.0,0.0,0.0]," + ((MotionDefiningNode)this.getNodeOfType(MotionDefiningNode.class)).getCartesianAcceleration() + ",100000.0)");
        } else if (this.stackType == Type.STACK) {
            writer.movel(startPoint.generatePoseScriptCode(), direction.getCartesianAcceleration(), direction.getCartesianSpeed());
            writer.assign(direction.getVariable().getScriptName(), "0.0");
            writer.sleep(0.1);
        }
        writer.assign("ur_stacking_motion_running_" + id, "False");
        writer.end();
        writer.assign("ur_thread_handler_" + id, "run ur_Thread_direction_" + id + "()");
        writer.assign("ur_stacking_motion_running_" + this.getId(), "True");
        writer.whileCondition("ur_stacking_motion_running_" + this.getId() + " == True");
        if (this.stackType == Type.DESTACK) {
            this.generateTestForEndConditionCode(direction, writer);
            writer.elseCondition();
            writer.ifCondition(this.expr.getScriptCodeText());
            writer.killThread("ur_thread_handler_" + this.getId());
            writer.assign("ur_stacking_motion_running_" + this.getId(), "False");
            writer.assign(direction.getVariable().getScriptName(), "pose_dist(get_forward_kin(),ur_start_point_" + id + ") +" + this.getItemThickness());
            writer.stopl(direction.getCartesianAcceleration());
            writer.assign(this.appendPoseVarName(this.actionSequence.getId()), "get_forward_kin()");
            writer.writeNode((ControllerInterfaceProgramNode)this.actionSequence);
            writer.end();
            writer.end();
        } else if (this.stackType == Type.STACK) {
            writer.ifCondition("(" + this.expr.getScriptCodeText() + ") or (" + direction.getVariable().getScriptName() + "==0.0)");
            writer.killThread("ur_thread_handler_" + this.getId());
            writer.assign("ur_stacking_motion_running_" + this.getId(), "False");
            writer.assign(direction.getVariable().getScriptName(), "pose_dist(get_forward_kin(),ur_start_point_" + id + ")+" + this.getItemThickness());
            writer.stopl(direction.getCartesianAcceleration());
            writer.assign(this.appendPoseVarName(this.actionSequence.getId()), "get_forward_kin()");
            this.actionSequence.generateScriptCode(writer);
            StringBuilder expr = new StringBuilder();
            if (direction.isStopAtDistance()) {
                expr.append("(" + direction.getVariable().getScriptName() + ">" + direction.getMaxDistance() + ")");
            }
            if (direction.isStopAtDistance() && direction.isStopAtExpression()) {
                expr.append(" and ");
            }
            if (direction.isStopAtExpression()) {
                expr.append("(" + direction.getExpressionScriptCode() + ")");
            }
            writer.ifCondition(expr.toString());
            writer.appendLine(String.valueOf(direction.getVariable().getScriptName()) + "=0.0\n");
            if (this.getHasAfterEndSequence()) {
                this.afterEndSequence.generateScriptCode(writer);
            }
            writer.end();
            writer.end();
        }
        writer.sync();
        writer.end();
        this.scriptEnd(writer);
        return writer;
    }

    private void generateTestForEndConditionCode(DirectionNode direction, ScriptWriter writer) {
        StringBuilder expr = new StringBuilder();
        if (direction.isStopAtDistance()) {
            expr.append("(pose_dist(get_forward_kin(),ur_start_point_" + this.getId() + ")>" + direction.getMaxDistance() + ")");
        }
        if (direction.isStopAtDistance() && direction.isStopAtExpression()) {
            expr.append(" and ");
        }
        if (direction.isStopAtExpression()) {
            expr.append("(" + direction.getExpressionScriptCode() + ")");
        }
        writer.ifCondition(expr.toString());
        writer.killThread("ur_thread_handler_" + this.getId());
        writer.assign("ur_stacking_motion_running_" + this.getId(), "False");
        writer.assign(direction.getVariable().getScriptName(), "0.0");
        writer.stopl(((MotionDefiningNode)this.getNodeOfType(MotionDefiningNode.class)).getCartesianAcceleration());
        writer.writeNode((ControllerInterfaceProgramNode)this.afterEndSequence);
    }

    public void insert(MutableTreeNode newChild, int childIndex) {
        if (newChild instanceof SpecialSequenceNode) {
            SpecialSequenceNode node = (SpecialSequenceNode)((Object)newChild);
            if (SpecialSequenceNode.SpecialSequenceType.BEFORE_POINT.matches(node)) {
                this.beforeStartSequence = (SpecialSequenceNode)((Object)newChild);
            } else if (SpecialSequenceNode.SpecialSequenceType.AFTER_END.matches(node)) {
                this.afterEndSequence = (SpecialSequenceNode)((Object)newChild);
            }
        } else if (newChild instanceof AnchoredSequenceNode) {
            this.actionSequence = (AnchoredSequenceNode)((Object)newChild);
        }
        super.insert(newChild, childIndex);
    }

    public boolean containsChild(MutableTreeNode newChild) {
        int i = 0;
        while (i < this.getChildCount()) {
            TreeNode childAt = this.getChildAt(i);
            if (this.isSameType(childAt, newChild)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isSameType(TreeNode childAt, MutableTreeNode newChild) {
        boolean isSameType = false;
        if (childAt.getClass().equals(newChild.getClass())) {
            if (newChild instanceof SpecialSequenceNode && childAt instanceof SpecialSequenceNode) {
                SpecialSequenceNode existingNode = (SpecialSequenceNode)((Object)childAt);
                SpecialSequenceNode newNode = (SpecialSequenceNode)((Object)newChild);
                isSameType = existingNode.getType().equals((Object)newNode.getType());
            } else {
                isSameType = true;
            }
        }
        return isSameType;
    }

    public void remove(int childIndex) {
        TreeNode nodeToRemove = this.getChildAt(childIndex);
        if (nodeToRemove == this.beforeStartSequence) {
            this.beforeStartSequence = null;
        } else if (nodeToRemove == this.afterEndSequence) {
            this.afterEndSequence = null;
        }
        super.remove(childIndex);
    }

    @Override
    public boolean isUndefined() {
        if (this.expr.isUndefined()) {
            return true;
        }
        return super.isUndefined();
    }

    public String toString() {
        if (this.stackType == Type.UNDEFINED) {
            return LanguagePack.getCommandNamesResource().Seek();
        }
        if (this.stackType == Type.STACK) {
            return LanguagePack.getCommandNamesResource().Stack();
        }
        return LanguagePack.getCommandNamesResource().Destack();
    }

    public Class<? extends CommandPanel<StackNode>> getCardClass() {
        if (this.stackType == Type.UNDEFINED) {
            return NewSeekCard.class;
        }
        if (this.stackType == Type.STACK) {
            return SeekCard.class;
        }
        return SeekCard.class;
    }

    @Override
    protected void getInternalProgramEntities(Collection<Object> collection) {
        if (this.expr != null) {
            this.expr.getExpression().getProgramEntities(collection);
        }
        if (this.foundPoseVariable != null) {
            collection.add(this.foundPoseVariable);
        }
        super.getInternalProgramEntities(collection);
    }

    @Override
    protected boolean doSubstituteReference(Object original, Object substitute) {
        boolean result = false;
        if (original == this.foundPoseVariable && substitute instanceof ProgramVariable) {
            this.foundPoseVariable = (ProgramVariable)substitute;
            result = true;
        }
        result |= this.expr == null ? false : this.expr.getExpression().substituteReference(original, substitute);
        return result |= super.doSubstituteReference(original, substitute);
    }

    protected boolean canChildrenStartFromSelection() {
        return false;
    }

    static {
        StackNode.ajc$preClinit();
    }

    static final /* synthetic */ void setType_aroundBody0(StackNode ajc$this, Type stackType, JoinPoint joinPoint) {
        if (ajc$this.stackType != stackType) {
            ajc$this.stackType = stackType;
        }
    }

    static final /* synthetic */ void setFoundPoseVariable_aroundBody2(StackNode ajc$this, ProgramVariable foundPoseVariable, JoinPoint joinPoint) {
        ajc$this.foundPoseVariable = foundPoseVariable;
    }

    static final /* synthetic */ void setFoundPoseVariable_aroundBody4(StackNode stackNode, ProgramVariable programVariable, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{stackNode, programVariable, joinPoint};
        StackNode$AjcClosure3 stackNode$AjcClosure3 = new StackNode$AjcClosure3(objectArray);
        try {
            ProgramEntitiesChangeAspect.aspectOf().aroundAnnotatedMethod(stackNode$AjcClosure3.linkStackClosureAndJoinPoint(69648));
            stackNode$AjcClosure3.unlink();
        }
        catch (Throwable throwable) {
            stackNode$AjcClosure3.unlink();
            throw throwable;
        }
    }

    static final /* synthetic */ void setActionSequence_aroundBody6(StackNode ajc$this, AnchoredSequenceNode actionSequence, JoinPoint joinPoint) {
        ajc$this.actionSequence = actionSequence;
    }

    static final /* synthetic */ void setItemThickness_aroundBody8(StackNode ajc$this, double itemThickness, JoinPoint joinPoint) {
        if (ajc$this.itemThickness != itemThickness) {
            ajc$this.itemThickness = itemThickness;
        }
    }

    static final /* synthetic */ void setExpression_aroundBody10(StackNode ajc$this, ExpressionBranchNode expression, JoinPoint joinPoint) {
        if (!EqualsUtil.equals((Object)ajc$this.getExpression(), (Object)expression)) {
            ajc$this.expr.setExpression(expression);
            ajc$this.textHasChanged();
        }
    }

    static final /* synthetic */ void setExpression_aroundBody12(StackNode stackNode, ExpressionBranchNode expressionBranchNode, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{stackNode, expressionBranchNode, joinPoint};
        StackNode$AjcClosure11 stackNode$AjcClosure11 = new StackNode$AjcClosure11(objectArray);
        try {
            ProgramEntitiesChangeAspect.aspectOf().aroundAnnotatedMethod(stackNode$AjcClosure11.linkStackClosureAndJoinPoint(69648));
            stackNode$AjcClosure11.unlink();
        }
        catch (Throwable throwable) {
            stackNode$AjcClosure11.unlink();
            throw throwable;
        }
    }

    static final /* synthetic */ void setBeforeStartSequence_aroundBody14(StackNode ajc$this, SpecialSequenceNode beforeStartSequence, JoinPoint joinPoint) {
        ajc$this.beforeStartSequence = beforeStartSequence;
    }

    static final /* synthetic */ void setHasBeforeStartSequence_aroundBody16(StackNode ajc$this, boolean shouldHaveBeforeStartSequence, JoinPoint joinPoint) {
        if (!ajc$this.getHasBeforeStartSequence() && shouldHaveBeforeStartSequence) {
            ajc$this.insertBeforeStartNode();
        } else if (ajc$this.getHasBeforeStartSequence() && !shouldHaveBeforeStartSequence) {
            ajc$this.deleteBeforeStartNode();
        }
    }

    static final /* synthetic */ void setAfterEndSequence_aroundBody18(StackNode ajc$this, SpecialSequenceNode afterEndSequence, JoinPoint joinPoint) {
        ajc$this.afterEndSequence = afterEndSequence;
    }

    static final /* synthetic */ void setHasAfterEndSequence_aroundBody20(StackNode ajc$this, boolean shouldHaveAfterEndSequence, JoinPoint joinPoint) {
        if (!ajc$this.getHasAfterEndSequence() && shouldHaveAfterEndSequence) {
            ajc$this.insertAfterEndNode();
        } else if (ajc$this.getHasAfterEndSequence() && !shouldHaveAfterEndSequence) {
            ajc$this.deleteAfterEndNode();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("StackNode.java", StackNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setType", "gui.program.StackNode", "gui.program.StackNode$Type", "stackType", "", "void"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFoundPoseVariable", "gui.program.StackNode", "com.ur.view.variables.core.ProgramVariable", "foundPoseVariable", "", "void"), 69);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setActionSequence", "gui.program.StackNode", "gui.program.AnchoredSequenceNode", "actionSequence", "", "void"), 78);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setItemThickness", "gui.program.StackNode", "double", "itemThickness", "", "void"), 87);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setExpression", "gui.program.StackNode", "com.ur.swing.expression.ExpressionBranchNode", "expression", "", "void"), 101);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBeforeStartSequence", "gui.program.StackNode", "gui.program.SpecialSequenceNode", "beforeStartSequence", "", "void"), 119);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setHasBeforeStartSequence", "gui.program.StackNode", "boolean", "shouldHaveBeforeStartSequence", "", "void"), 132);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAfterEndSequence", "gui.program.StackNode", "gui.program.SpecialSequenceNode", "afterEndSequence", "", "void"), 169);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setHasAfterEndSequence", "gui.program.StackNode", "boolean", "shouldHaveAfterEndSequence", "", "void"), 182);
    }

    public static enum Type {
        UNDEFINED,
        STACK,
        DESTACK;

    }
}

