/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamedEntityCollection;
import com.ur.lang.naming.NamingService;
import com.ur.move.Position;
import com.ur.move.PositionReference;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.util.logging.Log;
import gui.program.ProgramRootNode;
import gui.program.SubProgramNode;
import gui.program.position.WaypointNode;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class SubProgramAdjustmentSupport {
    private final NamingService namingService;
    private final TextResource textResource;

    @Inject
    public SubProgramAdjustmentSupport(NamingService namingService, TextResource textResource) {
        this.namingService = namingService;
        this.textResource = textResource;
    }

    public ErrorMessage subProgramContainsSubProgram(String subProgramName) {
        return new ErrorMessage(this.textResource.cannotLoadSubProgram(), this.textResource.subprogramContainsASubProgramCall(subProgramName), this.textResource.subprogramContainsASubProgramCallSuggestion(subProgramName));
    }

    public boolean hasContainedSubPrograms(ProgramRootNode subProgramRootNode, SubProgramNode.ConfirmationResolver resolver) {
        int i = 0;
        while (i < subProgramRootNode.getChildCount()) {
            if (subProgramRootNode.getChildAt(i) instanceof SubProgramNode) {
                resolver.showError(this.subProgramContainsSubProgram(subProgramRootNode.getName()));
                return true;
            }
            ++i;
        }
        return false;
    }

    public void fixWaypointNamesAlreadyInUse(SubProgramNode currentNode, ProgramRootNode subProgramRootNode, Map<String, Position> prNamesMap) {
        Enumeration en = subProgramRootNode.preorderEnumeration();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (!(o instanceof PositionReference)) continue;
            PositionReference pr = (PositionReference)o;
            Position mappedNode = prNamesMap.get(pr.getName());
            if (SubProgramAdjustmentSupport.isSamePosition(pr, mappedNode) || this.namingService.isNameUsed(WaypointNode.class, pr.getName())) {
                this.changeNameOfMatchingNode(currentNode, subProgramRootNode, pr);
            }
            prNamesMap.put(pr.getName(), pr.getPositionReference());
        }
    }

    private void changeNameOfMatchingNode(SubProgramNode currentNode, ProgramRootNode subProgramRootNode, PositionReference pr) {
        NamedEntityCollection usedNames = new NamedEntityCollection();
        ProgramRootNode rootNode = ProgramRootNode.get(currentNode);
        if (rootNode != null) {
            rootNode.getProgramEntitiesInSubtree((Collection)usedNames);
        }
        subProgramRootNode.getProgramEntitiesInSubtree((Collection)usedNames);
        String newName = this.namingService.makeUniqueName(pr.getClass(), pr.getName(), usedNames);
        pr.setName(newName);
    }

    private static boolean isSamePosition(PositionReference pr, Position mappedNode) {
        block4: {
            if (mappedNode == null) {
                return false;
            }
            try {
                boolean positionsEqual = mappedNode.getJointPositionVector().epsilonEquals(pr.getJointPositionVector(), 0.001);
                if (positionsEqual) {
                    pr.setPositionReference(mappedNode);
                    break block4;
                }
                return true;
            }
            catch (Exception e) {
                Log.error((String)"Exception caught: ", (Throwable)e);
            }
        }
        return false;
    }

    public Map<String, Position> buildSetOfWaypointNames(SubProgramNode currentNode) {
        HashMap<String, Position> prNamesMap = new HashMap<String, Position>();
        Enumeration en = ProgramRootNode.get(currentNode).preorderEnumeration();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (!(o instanceof PositionReference)) continue;
            PositionReference prNode = (PositionReference)o;
            prNamesMap.put(prNode.getName(), prNode.getPositionReference());
        }
        return prNamesMap;
    }
}

