/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.lang.naming.IgnoreNameChanges;
import com.ur.lang.naming.NameChange;
import com.ur.lang.naming.NameChangeAspect;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamedEntityCollection;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.geomfeature.ProgramFeature;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramModel;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.program.nodes.ProgramNodeTypeImpl;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.scriptconverter.ScriptConverter;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.reference.Reference;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.WarningMessage;
import com.ur.util.IterableEnumerationWrapper;
import com.ur.util.logging.Log;
import com.ur.view.domain.program.services.impl.UpdateInternalVariables;
import com.ur.view.program.CommandPanel;
import com.ur.view.program.CommandPanelProvider;
import com.ur.view.program.subprogramnode.SubProgramCard;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import gui.installation.naming.VariableNameClashResolver;
import gui.polyscope.DashBoard;
import gui.program.EntityFactory;
import gui.program.FileManagementProgramComponent;
import gui.program.HideableNode;
import gui.program.PlaceholderNode;
import gui.program.ProgramRootNode;
import gui.program.ProgramRootNodeLoad;
import gui.program.ProgramRootNodeSave;
import gui.program.SubProgramAdjustmentSupport;
import gui.program.SubProgramNode$AjcClosure1;
import gui.program.SubProgramNode$AjcClosure11;
import gui.program.SubProgramNode$AjcClosure13;
import gui.program.SubProgramNode$AjcClosure15;
import gui.program.SubProgramNode$AjcClosure17;
import gui.program.SubProgramNode$AjcClosure19;
import gui.program.SubProgramNode$AjcClosure3;
import gui.program.SubProgramNode$AjcClosure5;
import gui.program.SubProgramNode$AjcClosure7;
import gui.program.SubProgramNode$AjcClosure9;
import gui.program.UpdateExecutionFlowComponent;
import gui.program.services.GeomFeatureVariable;
import gui.tools.LegacyURDialogCreator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.swing.tree.MutableTreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class SubProgramNode
extends AbstractProgramNode
implements Cloneable,
CommandPanelProvider,
UpdateInternalVariables,
NamedEntity,
HideableNode {
    private static final long serialVersionUID = 4131L;
    private final EntityFactory entityFactory;
    private final transient NamingService namingService;
    private final SubProgramAdjustmentSupport adjustmentSupport;
    private VariableNameClashResolver variableNameClashResolver;
    private TextResource textResource;
    private CommandNamesResource commandNamesResource;
    private int jumpToLabel = -1;
    private transient ProgramRootNode subProgramRootNode = null;
    private String name;
    private File file;
    private boolean keepHidden = false;
    private boolean keepSynchronized = false;
    private ProgramRootNodeSave programRootNodeSave;
    private ConfirmationResolver resolver = new ConfirmationResolver(){

        @Override
        public void showError(ErrorMessage message) {
            LegacyURDialogCreator.showErrorDialog(message);
        }

        @Override
        public void showWarning(WarningMessage message) {
            LegacyURDialogCreator.showWarningDialog(message);
        }

        @Override
        public DialogReturnValue resolveConflict(ConfirmationMessage message) {
            return LegacyURDialogCreator.confirmMessageDialog(message);
        }
    };
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    @Inject
    public SubProgramNode(NamingService namingService, SubProgramAdjustmentSupport adjustmentSupport, EntityFactory entityFactory, VariableNameClashResolver variableNameClashResolver, ProgramRootNodeSave programRootNodeSave, ViewContext viewContext) {
        super((ProgramNodeType)new ProgramNodeTypeImpl(true, true));
        this.adjustmentSupport = adjustmentSupport;
        this.variableNameClashResolver = variableNameClashResolver;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.commandNamesResource = (CommandNamesResource)viewContext.getTextResource(CommandNamesResource.class);
        this.name = this.commandNamesResource.SubProgam();
        this.setNodeTypeName(this.commandNamesResource.SubProgam());
        this.namingService = namingService;
        this.entityFactory = entityFactory;
        this.programRootNodeSave = programRootNodeSave;
    }

    public boolean isOfSort(AbstractProgramNode.ProgramNodeSort sort) {
        return sort == AbstractProgramNode.ProgramNodeSort.TOP_LEVEL;
    }

    void forTestingSetProgramRootNode(ProgramRootNode subProgramRootNode) {
        this.subProgramRootNode = subProgramRootNode;
    }

    void setConfirmationResolver(ConfirmationResolver resolver) {
        this.resolver = resolver;
    }

    @CompoundProgramChange
    public void clear() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        SubProgramNode$AjcClosure1 subProgramNode$AjcClosure1 = new SubProgramNode$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(subProgramNode$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public String getName() {
        return this.name;
    }

    @NameChange
    @ProgramNodeChange
    public void setName(String newName) {
        String string = newName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        SubProgramNode$AjcClosure5 subProgramNode$AjcClosure5 = new SubProgramNode$AjcClosure5(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(subProgramNode$AjcClosure5.linkStackClosureAndJoinPoint(69648));
            subProgramNode$AjcClosure5.unlink();
        }
        catch (Throwable throwable) {
            subProgramNode$AjcClosure5.unlink();
            throw throwable;
        }
    }

    public String getScriptName() {
        return ScriptConverter.toScriptCode((String)this.namingService.toVariableName(this.getName()), (boolean)false);
    }

    public File getFile() {
        return this.file;
    }

    @ProgramNodeChange
    public void setFile(File file) {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)file2);
        Object[] objectArray = new Object[]{this, file2, joinPoint};
        SubProgramNode$AjcClosure7 subProgramNode$AjcClosure7 = new SubProgramNode$AjcClosure7(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(subProgramNode$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    public void setFileAndName(File file) {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)file2);
        Object[] objectArray = new Object[]{this, file2, joinPoint};
        SubProgramNode$AjcClosure9 subProgramNode$AjcClosure9 = new SubProgramNode$AjcClosure9(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(subProgramNode$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @Override
    public boolean getKeepHidden() {
        return this.keepHidden;
    }

    @Override
    @ProgramNodeChange
    public void setKeepHidden(boolean keepHidden) {
        boolean bl = keepHidden;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        SubProgramNode$AjcClosure11 subProgramNode$AjcClosure11 = new SubProgramNode$AjcClosure11(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(subProgramNode$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    public boolean isKeepSynchronizedWithDisk() {
        return this.keepSynchronized;
    }

    @ProgramNodeChange
    public void setKeepSynchronizedWithDisk(boolean sync) {
        boolean bl = sync;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        SubProgramNode$AjcClosure13 subProgramNode$AjcClosure13 = new SubProgramNode$AjcClosure13(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(subProgramNode$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    public ProgramRootNode getSubProgramRootNode() {
        if (this.subProgramRootNode == null) {
            this.subProgramRootNode = this.entityFactory.createProgramRootNode();
        }
        this.subProgramRootNode.setName(this.getName());
        this.subProgramRootNode.getMainProgram().removeAllChildren();
        try {
            ProgramRootNode.setSubTreeCloning(true);
            int i = 0;
            while (i < this.getChildCount()) {
                AbstractProgramNode pn = (AbstractProgramNode)this.getChildAt(i);
                if (!(pn instanceof PlaceholderNode)) {
                    this.subProgramRootNode.getMainProgram().add((MutableTreeNode)pn.clone());
                }
                ++i;
            }
        }
        finally {
            ProgramRootNode.setSubTreeCloning(false);
        }
        return this.subProgramRootNode;
    }

    public void setSubProgramRootNode(ProgramRootNode subProgramRootNode) {
        this.subProgramRootNode = subProgramRootNode;
        this.subProgramRootNode.setName(this.getName());
    }

    private WarningMessage subProgramContainsThreads(String subProgramName) {
        return new WarningMessage(this.textResource.cannotLoadSubProgramThreads(), this.textResource.subprogramContainsThreads(subProgramName));
    }

    @CompoundProgramChange
    public void setSubProgramRootNodeAndMoveNodes(ProgramRootNode subProgramRootNode) {
        ProgramRootNode programRootNode = subProgramRootNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)programRootNode);
        Object[] objectArray = new Object[]{this, programRootNode, joinPoint};
        SubProgramNode$AjcClosure15 subProgramNode$AjcClosure15 = new SubProgramNode$AjcClosure15(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(subProgramNode$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    @IgnoreProgramChanges
    @IgnoreNameChanges
    protected void adjust(ProgramRootNode subProgramRootNode) {
        ProgramRootNode programRootNode = subProgramRootNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)programRootNode);
        Object[] objectArray = new Object[]{this, programRootNode, joinPoint};
        SubProgramNode$AjcClosure19 subProgramNode$AjcClosure19 = new SubProgramNode$AjcClosure19(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(subProgramNode$AjcClosure19.linkStackClosureAndJoinPoint(69648));
            subProgramNode$AjcClosure19.unlink();
        }
        catch (Throwable throwable) {
            subProgramNode$AjcClosure19.unlink();
            throw throwable;
        }
    }

    private void resolveVariableNamesAgainstMainProgram(ProgramRootNode subProgramRootNode) {
        NamedEntityCollection entityCollection = new NamedEntityCollection();
        subProgramRootNode.getProgramEntitiesInSubtree((Collection)entityCollection);
        NamedEntityCollection mainProgramVars = new NamedEntityCollection();
        for (Object each : new IterableEnumerationWrapper(ProgramRootNode.get(this).children())) {
            if (each == this) continue;
            ((AbstractProgramNode)each).getProgramEntitiesInSubtree((Collection)mainProgramVars);
        }
        mainProgramVars = mainProgramVars.filterByType(Variable.class);
        ArrayList<String> subProgVarNamesTested = new ArrayList<String>();
        for (NamedEntity variableReferencingObject : entityCollection.filterByType(Variable.class).getFilteredCollection()) {
            Variable variable;
            boolean programFeatureVariable;
            Variable varInSubProgram = (Variable)variableReferencingObject;
            if (subProgVarNamesTested.contains(varInSubProgram.getName())) continue;
            boolean bl = programFeatureVariable = varInSubProgram instanceof GeomFeatureVariable && ((GeomFeatureVariable)varInSubProgram).dereference() instanceof ProgramFeature;
            if (!mainProgramVars.contains((Object)varInSubProgram) || !(varInSubProgram instanceof ProgramVariable) && !programFeatureVariable) continue;
            String commonName = varInSubProgram.getName();
            subProgVarNamesTested.add(commonName);
            if (programFeatureVariable || DialogReturnValue.OK == this.getResolveNameConflictApproach(commonName)) {
                NamedEntityCollection entitiesToSearch = new NamedEntityCollection();
                this.getEntitiesInProgramSubtree(entitiesToSearch);
                subProgramRootNode.getProgramEntitiesInSubtree((Collection)entitiesToSearch);
                String newName = this.namingService.makeUniqueName(varInSubProgram.getClass(), commonName, entitiesToSearch);
                variable = this.createVariable(varInSubProgram, newName);
            } else {
                variable = (Variable)mainProgramVars.get(commonName);
            }
            subProgramRootNode.substituteReference((Reference)varInSubProgram, (Reference)variable);
        }
    }

    private void getEntitiesInProgramSubtree(NamedEntityCollection entitiesToSearch) {
        ProgramRootNode rootNode = ProgramRootNode.get(this);
        if (rootNode != null) {
            rootNode.getProgramEntitiesInSubtree((Collection)entitiesToSearch);
        }
    }

    private Variable createVariable(Variable varInSubProgram, String newName) {
        Reference<String, GeomFeature> variable = varInSubProgram instanceof ProgramVariable && ((ProgramVariable)varInSubProgram).getProperties().containsKey("TimerVariable") ? this.entityFactory.createTimerVariable(newName) : (varInSubProgram instanceof GeomFeatureVariable ? this.entityFactory.createGeomFeatureVariable(newName) : this.entityFactory.createVariable(newName));
        if (varInSubProgram instanceof ProgramVariable && ((ProgramVariable)varInSubProgram).hasInitExpression()) {
            ((ProgramVariable)variable).setInitExpressionNode(((ProgramVariable)varInSubProgram).getInitExpression().getExpression().clone());
        }
        return variable;
    }

    public ConfirmationMessage confirmRenameVariableInSubProgram(String subProgramName, String commonName) {
        return new ConfirmationMessage(this.textResource.confirmMakeSubProgramsVariableUniqueTitle(subProgramName), this.textResource.confirmMakeSubProgramsVariableUniqueExplanation(commonName), this.textResource.confirmMakeSubProgramsVariableUniqueAction(), this.textResource.Cancel());
    }

    private DialogReturnValue getResolveNameConflictApproach(String commonName) {
        DialogReturnValue answer = DialogReturnValue.CANCEL;
        if (!DashBoard.autoLoadingNoPopups) {
            answer = this.resolver.resolveConflict(this.confirmRenameVariableInSubProgram(this.getName(), commonName));
        }
        return answer;
    }

    public boolean hasChildren() {
        return this.getChildCount() != 1 || !(this.getFirstChild() instanceof PlaceholderNode);
    }

    public boolean isTreeExpandable() {
        return !this.keepHidden;
    }

    public void loadFile() {
        try {
            ProgramRootNode prn = ProgramRootNodeLoad.loadSubProgram(this.getFile());
            if (prn != null) {
                this.setSubProgramRootNodeAndMoveNodes(prn);
            }
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
        }
    }

    public void saveFile() {
        ProgramRootNode programRootNode = this.getSubProgramRootNode();
        try {
            this.programRootNodeSave.actualSave(programRootNode, this.getFile());
        }
        catch (Exception e) {
            Log.error((String)"Unexpected exception while saving file", (Throwable)e);
        }
    }

    public Class<? extends CommandPanel<SubProgramNode>> getCardClass() {
        return SubProgramCard.class;
    }

    public SubProgramNode clone() {
        SubProgramNode newNode = (SubProgramNode)super.clone();
        newNode.setName(this.name);
        if (this.getFile() != null) {
            newNode.setFile(new File(this.getFile().toString()));
        }
        newNode.subProgramRootNode = this.subProgramRootNode != null ? this.getSubProgramRootNode().clone() : null;
        return newNode;
    }

    public String toString() {
        return this.getName();
    }

    public void setId(int id) {
        super.setId(id);
        Enumeration e = this.preorderEnumeration();
        while (e.hasMoreElements()) {
            AbstractProgramNode node = (AbstractProgramNode)e.nextElement();
            if (node == this) continue;
            node.setId(-1);
        }
    }

    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        this.scriptBegin(writer);
        if (!this.getName().equals(this.getScriptName())) {
            writer.comment(this.getName());
        }
        writer.defineFunction(this.getScriptName());
        if (this.jumpToLabel > -1) {
            writer.appendLine("jump_to_label(" + this.jumpToLabel + ")");
        }
        if (this.getId() != -1) {
            writer.writeProgramLabel((ControllerInterfaceProgramNode)this);
        }
        writer.writeChildren((Iterable)this.children);
        writer.end();
        this.scriptEnd(writer);
        return writer;
    }

    public boolean sameAs(NamedEntity entityToCompareTo) {
        if (this == entityToCompareTo) {
            return true;
        }
        if (!this.getName().equals(entityToCompareTo.getName())) {
            return false;
        }
        boolean entitiesAreEqual = false;
        if (entityToCompareTo instanceof SubProgramNode) {
            SubProgramNode spnToCompare = (SubProgramNode)entityToCompareTo;
            if (this.getSubProgramRootNode().equals(spnToCompare.subProgramRootNode)) {
                entitiesAreEqual = true;
            }
        }
        return entitiesAreEqual;
    }

    @Override
    public void updateProgramCounters(EntityFactory entityFactory, NamingService namingService) {
        this.setName(namingService.makeUniqueName(SubProgramNode.class, this.name));
    }

    public void setJumpToLabel(int jumpToLabel) {
        this.jumpToLabel = jumpToLabel;
    }

    public boolean canPauseOnNode() {
        return false;
    }

    static {
        SubProgramNode.ajc$preClinit();
    }

    static final /* synthetic */ void clear_aroundBody0(SubProgramNode ajc$this, JoinPoint joinPoint) {
        ajc$this.setFile(null);
        ProgramRootNode newProgramRootNode = ajc$this.entityFactory.createProgramRootNode();
        String newName = ajc$this.commandNamesResource.SubProgam();
        String newUniqueName = ajc$this.namingService.makeUniqueName(SubProgramNode.class, newName);
        ajc$this.setName(newUniqueName);
        newProgramRootNode.setName(ajc$this.getName());
        ajc$this.setSubProgramRootNodeAndMoveNodes(newProgramRootNode);
        ajc$this.setKeepHidden(false);
    }

    static final /* synthetic */ void setName_aroundBody2(SubProgramNode ajc$this, String newName, JoinPoint joinPoint) {
        ajc$this.name = newName;
        for (AbstractProgramNode p : ajc$this.getPrevExecutionProgramNodes()) {
            p.textHasChanged();
        }
        ajc$this.textHasChanged();
    }

    static final /* synthetic */ void setName_aroundBody4(SubProgramNode subProgramNode, String string, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{subProgramNode, string, joinPoint};
        SubProgramNode$AjcClosure3 subProgramNode$AjcClosure3 = new SubProgramNode$AjcClosure3(objectArray);
        try {
            NameChangeAspect.aspectOf().aroundAnnotatedMethod(subProgramNode$AjcClosure3.linkStackClosureAndJoinPoint(69648));
            subProgramNode$AjcClosure3.unlink();
        }
        catch (Throwable throwable) {
            subProgramNode$AjcClosure3.unlink();
            throw throwable;
        }
    }

    static final /* synthetic */ void setFile_aroundBody6(SubProgramNode ajc$this, File file, JoinPoint joinPoint) {
        ajc$this.file = file;
    }

    static final /* synthetic */ void setFileAndName_aroundBody8(SubProgramNode ajc$this, File file, JoinPoint joinPoint) {
        ajc$this.setFile(file);
        if (file != null) {
            ProgramRootNode subRootNode = ajc$this.getSubProgramRootNode();
            subRootNode.setName(subRootNode.getComponent(FileManagementProgramComponent.class).setDirectoryAndExtractName(file));
            String uniqueName = ajc$this.namingService.makeUniqueName(SubProgramNode.class, subRootNode.getName());
            ajc$this.setName(uniqueName);
        }
    }

    static final /* synthetic */ void setKeepHidden_aroundBody10(SubProgramNode ajc$this, boolean keepHidden, JoinPoint joinPoint) {
        if (keepHidden != ajc$this.keepHidden) {
            ajc$this.keepHidden = keepHidden;
        }
    }

    static final /* synthetic */ void setKeepSynchronizedWithDisk_aroundBody12(SubProgramNode ajc$this, boolean sync, JoinPoint joinPoint) {
        if (sync != ajc$this.keepSynchronized) {
            ajc$this.keepSynchronized = sync;
        }
    }

    static final /* synthetic */ void setSubProgramRootNodeAndMoveNodes_aroundBody14(SubProgramNode ajc$this, ProgramRootNode subProgramRootNode, JoinPoint joinPoint) {
        ajc$this.adjust(subProgramRootNode);
        ajc$this.setSubProgramRootNode(subProgramRootNode);
        ProgramModel treeModel = ajc$this.getProgramTreeModel();
        while (ajc$this.getChildCount() > 0 && !(ajc$this.getChildAt(0) instanceof PlaceholderNode)) {
            treeModel.removeNodeFromParent((MutableTreeNode)((AbstractProgramNode)ajc$this.getChildAt(0)));
        }
        int i = subProgramRootNode.getMainProgram().getChildCount();
        int childIndex = 0;
        while (i > 0) {
            AbstractProgramNode pn = (AbstractProgramNode)subProgramRootNode.getMainProgram().getFirstChild();
            pn.removeFromParent();
            if (!(pn instanceof PlaceholderNode)) {
                treeModel.insertNodeInto((MutableTreeNode)pn, (MutableTreeNode)((Object)ajc$this), childIndex);
                ++childIndex;
            }
            --i;
        }
        UpdateExecutionFlowComponent.updateExecutionFlow(ajc$this);
        ajc$this.variableNameClashResolver.resolveNameClash();
        if (!subProgramRootNode.getThreads().isEmpty()) {
            ajc$this.resolver.showWarning(ajc$this.subProgramContainsThreads(subProgramRootNode.getName()));
        }
    }

    static final /* synthetic */ void adjust_aroundBody16(SubProgramNode ajc$this, ProgramRootNode subProgramRootNode, JoinPoint joinPoint) {
        if (ajc$this.adjustmentSupport.hasContainedSubPrograms(subProgramRootNode, ajc$this.resolver)) {
            return;
        }
        ajc$this.adjustmentSupport.fixWaypointNamesAlreadyInUse(ajc$this, subProgramRootNode, ajc$this.adjustmentSupport.buildSetOfWaypointNames(ajc$this));
        ajc$this.resolveVariableNamesAgainstMainProgram(subProgramRootNode);
    }

    static final /* synthetic */ void adjust_aroundBody18(SubProgramNode subProgramNode, ProgramRootNode programRootNode, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{subProgramNode, programRootNode, joinPoint};
        SubProgramNode$AjcClosure17 subProgramNode$AjcClosure17 = new SubProgramNode$AjcClosure17(objectArray);
        try {
            NameChangeAspect.aspectOf().aroundAnnotatedMethod(subProgramNode$AjcClosure17.linkStackClosureAndJoinPoint(69648));
            subProgramNode$AjcClosure17.unlink();
        }
        catch (Throwable throwable) {
            subProgramNode$AjcClosure17.unlink();
            throw throwable;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SubProgramNode.java", SubProgramNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clear", "gui.program.SubProgramNode", "", "", "", "void"), 112);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setName", "gui.program.SubProgramNode", "java.lang.String", "newName", "", "void"), 131);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFile", "gui.program.SubProgramNode", "java.io.File", "file", "", "void"), 148);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFileAndName", "gui.program.SubProgramNode", "java.io.File", "file", "", "void"), 153);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setKeepHidden", "gui.program.SubProgramNode", "boolean", "keepHidden", "", "void"), 170);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setKeepSynchronizedWithDisk", "gui.program.SubProgramNode", "boolean", "sync", "", "void"), 187);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSubProgramRootNodeAndMoveNodes", "gui.program.SubProgramNode", "gui.program.ProgramRootNode", "subProgramRootNode", "", "void"), 229);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "adjust", "gui.program.SubProgramNode", "gui.program.ProgramRootNode", "subProgramRootNode", "", "void"), 260);
    }

    public static interface ConfirmationResolver {
        public void showError(ErrorMessage var1);

        public void showWarning(WarningMessage var1);

        public DialogReturnValue resolveConflict(ConfirmationMessage var1);
    }
}

