/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.google.common.collect.Sets;
import com.ur.polyscope.scriptconverter.ScriptConverter;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TimerScriptGeneration {
    private static final String TIMER_IS_COUNTING_POSTFIX = "_is_counting";
    private static final String TIME_STEP_FUNCTION = "get_steptime()";
    public static final String TIMER_THREAD_NAME = "Timer_Thread";
    private Set<Timer> timers = Sets.newHashSet();
    private static final Map<String, String> TIMER_VARIABLE_CACHE = new HashMap<String, String>();

    public TimerScriptGeneration(Set<String> timerVariables) {
        for (String timerVariable : timerVariables) {
            this.timers.add(new Timer(timerVariable));
        }
    }

    public void generatePreambleScript(ScriptWriter writer) {
        if (!this.timers.isEmpty()) {
            this.generateTimerVariables(writer);
            this.generateTimerThread(writer);
        }
    }

    private void generateTimerVariables(ScriptWriter writer) {
        for (Timer timer : this.timers) {
            writer.globalVariable(timer.isCountingVariable, "False");
        }
    }

    private void generateTimerThread(ScriptWriter writer) {
        writer.defineThread(TIMER_THREAD_NAME);
        writer.whileTrue();
        for (Timer timer : this.timers) {
            writer.ifCondition(timer.isCountingVariable);
            writer.assign(timer.baseName, String.valueOf(timer.baseName) + " + " + TIME_STEP_FUNCTION);
            writer.end();
        }
        writer.sync();
        writer.end();
        writer.end();
        writer.appendLine("run Timer_Thread()");
    }

    public static String getTimerIsCountingVariableName(String timerName) {
        if (!TIMER_VARIABLE_CACHE.containsKey(timerName)) {
            String result = ScriptConverter.toScriptCode((String)(String.valueOf(timerName) + TIMER_IS_COUNTING_POSTFIX), (boolean)false);
            TIMER_VARIABLE_CACHE.put(timerName, result);
            return result;
        }
        return TIMER_VARIABLE_CACHE.get(timerName);
    }

    private static class Timer {
        private String baseName;
        private String isCountingVariable;

        public Timer(String baseName) {
            this.baseName = ScriptConverter.toScriptCode((String)baseName, (boolean)false);
            this.isCountingVariable = TimerScriptGeneration.getTimerIsCountingVariableName(baseName);
        }

        public int hashCode() {
            return this.baseName.hashCode();
        }
    }
}

