/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.polyscope.program.ProgramComponent;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.util.logging.Log;
import gui.program.ProgramRootNode;
import gui.program.services.MotionDataUpdateService;
import javax.inject.Inject;

public class UpdateExecutionFlowComponent
implements ProgramComponent {
    private final MotionDataUpdateService motionDataUpdateService;

    @Inject
    public UpdateExecutionFlowComponent(MotionDataUpdateService updateService) {
        this.motionDataUpdateService = updateService;
    }

    public void update(ProgramRootNode programRootNode) {
        try {
            if (this.motionDataUpdateService != null) {
                this.motionDataUpdateService.requestUpdate(programRootNode);
            }
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
        }
    }

    public Class<? extends ProgramComponent> getType() {
        return UpdateExecutionFlowComponent.class;
    }

    public static void updateExecutionFlow(AbstractProgramNode programNode) {
        ProgramRootNode programRoot = ProgramRootNode.get(programNode);
        if (programRoot != null && programRoot.getComponent(UpdateExecutionFlowComponent.class) != null) {
            programRoot.getComponent(UpdateExecutionFlowComponent.class).update(programRoot);
        }
    }
}

