/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.lang.naming.NamingService;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import gui.program.position.WaypointNode;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class UpdateReservedNameIntercepter
implements MethodInterceptor {
    private NamingService namingService;

    @Inject
    public void setNamingService(NamingService namingService) {
        this.namingService = namingService;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        AbstractProgramNode programNode = (AbstractProgramNode)methodInvocation.getThis();
        if (!(programNode instanceof WaypointNode)) {
            return methodInvocation.proceed();
        }
        WaypointNode node = (WaypointNode)programNode;
        if (node.getPositionNodeType() != PositionNodeType.FIXED) {
            return methodInvocation.proceed();
        }
        if (node.getParent() == null) {
            return methodInvocation.proceed();
        }
        if (node.getName().equals(WaypointNode.DEFAULT_NAME)) {
            node.setName(this.namingService.makeUniqueName(WaypointNode.class, node.getName()));
        }
        return methodInvocation.proceed();
    }
}

